/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl.thread;

import java.io.File;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcTRLogUty;
import sanproject.snctrl.com.SJsnctrlSnConst;
import sanproject.snctrl.com.utility.SJcSleepUty;
import sanproject.snctrl.thread.SJsnctrlSnStreamGobbler;
import sanproject.snctrl.thread.SJsnctrlSnWebAppSurveillanceThread;
import sanproject.snctrl.thread.SJsnctrlSnWebAppThread;
import sanproject.snctrl.utility.SJsnctrlProcessLockUtility;
import sanproject.snctrl.utility.SJsnctrlSnLockUtility;

class SJsnctrlSnWebAppFinishThread
extends SJsnctrlSnWebAppThread {
    private static final String LOG_FUNCTION = "Jetty";
    private static final String LOG_TITLE = SJsnctrlSnWebAppFinishThread.class.getSimpleName();
    private StringBuilder stopcmd;
    private SJsnctrlSnWebAppSurveillanceThread parent;
    final SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
    private static final long SLEEP_TIME = 1000L;

    public SJsnctrlSnWebAppFinishThread(StringBuilder stopcmd, SJsnctrlSnWebAppSurveillanceThread parent, String dkcpath) {
        this.stopcmd = stopcmd;
        this.parent = parent;
        this.dkcpath = dkcpath;
    }

    public void run() {
        String LOG_SUBTITLE = "run";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "start.");
        this.monitorStopLockFile();
        SJcTRLogUty.info((String)"Web Application Server", (String)"TRSTNA000004", (String)"Stopping", (String)"jetty");
        try {
            this.parent.end();
            Process stopprocess = null;
            Runtime stoptime = Runtime.getRuntime();
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "SN2 Service STOP COMMAND start.");
            stopprocess = stoptime.exec(this.stopcmd.toString());
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "SN2 Service STOP COMMAND started.");
            SJsnctrlSnStreamGobbler stoperrorGobbler = new SJsnctrlSnStreamGobbler(stopprocess.getErrorStream(), System.err);
            SJsnctrlSnStreamGobbler stopoutputGobbler = new SJsnctrlSnStreamGobbler(stopprocess.getInputStream(), System.out);
            stoperrorGobbler.start();
            stopoutputGobbler.start();
            int stopexitVal = stopprocess.waitFor();
            stoperrorGobbler.join();
            stopoutputGobbler.join();
            if (stopexitVal == 0) {
                this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "SN2 Service STOP COMMAND is normal exit.");
            } else {
                this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "run", "SN2 Service STOP COMMAND is error exit. code = " + stopexitVal);
            }
            stopprocess.getErrorStream().close();
            stopprocess.getInputStream().close();
            stopprocess.getOutputStream().close();
            stopprocess.destroy();
            stopprocess = null;
            this.waitSNService();
            this.releasePortNo();
            SJsnctrlSnLockUtility.release();
        }
        catch (IllegalArgumentException ie) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "run", "runtime.exec() IllegalArgumentException", (Throwable)ie);
        }
        catch (Exception e) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "run", "runtime.exec() Exception", (Throwable)e);
            SJcTRLogUty.error((String)"Web Application Server", (String)"TRSTNA000006", (String)"Stopping : Failed to stop a Storage Navigator.", (String)"jetty");
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "end.");
    }

    private void monitorStopLockFile() {
        String LOG_SUBTITLE = "monitorStopLockFile";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "monitorStopLockFile", "Start.");
        String stopLockPath = this.dkcpath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_STOPFILE + File.separator + "STOPLOCKFILE";
        SJsnctrlProcessLockUtility stopUty = null;
        try {
            stopUty = new SJsnctrlProcessLockUtility(stopLockPath);
            while (stopUty.tryLock()) {
                stopUty.release();
                this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "monitorStopLockFile", "tryLock release by StopProcessMain Not started.");
                SJcSleepUty.sleepSchedule(1000L);
            }
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "monitorStopLockFile", "STOPLOCKFILE Lock wait...");
            stopUty.getLock();
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "monitorStopLockFile", "STOPLOCKFILE Lock success.");
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "monitorStopLockFile", "End.");
        }
        catch (Exception ex) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "monitorStopLockFile", "Exception in stopUty.", (Throwable)ex);
            return;
        }
    }
}

