/*
 * Decompiled with CFR 0.152.
 */
package spfc.ctrl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import spfc.ctrl.SPFC_FTPResponseParser;

public class SPFC_FileTransferProtocol959Ctrl {
    protected static final String COMMAND_USER_NAME = "USER ";
    protected static final String COMMAND_PASSWORD = "PASS ";
    protected static final String COMMAND_ACCOUNT = "ACCT ";
    protected static final String COMMAND_CHANGE_WORKING_DIRECTORY = "CWD ";
    protected static final String COMMAND_CHANGE_TO_PARENT_DIRECTORY = "CDUP ";
    protected static final String COMMAND_STRUCTURE_MOUNT = "SMNT ";
    protected static final String COMMAND_REINITIALIZE = "REIN ";
    protected static final String COMMAND_LOGOUT = "QUIT ";
    protected static final String COMMAND_DATA_PORT = "PORT ";
    protected static final String COMMAND_PASSIVE = "PASV ";
    protected static final String COMMAND_REPRESENTATION_TYPE = "TYPE ";
    protected static final String COMMAND_FILE_STRUCTURE = "STRU ";
    protected static final String COMMAND_TRANSFER_MODE = "MODE ";
    protected static final String COMMAND_RETRIEVE = "RETR ";
    protected static final String COMMAND_STORE = "STOR ";
    protected static final String COMMAND_STORE_UNIQUE = "STOU ";
    protected static final String COMMAND_APPEND = "APPE ";
    protected static final String COMMAND_ALLOCATE = "ALLO ";
    protected static final String COMMAND_RESTART = "REST ";
    protected static final String COMMAND_RENAME_FROM = "RNFR ";
    protected static final String COMMAND_RENAME_TO = "RNTO ";
    protected static final String COMMAND_ABORT = "ABOR ";
    protected static final String COMMAND_DELETE = "DELE ";
    protected static final String COMMAND_REMOVE_DIRECTORY = "RMD ";
    protected static final String COMMAND_MAKE_DIRECTORY = "MKD ";
    protected static final String COMMAND_PRINT_WORKING_DIRECTORY = "PWD ";
    protected static final String COMMAND_LIST = "LIST ";
    protected static final String COMMAND_NAME_LIST = "NLST ";
    protected static final String COMMAND_SITE_PARAMETERS = "SITE ";
    protected static final String COMMAND_SYSTEM = "SYST ";
    protected static final String COMMAND_STATUS = "STAT ";
    protected static final String COMMAND_HELP = "HELP ";
    protected static final String COMMAND_NOOP = "NOOP ";
    protected static int BUFFER_SIZE = 10240;
    private boolean m_bWaitResponse = false;
    private boolean m_bConnection = false;
    private boolean m_bPassiveMode = false;
    private boolean m_bBinaryMode = false;
    private Socket m_socControl;
    private InputStream m_brrCtrlReader;
    private OutputStream m_bwrCtrlWriter;
    private String m_sLogText = new String("");

    public SPFC_FileTransferProtocol959Ctrl(String string) throws UnknownHostException, IOException, SecurityException, Exception {
        this(string, 21);
    }

    public SPFC_FileTransferProtocol959Ctrl(String string, int n) throws UnknownHostException, IOException, SecurityException, Exception {
        this.connect(string, n);
    }

    protected void finalize() throws Throwable {
        this.logout();
    }

    public void connect(String string, int n) throws UnknownHostException, IOException, SecurityException, Exception {
        this.addLogText("Connecting to ... [" + string + ":" + n + "]");
        this.m_socControl = new Socket(string, n);
        this.m_brrCtrlReader = this.m_socControl.getInputStream();
        this.m_bwrCtrlWriter = this.m_socControl.getOutputStream();
        SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.getCtrlResponse());
        if (!sPFC_FTPResponseParser.getResponseCode().equals("220")) {
            throw new Exception("Connection failed. [" + string + ":" + n + "]");
        }
        this.m_bConnection = true;
        this.addLogText("A connection to [" + string + ":" + n + "] has been established.");
    }

    public boolean login(String string, String string2) throws IOException, Exception {
        SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand(COMMAND_USER_NAME + string));
        sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand(COMMAND_PASSWORD + string2));
        if (!sPFC_FTPResponseParser.getResponseCode().equals("230")) {
            this.logout();
            return false;
        }
        return true;
    }

    public void logout() throws IOException, Exception {
        if (!this.isConnect()) {
            return;
        }
        if (this.m_socControl != null) {
            this.sendCommand(COMMAND_LOGOUT);
            this.m_bwrCtrlWriter.close();
            this.m_bwrCtrlWriter = null;
            this.m_brrCtrlReader.close();
            this.m_brrCtrlReader = null;
            this.m_socControl.close();
            this.m_socControl = null;
            this.m_bConnection = false;
            this.addLogText("You have been logged out.");
        }
    }

    protected void setWaitResponse(boolean bl) {
        this.m_bWaitResponse = bl;
    }

    public boolean isWaitResponse() {
        return this.m_bWaitResponse;
    }

    public SPFC_FTPResponseParser parseResponseLine(String string) throws Exception {
        return new SPFC_FTPResponseParser(string);
    }

    public String getCtrlResponse() throws IOException, Exception {
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_brrCtrlReader));
            string = bufferedReader.readLine();
            this.addLogText(string);
            if (string != null) {
                SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(string);
                string = sPFC_FTPResponseParser.getResponseLine();
                if (sPFC_FTPResponseParser.isMultiLine()) {
                    String string2 = sPFC_FTPResponseParser.getResponseCode();
                    SPFC_FTPResponseParser sPFC_FTPResponseParser2 = this.parseResponseLine(bufferedReader.readLine());
                    while (!sPFC_FTPResponseParser2.isResponseEnd(string2)) {
                        string = sPFC_FTPResponseParser2.getResponseLine();
                        this.addLogText(string);
                        sPFC_FTPResponseParser2 = this.parseResponseLine(bufferedReader.readLine());
                    }
                    string = sPFC_FTPResponseParser2.getResponseLine();
                    this.addLogText(string);
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + "\nAn error occurred while receiving a reply.");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getStreamData(InputStream inputStream) throws IOException, Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            SPFC_FTPResponseParser sPFC_FTPResponseParser = new SPFC_FTPResponseParser(bufferedReader.readLine());
            while (sPFC_FTPResponseParser.getResponseLine() != null) {
                arrayList.add(sPFC_FTPResponseParser.getResponseLine());
                this.addLogText(sPFC_FTPResponseParser.getResponseLine());
                sPFC_FTPResponseParser = new SPFC_FTPResponseParser(bufferedReader.readLine());
            }
            Object var6_6 = null;
            if (bufferedReader == null) return arrayList;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedReader != null) {
                bufferedReader.close();
                bufferedReader = null;
            }
            throw throwable;
        }
        bufferedReader.close();
        return arrayList;
    }

    protected String DataTransfer(InputStream inputStream, OutputStream outputStream) throws IOException, Exception {
        return this.DataTransfer(inputStream, outputStream, System.getProperty("line.separator"));
    }

    protected String DataTransfer(InputStream inputStream, OutputStream outputStream, String string) throws IOException, Exception {
        if (this.isBinaryMode()) {
            return this.BinaryDataTransfer(inputStream, outputStream);
        }
        return this.StringDataTransfer(inputStream, outputStream, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String BinaryDataTransfer(InputStream inputStream, OutputStream outputStream) throws IOException, Exception {
        DataInputStream dataInputStream;
        block8: {
            dataInputStream = null;
            FilterOutputStream filterOutputStream = null;
            try {
                dataInputStream = new DataInputStream(inputStream);
                filterOutputStream = new DataOutputStream(outputStream);
                byte[] byArray = new byte[BUFFER_SIZE];
                int n = dataInputStream.read(byArray);
                while (n != -1) {
                    ((DataOutputStream)filterOutputStream).write(byArray, 0, n);
                    n = dataInputStream.read(byArray);
                }
                Object var8_8 = null;
                if (filterOutputStream == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                    filterOutputStream = null;
                }
                if (dataInputStream != null) {
                    dataInputStream.close();
                    dataInputStream = null;
                }
                throw throwable;
            }
            filterOutputStream.close();
            filterOutputStream = null;
        }
        if (dataInputStream != null) {
            dataInputStream.close();
            return this.getCtrlResponse();
        }
        return this.getCtrlResponse();
    }

    protected String StringDataTransfer(InputStream inputStream, OutputStream outputStream) throws IOException, Exception {
        return this.StringDataTransfer(inputStream, outputStream, System.getProperty("line.separator"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String StringDataTransfer(InputStream inputStream, OutputStream outputStream, String string) throws IOException, Exception {
        BufferedReader bufferedReader;
        block8: {
            bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    bufferedWriter.write(string2 + string);
                    bufferedWriter.flush();
                    string2 = bufferedReader.readLine();
                }
                Object var10_10 = null;
                if (bufferedWriter == null) break block8;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                throw throwable;
            }
            bufferedWriter.close();
            bufferedWriter = null;
        }
        if (bufferedReader != null) {
            bufferedReader.close();
            return this.getCtrlResponse();
        }
        return this.getCtrlResponse();
    }

    protected void addLogText(String string) {
        if (string != null) {
            string = string.trim() + "\n";
            this.m_sLogText = this.m_sLogText + string;
        }
    }

    public String getLog() {
        String string = new String("");
        String string2 = this.m_sLogText;
        this.m_sLogText = string;
        return string2;
    }

    public void setPassiveMode(boolean bl) {
        this.m_bPassiveMode = bl;
    }

    public void setActiveMode(boolean bl) {
        this.setPassiveMode(!bl);
    }

    public Object getDataConnection() throws UnknownHostException, IOException, Exception {
        Closeable closeable = null;
        int n = 0;
        String string = "";
        if (this.isConnect()) {
            if (this.isPassiveMode()) {
                SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand(COMMAND_PASSIVE));
                StringTokenizer stringTokenizer = new StringTokenizer(sPFC_FTPResponseParser.getResponseLine(), ",");
                int[] nArray = new int[6];
                int n2 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    try {
                        int n3;
                        String string2 = stringTokenizer.nextToken();
                        String string3 = new String("");
                        boolean bl = false;
                        int n4 = n3 = string2.length();
                        while (n4 > 0) {
                            String string4 = new String("");
                            char c = string2.charAt(n4 - 1);
                            if (Character.isDigit(c)) {
                                string4 = new Character(c).toString();
                                string3 = string4.concat(string3);
                                bl = true;
                            } else if (bl) break;
                            --n4;
                        }
                        nArray[n2++] = Integer.parseInt(string3);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new Exception("An error occurred while establishing a connection.");
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Exception("An error occurred while establishing a connection.");
                    }
                }
                string = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                n = (nArray[4] << 8) + nArray[5];
                closeable = new Socket(string, n);
                this.addLogText("DataConnection Local Address [" + closeable.getLocalAddress() + ":" + closeable.getLocalPort() + "]");
                this.addLogText("DataConnection Remote Address [" + closeable.getInetAddress() + ":" + closeable.getPort() + "]");
            } else {
                ServerSocket serverSocket = new ServerSocket(0, 1);
                n = serverSocket.getLocalPort();
                int n5 = n >> 8;
                int n6 = n & 0xFF;
                InetAddress inetAddress = this.m_socControl.getLocalAddress();
                int n7 = new Integer(inetAddress.getAddress()[0]);
                int n8 = new Integer(inetAddress.getAddress()[1]);
                int n9 = new Integer(inetAddress.getAddress()[2]);
                int n10 = new Integer(inetAddress.getAddress()[3]);
                if (n7 < 0) {
                    n7 += 256;
                }
                if (n8 < 0) {
                    n8 += 256;
                }
                if (n9 < 0) {
                    n9 += 256;
                }
                if (n10 < 0) {
                    n10 += 256;
                }
                String string5 = n7 + "," + n8 + "," + n9 + "," + n10 + "," + n5 + "," + n6;
                SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand(COMMAND_DATA_PORT + string5));
                string = n7 + "." + n8 + "." + n9 + "." + n10;
                if (!sPFC_FTPResponseParser.getResponseCode().equals("200")) {
                    throw new Exception("An error occurred while establishing a connection.");
                }
                closeable = serverSocket;
                this.addLogText("DataConnection Local Address [" + string + ":" + n + "]");
            }
        }
        return closeable;
    }

    public void setBinaryMode(boolean bl) {
        this.m_bBinaryMode = bl;
        try {
            if (bl) {
                SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand("TYPE I"));
            } else {
                SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand("TYPE A"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isBinaryMode() {
        return this.m_bBinaryMode;
    }

    public void setAsciiMode(boolean bl) {
        this.setBinaryMode(!bl);
    }

    public boolean isAsciiMode() {
        return !this.isBinaryMode();
    }

    public boolean isPassiveMode() {
        return this.m_bPassiveMode;
    }

    public boolean isActiveMode() {
        return !this.isPassiveMode();
    }

    public boolean isWait() {
        return this.m_bWaitResponse;
    }

    public boolean isConnect() {
        return this.m_bConnection;
    }

    protected String sendCommand(String string) throws IOException, Exception {
        string = string.trim();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.m_bwrCtrlWriter));
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        bufferedWriter.flush();
        if (string.startsWith(COMMAND_PASSWORD)) {
            string = new String("PASS ********");
        }
        this.addLogText("> " + string);
        return this.getCtrlResponse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void upload(String string, String string2) throws FileNotFoundException, IOException, Exception {
        if (this.isConnect()) {
            Socket socket;
            FileInputStream fileInputStream;
            block11: {
                fileInputStream = null;
                socket = null;
                OutputStream outputStream = null;
                try {
                    fileInputStream = new FileInputStream(string);
                    Object object = this.getDataConnection();
                    SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand(COMMAND_STORE + string2));
                    String string3 = sPFC_FTPResponseParser.getResponseCode();
                    if (!string3.equals("125") && !string3.equals("150")) {
                        throw new Exception(sPFC_FTPResponseParser.getResponseLine());
                    }
                    socket = this.isPassiveMode() ? (Socket)object : ((ServerSocket)object).accept();
                    object = null;
                    outputStream = socket.getOutputStream();
                    sPFC_FTPResponseParser = this.parseResponseLine(this.DataTransfer(fileInputStream, outputStream, new String("\r\n")));
                    Object var10_10 = null;
                    if (outputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (outputStream != null) {
                        outputStream.close();
                        outputStream = null;
                    }
                    if (socket != null) {
                        socket.close();
                        socket = null;
                    }
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                        fileInputStream = null;
                    }
                    throw throwable;
                }
                outputStream.close();
                outputStream = null;
            }
            if (socket != null) {
                socket.close();
                socket = null;
            }
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
                return;
            }
        }
    }

    public void changeDirectory(String string) throws IOException, Exception {
        if (this.isConnect()) {
            if (string == null) {
                string = new String("");
            }
            SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand(COMMAND_CHANGE_WORKING_DIRECTORY + string));
        }
    }

    public ArrayList getDirectoryList() throws UnknownHostException, IOException, SecurityException, Exception {
        return this.getDirectoryContents(COMMAND_LIST);
    }

    public ArrayList getDirectoryNameList() throws UnknownHostException, IOException, SecurityException, Exception {
        return this.getDirectoryContents(COMMAND_NAME_LIST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArrayList getDirectoryContents(String string) throws UnknownHostException, IOException, SecurityException, Exception {
        ArrayList arrayList = null;
        if (this.isConnect()) {
            Socket socket;
            block9: {
                arrayList = new ArrayList();
                socket = null;
                InputStream inputStream = null;
                try {
                    Object object = this.getDataConnection();
                    SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand(string));
                    String string2 = sPFC_FTPResponseParser.getResponseCode();
                    if (!string2.equals("125") && !string2.equals("150")) {
                        throw new Exception(sPFC_FTPResponseParser.getResponseLine());
                    }
                    socket = this.isPassiveMode() ? (Socket)object : ((ServerSocket)object).accept();
                    object = null;
                    inputStream = socket.getInputStream();
                    arrayList = this.getStreamData(inputStream);
                    sPFC_FTPResponseParser = this.parseResponseLine(this.getCtrlResponse());
                    Object var9_9 = null;
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (inputStream != null) {
                        inputStream.close();
                        inputStream = null;
                    }
                    if (socket != null) {
                        socket.close();
                        socket = null;
                    }
                    throw throwable;
                }
                inputStream.close();
                inputStream = null;
            }
            if (socket != null) {
                socket.close();
                return arrayList;
            }
        }
        return arrayList;
    }

    public void abort() throws IOException, Exception {
        SPFC_FTPResponseParser sPFC_FTPResponseParser = this.parseResponseLine(this.sendCommand(COMMAND_ABORT));
    }
}

