/*
 * Decompiled with CFR 0.152.
 */
package spfc.ctrl;

public class SPFC_LineTokenizer {
    private String m_sLineData;
    private String m_sDelimitor;
    private boolean m_bDoubleQuote = true;
    private int m_iTokenCount = 0;
    private int m_iPosition = 0;

    public SPFC_LineTokenizer(String string, String string2) {
        this.setLineData(string);
        this.setDelimitor(string2);
        this.analysisData();
    }

    public void setLineData(String string) {
        this.m_sLineData = string;
    }

    public void setDelimitor(String string) {
        this.m_sDelimitor = string;
    }

    protected int nextDelimitor(int n) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = n;
        int n3 = this.m_sDelimitor.length() - 1;
        int n4 = 0;
        while (n < this.m_sLineData.length()) {
            char c = this.m_sLineData.charAt(n);
            if (this.m_bDoubleQuote) {
                if (!bl && c == this.m_sDelimitor.charAt(n4)) {
                    if (++n4 > n3) {
                        n -= n3;
                        break;
                    }
                    bl2 = true;
                } else if (c == '\"') {
                    bl = !bl;
                } else {
                    n4 = 0;
                    if (bl2) {
                        bl2 = false;
                        continue;
                    }
                }
            } else if (c == this.m_sDelimitor.charAt(n4)) {
                if (++n4 > n3) {
                    n -= n3;
                    break;
                }
            } else {
                n4 = 0;
            }
            ++n;
        }
        return n;
    }

    public int getTokenCount() {
        return this.m_iTokenCount;
    }

    public void setDoubleQuoteCheck(boolean bl) {
        this.m_bDoubleQuote = bl;
    }

    protected void analysisData() {
        this.countTokens();
    }

    private void countTokens() {
        int n = 0;
        this.m_iTokenCount = 1;
        while ((n = this.nextDelimitor(n)) < this.m_sLineData.length()) {
            n += this.m_sDelimitor.length();
            ++this.m_iTokenCount;
        }
    }

    public String getNextToken() {
        String string = null;
        if (this.m_iPosition <= this.m_sLineData.length()) {
            int n = this.m_iPosition;
            int n2 = this.nextDelimitor(n);
            int n3 = n2 + this.m_sDelimitor.length();
            if (this.m_bDoubleQuote && n != n2 && this.m_sLineData.charAt(n) == '\"' && this.m_sLineData.charAt(n2 - 1) == '\"') {
                ++n;
                --n2;
            }
            if (n <= n2) {
                string = new String(this.m_sLineData.substring(n, n2));
                this.m_iPosition = n3;
            }
        }
        return string;
    }
}

