/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.system;

import java.util.List;
import java.util.ListIterator;
import sanproject.sn2.base.SJbaseConst;
import sanproject.sn2.base.system.SJbaseSystemAgent;
import sanproject.sn2.base.system.SJbaseSystemItem;
import sanproject.sn2.base.system.SJbaseSystemList;
import sanproject.sn2.base.system.inf.SJbasePluginInterface;
import sanproject.sn2.base.system.inf.SJbaseSystemStatusInterface;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.inf.SJcSingletonInterface;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcTRLogUty;

public class SJbaseSystemManager
implements SJbasePluginInterface,
SJcSingletonInterface,
SJcConst {
    private final String LOG_FUNCTION = "SystemManager";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    public static final int STATUS_PRESTART = -1;
    public static final int STATUS_ALLGREEN = 0;
    public static final int STATUS_RESTRICTED = 1;
    public static final int STATUS_ERROR = 2;
    private static final int PROGRESS_STATUS_NO = 0;
    private static final int PROGRESS_STATUS_STARTUP = 1;
    private static final int PROGRESS_STATUS_FINISH = 2;
    private static final int SYSTEMS_START_STATUS_ALLGREEN = 0;
    private static final int SYSTEMS_START_STATUS_NOTREADY = 1;
    private static final int SYSTEMS_START_STATUS_FATAL = 2;
    private static final int SYSTEMS_START_STATUS_RETRY = 3;
    private SJbaseSystemList systemList;
    private int startupStatus = -1;
    private Object lockObjStartupStatus = new Object();
    private int progressStatus = 0;
    private Object lockObjProgressStatus = new Object();
    private SJbaseSystemWatchThread watchStartThread = null;
    private boolean stopWatchStartThreadFlag;
    private SJbaseSystemWatchThread watchErrorThread = null;
    private Object lockObjStartWatchError = new Object();
    private boolean stopWatchErrorThreadFlag;
    private SJbaseSystemWatchThread watchStopThread = null;
    private boolean stopWatchStopThreadFlag;
    private long intervalWatchErrorInMillis;
    private final int INTERVAL_WATCH_ERROR_DEF = 1;
    private long startLimitInMillis;
    private final int START_LIMIT_DEF = 60;
    private long stopLimitInMillis;
    private final int STOP_TIME_LIMIT_DEF = 10;
    private int startRetryCountMax;
    private final int START_RETRY_COUNT_MAX_DEF = 3;
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger("SN_System.log");

    @Override
    public void initialize(int status) {
        String LOG_SUBTITLE = "initialize";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "initialize", "Start. - status:" + status);
        boolean result = true;
        boolean skipFlg = false;
        int prgStatus = this.getProgressStatus();
        switch (prgStatus) {
            case 1: {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "initialize", ":DO-NOTHING: Now processing initialize.");
                skipFlg = true;
                break;
            }
            case 2: {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "initialize", ":DO-NOTHING: Now processing finish.");
                skipFlg = true;
            }
        }
        if (!skipFlg) {
            int startUpStatus = this.getStartupStatus();
            switch (startUpStatus) {
                case 0: {
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "initialize", ":DO-NOTHING: Now running(ALLGREEN).");
                    skipFlg = true;
                    break;
                }
                case 1: {
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "initialize", ":DO-NOTHING: Now running(RESTRICTED).");
                    skipFlg = true;
                }
            }
        }
        if (!skipFlg) {
            if (result) {
                this.setProgressStatus(1);
            }
            if (result) {
                this.resetEnvironment();
            }
            if (result) {
                result = this.registSystems();
            }
            this.outTrInitializing();
            if (result) {
                result = this.startSystems();
            }
            if (result) {
                this.startWatchStartThread();
            }
            if (result) {
                this.startWatchErrorThread();
            }
            if (!result) {
                this.setProgressStatus(0);
            }
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "initialize", "End.");
    }

    @Override
    public void finish() {
        String LOG_SUBTITLE = "finish";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "finish", "Start.");
        boolean result = true;
        boolean skipFlg = false;
        int prgStatus = this.getProgressStatus();
        switch (prgStatus) {
            case 1: {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "finish", ":ABORT_INITIALIZE: Now processing initialize.");
                break;
            }
            case 2: {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "finish", ":DO-NOTHING: Now processing finish.");
                skipFlg = true;
            }
        }
        if (!skipFlg) {
            if (result) {
                this.setProgressStatus(2);
            }
            this.outTrStopping();
            if (result) {
                result = this.finishSystems();
            }
            if (!this.isSystemsStopped()) {
                this.outTrStoppedTimeout();
            }
            if (!result) {
                this.setProgressStatus(0);
            }
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "finish", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartupStatus() {
        Object object = this.lockObjStartupStatus;
        synchronized (object) {
            return this.startupStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartupStatus(int status) {
        String LOG_SUBTITLE = "setStartupStatus";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "setStartupStatus", "Start. - status:" + status);
        Object object = this.lockObjStartupStatus;
        synchronized (object) {
            this.startupStatus = status;
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "setStartupStatus", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgressStatus() {
        Object object = this.lockObjProgressStatus;
        synchronized (object) {
            return this.progressStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressStatus(int status) {
        String LOG_SUBTITLE = "setProgressStatus";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "setProgressStatus", "Start. - status:" + status);
        Object object = this.lockObjProgressStatus;
        synchronized (object) {
            this.progressStatus = status;
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "setProgressStatus", "End.");
    }

    @Override
    public boolean isEnable() {
        return true;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public List<SJcPluginItem> getPluginItems() {
        String LOG_SUBTITLE = "getPluginItems";
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "getPluginItems", "Start.");
        List<SJcPluginItem> itmeList = null;
        if (this.systemList != null) {
            itmeList = this.systemList.getPluginList();
        }
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "getPluginItems", "End.");
        return itmeList;
    }

    @Override
    public boolean destroy() {
        String LOG_SUBTITLE = "destroy";
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "destroy", "Start.");
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "destroy", "End.");
        return true;
    }

    private void resetEnvironment() {
        String LOG_SUBTITLE = "resetEnvironment";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "resetEnvironment", "Start.");
        int value = SJcEnvUty.getProperty2int("SN_BASE_GetStatusInterval", 1);
        this.intervalWatchErrorInMillis = (long)(0 < value ? value : 1) * 1000L;
        value = SJcEnvUty.getProperty2int("SN_BASE_StartTimeLimit", 60);
        this.startLimitInMillis = (long)value * 1000L;
        value = SJcEnvUty.getProperty2int("SN_BASE_FinishTimeLimit", 10);
        this.stopLimitInMillis = (long)value * 1000L;
        this.startRetryCountMax = value = SJcEnvUty.getProperty2int("SN_BASE_StartRetry", 3);
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "resetEnvironment", "intervalWatchErrorInMillis:" + this.intervalWatchErrorInMillis);
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "resetEnvironment", "startLimitInMillis:" + this.startLimitInMillis);
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "resetEnvironment", "stopLimitInMillis:" + this.stopLimitInMillis);
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "resetEnvironment", "startRetryCountMax:" + this.startRetryCountMax);
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "resetEnvironment", "End.");
    }

    private boolean registSystems() {
        String LOG_SUBTITLE = "registSystems";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "registSystems", "Start.");
        boolean ret = false;
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String systemPath = SJcFileUty.concatFolderPath(dataPath, SJbaseConst.SN_DIRECTORY_BASE_SETTING_SYSTEM);
        String filePath = SJcFileUty.concatFolderPath(systemPath, "SystemList.properties");
        this.systemList = new SJbaseSystemList();
        ret = this.systemList.loadFile(filePath);
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "registSystems", "End. - return:" + ret);
        return ret;
    }

    private boolean startSystems() {
        String LOG_SUBTITLE = "startSystems";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "startSystems", "Start.");
        boolean ret = false;
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJbaseSystemItem item = null;
            try {
                item = (SJbaseSystemItem)iterator.next();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "startSystems", "Item class is invald.", cce);
                continue;
            }
            String className = item.getClassName();
            if (null == className) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "startSystems", "Class name is invald.");
                continue;
            }
            SJbaseSystemAgent agent = null;
            try {
                agent = new SJbaseSystemAgent(className);
            }
            catch (Exception e) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "startSystems", "Failed to create system.");
                continue;
            }
            item.setAgent(agent);
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "startSystems", "Agent created.");
            agent.initialize();
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "startSystems", "Agent initialize published.");
        }
        ret = true;
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "startSystems", "End. - return:" + ret);
        return ret;
    }

    private boolean finishSystems() {
        String LOG_SUBTITLE = "finishSystems";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "finishSystems", "Start.");
        boolean ret = false;
        this.stopWatchStartThread();
        this.stopWatchErrorThread();
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator(this.systemList.getPluginList().size());
        while (iterator.hasPrevious()) {
            SJbaseSystemItem item = null;
            try {
                item = (SJbaseSystemItem)iterator.previous();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "finishSystems", "Item class is invald.", cce);
                continue;
            }
            SJbaseSystemAgent agent = item.getAgent();
            if (null == agent) {
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "finishSystems", "Agent is not set.");
                continue;
            }
            agent.finish();
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "finishSystems", "Agent finish published.");
        }
        this.startWatchStopThread();
        ret = true;
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "finishSystems", "End. - return:" + ret);
        return ret;
    }

    private void abortStartSystems() {
        String LOG_SUBTITLE = "abortStartSystems";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "abortStartSystems", "Start.");
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJbaseSystemItem item = null;
            try {
                item = (SJbaseSystemItem)iterator.next();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "abortStartSystems", "Item class is invald.", cce);
                continue;
            }
            SJbaseSystemAgent agent = item.getAgent();
            if (null == agent) {
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "abortStartSystems", "Agent is not set.");
                continue;
            }
            this.stdLogger.warn("SystemManager", this.LOG_TITLE, "abortStartSystems", agent.getSystemClassName() + ": aborting initialize.");
            agent.abortInitialize();
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "abortStartSystems", "End.");
    }

    private int isSystemsStartupAlready() {
        String LOG_SUBTITLE = "isSystemsStartupAlready";
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", "Start.");
        int ret = 0;
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJbaseSystemItem item = null;
            try {
                item = (SJbaseSystemItem)iterator.next();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", "Item class is invald.", cce);
                continue;
            }
            SJbaseSystemAgent agent = item.getAgent();
            if (null == agent) {
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", "Agent is not set.");
                continue;
            }
            SJbaseSystemStatusInterface status = agent.getStatus();
            if (null == status) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", "Status is null.");
                continue;
            }
            int phase = status.getPhase();
            this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + ":PHASE:" + phase);
            switch (phase) {
                case 2: {
                    break;
                }
                case 0: {
                    ret = 1;
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + " is not already.");
                    break;
                }
                case 1: {
                    if (status.isFatal()) {
                        ret = 2;
                        this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + " is fatal error.");
                        break;
                    }
                    if (status.isReqRetry()) {
                        ret = 3;
                        this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + " is retry request.");
                        break;
                    }
                    ret = 1;
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + " is not already.");
                    break;
                }
                case 3: {
                    if (status.isFatal()) {
                        ret = 2;
                        this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + " is fatal error.");
                        break;
                    }
                    if (status.isReqRetry()) {
                        ret = 3;
                        this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + " is retry request.");
                        break;
                    }
                    ret = 1;
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + " is not already.");
                    break;
                }
                case 4: {
                    ret = 1;
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", agent.getSystemClassName() + " is not already.");
                }
            }
            if (ret != 2 && ret != 3) continue;
            break;
        }
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsStartupAlready", "End. - return:" + ret);
        return ret;
    }

    private boolean isSystemsNoFatalError() {
        String LOG_SUBTITLE = "isSystemsNoFatalError";
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", "Start.");
        boolean ret = true;
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJbaseSystemItem item = null;
            try {
                item = (SJbaseSystemItem)iterator.next();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", "Item class is invald.", cce);
                continue;
            }
            SJbaseSystemAgent agent = item.getAgent();
            if (null == agent) {
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", "Agent is not set.");
                continue;
            }
            SJbaseSystemStatusInterface status = agent.getStatus();
            if (null == status) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", "Status is null.");
                continue;
            }
            boolean fatal = status.isFatal();
            this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", agent.getSystemClassName() + ":FATAL:" + fatal);
            if (fatal) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", agent.getSystemClassName() + " fatal error occured.");
                ret = false;
                break;
            }
            boolean retry = status.isReqRetry();
            this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", agent.getSystemClassName() + ":RETRY:" + retry);
            if (!retry) continue;
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", agent.getSystemClassName() + " Retry is required.");
            ret = false;
            break;
        }
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsNoFatalError", "End. - return:" + ret);
        return ret;
    }

    private boolean isSystemsStopped() {
        String LOG_SUBTITLE = "isSystemsStopped";
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsStopped", "Start.");
        boolean ret = true;
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator(this.systemList.getPluginList().size());
        while (iterator.hasPrevious()) {
            SJbaseSystemItem item = null;
            try {
                item = (SJbaseSystemItem)iterator.previous();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "isSystemsStopped", "Item class is invald.", cce);
                continue;
            }
            SJbaseSystemAgent agent = item.getAgent();
            if (null == agent) {
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsStopped", "Agent is not set.");
                continue;
            }
            SJbaseSystemStatusInterface status = agent.getStatus();
            if (null == status) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStopped", "Status is null.");
                continue;
            }
            int phase = status.getPhase();
            this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsStopped", agent.getSystemClassName() + ":PHASE:" + phase);
            if (4 == phase) continue;
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "isSystemsStopped", agent.getSystemClassName() + " is not stopped.");
            ret = false;
            break;
        }
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "isSystemsStopped", "End. - return:" + ret);
        return ret;
    }

    private void cleanUpSystemsAndSetStartupStatus() {
        SJbaseSystemItem item;
        String LOG_SUBTITLE = "cleanUpSystemsAndSetStartupStatus";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "cleanUpSystemsAndSetStartupStatus", "Start.");
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator();
        boolean essentialSystemNotInitialied = false;
        while (iterator.hasNext()) {
            item = null;
            try {
                item = (SJbaseSystemItem)iterator.next();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "cleanUpSystemsAndSetStartupStatus", "Item class is invald.", cce);
                continue;
            }
            SJbaseSystemAgent agent = item.getAgent();
            if (null == agent) {
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "cleanUpSystemsAndSetStartupStatus", "Agent is not set.");
                continue;
            }
            SJbaseSystemStatusInterface status = agent.getStatus();
            if (null == status) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "cleanUpSystemsAndSetStartupStatus", "Status is null.");
                continue;
            }
            int phase = status.getPhase();
            if (2 == phase) continue;
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "cleanUpSystemsAndSetStartupStatus", agent.getSystemClassName() + " is not already.");
            agent.abortInitialize();
            this.stdLogger.warn("SystemManager", this.LOG_TITLE, "cleanUpSystemsAndSetStartupStatus", "Agent abort initialing published.");
            item.setAgent(null);
            if (!item.isEssential()) continue;
            essentialSystemNotInitialied = true;
        }
        if (essentialSystemNotInitialied) {
            this.setStartupStatus(2);
            iterator = this.systemList.getPluginList().listIterator();
            while (iterator.hasNext()) {
                item = null;
                try {
                    item = (SJbaseSystemItem)iterator.next();
                }
                catch (ClassCastException cce) {
                    this.stdLogger.error("SystemManager", this.LOG_TITLE, "cleanUpSystemsAndSetStartupStatus", "Item class is invald.", cce);
                    continue;
                }
                item.setAgent(null);
            }
        } else {
            this.setStartupStatus(1);
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "cleanUpSystemsAndSetStartupStatus", "End.");
    }

    private void cleanUpUnFinishedSystems() {
        String LOG_SUBTITLE = "cleanUpUnFinishedSystems";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "cleanUpUnFinishedSystems", "Start.");
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator(this.systemList.getPluginList().size());
        while (iterator.hasPrevious()) {
            SJbaseSystemItem item = null;
            try {
                item = (SJbaseSystemItem)iterator.previous();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "cleanUpUnFinishedSystems", "Item class is invald.", cce);
                continue;
            }
            SJbaseSystemAgent agent = item.getAgent();
            if (null == agent) {
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "cleanUpUnFinishedSystems", "Agent is not set.");
                continue;
            }
            SJbaseSystemStatusInterface status = agent.getStatus();
            if (null == status) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "cleanUpUnFinishedSystems", "Status is null.");
                continue;
            }
            int phase = status.getPhase();
            if (4 != phase) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "cleanUpUnFinishedSystems", agent.getSystemClassName() + " is not stopped.");
                agent.abortFinish();
                this.stdLogger.warn("SystemManager", this.LOG_TITLE, "cleanUpUnFinishedSystems", "Agent abort finishing published.");
            }
            item.setAgent(null);
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "cleanUpUnFinishedSystems", "End.");
    }

    private void startWatchStartThread() {
        String LOG_SUBTITLE = "startWatchStartThread";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "startWatchStartThread", "Start.");
        this.watchStartThread = new SJbaseSystemWatchThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SJbaseSystemManager.this.watchStartPolling();
                }
                catch (InterruptedException e) {
                    SJbaseSystemManager.this.stdLogger.info("SystemManager", SJbaseSystemManager.this.LOG_TITLE, "startWatchStartThread", "Thread interrupted.");
                    Thread.currentThread().interrupt();
                }
                Object object = SJbaseSystemManager.this.lockObjStartWatchError;
                synchronized (object) {
                    SJbaseSystemManager.this.lockObjStartWatchError.notify();
                }
            }
        };
        this.stopWatchStartThreadFlag = false;
        this.watchStartThread.start();
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "startWatchStartThread", "End.");
    }

    private void startWatchErrorThread() {
        String LOG_SUBTITLE = "startWatchErrorThread";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "startWatchErrorThread", "Start.");
        this.watchErrorThread = new SJbaseSystemWatchThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SJbaseSystemManager.this.lockObjStartWatchError;
                synchronized (object) {
                    try {
                        SJbaseSystemManager.this.lockObjStartWatchError.wait();
                    }
                    catch (InterruptedException e) {
                        SJbaseSystemManager.this.stdLogger.info("SystemManager", SJbaseSystemManager.this.LOG_TITLE, "startWatchErrorThread", "Wait interrupted.");
                        Thread.currentThread().interrupt();
                    }
                }
                if (SJbaseSystemManager.this.getStartupStatus() == 2) {
                    return;
                }
                try {
                    SJbaseSystemManager.this.watchErrorPolling();
                }
                catch (InterruptedException e) {
                    SJbaseSystemManager.this.stdLogger.info("SystemManager", SJbaseSystemManager.this.LOG_TITLE, "startWatchErrorThread", "Thread interrupted.");
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.stopWatchErrorThreadFlag = false;
        this.watchErrorThread.start();
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "startWatchErrorThread", "End.");
    }

    private void startWatchStopThread() {
        String LOG_SUBTITLE = "startWatchStopThread";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "startWatchStopThread", "Start.");
        this.watchStopThread = new SJbaseSystemWatchThread(){

            @Override
            public void run() {
                try {
                    SJbaseSystemManager.this.watchStopPolling();
                }
                catch (InterruptedException e) {
                    SJbaseSystemManager.this.stdLogger.info("SystemManager", SJbaseSystemManager.this.LOG_TITLE, "startWatchStopThread", "Thread interrupted.");
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.stopWatchStopThreadFlag = false;
        this.watchStopThread.start();
        try {
            this.watchStopThread.join();
        }
        catch (InterruptedException e) {
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "startWatchStopThread", "Join interrupted.");
            Thread.currentThread().interrupt();
        }
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "startWatchStopThread", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWatchStartThread() {
        String LOG_SUBTITLE = "stopWatchStartThread";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchStartThread", "Start.");
        if (null == this.watchStartThread) {
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchStartThread", "Thread is already null.");
            return;
        }
        SJbaseSystemWatchThread sJbaseSystemWatchThread = this.watchStartThread;
        synchronized (sJbaseSystemWatchThread) {
            this.stopWatchStartThreadFlag = true;
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchStartThread", "Thread notify start.");
            this.watchStartThread.notify();
        }
        try {
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchStartThread", "Thread join start.");
            this.watchStartThread.join();
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchStartThread", "Thread join end.");
        }
        catch (InterruptedException e) {
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchStartThread", "Join interrupted.");
            Thread.currentThread().interrupt();
        }
        this.watchStartThread = null;
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchStartThread", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWatchErrorThread() {
        String LOG_SUBTITLE = "stopWatchErrorThread";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchErrorThread", "Start.");
        if (null == this.watchErrorThread) {
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchErrorThread", "Thread is already null.");
            return;
        }
        SJbaseSystemWatchThread sJbaseSystemWatchThread = this.watchErrorThread;
        synchronized (sJbaseSystemWatchThread) {
            this.stopWatchErrorThreadFlag = true;
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchErrorThread", "Thread notify start.");
            this.watchErrorThread.notify();
        }
        try {
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchErrorThread", "Thread join start.");
            this.watchErrorThread.join();
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchErrorThread", "Thread join end.");
        }
        catch (InterruptedException e) {
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchErrorThread", "Join interrupted.");
            Thread.currentThread().interrupt();
        }
        this.watchErrorThread = null;
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "stopWatchErrorThread", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchStartPolling() throws InterruptedException {
        String LOG_SUBTITLE = "watchStartPolling";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStartPolling", "Start.");
        int counter = 1;
        this.setStartupStatus(-1);
        while (!this.stopWatchStartThreadFlag && null != this.watchStartThread) {
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStartPolling", "Loop starting(Retry) " + counter + " times.");
            long watchStartedTime = this.getSystemTime();
            while (!this.stopWatchStartThreadFlag && null != this.watchStartThread) {
                long currentTime = this.getSystemTime();
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "watchStartPolling", "Loop starting(Limit) at " + currentTime);
                if (this.startLimitInMillis < 0L) {
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStartPolling", "Ignore start limit time.");
                } else if (watchStartedTime + this.startLimitInMillis < currentTime) {
                    this.stdLogger.error("SystemManager", this.LOG_TITLE, "watchStartPolling", "Loop time limit over.");
                    break;
                }
                SJbaseSystemWatchThread sJbaseSystemWatchThread = this.watchStartThread;
                synchronized (sJbaseSystemWatchThread) {
                    this.stdLogger.trace("SystemManager", this.LOG_TITLE, "watchStartPolling", "Wait start. - interval:" + this.intervalWatchErrorInMillis);
                    this.watchStartThread.wait(this.intervalWatchErrorInMillis);
                    this.stdLogger.trace("SystemManager", this.LOG_TITLE, "watchStartPolling", "Wait End.");
                }
                int systemsStatus = this.isSystemsStartupAlready();
                if (systemsStatus == 0) {
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStartPolling", "ALL SYSTEMS ARE ALREADY.");
                    this.setStartupStatus(0);
                    break;
                }
                if (systemsStatus == 1) {
                    this.stdLogger.trace("SystemManager", this.LOG_TITLE, "watchStartPolling", "ANY SYSTEM IS STARTING.");
                    continue;
                }
                if (systemsStatus == 3) {
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStartPolling", "ANY SYSTEM IS RETRY REQUEST.");
                } else {
                    this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStartPolling", "ANY SYSTEM IS FATAL ERROR.");
                }
                this.setStartupStatus(2);
                break;
            }
            if (0 == this.getStartupStatus()) {
                this.outTrReady();
                break;
            }
            if (this.startRetryCountMax > 0 && ++counter > this.startRetryCountMax) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "watchStartPolling", "Loop retry count over.");
                break;
            }
            this.stdLogger.error("SystemManager", this.LOG_TITLE, "watchStartPolling", "RESTART ALL SYSTEMS!");
            this.abortStartSystems();
            if (this.stopWatchStartThreadFlag) {
                this.setAgentNull();
                break;
            }
            this.outTrWarning();
            this.startSystems();
        }
        if (0 != this.getStartupStatus()) {
            this.cleanUpSystemsAndSetStartupStatus();
        }
        this.setProgressStatus(0);
        this.watchStartThread = null;
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStartPolling", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchErrorPolling() throws InterruptedException {
        String LOG_SUBTITLE = "watchErrorPolling";
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "watchErrorPolling", "Start.");
        while (!this.stopWatchErrorThreadFlag && null != this.watchErrorThread) {
            SJbaseSystemWatchThread sJbaseSystemWatchThread = this.watchErrorThread;
            synchronized (sJbaseSystemWatchThread) {
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "watchErrorPolling", "Wait start. - interval:" + this.intervalWatchErrorInMillis);
                this.watchErrorThread.wait(this.intervalWatchErrorInMillis);
                this.stdLogger.trace("SystemManager", this.LOG_TITLE, "watchErrorPolling", "Wait End.");
            }
            if (2 == this.getProgressStatus()) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchErrorPolling", "Finish received. Watch error stop.");
                break;
            }
            if (this.isSystemsNoFatalError()) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchErrorPolling", "ALL SYSTEMS ARE NORMAL.");
                continue;
            }
            this.stdLogger.error("SystemManager", this.LOG_TITLE, "watchErrorPolling", "RESTART ALL SYSTEMS!");
            this.watchErrorThread = null;
            this.finishSystems();
            this.startSystems();
            this.startWatchStartThread();
            this.startWatchErrorThread();
            break;
        }
        this.stdLogger.trace("SystemManager", this.LOG_TITLE, "watchErrorPolling", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchStopPolling() throws InterruptedException {
        long watchStartedTime = this.getSystemTime();
        String LOG_SUBTITLE = "watchStopPolling";
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStopPolling", "Start. at " + watchStartedTime);
        while (!this.stopWatchStopThreadFlag && null != this.watchStopThread) {
            long currentTime = this.getSystemTime();
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStopPolling", "Loop starting at " + currentTime);
            if (this.stopLimitInMillis < 0L) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStopPolling", "Ignore stop limit time.");
            } else if (watchStartedTime + this.stopLimitInMillis < currentTime) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "watchStopPolling", "Loop time limit over.");
                break;
            }
            SJbaseSystemWatchThread sJbaseSystemWatchThread = this.watchStopThread;
            synchronized (sJbaseSystemWatchThread) {
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStopPolling", "Wait start. - interval:" + this.intervalWatchErrorInMillis);
                this.watchStopThread.wait(this.intervalWatchErrorInMillis);
                this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStopPolling", "Wait End.");
            }
            if (!this.isSystemsStopped()) continue;
            this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStopPolling", "ALL SYSTEMS ARE STOPPED.");
            this.setProgressStatus(0);
            break;
        }
        this.cleanUpUnFinishedSystems();
        this.watchStopThread = null;
        this.stdLogger.info("SystemManager", this.LOG_TITLE, "watchStopPolling", "End.");
    }

    private long getSystemTime() {
        return System.nanoTime() / 1000000L;
    }

    private void setAgentNull() {
        String LOG_SUBTITLE = "setAgentNull";
        ListIterator<SJcPluginItem> iterator = this.systemList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJbaseSystemItem item = null;
            try {
                item = (SJbaseSystemItem)iterator.next();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SystemManager", this.LOG_TITLE, "setAgentNull", "Item class is invald.", cce);
                continue;
            }
            item.setAgent(null);
        }
    }

    private void outTrInitializing() {
        SJcTRLogUty.info("Storage Navigator", "TRSTNA001001", "Initializing", "sn2");
    }

    private void outTrReady() {
        SJcTRLogUty.info("Storage Navigator", "TRSTNA001002", "Ready", "sn2");
    }

    private void outTrWarning() {
        SJcTRLogUty.warn("Storage Navigator", "TRSTNA001003", "Warning : A Storage Navigator service has restarted.", "sn2");
    }

    private void outTrStopping() {
        SJcTRLogUty.info("Storage Navigator", "TRSTNA001004", "Stopping", "sn2");
    }

    private void outTrStoppedTimeout() {
        SJcTRLogUty.warn("Storage Navigator", "TRSTNA001006", "Stopping : Timeout has occurred in the stop processing of a Storage Navigator.", "sn2");
    }

    protected class SJbaseSystemWatchThread
    extends Thread {
    }
}

