/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.fileuty;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.fileuty.SJcFileOnDisk;
import sanproject.sn2.com.utility.fileuty.SJcFileOnMemory;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyDirInfo;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyMemFile;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileInterface;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileUtyProcessor;

public class SJcFileUtyProcessorImpl
implements SJcFileUtyProcessor {
    private List<SJcFileUtyDirInfo> specialDirList;
    private HashMap<String, SJcFileUtyMemFile> memFileMap;

    public SJcFileUtyProcessorImpl(List<SJcFileUtyDirInfo> specialDirList) {
        this.specialDirList = specialDirList;
        this.memFileMap = new HashMap();
        String dataPath = SJcEnvUty.getProperty("SN_DataPath");
        String rootDir = dataPath.substring(0, dataPath.indexOf(SJcFileInterface.separator));
        SJcFileUtyMemFile root = new SJcFileUtyMemFile(rootDir, null, true);
        this.memFileMap.put(rootDir.toUpperCase(), root);
    }

    @Override
    public SJcFileInterface getSJcFile(String filepath) {
        boolean isDisk = this.isOnDisk(filepath);
        SJcFileInterface ret = isDisk ? new SJcFileOnDisk(filepath) : new SJcFileOnMemory(filepath, this.memFileMap);
        return ret;
    }

    private boolean isOnDisk(String filepath) {
        if (null != this.specialDirList) {
            ListIterator<SJcFileUtyDirInfo> iterator = this.specialDirList.listIterator();
            while (iterator.hasNext()) {
                String dirPath;
                SJcFileUtyDirInfo dirInfo = iterator.next();
                if (dirInfo.getDirType() != 1 || null == (dirPath = dirInfo.getPath())) continue;
                if (dirPath.equals(filepath)) {
                    return false;
                }
                if (!filepath.startsWith(dirPath + SJcFileInterface.separator)) continue;
                return false;
            }
        }
        return true;
    }
}

