/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.SJctrControllerManager;
import sanproject.sn2.controller.com.SJctrAction;
import sanproject.sn2.controller.com.SJctrAsyncGetDataController;
import sanproject.sn2.controller.com.SJctrAsyncGetInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrDirectLauncher;
import sanproject.sn2.controller.com.SJctrExecAppDataController;
import sanproject.sn2.controller.com.SJctrFileDownloadDataController;
import sanproject.sn2.controller.com.SJctrFileDownloadInterface;
import sanproject.sn2.controller.com.SJctrFileUploadDataController;
import sanproject.sn2.controller.com.SJctrFileUploadInterface;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMakeExport;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrModelDataProxy;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRequestInterface;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrAccordionTreeModel;
import sanproject.sn2.controller.topwindow.base.SJctrLastUpdateTimeModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.cvs.shredldev.SJctrShredDownloadIF;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLastUpdateTime;

public abstract class SJctrDataController
implements SJctrRequestInterface,
SJctrAsyncGetInterface {
    private SJctrUserController mUsrCtr;
    private int mDisplayId = 0;
    protected SJctrLogUty logUty = new SJctrLogUty();
    protected Map<Integer, SJctrAction> mActionMap = new HashMap<Integer, SJctrAction>();
    private SJctrSimpleDataModel dataModel;
    protected SJctrModelDataProxy proxy;
    private SJctrComUtility utility;
    private SJctrRelatedDispDataObject asyncRelated = null;
    private ArrayList<SJctrRelatedDispDataObject> updateDisp = new ArrayList();
    private int uId = -1;
    private boolean constructFlg = false;
    public static final int DISP_KIND_MASK = 0xFF00000;
    public static final int DISP_KIND_LIST_VIEW = 0;
    public static final int DISP_KIND_TAB = 0x100000;
    public static final int DISP_KIND_WIZARD = 0x1000000;
    public static final int DISP_KIND_SINGLE_WIZARD = 0x1100000;
    public static final int DISP_KIND_DIALOG = 0x2000000;
    public static final int DISP_KIND_PROPERTY = 0x2100000;
    public static final int DISP_KIND_OTHER = 0x3000000;
    private static final String MSG_ID_COMMON = "201";
    private static final String MSG_ID_CONTROLLER = "022";
    private static final String MSG_ID_CONFLICT = "105278";
    private List<SJctrDataController> relatedDCList;
    private boolean restoreFlg = false;
    private String unitSelect = null;
    public static final String COM_TURN_AROUND = "COM_TURN_AROUND";
    private SJcException asyncException = null;
    private boolean dialogAsyncGet = false;

    protected void addAction(int reqCode, SJctrAction action) throws SJcException {
        this.mActionMap.put(reqCode, action);
    }

    protected void initComActions() throws SJcException {
        this.addAction(0, new SJctrAction(){

            @Override
            public SJctrRequestDataObject execute(SJctrRequestDataObject req) throws SJcException {
                return SJctrDataController.this.requestGet(req);
            }
        });
        this.addAction(0x1000000, new SJctrAction(){

            @Override
            public SJctrRequestDataObject execute(SJctrRequestDataObject req) throws SJcException {
                return SJctrDataController.this.requestSet(req);
            }
        });
    }

    protected void initProxy() {
        this.proxy = new SJctrModelDataProxy(this.mUsrCtr.getModelAgent());
    }

    public SJctrModelDataProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(SJctrModelDataProxy proxy) {
        this.proxy = proxy;
    }

    void initialize(SJctrUserController usrCtr) throws SJcException {
        this.setOwner(usrCtr);
        this.initComActions();
        this.initProxy();
        this.initGuidance(this.utility);
    }

    public void initGuidance(SJctrComUtility util) {
        this.dataModel.initGuidance(util);
    }

    protected SJctrDataController(int dispId) throws SJcException {
        this.mDisplayId = dispId;
        this.logUty.setTitle(this.getClass().getSimpleName());
        this.dataModel = this.createRootDataModel();
        this.dataModel.setDataController(this);
        this.initListener();
        this.setDetaultRestoreFlg();
    }

    protected SJctrSimpleDataModel createRootDataModel() {
        return new SJctrSimpleDataModel();
    }

    public boolean getRollBackInfo() {
        return false;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    protected void setOwner(SJctrUserController usrCtr) {
        this.mUsrCtr = usrCtr;
        this.utility = usrCtr.getComUtility();
        SJctrLogUty logUty = usrCtr.createLogUty();
        logUty.setTitle(this.getClass().getSimpleName());
        this.setLogUty(logUty);
        SJctrLogUty dataModelLogUty = usrCtr.createLogUty();
        dataModelLogUty.setTitle(logUty.getTitle());
        this.dataModel.setLogUty(dataModelLogUty);
    }

    public SJctrLogUty getLogUty() {
        return this.logUty;
    }

    public void setLogUty(SJctrLogUty logUty) {
        this.logUty = logUty;
    }

    public SJctrUserController getOwner() {
        return this.mUsrCtr;
    }

    @Override
    public SJctrRequestDataObject post(SJctrRequestDataObject req) throws SJcException {
        this.logUty.putlog("post", "start");
        Long sTime = System.currentTimeMillis();
        SJctrRequestDataObject ret = null;
        Integer request = req.request();
        if (request != null) {
            SJctrAction action = this.mActionMap.get(request);
            if (action != null) {
                ret = action.execute(req);
            } else {
                this.logUty.putlog("request", "Invalid");
                ret = req.createDefualtResponse();
            }
        }
        Long time = System.currentTimeMillis() - sTime;
        this.logUty.putlog("post", "end execute time(ms)=" + time);
        return ret;
    }

    public void finish() throws SJcException {
        this.saveControlData();
        this.resetDispInf();
        this.mUsrCtr = null;
    }

    protected SJctrRequestDataObject requestGet(SJctrRequestDataObject req) {
        SJctrRequestDataObject ret = req.createDefualtResponse();
        SJctrDataObject inputObject = (SJctrDataObject)req.getData("COM_TARGET");
        if (inputObject == null) {
            this.construct();
        }
        SJctrDataObject outputObject = (SJctrDataObject)this.dataModel.getDataObject(inputObject);
        if (this.getAsyncIf() != null && this.getReqModelData() == null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.putAll(outputObject.getDataMap());
            SJctrDataObject outputClone = new SJctrDataObject();
            outputClone.setDataMap(data);
            ArrayList<SJctrRelatedDispDataObject> relatedDispList = new ArrayList<SJctrRelatedDispDataObject>();
            relatedDispList.add(this.asyncRelated);
            outputClone.setData("COM_CHILD", relatedDispList);
            ret.target(outputClone);
        } else {
            ret.target(outputObject);
        }
        this.dataModel.clearDirty();
        return ret;
    }

    protected SJctrRequestDataObject requestSet(SJctrRequestDataObject req) {
        this.updateDisp.clear();
        SJctrRequestDataObject ret = req.createDefualtResponse();
        SJctrDataObject reqTarget = req.target();
        this.dataModel.setDataObject(reqTarget);
        SJctrRelatedDispDataObject related = this.getUpdateDisp();
        this.addUpdateDisp(related);
        ret.update(this.getUpdataDispList());
        return ret;
    }

    public void addUpdateDisp(SJctrRelatedDispDataObject related) {
        if (related != null) {
            this.updateDisp.add(related);
        }
    }

    public SJctrRelatedDispDataObject getUpdateDisp() {
        SJctrUserController uc = this.getOwner();
        if (uc == null) {
            return null;
        }
        SJctrDataObject target = this.dataModel.getDirtyTarget();
        if (target == null) {
            return null;
        }
        SJctrRelatedDispDataObject relatedDisp = null;
        this.dataModel.clearDirty();
        relatedDisp = uc.getRelatedDispData(this.getuId());
        if (relatedDisp != null) {
            relatedDisp.target(target);
        }
        return relatedDisp;
    }

    public List<SJctrRelatedDispDataObject> getUpdataDispList() {
        ArrayList<SJctrRelatedDispDataObject> retList = new ArrayList<SJctrRelatedDispDataObject>(this.updateDisp);
        this.updateDisp.clear();
        return retList;
    }

    public void setDirtyAll() {
        this.dataModel.setDirtyAll();
    }

    protected void addDataObjectModel(String key, SJctrDataObjectModel<? extends SJctrDataObject> model) {
        this.dataModel.addDataModel(key, model);
    }

    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        this.logUty.putlog("Make data model", "begin");
        long time = System.currentTimeMillis();
        Set<SJctrGetDirectWrapper> directList = this.getModelDirect();
        directList.add(this.getLastUpdateTimeDirect());
        Map<SJctrGetDirectWrapper, List<?>> map = this.getDataInf(directList);
        this.checkConstructData();
        this.divideModelData(map);
        this.setLastUpdateTime(map);
        this.makeDataModel();
        this.logUty.putlog("Make data model", "end:" + (System.currentTimeMillis() - time) + "ms");
    }

    public Set<SJctrGetDirectWrapper> getModelDirect() {
        List<SJctrGetDirectWrapper> list = this.dataModel.createModelDirect();
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>(list);
        return set;
    }

    protected Map<SJctrGetDirectWrapper, List<?>> getDataInf(Set<SJctrGetDirectWrapper> directList) {
        Map<SJctrGetDirectWrapper, List<?>> map;
        if (this.getAsyncIf() != null) {
            map = this.getReqModelData();
            this.proxy.setDataInf(map);
        } else {
            map = this.proxy.getDataInf(directList);
        }
        return map;
    }

    public boolean checkConstructData() {
        boolean result = true;
        return result;
    }

    public void divideModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        this.dataModel.divideModelData(models);
    }

    public void makeDataModel() {
        this.dataModel.makeDataModel();
    }

    public void construct() throws SJcException {
        boolean construct = this.isConstruct();
        boolean asyncFlg = this.chkAsyncGet();
        if (!construct && !asyncFlg) {
            this.preRestoreControlData();
            this.makeDataObjectModel(this.dataModel.keySet());
            this.restoreControlData();
            this.constructFlg = true;
        } else if (!construct && asyncFlg) {
            SJctrAsyncGetInterface async = this.getAsyncIf();
            this.asyncRelated = this.createAsyncGet(async);
            SJctrUserController uc = this.getOwner();
            SJctrAsyncGetDataController dc = (SJctrAsyncGetDataController)uc.getDataController(this.asyncRelated);
            dc.setAsyncType(true);
        }
    }

    private boolean chkAsyncGet() {
        boolean result = false;
        if (this.getAsyncIf() != null && this.getReqModelData() == null) {
            result = true;
        }
        return result;
    }

    public SJctrDataObjectModel<? extends SJctrDataObject> getDataObjectModel(String key) {
        return this.dataModel.getDataModel(key);
    }

    public void refreshDataModel(List<SJctrDataObjectModel<?>> dataModelList) {
        this.getLogUty().putlog("refreshDataModel", "begin:" + dataModelList);
        long time = System.currentTimeMillis();
        HashSet<SJctrGetDirectWrapper> directList = new HashSet<SJctrGetDirectWrapper>();
        for (SJctrDataObjectModel<?> dataModel : dataModelList) {
            directList.addAll(dataModel.createModelDirect());
        }
        Map<SJctrGetDirectWrapper, List<?>> map = this.getProxy().getDataInf(directList);
        for (SJctrDataObjectModel<?> dataModel : dataModelList) {
            dataModel.divideModelData(map);
        }
        for (SJctrDataObjectModel<?> dataModel : dataModelList) {
            dataModel.makeDataModel();
        }
        this.getLogUty().putlog("refreshDataModel", "end:" + (System.currentTimeMillis() - time) + "ms");
    }

    public void setParameter(Object ... args) {
    }

    void setUId(int id) {
        this.uId = id;
    }

    @Override
    public int getuId() {
        return this.uId;
    }

    public void addMessageEventListener(SJctrNotifyState state, SJctrMessageEventListener listener) {
        this.dataModel.addMessageEventListener(state, listener);
    }

    public boolean isConstruct() {
        return this.constructFlg;
    }

    protected void clearData() {
        this.constructFlg = false;
        this.dataModel.clearData();
    }

    public void clearDataforColumnSettings() {
        this.clearData();
    }

    public String getExport() {
        this.logUty.putlog("Make Export", "begin");
        long time = System.currentTimeMillis();
        StringBuilder buf = new StringBuilder(1024);
        this.dataModel.getExport(buf);
        this.logUty.putlog("Make Export", "end: " + (System.currentTimeMillis() - time) + " ms");
        return buf.toString();
    }

    public static boolean isDispKind(int dispId, int kind) {
        int dispKind = dispId & 0xFF00000;
        return dispKind == kind;
    }

    public boolean isDispKind(int kind) {
        int dispId = this.getDisplayId();
        return SJctrDataController.isDispKind(dispId, kind);
    }

    protected SJctrDataObject getManageData() {
        return this.dataModel.getManageData();
    }

    public SJctrTopWindowDC getTopWindow() {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(SJctrTopWindowDC.class);
        SJctrTopWindowDC dc = (SJctrTopWindowDC)uc.getDataController(related);
        return dc;
    }

    protected final SJctrComUtility getComUtility() {
        return this.utility;
    }

    public final Map<String, Map<String, Object>> getActionMenu() {
        return this.dataModel.getActionMenu();
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_STATE.MAKE_WIZARD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                List list;
                Object obj = event.getNofifyObject();
                if (obj instanceof List && (list = (List)obj).size() > 0) {
                    Class subwiz = (Class)list.get(0);
                    Map param = null;
                    if (list.size() > 1) {
                        param = (Map)list.get(1);
                    }
                    SJctrRelatedDispDataObject wizardRelated = SJctrDataController.this.createWizard(subwiz, param);
                    SJctrDataController.this.addUpdateDisp(wizardRelated);
                }
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MAKE_DIALOG_EX, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                List list;
                Object obj = event.getNofifyObject();
                if (obj instanceof List && (list = (List)obj).size() > 0) {
                    Class dialogClass = (Class)list.get(0);
                    Map param = null;
                    if (list.size() > 1) {
                        param = (Map)list.get(1);
                    }
                    SJctrRelatedDispDataObject dialogRelated = SJctrDataController.this.createDialog(dialogClass, param);
                    SJctrDataController.this.addUpdateDisp(dialogRelated);
                }
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MOVE_LISTVIEW, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object obj = event.getNofifyObject();
                SJctrDataController.this.moveEventAction(obj, "COM_SUBSYSTEM");
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MAKE_OLDGUI, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object obj = event.getNofifyObject();
                if (obj instanceof String) {
                    String appID = (String)obj;
                    SJctrRelatedDispDataObject related = SJctrDataController.this.createExecApp(appID);
                    SJctrDataController.this.addUpdateDisp(related);
                }
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MOVE_ADMIN, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object obj = event.getNofifyObject();
                SJctrDataController.this.moveEventAction(obj, "COM_ADMIN");
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MOVE_PERFORMANCE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object obj = event.getNofifyObject();
                SJctrDataController.this.moveEventAction(obj, "COM_PERFORMANCE");
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MAKE_EXPORT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMakeExport makeExport = new SJctrMakeExport();
                Object obj = event.getNofifyObject();
                if (!(obj instanceof List)) {
                    return;
                }
                List list = (List)obj;
                SJctrDataObjectModel exportDataModel = (SJctrDataObjectModel)list.get(0);
                makeExport.setExportDataModel(exportDataModel);
                if (list.size() > 1) {
                    String defaultFileName = (String)list.get(1);
                    makeExport.setDefaultFileName(defaultFileName);
                } else {
                    String tabLabel = "";
                    if (exportDataModel instanceof SJctrTableDataModel) {
                        tabLabel = ((SJctrTableDataModel)exportDataModel).getExportTabLabel();
                    }
                    String STR_EXPORT = "Export";
                    tabLabel = tabLabel + STR_EXPORT;
                    String defaultFileName = SJctrComUtility.getTsvFileName(tabLabel);
                    makeExport.setDefaultFileName(defaultFileName);
                }
                SJctrRelatedDispDataObject related = SJctrDataController.this.createFileDownload(makeExport);
                SJctrDataController.this.addUpdateDisp(related);
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.SELECT_MENU, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTopWindowDC topDc = SJctrDataController.this.getTopWindow();
                if (topDc == null) {
                    SJctrDataController.this.getLogUty().putlog("MessageListener", "TopWindowDC is null", 30000);
                    return;
                }
                Object obj = event.getNofifyObject();
                if (obj instanceof String) {
                    SJctrRelatedDispDataObject related = topDc.createLaunch((String)obj);
                    SJctrDataController.this.addUpdateDisp(related);
                }
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MAKE_DOWNLOAD_NEW, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrShredDownloadIF shredDown = new SJctrShredDownloadIF();
                shredDown.setDownType(0);
                Object obj = event.getNofifyObject();
                if (!(obj instanceof String)) {
                    return;
                }
                SJctrRelatedDispDataObject related = SJctrDataController.this.createFileDownload((SJctrFileDownloadInterface)shredDown);
                SJctrDataController.this.addUpdateDisp(related);
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MAKE_DOWNLOAD_OLD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrShredDownloadIF shredDown = new SJctrShredDownloadIF();
                shredDown.setDownType(1);
                Object obj = event.getNofifyObject();
                if (!(obj instanceof String)) {
                    return;
                }
                SJctrRelatedDispDataObject related = SJctrDataController.this.createFileDownload((SJctrFileDownloadInterface)shredDown);
                SJctrDataController.this.addUpdateDisp(related);
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.MAKE_DIALOG_ASYNC_GET, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object obj = event.getNofifyObject();
                if (obj instanceof List) {
                    List list = (List)obj;
                    if (list.size() == 0) {
                        return;
                    }
                    Class dialogClass = (Class)list.get(0);
                    Map param = null;
                    if (list.size() > 1) {
                        param = (Map)list.get(1);
                    }
                    SJctrRelatedDispDataObject dialogRelated = SJctrDataController.this.createDialog(dialogClass, param);
                    int dialogUid = dialogRelated.uId();
                    SJctrDataController dialogDc = SJctrDataController.this.getOwner().getDataController(dialogUid);
                    dialogDc.dialogAsyncGet = true;
                    SJctrRelatedDispDataObject asyncRelated = SJctrDataController.this.createAsyncGet(dialogDc);
                    SJctrDataController.this.addUpdateDisp(asyncRelated);
                }
            }
        });
        this.addMessageEventListener(NOTIFY_STATE.TREE_EXPAND_EVNET_MSG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrDataObjectModel<? extends SJctrDataObject> srcModel = event.getSource();
                Object msg = event.getNofifyObject();
                SJctrDataController.this.doMessageTreeExpand(srcModel, msg);
            }
        });
    }

    public void moveEventAction(Object obj, String key) {
        List list;
        if (obj instanceof List && (list = (List)obj).size() > 0) {
            Class dcClass = (Class)list.get(0);
            Object[] args = new Object[list.size() - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = list.get(i + 1);
            }
            SJctrTopWindowDC topWindowDC = this.getTopWindow();
            SJctrAccordionTreeModel accordionTreeModel = (SJctrAccordionTreeModel)topWindowDC.getDataObjectModel(key);
            accordionTreeModel.moveDisplay(accordionTreeModel.getTreePath(dcClass, args));
            List updataDispList = topWindowDC.getUpdataDispList();
            for (SJctrRelatedDispDataObject related : updataDispList) {
                this.addUpdateDisp(related);
            }
        }
    }

    public SJctrRelatedDispDataObject createWizard(Class<? extends SJctrSubWizard> subwiz, Map<String, List<?>> param) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject wizardRelated = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC wizardDC = (SJctrWizardWindowDC)uc.getDataController(wizardRelated);
        try {
            wizardDC.addSubWizard(subwiz);
            SJctrSubWizard subWizard = wizardDC.getSubWizard(subwiz);
            subWizard.setUnitSelect(this.getUnitSelect());
            wizardDC.next();
            if (param != null) {
                for (Map.Entry<String, List<?>> entry : param.entrySet()) {
                    wizardDC.putCache(entry.getKey(), entry.getValue());
                }
            }
            wizardDC.setParentDC(this);
            SJctrWizardDataController dc = wizardDC.getFirstWizardDataController(subwiz);
            if (dc == null) {
                wizardDC.singleWizardConfirm();
                dc = wizardDC.getNowWizardDataController();
            }
            dc.checkStartData();
        }
        catch (RuntimeException e) {
            uc.removeRelatedDispData(wizardDC.getuId());
            throw e;
        }
        this.dataModel.clearDirty();
        return wizardRelated;
    }

    public SJctrRelatedDispDataObject createWizardForRegularBackup(Class<? extends SJctrSubWizard> subwiz) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject wizardRelated = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC wizardDC = (SJctrWizardWindowDC)uc.getDataController(wizardRelated);
        try {
            wizardDC.addSubWizardForRegularBackup(subwiz);
            SJctrSubWizard subWizard = wizardDC.getSubWizard(subwiz);
            subWizard.setUnitSelect(this.getUnitSelect());
            wizardDC.next();
            wizardDC.setParentDC(this);
            SJctrWizardDataController dc = wizardDC.getFirstWizardDataController(subwiz);
            if (dc == null) {
                wizardDC.singleWizardConfirm();
                dc = wizardDC.getNowWizardDataController();
            }
            dc.checkStartData();
        }
        catch (RuntimeException e) {
            uc.removeRelatedDispData(wizardDC.getuId());
            throw e;
        }
        this.dataModel.clearDirty();
        return wizardRelated;
    }

    private SJctrRelatedDispDataObject createConflictMsg(final SJctrRelatedDispDataObject wizardRelated, final SJctrWizardWindowDC wizardDC) {
        final SJctrUserController uc = this.getOwner();
        SJcMessage msg = new SJcMessage(MSG_ID_COMMON, MSG_ID_CONTROLLER, MSG_ID_CONFLICT);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)((Object)uc.getDataController(related));
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrDataController.this.addUpdateDisp(wizardRelated);
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                uc.removeRelatedDispData(wizardDC.getuId());
            }
        });
        return related;
    }

    public SJctrRelatedDispDataObject createDialog(Class<? extends SJctrDialogDataController> dialog, Map<String, List<?>> param) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject dialogRelated = uc.createRelatedDispData(dialog);
        SJctrDialogDataController dialogDC = (SJctrDialogDataController)((Object)uc.getDataController(dialogRelated));
        try {
            dialogDC.setProxy(this.getProxy());
            dialogDC.initCache();
            dialogDC.addRelatedDataController(this);
            dialogDC.setRollBackInfo(this.getRollBackInfo());
            if (param != null) {
                Map<String, List<?>> addtionalParam = this.putDialogCacheData();
                param.putAll(addtionalParam);
                for (Map.Entry<String, List<?>> entry : param.entrySet()) {
                    dialogDC.putCache(entry.getKey(), entry.getValue());
                }
            }
            dialogDC.checkStartData();
        }
        catch (RuntimeException e) {
            uc.removeRelatedDispData(dialogDC.getuId());
            throw e;
        }
        this.dataModel.clearDirty();
        return dialogRelated;
    }

    protected Map<String, List<?>> putDialogCacheData() {
        return new HashMap();
    }

    public SJctrRelatedDispDataObject createMsgDialog(SJcMessage msg) {
        SJctrRelatedDispDataObject relatedDisp = this.createDialog(SJctrMessageDataController.class, null);
        SJctrMessageDataController msgDlg = (SJctrMessageDataController)((Object)this.getOwner().getDataController(relatedDisp));
        msgDlg.setMessage(msg);
        return relatedDisp;
    }

    public SJctrRelatedDispDataObject createExecApp(String appID) {
        this.getLogUty().putlog("createExecApp", "appID=" + appID);
        SJctrRelatedDispDataObject relatedDisp = this.createDialog(SJctrExecAppDataController.class, null);
        SJctrExecAppDataController appDC = (SJctrExecAppDataController)((Object)this.getOwner().getDataController(relatedDisp));
        appDC.setAppID(appID);
        return relatedDisp;
    }

    public SJctrRelatedDispDataObject createFileDownload(SJctrFileDownloadInterface download) {
        SJctrRelatedDispDataObject related = this.createDialog(SJctrFileDownloadDataController.class, null);
        SJctrFileDownloadDataController downloadDC = (SJctrFileDownloadDataController)((Object)this.getOwner().getDataController(related));
        downloadDC.setFileDownload(download);
        return related;
    }

    public SJctrRelatedDispDataObject createFileUpload(SJctrFileUploadInterface upload) {
        SJctrRelatedDispDataObject related = this.createDialog(SJctrFileUploadDataController.class, null);
        SJctrFileUploadDataController uploadDC = (SJctrFileUploadDataController)((Object)this.getOwner().getDataController(related));
        uploadDC.setFileUpload(upload);
        return related;
    }

    public final void addRelatedDataController(SJctrDataController dc) {
        if (dc != null) {
            if (this.relatedDCList == null) {
                this.relatedDCList = new ArrayList<SJctrDataController>();
            }
            this.relatedDCList.add(dc);
        }
    }

    public final void doMessageEvent(SJctrMessageEvent message) {
        this.dataModel.doMessageEvent(message);
    }

    public final void fireMessageEvent(SJctrNotifyState state) {
        SJctrMessageEvent message = new SJctrMessageEvent(this.dataModel, state);
        this.doMessageEvent(message);
    }

    public final void fireMessageEvent(SJctrNotifyState state, Object obj) {
        SJctrMessageEvent message = new SJctrMessageEvent(this.dataModel, state, obj);
        this.doMessageEvent(message);
    }

    public void setControlData(HashMap<String, Object> controlData) {
        this.dataModel.setControlData(controlData);
    }

    public void setPreControlData(HashMap<String, Object> controlData) {
        this.dataModel.setPreControlData(controlData);
    }

    public HashMap<String, Object> getControlData() {
        return this.dataModel.getControlData();
    }

    public void resetControlData() {
        this.dataModel.resetControlData();
    }

    public boolean isRestoreFlg() {
        return this.restoreFlg;
    }

    public void setRestoreFlg(boolean restoreFlg) {
        this.restoreFlg = restoreFlg;
    }

    protected void setDetaultRestoreFlg() {
        boolean flg = false;
        if (this.isDispKind(0)) {
            flg = true;
        } else if (this.isDispKind(0x100000)) {
            flg = true;
        }
        this.setRestoreFlg(flg);
    }

    public void saveControlData() {
        if (!this.isRestoreFlg()) {
            return;
        }
        if (!this.isConstruct()) {
            this.getLogUty().putlog("saveControlData", "unconstruct");
            return;
        }
        HashMap<String, Object> newData = this.getControlData();
        SJctrUserController uc = this.getOwner();
        HashMap<String, Object> data = uc.getControlData(this.getDisplayId());
        data.putAll(newData);
    }

    public void restoreControlData() {
        if (!this.isRestoreFlg()) {
            return;
        }
        SJctrUserController uc = this.getOwner();
        HashMap<String, Object> data = uc.getControlData(this.getDisplayId());
        this.setControlData(data);
    }

    public void preRestoreControlData() {
        if (!this.isRestoreFlg()) {
            return;
        }
        SJctrUserController uc = this.getOwner();
        HashMap<String, Object> data = uc.getControlData(this.getDisplayId());
        this.setPreControlData(data);
    }

    protected final List<SJctrDataController> getRelatedDataController() {
        if (this.relatedDCList != null) {
            for (int i = this.relatedDCList.size() - 1; i >= 0; --i) {
                if (this.relatedDCList.get(i).getOwner() != null) continue;
                this.relatedDCList.remove(i);
            }
        }
        return this.relatedDCList;
    }

    public List<?> getModelData(Class kindClass) {
        return this.getModelData(kindClass, false);
    }

    public List<?> getModelData(Class kindClass, boolean cache) {
        SJmoGetKind_IF kind = null;
        try {
            kind = (SJmoGetKind_IF)kindClass.newInstance();
        }
        catch (Exception e) {
            this.getLogUty().putlog("getModelData", "new fail:" + kindClass, e, 20000);
            throw new SJcException();
        }
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper directWrap = new SJctrGetDirectWrapper(direct, cache);
        return this.getModelData(directWrap);
    }

    public List<?> getModelData(SJctrGetDirectWrapper directWrap) {
        HashSet<SJctrGetDirectWrapper> getSet = new HashSet<SJctrGetDirectWrapper>();
        getSet.add(directWrap);
        Map<String, List<?>> cacheDataMap = null;
        cacheDataMap = this.getModelData(getSet);
        return cacheDataMap.get(directWrap.getCacheKey());
    }

    public Map<String, List<?>> getModelData(Set<SJctrGetDirectWrapper> set) {
        Map<SJctrGetDirectWrapper, List<?>> datamap = this.getProxy().getDataInf(set);
        HashMap cacheDataMap = new HashMap();
        for (SJctrGetDirectWrapper wrapper : set) {
            List<?> dataList = datamap.get(wrapper);
            if (dataList == null) {
                dataList = new ArrayList(0);
            }
            cacheDataMap.put(wrapper.getCacheKey(), dataList);
        }
        return cacheDataMap;
    }

    protected SJctrSimpleDataModel getRootDataModel() {
        return this.dataModel;
    }

    public String getUnitSelect() {
        return this.unitSelect;
    }

    public void setUnitSelect(String unitSelect) {
        this.unitSelect = unitSelect;
    }

    private void doMessageTreeExpand(final SJctrDataObjectModel<?> srcModel, Object msg) {
        if (!(msg instanceof SJcMessage)) {
            this.getLogUty().putlog("doMessageTreeNode", "Message: " + msg, 30000);
            return;
        }
        SJctrRelatedDispDataObject related = this.createMsgDialog((SJcMessage)msg);
        SJctrMessageDataController msgDc = (SJctrMessageDataController)((Object)this.getOwner().getDataController(related));
        msgDc.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                srcModel.setDirty();
            }
        });
        this.addUpdateDisp(related);
    }

    public SJctrRelatedDispDataObject createAsyncGet(SJctrAsyncGetInterface async) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject related = uc.createRelatedDispData(SJctrAsyncGetDataController.class);
        SJctrAsyncGetDataController dc = (SJctrAsyncGetDataController)uc.getDataController(related);
        dc.setAsyncGet(async);
        int tmie = async.getTurnAroundTime();
        related.setData(COM_TURN_AROUND, tmie);
        return related;
    }

    public SJctrAsyncGetInterface getAsyncIf() {
        return null;
    }

    public Map<SJctrGetDirectWrapper, List<?>> getReqModelData() {
        Map<SJctrGetDirectWrapper, List<?>> map = null;
        return map;
    }

    public SJcException getAsyncExseption() {
        return this.asyncException;
    }

    @Override
    public void setAsyncException(SJcException e) {
        this.asyncException = e;
    }

    @Override
    public boolean isDialogAsyncGet() {
        return this.dialogAsyncGet;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelRequest() {
        return this.getModelDirect();
    }

    @Override
    public int getTurnAroundTime() {
        return 0;
    }

    @Override
    public void setModelData(Map<SJctrGetDirectWrapper, List<?>> map) {
    }

    void resetDispInf() {
        this.mUsrCtr.resetDispInf();
        this.mUsrCtr.resetUserProperty();
        if (this.isDispKind(0)) {
            this.mUsrCtr.setResetViewSettings(false);
        }
    }

    SJctrGetDirectWrapper getLastUpdateTimeDirect() {
        SJmoGetDirect direct = new SJmoGetDirect();
        direct.setGetKind((SJmoGetKind_IF)new SJmoGetLastUpdateTime());
        return new SJctrGetDirectWrapper(direct, false);
    }

    public void setLastUpdateTime(Map<SJctrGetDirectWrapper, List<?>> map) {
        Object time;
        if (!this.isDispKind(0)) {
            return;
        }
        if (this.getDisplayId() == 0) {
            return;
        }
        SJctrTopWindowDC topWindow = this.getTopWindow();
        SJctrLastUpdateTimeModel lastUpdateTimeModel = (SJctrLastUpdateTimeModel)topWindow.getDataObjectModel("COM_LASTUPDATE");
        Date date = null;
        List<?> datalist = map.get(this.getLastUpdateTimeDirect());
        if (datalist != null && datalist.size() > 0 && (time = datalist.get(0)) instanceof Date) {
            date = (Date)datalist.get(0);
        }
        lastUpdateTimeModel.setLastUpdateTime(date);
        this.addUpdateDisp(topWindow.getUpdateDisp());
    }

    public static boolean isHM() {
        return SJctrControllerManager.isHM();
    }

    public Map<String, List<?>> getDisplayParam(SJctrDirectLauncher dl) throws SJcException {
        return null;
    }

    public static enum NOTIFY_STATE implements SJctrNotifyState
    {
        NOTHING,
        CHANGE_TABLE,
        MOVE_DISP,
        MAKE_WIZARD,
        MAKE_DIALOG,
        MOVE_LISTVIEW,
        MAKE_OLDGUI,
        SELECT_MENU,
        MOVE_ADMIN,
        MOVE_PERFORMANCE,
        MAKE_DIALOG_EX,
        MAKE_EXPORT,
        MAKE_DOWNLOAD_NEW,
        MAKE_DOWNLOAD_OLD,
        MAKE_DIALOG_ASYNC_GET,
        TREE_EXPAND_EVNET_MSG;

    }
}

