/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_DKCgetSystemOption;
import sanproject.serverux.dataimpl.EXDTargetPort_Fiber;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrIpAddrUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrHostModeOptionTableKey;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserInfoIncludeNewChap;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrCommStatusInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiDataMacro;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameInfoIncludeLoginStatus;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameInfoIncludeNewHost;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortChapUserInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLoginIscsiNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortLoginIscsiNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrIscsiUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    private static final int ERROR_PART_DIGIT = 100;

    public SJctrIscsiUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    private static List<?> getCache(SJctrDataController dc, Class<?> key) {
        if (dc instanceof SJctrWizardDataController) {
            return ((SJctrWizardDataController)dc).getCache(key);
        }
        return dc.getProxy().getCache(key);
    }

    public static List<SJmoPortIscsiTargetInfo> getSJmoPortIscsiTargetInfoList(SJctrDataController dc) {
        List<SJmoPortIscsiTargetInfo> info = SJctrIscsiUtility.getCache(dc, SJmoGetPortIscsiTargetInfo.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoPortIscsiTargetInfoList", "PortIscsiTargetInfoList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoPortIscsiNameInfo> getSJmoPortIscsiNameInfoList(SJctrDataController dc) {
        List<SJmoPortIscsiNameInfo> info = SJctrIscsiUtility.getCache(dc, SJmoGetPortIscsiNameInfo.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoPortIscsiNameInfoList", "PortIscsiNameInfoList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoPortLoginIscsiNameInfo> getSJmoPortLoginIscsiNameInfoList(SJctrDataController dc) {
        List<SJmoPortLoginIscsiNameInfo> info = SJctrIscsiUtility.getCache(dc, SJmoGetPortLoginIscsiNameInfo.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoPortLoginIscsiNameInfoList", "PortLoginIscsiNameInfoList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoPortChapUserInfo> getSJmoPortChapUserInfoList(SJctrDataController dc) {
        List<SJmoPortChapUserInfo> info = SJctrIscsiUtility.getCache(dc, SJmoGetPortChapUserInfo.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoPortChapUserInfoList", "PortChapUserInfoList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoPortDetail> getSJmoPortDetailList(SJctrDataController dc) {
        List<SJmoPortDetail> info = SJctrIscsiUtility.getCache(dc, SJmoGetPortDetail.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoPortDetailList", "PortDetailList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoPortAttributeInfo> getSJmoPortAttributeInfoList(SJctrDataController dc) {
        List<SJmoPortAttributeInfo> info = SJctrIscsiUtility.getCache(dc, SJmoGetPortAttributeInfo.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoPortAttributeInfoList", "PortAttributeInfoList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoRSGgetAllRsgs> getSJmoRSGgetAllRsgsList(SJctrDataController dc) {
        List<SJmoRSGgetAllRsgs> info = SJctrIscsiUtility.getCache(dc, SJmoGetRSGgetAllRsgs.class);
        if (info == null || info.size() == 0) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoRSGgetAllRsgsList", "RSGgetAllRsgsList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (info.get(0) == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoRSGgetAllRsgsList", "RSGgetAllRsgs is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static SJmoSubsystemInfo getSJmoSubsystemInfo(SJctrDataController dc) {
        List<?> info = SJctrIscsiUtility.getCache(dc, SJmoGetSubsystemInfo.class);
        if (info == null || info.size() == 0) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoSubsystemList", "SubsystemInfoList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (info.get(0) == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoSubsystemList", "SystemOption is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return (SJmoSubsystemInfo)info.get(0);
    }

    public static Robj_interface_DKCgetSystemOption[] getSystemOptionInfo(SJctrWizardDataController dc) {
        Robj_interface_DKCgetSystemOption[] sysOptList = null;
        List optList = dc.getCache(SJctrGetSystemOption.class);
        if (optList == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getHostModeReserveOption", "System option list is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (optList.isEmpty()) {
            SJctrLogUty.error("SJctrIscsiUtility", "getHostModeReserveOption", "System option list is empty.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)optList.get(0);
        sysOptList = (Robj_interface_DKCgetSystemOption[])rmiData.getObjRmi();
        if (sysOptList == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getHostModeReserveOption", "System option list from RMI is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (sysOptList.length == 0) {
            SJctrLogUty.error("SJctrIscsiUtility", "getHostModeReserveOption", "System option list from RMI is empty.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return sysOptList;
    }

    public static List<SJmoChapUserInfo> getSpecifiedPortChapUserInfo(List<SJmoPortChapUserInfo> portChapInfoList, short port) {
        ArrayList chapUserList = new ArrayList();
        if (null == portChapInfoList) {
            return chapUserList;
        }
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(port);
        int index = Collections.binarySearch(portChapInfoList, portIndex);
        if (index >= 0) {
            SJmoPortChapUserInfo portChapUserInfo = portChapInfoList.get(index);
            chapUserList = portChapUserInfo.getAlPortChapUser();
        }
        return chapUserList;
    }

    public static List<SJctrChapUserWithTgInfo> getAllChapUserInfo(List<SJmoPortIscsiTargetInfo> portIscsiTargetList) {
        ArrayList<SJctrChapUserWithTgInfo> chapUserList = new ArrayList<SJctrChapUserWithTgInfo>();
        if (portIscsiTargetList == null) {
            SJctrLogUty.error(SJctrIscsiUtility.class.getSimpleName(), "getSJmoPortIscsiTargetInfo", "Argument is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            throw err.createException();
        }
        for (SJmoPortIscsiTargetInfo portIscsiInfo : portIscsiTargetList) {
            ArrayList iscsiList = portIscsiInfo.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo iscsiInfo : iscsiList) {
                ArrayList chapList = iscsiInfo.getAlUserInfo();
                for (SJmoChapUserInfo chapInfo : chapList) {
                    SJctrChapUserWithTgInfo chapUserdata = new SJctrChapUserWithTgInfo(chapInfo, iscsiInfo);
                    chapUserList.add(chapUserdata);
                }
            }
        }
        return chapUserList;
    }

    public static Object getPortInfoByPortId(List<? extends SJmoPortIndex> infoList, short portId) {
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(portId);
        return SJctrIscsiUtility.getPortInfoByPortIndex(infoList, portIndex);
    }

    public static Object getPortInfoByPortIndex(List<? extends SJmoPortIndex> infoList, SJmoPortIndex portIndex) {
        int matchIndex;
        SJmoPortIndex ret = null;
        if (null != infoList && null != portIndex && (matchIndex = Collections.binarySearch(infoList, portIndex)) >= 0) {
            ret = infoList.get(matchIndex);
        }
        return ret;
    }

    public static List<SJmoPortLunInfo> getSJmoPortLunInfo(SJctrDataController dc) {
        List<SJmoPortLunInfo> info = SJctrIscsiUtility.getCache(dc, SJmoGetPortLunInfo.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoPortLunInfo", "LUPath is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoLdevGuardInfo> getSJmoLdevGuardInfo(SJctrDataController dc) {
        List<SJmoLdevGuardInfo> info = SJctrIscsiUtility.getCache(dc, SJmoGetLdevGuardInfo.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoLdevGuardInfo", "LdevGuardInfo is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoLdevDetail> getSJmoLdevDetail(SJctrDataController dc) {
        List<SJmoLdevDetail> info = SJctrIscsiUtility.getCache(dc, SJmoGetLdevDetail.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoLdevDetail", "LDEV Detail is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoPortIscsiTargetPathInfo> getSJmoPortIscsiTargetPathInfoList(SJctrDataController dc) {
        List<SJmoPortIscsiTargetPathInfo> info = SJctrIscsiUtility.getCache(dc, SJmoGetPortIscsiTargetPathInfo.class);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoPortIscsiTargetPathInfoList", "PortIscsiTargetPathInfoList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static SJmoExdTargetPortInfoMgr getSJmoExdTargetPortInfoMgr(SJctrDataController dc) {
        List<?> infoList = SJctrIscsiUtility.getCache(dc, SJmoGetExdTargetPortInfoMgr.class);
        if (infoList == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoExdTargetPortInfoList", "ExdTargetPortInfoMgrList is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (infoList.size() == 0) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoExdTargetPortInfoList", "Size of ExdTargetPortInfoMgrList is zero.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        SJmoExdTargetPortInfoMgr info = (SJmoExdTargetPortInfoMgr)infoList.get(0);
        if (info == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getSJmoExdTargetPortInfoList", "ExdTargetPortInfoMgr is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return info;
    }

    public static List<SJmoIscsiTargetPathInfo> checkAndGetIscsiTargetPathInfo(List<SJmoPortIscsiTargetPathInfo> modelIscsiPathList, List<SJmoIscsiTargetPathInfo> selectIscsiPathList) {
        if (modelIscsiPathList == null || selectIscsiPathList == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "checkAndGetIscsiTargetPathInfo", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        ArrayList<SJmoIscsiTargetPathInfo> iscsiPathList = new ArrayList<SJmoIscsiTargetPathInfo>(selectIscsiPathList.size());
        for (SJmoIscsiTargetPathInfo iscsiPathInfo : selectIscsiPathList) {
            SJmoIscsiTargetPathInfo searchPathInfo = null;
            SJmoPortIscsiTargetPathInfo portIscsiPath = (SJmoPortIscsiTargetPathInfo)SJctrIscsiUtility.getPortInfoByPortId(modelIscsiPathList, iscsiPathInfo.getSPort());
            if (null != portIscsiPath) {
                searchPathInfo = SJctrIscsiUtility.getIscsiTargetPathInfoByIndex(portIscsiPath, iscsiPathInfo);
            }
            if (searchPathInfo == null) {
                SJctrLogUty.error("SJctrIscsiUtility", "checkAndGetIscsiTargetPathInfo", "Not found iSCSI Path data. Target# : " + iscsiPathInfo.toString());
                throw SJctrIscsiUtility.makeException(206524);
            }
            try {
                SJmoIscsiTargetPathInfo clonePathInfo = (SJmoIscsiTargetPathInfo)searchPathInfo.clone();
                iscsiPathList.add(clonePathInfo);
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error("SJctrIscsiUtility", "checkAndGetIscsiTargetPathInfo", "CloneNotSupportedException");
                throw SJctrIscsiUtility.makeException(107001);
            }
        }
        return iscsiPathList;
    }

    private static String getIpv4AddrString(int[] addrArray) {
        String ret = "?";
        byte[] byAddrArray = new byte[addrArray.length];
        for (int i = 0; i < byAddrArray.length; ++i) {
            byAddrArray[i] = (byte)(addrArray[i] & 0xFF);
        }
        try {
            InetAddress inet = InetAddress.getByAddress(byAddrArray);
            ret = inet.getHostAddress();
        }
        catch (UnknownHostException e) {
            SJctrLogUty.error("SJctrIscsiUtility", "getIpv4AddrString", e.getMessage());
        }
        return ret;
    }

    public String getIpv4AddrString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? SJctrIscsiUtility.getIpv4AddrString(portInfo.getIV4IPAddress()) : "-";
        }
        return ret;
    }

    public String getIpv4AddrString(SJmoIscsiTargetPathInfo iscsiPath) {
        String ret = "?";
        if (iscsiPath != null) {
            ret = iscsiPath.getIIpType() == 0 ? SJctrIscsiUtility.getIpv4AddrString(iscsiPath.getIIpv4Address()) : "-";
        }
        return ret;
    }

    public String getIpv4SubnetMaskString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? SJctrIscsiUtility.getIpv4AddrString(portInfo.getIV4NetMaskAddress()) : "-";
        }
        return ret;
    }

    public String getIpv4DefGatewayString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? SJctrIscsiUtility.getIpv4AddrString(portInfo.getIV4GateWayAddress()) : "-";
        }
        return ret;
    }

    public String getIpv6ModeString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBV6Mode() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED")) : "-";
        }
        return ret;
    }

    public String getIpv6AddrString(SJmoIscsiTargetPathInfo iscsiPath) {
        String ret = "?";
        if (iscsiPath != null) {
            ret = iscsiPath.getIIpType() == 1 ? SJctrIscsiUtility.getIpv6AddrString(iscsiPath.getIIpv6Address()) : "-";
        }
        return ret;
    }

    public static String getIpv6AddrString(int[] addrArray) {
        String ret = "?";
        byte[] byAddrArray = new byte[addrArray.length * 2];
        for (int i = 0; i < addrArray.length; ++i) {
            byAddrArray[i * 2] = (byte)((addrArray[i] & 0xFF00) >>> 8);
            byAddrArray[i * 2 + 1] = (byte)(addrArray[i] & 0xFF);
        }
        try {
            InetAddress inet = InetAddress.getByAddress(byAddrArray);
            ret = inet.getHostAddress();
            byte[] iAddress = inet.getAddress();
            if (iAddress.length == 4) {
                ret = "0:0:0:0:0:ffff:" + ret;
            }
        }
        catch (UnknownHostException e) {
            SJctrLogUty.error("SJctrIscsiUtility", "getIpv6AddrString", e.getMessage());
        }
        return ret;
    }

    public String getIpv6LinkLocalAddrString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBV6Mode() ? (portInfo.getBV6LinkAddressMode() ? this.guidanceHandle.getGuidance("AUTO") + " " + "(" + SJctrIscsiUtility.getIpv6AddrString(portInfo.getIV6LinkAddressAuto()) + ")" : SJctrIscsiUtility.getIpv6AddrString(portInfo.getIV6LinkAddressManual())) : "-") : "-";
        }
        return ret;
    }

    public String getIpv6GlobalAddrString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBV6Mode() ? (portInfo.getBV6GlobalAddressMode() ? this.guidanceHandle.getGuidance("AUTO") + " " + "(" + SJctrIscsiUtility.getIpv6AddrString(portInfo.getIV6GlobalAddressAuto()) + ")" : SJctrIscsiUtility.getIpv6AddrString(portInfo.getIV6GlobalAddressManual())) : "-") : "-";
        }
        return ret;
    }

    public String getIpv6GlobalAddr2String(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBV6Mode() ? (portInfo.getBV6GlobalAddressMode() ? (portInfo.getIV6GlobalAddress2Auto() == null ? "-" : this.guidanceHandle.getGuidance("AUTO") + " " + "(" + SJctrIscsiUtility.getIpv6AddrString(portInfo.getIV6GlobalAddress2Auto()) + ")") : (portInfo.getIV6GlobalAddress2Manual() == null ? "-" : SJctrIscsiUtility.getIpv6AddrString(portInfo.getIV6GlobalAddress2Manual()))) : "-") : "-";
        }
        return ret;
    }

    public String getIpv6AssignDefGatewayString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBV6Mode() ? SJctrIscsiUtility.getIpv6AddrString(portInfo.getIV6GateWayAddress()) : "-") : "-";
        }
        return ret;
    }

    public String getIpv6CurrentDefGatewayString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBV6Mode() ? SJctrIscsiUtility.getIpv6AddrString(portInfo.getIV6GateWayAddressCurrent()) : "-") : "-";
        }
        return ret;
    }

    public String getIpv6LinkLocalAddrStatusString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            if (SJctrIscsiUtility.isIscsiPort(portInfo)) {
                if (portInfo.getBV6Mode()) {
                    switch (portInfo.getIV6LinkAddressStatus()) {
                        case 1: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_VERIFYING");
                            break;
                        }
                        case 2: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_ENABLED");
                            break;
                        }
                        case 3: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_DISABLED");
                            break;
                        }
                        case 4: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_DUPLICATED");
                            break;
                        }
                    }
                } else {
                    ret = "-";
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getIpv6GlobalAddrStatusString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            if (SJctrIscsiUtility.isIscsiPort(portInfo)) {
                if (portInfo.getBV6Mode()) {
                    switch (portInfo.getIV6GlobalAddressStatus()) {
                        case 1: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_VERIFYING");
                            break;
                        }
                        case 2: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_ENABLED");
                            break;
                        }
                        case 3: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_DISABLED");
                            break;
                        }
                        case 4: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_DUPLICATED");
                            break;
                        }
                    }
                } else {
                    ret = "-";
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getIpv6GlobalAddr2StatusString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            if (SJctrIscsiUtility.isIscsiPort(portInfo)) {
                if (portInfo.getBV6Mode()) {
                    switch (portInfo.getIV6GlobalAddress2Status()) {
                        case 1: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_VERIFYING");
                            break;
                        }
                        case 2: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_ENABLED");
                            break;
                        }
                        case 3: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_DISABLED");
                            break;
                        }
                        case 4: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_DUPLICATED");
                            break;
                        }
                        default: {
                            ret = "-";
                            break;
                        }
                    }
                } else {
                    ret = "-";
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public static String getIpv6SubnetPrefixString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBV6Mode() ? String.valueOf(portInfo.getIV6SubnetPrefixSize()) : "-") : "-";
        }
        return ret;
    }

    public String getIpv6DefGatewayStatusString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            if (SJctrIscsiUtility.isIscsiPort(portInfo)) {
                if (portInfo.getBV6Mode()) {
                    switch (portInfo.getIV6GateWayAddressStatus()) {
                        case 2: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_ENABLED");
                            break;
                        }
                        case 3: {
                            ret = this.guidanceHandle.getGuidance("IPV6_STATUS_DISABLED");
                            break;
                        }
                    }
                } else {
                    ret = "-";
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getSecurityString(SJmoPortDetail portInfo, SJmoIscsiTargetIndex targetIndex) {
        String ret = "?";
        if (portInfo != null) {
            boolean ptSec = portInfo.isBPortSecuritySwitch();
            ret = ptSec ? this.guidanceHandle.getGuidance("ENABLED") : (targetIndex.getSIscsiTarget() == 0 ? this.guidanceHandle.getGuidance("DISABLED_ACCESSIBLE") : this.guidanceHandle.getGuidance("DISABLED"));
        }
        return ret;
    }

    public String getTcpPortNumString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? String.valueOf(portInfo.getITcpPortNumber()) : "-";
        }
        return ret;
    }

    public String getMtuSizeString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? String.valueOf(portInfo.getIMtuSize()) + " " + this.guidanceHandle.getGuidance("BYTES") : "-";
        }
        return ret;
    }

    public String getMtuSizeLinkedString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? String.valueOf(portInfo.getILinkedMtuSize()) + " " + this.guidanceHandle.getGuidance("BYTES") : "-";
        }
        return ret;
    }

    public String getMacAddrString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            if (SJctrIscsiUtility.isIscsiPort(portInfo)) {
                int[] addrList = portInfo.getIMACAddress();
                if (addrList.length == 6) {
                    int index = 0;
                    ret = String.format("%02X", addrList[index]);
                    ++index;
                    while (index < 6) {
                        ret = ret + ":" + String.format("%02X", addrList[index]);
                        ++index;
                    }
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getKeepAliveTimerString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? String.valueOf(portInfo.getiKeepAliveTimer()) + " " + this.guidanceHandle.getGuidance("SEC") : "-";
        }
        return ret;
    }

    public String getSelectiveAckString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBAvailableSelectiveACK() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED")) : "-";
        }
        return ret;
    }

    public String getDelayedAckString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBAvailableDelayedACK() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED")) : "-";
        }
        return ret;
    }

    public String getMaximumWindowSizeString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            if (SJctrIscsiUtility.isIscsiPort(portInfo)) {
                int ITcpWindowSize = portInfo.getITcpWindowSize();
                ret = String.valueOf(ITcpWindowSize) + " " + this.guidanceHandle.getGuidance("KB");
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getIsnsModeString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBIsnsServerMode() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED")) : "-";
        }
        return ret;
    }

    public String getIsnsIpAddrString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            if (SJctrIscsiUtility.isIscsiPort(portInfo)) {
                if (portInfo.getBIsnsServerMode()) {
                    if (portInfo.getIIsnsIpType() == 0) {
                        ret = SJctrIscsiUtility.getIpv4AddrString(portInfo.getIIsnsV4Address());
                    } else if (portInfo.getIIsnsIpType() == 1) {
                        ret = SJctrIscsiUtility.getIpv6AddrString(portInfo.getIIsnsV6Address());
                    }
                } else {
                    ret = "-";
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getIsnsTcpPortNumString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBIsnsServerMode() ? String.valueOf(portInfo.getIIsnsTcpPortNumber()) : "-") : "-";
        }
        return ret;
    }

    public String getVlanTagModeString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBAvailableVlanTagging() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED")) : "-";
        }
        return ret;
    }

    public String getVlanIdString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = SJctrIscsiUtility.isIscsiPort(portInfo) ? (portInfo.getBAvailableVlanTagging() ? String.valueOf(portInfo.getIVlanId()) : "-") : "-";
        }
        return ret;
    }

    public String getNumOfLunsString(SJmoPortLunInfo lunInfo) {
        String ret = "?";
        int portLunSize = 0;
        if (lunInfo != null) {
            portLunSize = lunInfo.getAlPortLun().size();
        }
        ret = portLunSize + " " + "(" + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + SJmoDataMacro_IF.MAX_LUN_PORT + ")";
        return ret;
    }

    public String getNumOfHostsString(SJmoPortIscsiNameInfo portIscsiNameInfo) {
        String ret = "?";
        if (portIscsiNameInfo != null) {
            ret = String.valueOf(portIscsiNameInfo.getAlPortIscsiName().size()) + " " + "(" + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + SJmoDataMacro_IF.MAX_ISCSI_NAME_PORT + ")";
        }
        return ret;
    }

    public String getNumOfIscsiTargetsString(SJmoPortIscsiTargetInfo portiscsiTargetInfo, SJctrResourceGroupUtility rsgUtil) {
        String ret = "?";
        if (portiscsiTargetInfo != null && rsgUtil != null) {
            List<SJmoHostGroupIndex> enableRsgPortTargetList = SJctrIscsiUtility.getRsgPortIscsiTargetList((SJmoPortIndex)portiscsiTargetInfo, rsgUtil);
            List<SJmoIscsiTargetInfo> enableRsgTargetList = SJctrIscsiUtility.getRsgIscsiTargetList(portiscsiTargetInfo, rsgUtil);
            ret = enableRsgTargetList.size() + " " + "(" + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + enableRsgPortTargetList.size() + ")";
        }
        return ret;
    }

    public String getNumOfChapUsersString(SJmoPortChapUserInfo chapUserInfo) {
        String ret = "?";
        if (chapUserInfo != null) {
            ret = String.valueOf(chapUserInfo.getAlPortChapUser().size()) + " " + "(" + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + SJctrPortUtility.PORT_CHAPUSER_MAX + ")";
        }
        return ret;
    }

    public static String getIscsiTargetNameString(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String ret = "?";
        if (iscsiTargetInfo != null) {
            ret = iscsiTargetInfo.getStrIscsiTargetName();
        }
        return ret;
    }

    public static String getIscsiTargetIdString(SJmoIscsiTargetIndex iscsiTargetIndex) {
        String ret = "?";
        if (iscsiTargetIndex != null) {
            ret = SJctrComUtility.toHexString(iscsiTargetIndex.getSIscsiTarget(), 2, true);
        }
        return ret;
    }

    public static String getIscsiTargetAliasString(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String ret = "?";
        if (iscsiTargetInfo != null) {
            ret = iscsiTargetInfo.getStrIscsiTargetAlias();
        }
        return ret;
    }

    public static String getIscsiTargetPortIdString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = portInfo.getStrPortDisplayName();
        }
        return ret;
    }

    public String toHostModeDisplay(int iHostMode) {
        String ret = "? [?]";
        String str = this.dataChange.ChangeHostMode((byte)iHostMode);
        if (str.length() != 0) {
            ret = str;
        }
        return ret;
    }

    public String getIscsiTargetHostModeString(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String ret = "? [?]";
        if (iscsiTargetInfo != null) {
            ret = this.toHostModeDisplay(iscsiTargetInfo.getIHostMode());
        }
        return ret;
    }

    public String getIscsiTargetAutheString(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String ret = "?";
        if (iscsiTargetInfo != null) {
            int auth = iscsiTargetInfo.getiUserAuthentSwitch();
            ret = this.getIscsiTargetAutheString(auth);
        }
        return ret;
    }

    public String getIscsiTargetAutheString(int authSwitch) {
        String ret = "?";
        switch (authSwitch) {
            case 2: {
                ret = this.guidanceHandle.getGuidance("CHAP_NONE");
                break;
            }
            case 1: {
                ret = this.guidanceHandle.getGuidance("CHAP");
                break;
            }
            case 3: {
                ret = this.guidanceHandle.getGuidance("COMP_WITH_HOST_SETTING");
                break;
            }
        }
        return ret;
    }

    public String getIscsiTargetModeString(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String ret = "?";
        if (iscsiTargetInfo != null) {
            int chapMode = iscsiTargetInfo.getiAuthentMode();
            switch (chapMode) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ENABLED");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("DISABLED");
                    break;
                }
            }
        }
        return ret;
    }

    public String getIscsiPathAuthMethodString(SJmoIscsiTargetPathInfo iscsiPath) {
        String ret = "?";
        if (iscsiPath != null) {
            int authMethod = iscsiPath.getIAuthentSwitch();
            switch (authMethod) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("CHAP");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("CHAP_NONE");
                    break;
                }
            }
        }
        return ret;
    }

    public String getIscsiPathMutualChapString(SJmoIscsiTargetPathInfo iscsiPath) {
        String ret = "?";
        if (iscsiPath != null) {
            int mutualChap = iscsiPath.getIAuthentMode();
            switch (mutualChap) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("DISABLED");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ENABLED");
                    break;
                }
            }
        }
        return ret;
    }

    public String getIscsiPathMutualChapStringWhenAdd(SJmoIscsiTargetPathInfo iscsiPath) {
        String ret = "?";
        if (iscsiPath != null) {
            int mutualChap = iscsiPath.getIAuthentMode();
            switch (mutualChap) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("DISABLE");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ENABLE");
                    break;
                }
            }
        }
        return ret;
    }

    public String getIscsiPathChapUserNameString(SJmoIscsiTargetPathInfo iscsiPath) {
        String ret = "?";
        if (iscsiPath != null) {
            int authMethod = iscsiPath.getIAuthentSwitch();
            switch (authMethod) {
                case 0: {
                    ret = "";
                    break;
                }
                case 1: {
                    ret = iscsiPath.getStrTargetUserName();
                    break;
                }
            }
        }
        return ret;
    }

    public String getIscsiTargetMutualChapStringWhenCreate(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String ret = "?";
        if (iscsiTargetInfo != null) {
            int chapMode = iscsiTargetInfo.getiAuthentMode();
            switch (chapMode) {
                case 1: {
                    ret = this.guidanceHandle.getGuidance("ENABLE");
                    break;
                }
                case 0: {
                    ret = this.guidanceHandle.getGuidance("DISABLE");
                    break;
                }
            }
        }
        return ret;
    }

    public static String getIscsiTargetUserNameString(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String ret = "?";
        if (iscsiTargetInfo != null) {
            ret = iscsiTargetInfo.getStrTargetUserName();
        }
        return ret;
    }

    public static String getChapUserNameString(SJmoChapUserInfo chapUserInfo) {
        String ret = "?";
        if (chapUserInfo != null) {
            ret = chapUserInfo.getStrUserName();
        }
        return ret;
    }

    public static String getUserSeqNoString(SJctrChapUserInfoIncludeNewChap newChapUserInfo) {
        String ret = "(?)";
        if (newChapUserInfo != null) {
            ret = "(" + newChapUserInfo.getUserSeqNo() + ")";
        }
        return ret;
    }

    public String newString(boolean newString) {
        String ret = "?";
        ret = newString ? this.guidanceHandle.getGuidance("YES") : this.guidanceHandle.getGuidance("NO");
        return ret;
    }

    public String getNewChapUserString(SJctrChapUserInfoIncludeNewChap newChapUserInfo) {
        String ret = "?";
        if (newChapUserInfo != null) {
            boolean newChap = newChapUserInfo.isNewChap();
            ret = this.newString(newChap);
        }
        return ret;
    }

    public String getNewHostString(SJctrIscsiNameInfoIncludeNewHost newHostInfo) {
        String ret = "?";
        if (newHostInfo != null) {
            boolean newHost = newHostInfo.isNewHostNameInfo();
            ret = this.newString(newHost);
        }
        return ret;
    }

    public String getLoginStatusString(SJctrIscsiNameInfoIncludeLoginStatus loginStatus) {
        String ret = "?";
        if (loginStatus != null) {
            ret = loginStatus.getLoginStatus() ? this.guidanceHandle.getGuidance("LUNM", "WWNST_LOGGED_IN") : this.guidanceHandle.getGuidance("LUNM", "WWNST_LOGGED_OUT");
        }
        return ret;
    }

    public String getCommStatusString(SJctrCommStatusInfo commStatus) {
        String ret = "?";
        if (commStatus != null) {
            int status = commStatus.getStatus();
            switch (status) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("SUCCEEDED");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("FAILED2");
                    break;
                }
            }
        }
        return ret;
    }

    public static String getHbaIscsiNameString(SJmoIscsiName iscsiNameInfo) {
        String ret = "?";
        if (iscsiNameInfo != null) {
            ret = iscsiNameInfo.getStrIscsiName();
        }
        return ret;
    }

    public static String getIscsiInitiatorHostNameString(SJmoIscsiName iscsiNameInfo) {
        String ret = "?";
        if (iscsiNameInfo != null) {
            ret = iscsiNameInfo.getStrIscsiNickName();
        }
        return ret;
    }

    public static String getNumOfIscsiTargetsFromIscsiName(SJmoIscsiName iscsiNameInfo) {
        String ret = "?";
        if (iscsiNameInfo != null) {
            ret = String.valueOf(iscsiNameInfo.getAlIscsiTargets().size());
        }
        return ret;
    }

    public static String getNumOfIscsiTargetsFromChapUserName(SJmoChapUserInfo chapUserInfo) {
        String ret = "?";
        if (chapUserInfo != null) {
            ret = String.valueOf(chapUserInfo.getAlIscsiTargets().size());
        }
        return ret;
    }

    public static boolean getHostModeReserveOption(SJctrWizardDataController dc) {
        Robj_interface_DKCgetSystemOption[] sysOptList;
        boolean bRetVal = false;
        if (dc == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getHostModeReserveOption", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        for (Robj_interface_DKCgetSystemOption option : sysOptList = SJctrIscsiUtility.getSystemOptionInfo(dc)) {
            int clpr = option.getNCLPR();
            if (clpr != -1) continue;
            bRetVal = option.isEnable(847);
        }
        return bRetVal;
    }

    public static String getIscsiHostModeOptionEnableNumString(SJmoIscsiTargetInfo iscsiTargetInfo) {
        StringBuffer optionNumber = new StringBuffer();
        if (iscsiTargetInfo != null) {
            BitSet optbt = iscsiTargetInfo.getBtOption();
            for (int optIndex = 0; optIndex <= optbt.size(); ++optIndex) {
                if (!optbt.get(optIndex)) continue;
                if (optionNumber.length() != 0) {
                    optionNumber.append(",");
                }
                optionNumber.append(optIndex);
            }
        } else {
            optionNumber.append("?");
        }
        return optionNumber.toString();
    }

    public String getIscsiTargetAliasIdString(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String ret = "?";
        String targetAlias = "?";
        String targetId = "?";
        if (iscsiTargetInfo != null) {
            targetAlias = SJctrIscsiUtility.getIscsiTargetAliasString(iscsiTargetInfo);
            targetId = SJctrIscsiUtility.getIscsiTargetIdString((SJmoIscsiTargetIndex)iscsiTargetInfo);
        }
        ret = targetAlias + " " + "(" + targetId + ")";
        return ret;
    }

    public String getPortKindString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = portInfo.getStrPortKindName();
        }
        return ret;
    }

    public static SJcException makeException(int errCode) {
        return SJctrIscsiUtility.makeError(errCode).createException();
    }

    public static SJctrError makeError(int errCode) {
        SJctrError err = new SJctrError(12, 22, errCode);
        return err;
    }

    public static SJcException convIscsiLogicErrorException(SJcException e, int errCode) {
        if (e != null) {
            SJcMessage msgObj = e.getMsg();
            if (!msgObj.getFunctionID().equals(Integer.toString(12))) {
                return e;
            }
            if (!msgObj.getModuleID().equals(Integer.toString(22))) {
                return e;
            }
            if (!msgObj.getMsgID().equals(Integer.toString(107001))) {
                return e;
            }
        }
        e = SJctrIscsiUtility.makeException(errCode);
        return e;
    }

    public static void setNeedDataMap(SJctrDataController dc, List<Class<?>> clList, Map<String, List<?>> needDataMap) {
        if (null == dc || null == clList || null == needDataMap) {
            SJctrLogUty.error("SJctrIscsiUtility", "setNeedDataMap", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        for (Class<?> cl : clList) {
            List<?> cacheList = SJctrIscsiUtility.getCache(dc, cl);
            if (null == cacheList) {
                dc.getLogUty().putlog("setNeedDataMap", "Information is null: " + cl.getSimpleName());
                throw SJctrIscsiUtility.makeException(107001);
            }
            needDataMap.put(cl.getName(), cacheList);
        }
    }

    public static void setFinishChangeCheck(SJctrDataController dc, boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        if (dc == null) {
            throw SJctrIscsiUtility.makeException(107001);
        }
        SJctrFooterDataModel footer = (SJctrFooterDataModel)dc.getDataObjectModel("COM_FOOTER");
        if (footer != null && (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH)) != null) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    public static SJctrDataObjectModel<? extends SJctrDataObject> addItemSelectEventListener(SJctrDataObjectModel<? extends SJctrDataObject> model, final SJctrNotifyState state) {
        if (model == null || state == null) {
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (model instanceof SJctrRadioButtonGroupDataModel || model instanceof SJctrComboBoxDataModel) {
            model.addEventListener(new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    if (event.isSelect()) {
                        SJctrDataController dc = event.getSource().getDataController();
                        dc.fireMessageEvent(state, event);
                    }
                }
            });
        } else {
            model.addEventListener(new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrDataController dc = event.getSource().getDataController();
                    dc.fireMessageEvent(state, event);
                }
            });
        }
        return model;
    }

    public static SJctrDataObjectModel<? extends SJctrDataObject> addTextChangeEventListener(SJctrDataObjectModel<? extends SJctrDataObject> model, final SJctrNotifyState state) {
        if (model == null || state == null) {
            throw SJctrIscsiUtility.makeException(107001);
        }
        model.addEventListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrDataController dc = event.getSource().getDataController();
                dc.fireMessageEvent(state, event);
            }
        });
        return model;
    }

    public static boolean isIscsiPort(SJmoPortDetail portInfo) {
        boolean ret = false;
        if (portInfo == null) {
            return ret;
        }
        if (portInfo.getByPortKindNo() == 5) {
            ret = true;
        }
        return ret;
    }

    public static Map<Short, String> getPortNameMap() {
        HashMap portMap = new HashMap();
        int iModeKind = SJsncProductModelUty.getProductModel();
        switch (iModeKind) {
            case 20: {
                portMap = SJctrIscsiDataMacro.PortList_HM800_S_MODEL_MAP;
                break;
            }
            case 40: {
                portMap = SJctrIscsiDataMacro.PortList_HM800_M_MODEL_MAP;
                break;
            }
            case 60: {
                portMap = SJctrIscsiDataMacro.PortList_HM800_H_MODEL_MAP;
                break;
            }
            default: {
                SJctrLogUty.error("SJctrIscsiUtility", "getPortNameMap", "DKC Model is invalid = " + iModeKind);
                portMap = SJctrIscsiDataMacro.PortList_HM800_H_MODEL_MAP;
            }
        }
        return portMap;
    }

    public static String getPortName(short portNum) {
        Map<Short, String> map = SJctrIscsiUtility.getPortNameMap();
        String portStr = map.get(portNum);
        if (portStr == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getPortName", "Port Number is invalid = " + portNum);
            portStr = "";
        }
        return portStr;
    }

    public String getDefTargetIqnTopName(SJmoSubsystemInfo subsystemInfo) {
        String ret = "";
        String model = "";
        int iModeKind = SJsncProductModelUty.getProductModel();
        switch (iModeKind) {
            case 20: {
                model = "h8s";
                break;
            }
            case 40: {
                model = "h8m";
                break;
            }
            case 60: {
                model = "h8h";
                break;
            }
            default: {
                SJctrLogUty.error("SJctrIscsiUtility", "getDefTargetIqnTopName", "DKC Model is invalid = " + iModeKind);
                model = "h8h";
            }
        }
        int dkcNum = subsystemInfo.getDKCSNInt();
        String modelNum = String.format(SJctrComUtility.toPaddingZeroString(dkcNum %= 100000, 5), new Object[0]);
        ret = this.guidanceHandle.getGuidance("ISCSI_TARGET_NAME_IQN_DEF") + model + "." + "t" + "." + modelNum + ".";
        return ret.toLowerCase();
    }

    public static String getDefTargetIqnUnderName(short portNum, short targetId) {
        String ret = "";
        String portStr = SJctrIscsiUtility.getPortName(portNum);
        String targetStr = SJctrComUtility.toHexString(targetId, 3, false);
        ret = portStr + targetStr;
        return ret.toLowerCase();
    }

    public static String getDefTargetEuiTopName(SJmoPortDetail portInfo, SJmoSubsystemInfo subsystemInfo) {
        String ret = "?";
        if (portInfo == null || subsystemInfo == null) {
            return ret;
        }
        String oui = "";
        int[] addr = portInfo.getIMACAddress();
        for (int index = 0; index < 3; ++index) {
            oui = oui + SJctrComUtility.toHexString(addr[index], 2, true);
        }
        ret = oui;
        int dkcNum = subsystemInfo.getDKCSNInt();
        ret = dkcNum > 65535 ? ret + "22" : ret + "12";
        ret = ret + SJctrComUtility.toHexString(dkcNum &= 0xFFFF, 4, true);
        return ret.toUpperCase();
    }

    public static String getDefTargetEuiUnderName(short portNum, short targetId) {
        String ret = "";
        String portStr = SJctrComUtility.toHexString(portNum, 2, true);
        String targetStr = SJctrComUtility.toHexString(targetId, 2, true);
        ret = portStr + targetStr;
        return ret.toUpperCase();
    }

    public String getDefIscsiTargetName(short portNum, SJmoSubsystemInfo subsystemInfo) {
        String ret = "?";
        if (subsystemInfo == null) {
            return ret;
        }
        ret = "";
        String top = this.getDefTargetIqnTopName(subsystemInfo);
        String portStr = SJctrIscsiUtility.getPortName(portNum);
        String targetStr = SJctrComUtility.toHexString(0, 3, false);
        ret = this.guidanceHandle.getGuidance("IQN3") + top + portStr + targetStr;
        return ret.toLowerCase();
    }

    public static String getDefTargetAlias(short portNum, short targetId) {
        String ret = "";
        String portStr = SJctrIscsiUtility.getPortName(portNum);
        String targetStr = SJctrComUtility.toHexString(targetId, 2, false);
        ret = portStr + "-" + "G" + targetStr;
        return ret.toUpperCase();
    }

    public String getDefIscsiTargetAlias(short portNum) {
        return SJctrIscsiUtility.getDefTargetAlias(portNum, (short)0);
    }

    public void checkPortSecurityMsg(List<SJmoPortDetail> portDetailList, List<? extends SJmoIscsiTargetIndex> iscsiTargetList, SJctrDataController dc) {
        if (portDetailList == null || iscsiTargetList == null || dc == null) {
            throw SJctrIscsiUtility.makeException(107001);
        }
        for (SJmoIscsiTargetIndex sJmoIscsiTargetIndex : iscsiTargetList) {
            SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortId(portDetailList, sJmoIscsiTargetIndex.getSPort());
            if (portDetail == null) {
                SJctrLogUty.warn("SJctrIscsiUtility", "checkPortSecurityMsg", "PortDetailInfo is not found. iSCSITarget# : " + sJmoIscsiTargetIndex.toString());
                continue;
            }
            if (!this.isPortSecurityMsg(portDetail, sJmoIscsiTargetIndex.getSIscsiTarget())) continue;
            String strFuncID = Integer.toString(12);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(206229);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
            dc.addUpdateDisp(related);
            break;
        }
    }

    public boolean isPortSecurityMsg(SJmoPortDetail portDetail, short iscsiTargetId) {
        if (portDetail == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "isPortSecurityMsg", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        boolean result = false;
        boolean portSetSecurity = portDetail.isBPortSecuritySwitch();
        if (!portSetSecurity && iscsiTargetId != 0) {
            result = true;
        }
        return result;
    }

    public static List<SJmoIscsiTargetInfo> getRsgIscsiTargetList(SJmoPortIscsiTargetInfo portIscsiTarget, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>();
        if (null == portIscsiTarget || null == rsgUtil) {
            return iscsiTargetList;
        }
        ArrayList allIscsiTargetList = portIscsiTarget.getAlPortIscsiTarget();
        List<SJmoHostGroupIndex> enableHgList = SJctrIscsiUtility.getEnableResourceHgList(rsgUtil);
        for (SJmoIscsiTargetInfo iscsiInfo : allIscsiTargetList) {
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            hgIndex.setSPort(iscsiInfo.getSPort());
            hgIndex.setSHostGroup(iscsiInfo.getSIscsiTarget());
            int index = Collections.binarySearch(enableHgList, hgIndex);
            if (index < 0) continue;
            iscsiTargetList.add(iscsiInfo);
        }
        return iscsiTargetList;
    }

    public static void checkNotifyOpenVmsOpt33Dialog(List<SJctrHostModeOptionTableKey> keyList, int status, SJctrDataController dc, SJctrComboBoxDataModel comboBox) {
        if (keyList == null || dc == null || comboBox == null) {
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (Byte.valueOf(comboBox.getSelection()) != 5) {
            return;
        }
        for (SJctrHostModeOptionTableKey key : keyList) {
            if (key.getSOptionNo() != 33) continue;
            if (key.getIOptionStatus() == status) break;
            int msgCode = 0;
            msgCode = status == 1 ? 206231 : 206232;
            String strFuncID = Integer.toString(12);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(msgCode);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
            dc.addUpdateDisp(related);
            break;
        }
    }

    public static List<SJmoHostGroupIndex> getEnableResourceHgList(SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoHostGroupIndex> enableHgList = new ArrayList<SJmoHostGroupIndex>();
        if (null != rsgUtil) {
            List<SJmoRSGgetRsg> rsgList = rsgUtil.extractRsg();
            for (SJmoRSGgetRsg rsgInfo : rsgList) {
                enableHgList.addAll(rsgInfo.getHostGrps());
            }
        }
        Collections.sort(enableHgList);
        return enableHgList;
    }

    public static boolean isRsgHostGroupIndex(SJmoHostGroupIndex hostIndex, SJctrResourceGroupUtility rsgUtil) {
        boolean result = false;
        if (hostIndex == null || rsgUtil == null) {
            return result;
        }
        int rsgId = rsgUtil.getRsgId(hostIndex);
        result = SJctrIscsiUtility.chkResourceGroup(rsgId, rsgUtil);
        return result;
    }

    public static boolean isRsgPortIndex(SJmoPortIndex portIndex, SJctrResourceGroupUtility rsgUtil) {
        boolean result = false;
        if (portIndex == null || rsgUtil == null) {
            return result;
        }
        int rsgId = rsgUtil.getRsgId(portIndex);
        result = SJctrIscsiUtility.chkResourceGroup(rsgId, rsgUtil);
        return result;
    }

    public static boolean chkResourceGroup(int rsgId, SJctrResourceGroupUtility rsgUtil) {
        boolean result = false;
        if (rsgUtil == null) {
            return result;
        }
        if (rsgId > -1) {
            result = rsgUtil.chkResourceGroup(rsgId);
        }
        return result;
    }

    public static SJmoIscsiTargetInfo getIscsiTargetInfoByIndex(List<SJmoPortIscsiTargetInfo> portIscsiTargetInfoList, SJmoIscsiTargetIndex targetIndex) {
        if (portIscsiTargetInfoList == null || targetIndex == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getIscsiTargetInfoByIndex", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        SJmoIscsiTargetInfo retInfo = null;
        SJmoPortIscsiTargetInfo portIscsiTarget = (SJmoPortIscsiTargetInfo)SJctrIscsiUtility.getPortInfoByPortId(portIscsiTargetInfoList, targetIndex.getSPort());
        if (null != portIscsiTarget) {
            retInfo = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portIscsiTarget, targetIndex);
        }
        return retInfo;
    }

    public static SJmoIscsiTargetInfo getIscsiTargetInfoByIndex(SJmoPortIscsiTargetInfo portIscsiTargetInfo, SJmoIscsiTargetIndex index) {
        if (portIscsiTargetInfo == null || index == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getIscsiTargetInfoByIndex", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        SJmoIscsiTargetInfo retInfo = null;
        ArrayList iscsiTargetList = portIscsiTargetInfo.getAlPortIscsiTarget();
        int search = Collections.binarySearch(iscsiTargetList, index);
        if (search >= 0) {
            retInfo = (SJmoIscsiTargetInfo)iscsiTargetList.get(search);
        }
        return retInfo;
    }

    public static SJmoIscsiTargetPathInfo getIscsiTargetPathInfoByIndex(SJmoPortIscsiTargetPathInfo portIscsiTargetPathInfo, SJmoIscsiTargetPathInfo targetPath) {
        if (portIscsiTargetPathInfo == null || targetPath == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getIscsiTargetPathInfoByIndex", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        SJmoIscsiTargetPathInfo retInfo = null;
        ArrayList iscsiTargetPathList = portIscsiTargetPathInfo.getAlPortIscsiTargetPath();
        Collections.sort(iscsiTargetPathList);
        int search = Collections.binarySearch(iscsiTargetPathList, targetPath);
        if (search >= 0) {
            retInfo = (SJmoIscsiTargetPathInfo)iscsiTargetPathList.get(search);
        }
        return retInfo;
    }

    public static boolean isIqn(SJmoIscsiTargetInfo iscsiTargetInfo) {
        if (iscsiTargetInfo == null) {
            return false;
        }
        return SJctrIscsiUtility.isIqn(iscsiTargetInfo.getStrIscsiTargetName());
    }

    public static boolean isIqn(String iscsiTargetName) {
        if (iscsiTargetName == null) {
            return false;
        }
        return iscsiTargetName.startsWith("iqn.");
    }

    public static boolean isEui(SJmoIscsiTargetInfo iscsiTargetInfo) {
        if (iscsiTargetInfo == null) {
            return false;
        }
        return SJctrIscsiUtility.isEui(iscsiTargetInfo.getStrIscsiTargetName());
    }

    public static boolean isEui(String iscsiTargetName) {
        if (iscsiTargetName == null) {
            return false;
        }
        return iscsiTargetName.startsWith("eui.");
    }

    public static SJmoRSGgetRsg getRsgInfoIncludeSpecifyIscsiTarget(List<SJmoRSGgetRsg> rsgList, SJmoIscsiTargetIndex iscsiTgIndex) {
        SJmoRSGgetRsg retObj = null;
        if (rsgList == null || iscsiTgIndex == null) {
            return retObj;
        }
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        hgIndex.setSPort(iscsiTgIndex.getSPort());
        hgIndex.setSHostGroup(iscsiTgIndex.getSIscsiTarget());
        for (SJmoRSGgetRsg rsgInfo : rsgList) {
            ArrayList hgList = rsgInfo.getHostGrps();
            int searchIndex = Collections.binarySearch(hgList, hgIndex);
            if (searchIndex < 0) continue;
            retObj = rsgInfo;
        }
        return retObj;
    }

    public static SJcException createExceptionKeyValueError(SanResponse sanResponse) {
        if (sanResponse == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "createExceptionKeyValueError", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        int[] messageId = SJctrIscsiUtility.getMessageId(sanResponse);
        int funcCode = messageId[0] / 100;
        int moduleCode = messageId[0] % 100;
        int errorCode = messageId[1];
        SJctrError err = new SJctrError(funcCode, moduleCode, errorCode);
        SJcException exp = err.createException();
        return exp;
    }

    public static boolean hasErrorSanResponse(SanResponse sanResponse) {
        if (sanResponse == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "hasErrorSanResponse", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        boolean error = true;
        int[] messageId = SJctrIscsiUtility.getMessageId(sanResponse);
        if (messageId[1] == 0) {
            error = false;
        }
        return error;
    }

    public static int[] getMessageId(SanResponse sanResponse) {
        if (sanResponse == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "getMessageId", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        int[] messageId = null;
        try {
            SanObject errorInfo = sanResponse.getObj("ErrorInfo");
            messageId = errorInfo.getIntArray("MessageId");
        }
        catch (SanDataException e) {
            SJctrLogUty.error("SJctrIscsiUtility", "getMessageId", e.getMessage());
            throw SJctrIscsiUtility.makeException(107001);
        }
        return messageId;
    }

    public static boolean isFibrePort(SJmoPortDetail portDetail) {
        boolean ret = false;
        if (portDetail != null) {
            switch (portDetail.getByPortKindNo()) {
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static List<SJmoHostGroupInfo> getHostGroupInfoList(List<SJmoPortHostGroupInfo> portHGList, SJmoPortLunDetail portLunDetail) {
        ArrayList<SJmoHostGroupInfo> retList = new ArrayList<SJmoHostGroupInfo>(1);
        if (portHGList == null || portLunDetail == null) {
            return retList;
        }
        int portIndex = Collections.binarySearch(portHGList, portLunDetail);
        if (portIndex >= 0) {
            SJmoPortHostGroupInfo portHGInfo = portHGList.get(portIndex);
            ArrayList hgInfoList = portHGInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                if (hgInfo.getSHostGroup() != portLunDetail.getSHostGroup()) continue;
                retList.add(hgInfo);
                break;
            }
        }
        return retList;
    }

    public static List<SJmoIscsiTargetInfo> getIscsiTargetInfoList(List<SJmoPortIscsiTargetInfo> portIscsiTargetList, SJmoPortLunDetail portLunDetail) {
        ArrayList<SJmoIscsiTargetInfo> retList = new ArrayList<SJmoIscsiTargetInfo>(1);
        if (portIscsiTargetList == null || portLunDetail == null) {
            return retList;
        }
        int iscsiIndex = Collections.binarySearch(portIscsiTargetList, portLunDetail);
        if (iscsiIndex >= 0) {
            SJmoPortIscsiTargetInfo portTargetInfo = portIscsiTargetList.get(iscsiIndex);
            ArrayList targetInfoList = portTargetInfo.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo targetInfo : targetInfoList) {
                if (targetInfo.getSIscsiTarget() != portLunDetail.getSHostGroup()) continue;
                retList.add(targetInfo);
                break;
            }
        }
        return retList;
    }

    public static List<SJmoHostGroupIndex> getRsgPortIscsiTargetList(SJmoPortIndex iscsiTargetPortIndex, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoHostGroupIndex> retList = new ArrayList<SJmoHostGroupIndex>();
        short ptPortId = iscsiTargetPortIndex.getSPort();
        List<SJmoHostGroupIndex> enableHgList = SJctrIscsiUtility.getEnableResourceHgList(rsgUtil);
        for (SJmoHostGroupIndex enableHg : enableHgList) {
            if (enableHg.getSPort() != ptPortId) continue;
            retList.add(enableHg);
        }
        return retList;
    }

    public static int getLeadTime(int applySize, double progressUnit, double progressTime) {
        int ret = 1;
        if (progressTime <= 0.0) {
            return ret;
        }
        if (progressUnit <= 0.0 || applySize <= 0) {
            ret = (int)Math.ceil(progressTime / 1000.0);
            return ret;
        }
        double unitNum = Math.ceil((double)applySize / progressUnit);
        ret = (int)Math.ceil(unitNum * progressTime / 1000.0);
        return ret;
    }

    public static int[] splitIPv6String(String ipv6Addr) {
        if (ipv6Addr == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "splitIPv6String", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        SJctrIpAddrUtility.IPv6 ipV6 = new SJctrIpAddrUtility.IPv6();
        if (!ipV6.chkRegex(ipv6Addr)) {
            SJctrLogUty.error("SJctrIscsiUtility", "splitIPv6String", "IP address is not input in the form of IPv6.");
            SJctrError err = new SJctrError(201, 22, 105370);
            SJcException exp = err.createException();
            throw exp;
        }
        int[] iIpv6Addr = new int[8];
        String[] strSplitAddr = ipv6Addr.split(":");
        if (strSplitAddr.length > iIpv6Addr.length || 1 > strSplitAddr.length) {
            SJctrLogUty.error("SJctrIscsiUtility", "splitIPv6String", "IPv6 is no check and Disable.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        String strLstEle = strSplitAddr[strSplitAddr.length - 1];
        if (strLstEle.indexOf(".") != -1) {
            iIpv6Addr = SJctrIscsiUtility.createArrayProjectionIPv4Addr(strLstEle);
            return iIpv6Addr;
        }
        boolean loopFlg = false;
        for (int index = 0; index < strSplitAddr.length; ++index) {
            if (strSplitAddr[index].isEmpty()) {
                loopFlg = true;
                break;
            }
            iIpv6Addr[index] = Integer.parseInt(strSplitAddr[index], 16);
        }
        if (loopFlg) {
            int lear = iIpv6Addr.length - 1;
            for (int index = strSplitAddr.length - 1; index >= 0 && !strSplitAddr[index].isEmpty(); --index) {
                iIpv6Addr[lear] = Integer.parseInt(strSplitAddr[index], 16);
                --lear;
            }
        }
        return iIpv6Addr;
    }

    public static int[] createArrayProjectionIPv4Addr(String ipv4Addr) {
        if (ipv4Addr == null) {
            SJctrLogUty.error("SJctrIscsiUtility", "createArrayProjectionIPv4Addr", "parameter is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        int[] rtnAddr = new int[8];
        int[] iIpv4 = SJctrPortUtility.splitIPv4String(ipv4Addr);
        int[] iTmpAddr = new int[2];
        for (int i = 0; i < iTmpAddr.length; ++i) {
            int tmpElement;
            iTmpAddr[i] = tmpElement = (iIpv4[i * 2] << 8) + iIpv4[i * 2 + 1];
        }
        System.arraycopy(SJctrIscsiDataMacro.ARRAY_PROJECTION_IPV4_ADDR, 0, rtnAddr, 0, SJctrIscsiDataMacro.ARRAY_PROJECTION_IPV4_ADDR.length);
        System.arraycopy(iTmpAddr, 0, rtnAddr, SJctrIscsiDataMacro.ARRAY_PROJECTION_IPV4_ADDR.length, iTmpAddr.length);
        return rtnAddr;
    }

    public static boolean isUsedUvmIscsiPath(SJmoIscsiTargetPathInfo iscsiPath, List<SJmoExdTargetPortInfo> exdTargetInfoList) {
        boolean ret = false;
        if (iscsiPath != null && exdTargetInfoList != null) {
            for (SJmoExdTargetPortInfo exdTargetPortInfo : exdTargetInfoList) {
                EXDTargetPort_Fiber modelData = (EXDTargetPort_Fiber)exdTargetPortInfo.getRmiExdTargetPortInfo();
                String wwn = modelData.getDispTargetPortAddress();
                int targetIndex = SJctrExtUtility.getIscsiTargetPathIndex(wwn);
                if (targetIndex != iscsiPath.getITargetPathIndex()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String getIscsiPathUsageString(boolean useFlag) {
        String ret = "?";
        ret = useFlag ? this.guidanceHandle.getGuidance("ISCSI_PATH_USED") : this.guidanceHandle.getGuidance("ISCSI_PATH_FREE");
        return ret;
    }

    public static String getInitiatorChapUserNameString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = portInfo.getStrUserName();
        }
        return ret;
    }

    public static String getInternalIscsiNameString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            ret = portInfo.getStrIscsiName();
        }
        return ret;
    }

    public static String getIpAddressString(SJmoIscsiTargetPathInfo info) {
        String ret = "?";
        if (info != null) {
            int ipType = info.getIIpType();
            if (ipType == 0) {
                ret = SJctrIscsiUtility.getIpv4AddrString(info.getIIpv4Address());
            } else if (ipType == 1) {
                ret = SJctrIscsiUtility.getIpv6AddrString(info.getIIpv6Address());
            }
        }
        return ret;
    }

    public static boolean isIscsiTargetAuthChap(List<SJmoIscsiTargetPathInfo> iscsiTargetPathList) {
        boolean ret = false;
        if (iscsiTargetPathList != null) {
            for (SJmoIscsiTargetPathInfo iscsiPathInfo : iscsiTargetPathList) {
                if (iscsiPathInfo.getIAuthentSwitch() != 1) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public String getVPortModeString(SJmoPortDetail portInfo) {
        String ret = "?";
        if (portInfo != null) {
            if (!SJctrPortUtility.isIscsiPort(portInfo)) {
                ret = SJctrPortUtility.STR_HYPHEN;
            } else if (portInfo.getIVPortMode() == 1) {
                ret = this.guidanceHandle.getGuidance("ENABLED");
            } else if (portInfo.getIVPortMode() == 2) {
                ret = this.guidanceHandle.getGuidance("DISABLED");
            } else if (portInfo.getIVPortMode() == 0) {
                ret = SJctrPortUtility.STR_HYPHEN;
            } else {
                return ret;
            }
        }
        return ret;
    }
}

