/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.data.device.SJmoPdevDetail;

public class SJctrPdevUtility
extends SJctrStringUtility {
    private static Pattern DRIVE_KIND_PATTERN = Pattern.compile("(..)...-(.)(...)..");
    public static int RMI_VALUE_HDD_STATUS_NORMAL = 0;
    public static int RMI_VALUE_HDD_STATUS_FREE = 12;
    public static int RMI_VALUE_HDD_STATUS_RESERVED = 13;
    public static int RMI_VALUE_DRIVE_KIND_SPARE = 2;
    public static int RMI_VALUE_DRIVE_KIND_SPARE_RESERVED = 4;
    public static int RMI_VALUE_DRIVE_KIND_FREE = 5;
    public static String HDD_KIND_FMD = "P";
    public static String DRIVE_TYPE_RPM_FMC = "SSD(FMC)/-";

    public SJctrPdevUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public String getStrDriveTypeRPM(SJmoPdevDetail pdevDetail) {
        String strDriveRpm = "-";
        String Drive = "";
        String rpm = "";
        if (pdevDetail.getDriveType() == 0) {
            Drive = this.guidanceHandle.getGuidance("SAS");
            rpm = String.valueOf(pdevDetail.getHDDrpm());
            double dHDDRpm = 0.0;
            int iHDDRpm = 0;
            if (pdevDetail.getHDDrpm() % 1000 != 0) {
                dHDDRpm = (double)pdevDetail.getHDDrpm() / 1000.0;
                rpm = dHDDRpm + "k";
            } else {
                iHDDRpm = pdevDetail.getHDDrpm() / 1000;
                rpm = iHDDRpm + "k";
            }
            strDriveRpm = Drive + "/" + rpm;
        } else if (pdevDetail.getDriveType() == 1) {
            Drive = this.guidanceHandle.getGuidance("SATA");
            rpm = String.valueOf(pdevDetail.getHDDrpm());
            double dHDDRpm = 0.0;
            int iHDDRpm = 0;
            if (pdevDetail.getHDDrpm() % 1000 != 0) {
                dHDDRpm = (double)pdevDetail.getHDDrpm() / 1000.0;
                rpm = dHDDRpm + "k";
            } else {
                iHDDRpm = pdevDetail.getHDDrpm() / 1000;
                rpm = iHDDRpm + "k";
            }
            strDriveRpm = Drive + "/" + rpm;
        } else if (pdevDetail.getDriveType() == 5) {
            strDriveRpm = Drive = this.guidanceHandle.getGuidance("SSD");
        }
        return strDriveRpm;
    }

    public String getStrDriveKind(SJmoPdevDetail pdevDetail) {
        return this.getStrDriveKind(pdevDetail.getHDDKind());
    }

    public String getStrDriveKind(String hddKind) {
        if (hddKind == null) {
            return "-";
        }
        Matcher matcher = DRIVE_KIND_PATTERN.matcher(hddKind.trim());
        if (!matcher.matches()) {
            return "-";
        }
        String type = matcher.group(1);
        String rpmOrCell = matcher.group(2);
        String capacity = matcher.group(3).replace('R', '.');
        StringBuilder builder = new StringBuilder();
        if (rpmOrCell.equals("M")) {
            builder.append("SSD(MLC)/-/");
        } else {
            if (type.equals("DK")) {
                builder.append("SAS");
            } else if (type.equals("SL")) {
                builder.append("SSD/-");
            } else if (type.equals("NF")) {
                if (rpmOrCell.equals(HDD_KIND_FMD)) {
                    builder.append("SSD(FMD)/-");
                } else {
                    builder.append(DRIVE_TYPE_RPM_FMC);
                }
            }
            builder.append("/");
            if (rpmOrCell.equals("K")) {
                builder.append("15krpm/");
            } else if (rpmOrCell.equals("J")) {
                builder.append("10krpm/");
            } else if (rpmOrCell.equals("H")) {
                builder.append("7.2krpm/");
            }
        }
        if (type.equals("NF") && capacity.equals("13.")) {
            capacity = "12.8";
        }
        if (capacity.indexOf(".") == capacity.length() - 1) {
            capacity = capacity + "0";
        }
        builder.append(capacity);
        builder.append(capacity.contains(".") ? "TB" : "GB");
        return builder.toString();
    }

    public String getStrHDDStatus(SJmoPdevDetail pdevDetail) {
        String strHDDStatus = "-";
        strHDDStatus = pdevDetail.getHDDStatus() == 0 || pdevDetail.getHDDStatus() == 12 ? this.guidanceHandle.getGuidance("NORMAL_HDDSTATUS") : (pdevDetail.getHDDStatus() == 1 ? this.guidanceHandle.getGuidance("FAILED_HDDSTATUS") : (pdevDetail.getHDDStatus() == 2 ? this.guidanceHandle.getGuidance("BLOCKED_HDDSTATUS") : (pdevDetail.getHDDStatus() == 3 ? this.guidanceHandle.getGuidance("WARNING_HDDSTATUS") : (pdevDetail.getHDDStatus() == 4 || pdevDetail.getHDDStatus() == 6 || pdevDetail.getHDDStatus() == 8 || pdevDetail.getHDDStatus() == 10 ? this.guidanceHandle.getGuidance("COPYING_HDDSTATUS") : (pdevDetail.getHDDStatus() == 13 ? this.guidanceHandle.getGuidance("RESERVED_HDDSTATUS") : (pdevDetail.getHDDStatus() == 14 ? this.guidanceHandle.getGuidance("COPY_INCOMPLETE_HDDSTATUS") : this.guidanceHandle.getGuidance("UNKNOWN_HDDSTATUS")))))));
        return strHDDStatus;
    }

    public String getUsageInfo(SJmoPdevDetail pdevDetail) {
        String strUsage = "-";
        if (pdevDetail.getDriveKind() == 1) {
            strUsage = this.guidanceHandle.getGuidance("DATA_DRIVE");
        } else if (pdevDetail.getDriveKind() == 2) {
            strUsage = this.guidanceHandle.getGuidance("SPARE_DRIVE");
        } else if (pdevDetail.getDriveKind() == 3) {
            strUsage = this.guidanceHandle.getGuidance("DATA_DRIVE");
        } else if (pdevDetail.getDriveKind() == 4) {
            strUsage = this.guidanceHandle.getGuidance("SPARE_DRIVE");
        } else if (pdevDetail.getDriveKind() == 5) {
            strUsage = this.guidanceHandle.getGuidance("FREE_DRIVE");
        }
        return strUsage;
    }

    public static boolean isSpareDriveKind(SJmoPdevDetail pdev) {
        return pdev.getDriveKind() == RMI_VALUE_DRIVE_KIND_SPARE || pdev.getDriveKind() == RMI_VALUE_DRIVE_KIND_SPARE_RESERVED;
    }

    public static boolean isFreeDriveKind(SJmoPdevDetail pdev) {
        return pdev.getDriveKind() == RMI_VALUE_DRIVE_KIND_FREE;
    }

    public static boolean isFreeStatus(SJmoPdevDetail pdev) {
        return pdev.getHDDStatus() == RMI_VALUE_HDD_STATUS_FREE;
    }

    public static boolean isNormalStatus(SJmoPdevDetail pdev) {
        return pdev.getHDDStatus() == RMI_VALUE_HDD_STATUS_NORMAL;
    }

    public static boolean isReservedStatus(SJmoPdevDetail pdev) {
        return pdev.getHDDStatus() == RMI_VALUE_HDD_STATUS_RESERVED;
    }
}

