/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.List;
import sanproject.common.Robj_interface_AuditUserInfo;
import sanproject.serverux.dataimpl.AuditUserInfo;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.controller.com.SJctrAddTaskAuditLog;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrUserController;

public class SJctrQueueBox {
    private final String mPosition;
    private SJctrUserController mUserCtr;
    private SJctrAddTaskAuditLog auditLog;

    public SJctrQueueBox(SJctrUserController userCtr) {
        this.mUserCtr = userCtr;
        this.mPosition = userCtr.getUserNo() + ":" + this.getClass().getSimpleName();
        this.auditLog = new SJctrAddTaskAuditLog(this.mUserCtr);
    }

    public void finish() {
        this.mUserCtr = null;
    }

    private Robj_interface_AuditUserInfo createUserInfo(SJbaseUserSessionInterface userSession, String taskName) {
        AuditUserInfo userInfo = new AuditUserInfo();
        userInfo.setStrGlblSessionID(userSession.getSessionID());
        userInfo.setStrUserName(userSession.getUserName());
        userInfo.setStrIPaddress(SJcSessionUty.getIPAddress(userSession));
        userInfo.setIConnectionID(userSession.getSessionIdentificationID());
        userInfo.setStrTaskName(taskName);
        return userInfo;
    }

    public void addTask(SJctrTask task) throws SJcException {
        SJctrLogUty.trace(this.mPosition, "addTask", "addTask start");
        SJbaseUserSessionInterface userSession = this.mUserCtr.getUserSession();
        task.setUserId(userSession.getUserName());
        Robj_interface_AuditUserInfo userInfo = this.createUserInfo(userSession, task.getName());
        task.setUserInfo(userInfo);
        int interfaceId = this.getInterfaceId();
        task.setInterfaceId(interfaceId);
        String pass = ((SJbaseUserSessionInterfaceInternal)userSession).getPassword();
        task.setPassword(pass);
        long lockId = this.mUserCtr.getLockId();
        task.setLockId(lockId);
        Boolean allRSGFlg = this.mUserCtr.getAuthorizeContainer().getRoleResourceContainer().checkAllResourceGroup();
        task.setAllRSGFlg(allRSGFlg);
        int ssoOpt = this.mUserCtr.getSsoOpt();
        task.setssoOpt(ssoOpt);
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        SJcMessage auditMsg = null;
        String auditResult = "Success";
        try {
            queueCtr.addTask(task);
        }
        catch (SJcException e) {
            auditMsg = e.getMsg();
            auditResult = "Error";
            throw e;
        }
        finally {
            SJcAuditLogCtrlElemCon container = this.auditLog.createElemCon();
            container.setTaskName(task.getName());
            container.setOperationResult(auditResult);
            container.setOperationErrorCode(auditMsg);
            List<String> actList = task.getActionTypeEn();
            for (String act : actList) {
                SJctrAuditLogData element = this.auditLog.createElement(act);
                container.setAdtDetailList(element);
            }
            SJcAuditLoggerInterface adtLogger = userSession.getAuditLogger();
            if (adtLogger != null) {
                adtLogger.putLog(container);
            } else {
                SJctrLogUty.info(this.mPosition, "addTask", "AuditLogger is null.");
            }
        }
        SJctrLogUty.trace(this.mPosition, "addTask", "addTask end");
    }

    public void addTaskForRegularBackup(SJctrTask task) throws SJcException {
        SJctrLogUty.trace(this.mPosition, "addTaskForRegularBackup", "addTaskForRegularBackup start");
        SJbaseUserSessionInterface userSession = this.mUserCtr.getUserSession();
        task.setUserId(userSession.getUserName());
        Robj_interface_AuditUserInfo userInfo = this.createUserInfo(userSession, task.getName());
        task.setUserInfo(userInfo);
        task.setInterfaceId(0);
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        SJcMessage auditMsg = null;
        String auditResult = "Success";
        try {
            queueCtr.addTaskForRegularBackup(task);
        }
        catch (SJcException e) {
            auditMsg = e.getMsg();
            auditResult = "Error";
            throw e;
        }
        finally {
            SJcAuditLogCtrlElemCon container = this.auditLog.createElemCon();
            container.setTaskName(task.getName());
            container.setOperationResult(auditResult);
            container.setOperationErrorCode(auditMsg);
            List<String> actList = task.getActionTypeEn();
            for (String act : actList) {
                SJctrAuditLogData element = this.auditLog.createElement(act);
                container.setAdtDetailList(element);
            }
            SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger((SJbaseUserSessionInterfaceInternal)userSession);
            userSession.setAuditLogger(adtLogger);
            if (adtLogger != null) {
                adtLogger.putLog(container);
            } else {
                SJctrLogUty.info(this.mPosition, "addTaskForRegularBackup", "AuditLogger is null.");
            }
        }
        SJctrLogUty.trace(this.mPosition, "addTaskForRegularBackup", "addTaskForRegularBackup end");
    }

    private int getInterfaceId() {
        int ret = 0;
        SJctrAuthorizeContainer ac = this.mUserCtr.getAuthorizeContainer();
        SJctrSystemParamContainer spc = ac.getSystemParamContainer();
        boolean host = spc.isLocalHost();
        if (host) {
            ret = 1;
        }
        return ret;
    }

    public void removeTask(SJctrTask task) throws SJcException {
        SJctrLogUty.trace(this.mPosition, "removeTask", "removeTask start");
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        queueCtr.removeTask(task);
        SJctrLogUty.trace(this.mPosition, "removeTask", "removeTask end");
    }

    public void suspendTask(SJctrTask task) throws SJcException {
        SJctrLogUty.trace(this.mPosition, "suspendTask", "suspendTask start");
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        queueCtr.suspendTask(task);
        SJctrLogUty.trace(this.mPosition, "suspendTask", "suspendTask end");
    }

    public void resumeTask(SJctrTask task) throws SJcException {
        SJctrLogUty.trace(this.mPosition, "resumeTask", "resumeTask start");
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        queueCtr.resumeTask(task);
        SJctrLogUty.trace(this.mPosition, "resumeTask", "resumeTask end");
    }

    public void abortTask(SJctrTask task) throws SJcException {
        SJctrLogUty.info(this.mPosition, "abortTask", "abortTask start");
        SJbaseUserSessionInterface userSession = this.mUserCtr.getUserSession();
        Robj_interface_AuditUserInfo userInfo = this.createUserInfo(userSession, task.getName());
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        queueCtr.abortTask(task, userInfo);
        SJctrLogUty.info(this.mPosition, "abortTask", "abortTask end");
    }

    public void protectTask(SJctrTask task, boolean protection) throws SJcException {
        SJctrLogUty.trace(this.mPosition, "protectTask", "protectTask start");
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        queueCtr.protectTask(task, protection);
        SJctrLogUty.trace(this.mPosition, "protectTask", "protectTask end");
    }

    public List<SJctrTask> getTaskList() {
        SJctrLogUty.trace(this.mPosition, "getTaskList", "getTaskList start");
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        List<SJctrTask> ret = queueCtr.getTaskList();
        SJctrLogUty.trace(this.mPosition, "getTaskList", "getTaskList end");
        return ret;
    }

    public boolean isHistoryAccept() {
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        boolean ret = queueCtr.isHistoryAccept();
        if (!ret) {
            SJctrLogUty.warn(this.mPosition, "isHistoryAccept", "Can't make any space in the history task list !!");
        }
        return ret;
    }

    public List<SJctrGuidance> getQueueingTaskActNameList() {
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        List<SJctrGuidance> ret = queueCtr.getQueueingTaskActNameList();
        return ret;
    }

    public List<String> getDeleteTaskList() {
        SJctrLogUty.trace(this.mPosition, "getDeleteTaskList", "getDeleteTaskList start");
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        List<String> ret = queueCtr.getDeleteTaskList();
        SJctrLogUty.trace(this.mPosition, "getDeleteTaskList", "getDeleteTaskList end");
        return ret;
    }
}

