/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.com.utility.SJcBitSetUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrResourceGroupUtility {
    private SJctrUserController usrctrl = null;
    private SJmoRSGgetAllRsgs allrsgs = null;
    private SJcRoleResourceContainer rolecntnr = null;
    private List<SJmoRSGgetRsg> possibleRsg = null;
    private List<SJmoRSGgetRsg> impossibleRsg = null;
    public static final int DEF_RSG_ID = -1;
    private SJmoRSGgetRsg systemRsgInfo = null;

    public SJctrResourceGroupUtility(SJctrUserController user, SJmoRSGgetAllRsgs allresource) {
        this.setUsrctrl(user);
        this.setAllrsgs(allresource);
        this.setRolecntnr(this.getUsrctrl().getUserSession().getRoleResourceInfo());
        this.systemRsgInfo = this.getSysRsg();
    }

    public int getRsgId(SJmoLdevIndex ldev) {
        SJmoRSGgetRsg rsg;
        int rsgid = -1;
        if (ldev != null && (rsg = this.srchRsgFromLdev(ldev)) != null) {
            rsgid = rsg.getRsgInfo().getRsgId();
        }
        return rsgid;
    }

    public int getRsgId(SJmoPgIndex pg) {
        SJmoRSGgetRsg rsg;
        int rsgid = -1;
        if (pg != null && (rsg = this.srchRsgFromPg(pg)) != null) {
            rsgid = rsg.getRsgInfo().getRsgId();
        }
        return rsgid;
    }

    public int getRsgId(SJmoPortIndex port) {
        SJmoRSGgetRsg rsg;
        int rsgid = -1;
        if (port != null && (rsg = this.srchRsgFromPort(port)) != null) {
            rsgid = rsg.getRsgInfo().getRsgId();
        }
        return rsgid;
    }

    public int getRsgId(SJmoHostGroupIndex hg) {
        SJmoRSGgetRsg rsg;
        int rsgid = -1;
        if (hg != null && (rsg = this.srchRsgFromHg(hg)) != null) {
            rsgid = rsg.getRsgInfo().getRsgId();
        }
        return rsgid;
    }

    public boolean chkSameRsgForLdev(List<? extends SJmoLdevIndex> ldevlist) {
        SJmoRSGgetRsg rsg;
        boolean chkrslt = true;
        if (ldevlist != null && ldevlist.size() > 0 && (rsg = this.srchRsgFromLdev(ldevlist.get(0))) != null) {
            ArrayList<SJmoRSGgetRsg> rsglist = new ArrayList<SJmoRSGgetRsg>();
            rsglist.add(rsg);
            List<SJmoLdevIndex> rsltlist = this.extractRsgLdev(ldevlist, rsglist);
            if (ldevlist.size() != rsltlist.size()) {
                chkrslt = false;
            }
        }
        return chkrslt;
    }

    public boolean chkSameRsgForPg(List<? extends SJmoPgIndex> pglist) {
        SJmoRSGgetRsg rsg;
        boolean chkrslt = true;
        if (pglist != null && pglist.size() > 0 && (rsg = this.srchRsgFromPg(pglist.get(0))) != null) {
            ArrayList<SJmoRSGgetRsg> rsglist = new ArrayList<SJmoRSGgetRsg>();
            rsglist.add(rsg);
            List<SJmoPgIndex> rsltlist = this.extractRsgPg(pglist, rsglist);
            if (pglist.size() != rsltlist.size()) {
                chkrslt = false;
            }
        }
        return chkrslt;
    }

    public boolean chkSameRsgForPort(List<? extends SJmoPortIndex> portlist) {
        SJmoRSGgetRsg rsg;
        boolean chkrslt = true;
        if (portlist != null && portlist.size() > 0 && (rsg = this.srchRsgFromPort(portlist.get(0))) != null) {
            ArrayList<SJmoRSGgetRsg> rsglist = new ArrayList<SJmoRSGgetRsg>();
            rsglist.add(rsg);
            List<SJmoPortIndex> rsltlist = this.extractRsgPort(portlist, rsglist);
            if (portlist.size() != rsltlist.size()) {
                chkrslt = false;
            }
        }
        return chkrslt;
    }

    public boolean chkSameRsgForHg(List<? extends SJmoHostGroupIndex> hglist) {
        SJmoRSGgetRsg rsg;
        boolean chkrslt = true;
        if (hglist != null && hglist.size() > 0 && (rsg = this.srchRsgFromHg(hglist.get(0))) != null) {
            ArrayList<SJmoRSGgetRsg> rsglist = new ArrayList<SJmoRSGgetRsg>();
            rsglist.add(rsg);
            List<SJmoHostGroupIndex> rsltlist = this.extractRsgHg(hglist, rsglist);
            if (hglist.size() != rsltlist.size()) {
                chkrslt = false;
            }
        }
        return chkrslt;
    }

    public List<SJmoLdevIndex> extractLdev(List<? extends SJmoLdevIndex> ldevlist) {
        List<SJmoLdevIndex> rsltlist = this.extractRsgLdev(ldevlist, this.getPossibleRsg());
        return rsltlist;
    }

    public List<SJmoPgIndex> extractPg(List<? extends SJmoPgIndex> pglist) {
        List<SJmoPgIndex> rsltlist = this.extractRsgPg(pglist, this.getPossibleRsg());
        return rsltlist;
    }

    public List<SJmoPortIndex> extractPort(List<? extends SJmoPortIndex> portlist) {
        List<SJmoPortIndex> rsltlist = this.extractRsgPort(portlist, this.getPossibleRsg());
        return rsltlist;
    }

    public List<SJmoHostGroupIndex> extractHg(List<? extends SJmoHostGroupIndex> hglist) {
        List<SJmoHostGroupIndex> rsltlist = this.extractRsgHg(hglist, this.getPossibleRsg());
        return rsltlist;
    }

    public List<SJmoLdevIndex> extractImpossibleLdev(List<? extends SJmoLdevIndex> ldevlist) {
        List<SJmoLdevIndex> rsltlist = this.extractRsgLdev(ldevlist, this.getImpossibleRsg());
        return rsltlist;
    }

    public List<SJmoPgIndex> extractImpossiblePg(List<? extends SJmoPgIndex> pglist) {
        List<SJmoPgIndex> rsltlist = this.extractRsgPg(pglist, this.getImpossibleRsg());
        return rsltlist;
    }

    public List<SJmoPortIndex> extractImpossiblePort(List<? extends SJmoPortIndex> portlist) {
        List<SJmoPortIndex> rsltlist = this.extractRsgPort(portlist, this.getImpossibleRsg());
        return rsltlist;
    }

    public List<SJmoHostGroupIndex> extractImpossibleHg(List<? extends SJmoHostGroupIndex> hglist) {
        List<SJmoHostGroupIndex> rsltlist = this.extractRsgHg(hglist, this.getImpossibleRsg());
        return rsltlist;
    }

    public List<SJmoRSGgetRsg> extractRsg() {
        return this.getPossibleRsg();
    }

    public boolean chkResourceGroup(int rsgid) {
        return this.getRolecntnr().checkResourceGroup(rsgid);
    }

    public BitSet getResourceGroupIdSet() {
        boolean[] bList = this.getRolecntnr().getResourceGroup();
        BitSet lockBit = SJcBitSetUty.booolean2bitset(bList);
        return lockBit;
    }

    public SJmoRSGgetRsg getRsgFromLdev(SJmoLdevIndex ldev) {
        return this.srchRsgFromLdev(ldev);
    }

    public SJmoRSGgetRsg getRsgFromHg(SJmoHostGroupIndex hg) {
        return this.srchRsgFromHg(hg);
    }

    public SJmoRSGgetRsg getRsgFromPg(SJmoPgIndex pg) {
        return this.srchRsgFromPg(pg);
    }

    public SJmoRSGgetRsg getRsgFromPort(SJmoPortIndex port) {
        return this.srchRsgFromPort(port);
    }

    private SJmoRSGgetRsg srchRsgFromLdev(SJmoLdevIndex ldev) {
        SJmoRSGgetRsg rtnRsg = null;
        if (ldev != null) {
            ArrayList rsglist = this.getAllrsgs().getRsgs();
            for (SJmoRSGgetRsg rsg : rsglist) {
                int index;
                ArrayList ldevlist = rsg.getLdevs();
                if (ldevlist == null && ldevlist.size() == 0 || (index = Collections.binarySearch(ldevlist, ldev)) < 0) continue;
                rtnRsg = rsg;
                break;
            }
        }
        return rtnRsg;
    }

    private SJmoRSGgetRsg srchRsgFromPg(SJmoPgIndex pg) {
        SJmoRSGgetRsg rtnRsg = null;
        if (pg != null) {
            ArrayList rsglist = this.getAllrsgs().getRsgs();
            for (SJmoRSGgetRsg rsg : rsglist) {
                int index;
                ArrayList pglist = rsg.getVdevs();
                if (pglist == null && pglist.size() == 0 || (index = Collections.binarySearch(pglist, pg)) < 0) continue;
                rtnRsg = rsg;
                break;
            }
        }
        return rtnRsg;
    }

    private SJmoRSGgetRsg srchRsgFromPort(SJmoPortIndex port) {
        SJmoRSGgetRsg rtnRsg = null;
        if (port != null) {
            ArrayList rsglist = this.getAllrsgs().getRsgs();
            for (SJmoRSGgetRsg rsg : rsglist) {
                int index;
                ArrayList portlist = rsg.getPorts();
                if (portlist == null && portlist.size() == 0 || (index = Collections.binarySearch(portlist, port)) < 0) continue;
                rtnRsg = rsg;
                break;
            }
        }
        return rtnRsg;
    }

    private SJmoRSGgetRsg srchRsgFromHg(SJmoHostGroupIndex hg) {
        SJmoRSGgetRsg rtnRsg = null;
        if (hg != null) {
            ArrayList rsglist = this.getAllrsgs().getRsgs();
            for (SJmoRSGgetRsg rsg : rsglist) {
                int index;
                ArrayList hglist = rsg.getHostGrps();
                if (hglist == null || hglist.size() == 0 || (index = Collections.binarySearch(hglist, hg)) < 0) continue;
                rtnRsg = rsg;
                break;
            }
        }
        return rtnRsg;
    }

    private List<SJmoLdevIndex> extractRsgLdev(List<? extends SJmoLdevIndex> ldevlist, List<SJmoRSGgetRsg> rsglist) {
        ArrayList<SJmoLdevIndex> rsltlist = new ArrayList<SJmoLdevIndex>();
        if (ldevlist == null || ldevlist.size() == 0) {
            return rsltlist;
        }
        if (rsglist == null || rsglist.size() == 0) {
            return rsltlist;
        }
        int size = 0;
        for (SJmoRSGgetRsg rsgData : rsglist) {
            ArrayList arrayList = rsgData.getLdevs();
            if (arrayList == null) continue;
            size += arrayList.size();
        }
        HashSet<String> checkSet = new HashSet<String>(size / 3 * 4 + 1);
        for (SJmoRSGgetRsg sJmoRSGgetRsg : rsglist) {
            ArrayList list = sJmoRSGgetRsg.getLdevs();
            if (list == null) continue;
            for (SJmoLdevIndex index : list) {
                checkSet.add(index.getIndexKey());
            }
        }
        for (SJmoLdevIndex sJmoLdevIndex : ldevlist) {
            boolean result = checkSet.contains(sJmoLdevIndex.getIndexKey());
            if (!result) continue;
            rsltlist.add(sJmoLdevIndex);
        }
        return rsltlist;
    }

    private List<SJmoPgIndex> extractRsgPg(List<? extends SJmoPgIndex> pglist, List<SJmoRSGgetRsg> rsglist) {
        ArrayList<SJmoPgIndex> rsltlist = new ArrayList<SJmoPgIndex>();
        if (pglist == null || pglist.size() == 0) {
            return rsltlist;
        }
        if (rsglist == null || rsglist.size() == 0) {
            return rsltlist;
        }
        int size = 0;
        for (SJmoRSGgetRsg rsgData : rsglist) {
            ArrayList arrayList = rsgData.getVdevs();
            if (arrayList == null) continue;
            size += arrayList.size();
        }
        HashSet<String> checkSet = new HashSet<String>(size / 3 * 4 + 1);
        for (SJmoRSGgetRsg sJmoRSGgetRsg : rsglist) {
            ArrayList list = sJmoRSGgetRsg.getVdevs();
            if (list == null) continue;
            for (SJmoPgIndex index : list) {
                checkSet.add(index.getIndexKey());
            }
        }
        for (SJmoPgIndex sJmoPgIndex : pglist) {
            boolean result = checkSet.contains(sJmoPgIndex.getIndexKey());
            if (!result) continue;
            rsltlist.add(sJmoPgIndex);
        }
        return rsltlist;
    }

    private List<SJmoPortIndex> extractRsgPort(List<? extends SJmoPortIndex> portlist, List<SJmoRSGgetRsg> rsglist) {
        ArrayList<SJmoPortIndex> rsltlist = new ArrayList<SJmoPortIndex>();
        if (portlist == null || portlist.size() == 0) {
            return rsltlist;
        }
        if (rsglist == null || rsglist.size() == 0) {
            return rsltlist;
        }
        int size = 0;
        for (SJmoRSGgetRsg rsgData : rsglist) {
            ArrayList arrayList = rsgData.getPorts();
            if (arrayList == null) continue;
            size += arrayList.size();
        }
        HashSet<String> checkSet = new HashSet<String>(size / 3 * 4 + 1);
        for (SJmoRSGgetRsg sJmoRSGgetRsg : rsglist) {
            ArrayList list = sJmoRSGgetRsg.getPorts();
            if (list == null) continue;
            for (SJmoPortIndex index : list) {
                checkSet.add(index.getIndexKey());
            }
        }
        for (SJmoPortIndex sJmoPortIndex : portlist) {
            boolean result = checkSet.contains(sJmoPortIndex.getIndexKey());
            if (!result) continue;
            rsltlist.add(sJmoPortIndex);
        }
        return rsltlist;
    }

    private List<SJmoHostGroupIndex> extractRsgHg(List<? extends SJmoHostGroupIndex> hglist, List<SJmoRSGgetRsg> rsglist) {
        ArrayList<SJmoHostGroupIndex> rsltlist = new ArrayList<SJmoHostGroupIndex>();
        if (hglist == null || hglist.size() == 0) {
            return rsltlist;
        }
        if (rsglist == null || rsglist.size() == 0) {
            return rsltlist;
        }
        int size = 0;
        for (SJmoRSGgetRsg rsgData : rsglist) {
            ArrayList arrayList = rsgData.getHostGrps();
            if (arrayList == null) continue;
            size += arrayList.size();
        }
        HashSet<String> checkSet = new HashSet<String>(size / 3 * 4 + 1);
        for (SJmoRSGgetRsg sJmoRSGgetRsg : rsglist) {
            ArrayList list = sJmoRSGgetRsg.getHostGrps();
            if (list == null) continue;
            for (SJmoHostGroupIndex index : list) {
                checkSet.add(index.getIndexKey());
            }
        }
        for (SJmoHostGroupIndex sJmoHostGroupIndex : hglist) {
            boolean result = checkSet.contains(sJmoHostGroupIndex.getIndexKey());
            if (!result) continue;
            rsltlist.add(sJmoHostGroupIndex);
        }
        return rsltlist;
    }

    private void extractAllRsgs() {
        ArrayList<SJmoRSGgetRsg> possibleRsg = new ArrayList<SJmoRSGgetRsg>();
        ArrayList<SJmoRSGgetRsg> impossibleRsg = new ArrayList<SJmoRSGgetRsg>();
        if (this.getAllrsgs() != null) {
            ArrayList rsglist = this.getAllrsgs().getRsgs();
            for (SJmoRSGgetRsg rsg : rsglist) {
                int rsgid = rsg.getRsgInfo().getRsgId();
                if (this.getRolecntnr().checkResourceGroup(rsgid)) {
                    possibleRsg.add(rsg);
                    continue;
                }
                impossibleRsg.add(rsg);
            }
        }
        this.setPossibleRsg(possibleRsg);
        this.setImpossibleRsg(impossibleRsg);
    }

    private List<SJmoRSGgetRsg> getPossibleRsg() {
        if (this.possibleRsg == null) {
            this.extractAllRsgs();
        }
        return this.possibleRsg;
    }

    private void setPossibleRsg(List<SJmoRSGgetRsg> possibleRsg) {
        this.possibleRsg = possibleRsg;
    }

    private List<SJmoRSGgetRsg> getImpossibleRsg() {
        if (this.impossibleRsg == null) {
            this.extractAllRsgs();
        }
        return this.impossibleRsg;
    }

    private void setImpossibleRsg(List<SJmoRSGgetRsg> impossibleRsg) {
        this.impossibleRsg = impossibleRsg;
    }

    private SJmoRSGgetAllRsgs getAllrsgs() {
        return this.allrsgs;
    }

    private void setAllrsgs(SJmoRSGgetAllRsgs allrsgs) {
        this.allrsgs = allrsgs;
    }

    private SJcRoleResourceContainer getRolecntnr() {
        return this.rolecntnr;
    }

    private void setRolecntnr(SJcRoleResourceContainer rolecntnr) {
        this.rolecntnr = rolecntnr;
    }

    private SJctrUserController getUsrctrl() {
        return this.usrctrl;
    }

    private void setUsrctrl(SJctrUserController usrctrl) {
        this.usrctrl = usrctrl;
    }

    private SJmoRSGgetRsg getSysRsg() {
        SJmoRSGgetRsg ret = null;
        SJmoRSGgetAllRsgs allRsgs = this.getAllrsgs();
        if (allRsgs.isBHfbInstall()) {
            ArrayList allRsgInfoList = this.getAllrsgs().getRsgs();
            for (SJmoRSGgetRsg rsgInfo : allRsgInfoList) {
                if (!SJctrRsgUtility.isSysRsg(rsgInfo.getRsgInfo())) continue;
                ret = rsgInfo;
                break;
            }
        }
        return ret;
    }

    public boolean isSelRscPgInSysRsg(SJmoPgIndex checkPgIndex) {
        ArrayList sysRsgPgList;
        int index;
        boolean ret = false;
        if (null == checkPgIndex) {
            SJctrLogUty.error("SJctrResourceGroupUtility", "isSelRscPgInSysRsg", "checkPgIndex is null.");
            throw SJctrRsgUtility.makeException(107001);
        }
        if (null != this.systemRsgInfo && (index = Collections.binarySearch(sysRsgPgList = this.systemRsgInfo.getVdevs(), checkPgIndex)) >= 0) {
            ret = true;
        }
        return ret;
    }

    public List<SJmoPgIndex> extractPgInSysRsg(List<? extends SJmoPgIndex> checkPgList) {
        ArrayList<SJmoPgIndex> retList = new ArrayList<SJmoPgIndex>();
        if (null != checkPgList && null != this.systemRsgInfo) {
            ArrayList sysRsgPgList = this.systemRsgInfo.getVdevs();
            for (SJmoPgIndex sJmoPgIndex : checkPgList) {
                int index = Collections.binarySearch(sysRsgPgList, sJmoPgIndex);
                if (index < 0) continue;
                retList.add(sJmoPgIndex);
            }
        }
        return retList;
    }

    public List<SJmoPgIndex> extractPgExceptSysRsg(List<? extends SJmoPgIndex> checkPgList) {
        ArrayList<SJmoPgIndex> retList = new ArrayList<SJmoPgIndex>();
        if (null != checkPgList) {
            if (null != this.systemRsgInfo) {
                ArrayList sysRsgPgList = this.systemRsgInfo.getVdevs();
                for (SJmoPgIndex sJmoPgIndex : checkPgList) {
                    int index = Collections.binarySearch(sysRsgPgList, sJmoPgIndex);
                    if (index >= 0) continue;
                    retList.add(sJmoPgIndex);
                }
            } else {
                retList.addAll(checkPgList);
            }
        }
        return retList;
    }

    public boolean isSelRscLdevInSysRsg(SJmoLdevIndex checkLdevIndex) {
        ArrayList sysRsgLdevList;
        int index;
        boolean ret = false;
        if (null == checkLdevIndex) {
            SJctrLogUty.error("SJctrResourceGroupUtility", "isSelRscLdevInSysRsg", "checkLdevIndex is null.");
            throw SJctrRsgUtility.makeException(107001);
        }
        if (null != this.systemRsgInfo && (index = Collections.binarySearch(sysRsgLdevList = this.systemRsgInfo.getLdevs(), checkLdevIndex)) >= 0) {
            ret = true;
        }
        return ret;
    }

    public List<SJmoLdevIndex> extractLdevInSysRsg(List<? extends SJmoLdevIndex> checkLdevList) {
        ArrayList<SJmoLdevIndex> retList = new ArrayList<SJmoLdevIndex>();
        if (null != checkLdevList && null != this.systemRsgInfo) {
            ArrayList sysRsgLdevList = this.systemRsgInfo.getLdevs();
            for (SJmoLdevIndex sJmoLdevIndex : checkLdevList) {
                int index = Collections.binarySearch(sysRsgLdevList, sJmoLdevIndex);
                if (index < 0) continue;
                retList.add(sJmoLdevIndex);
            }
        }
        return retList;
    }

    public List<SJmoLdevIndex> extractLdevExceptSysRsg(List<? extends SJmoLdevIndex> checkLdevList) {
        ArrayList<SJmoLdevIndex> retList = new ArrayList<SJmoLdevIndex>();
        if (null != checkLdevList) {
            if (null != this.systemRsgInfo) {
                ArrayList sysRsgLdevList = this.systemRsgInfo.getLdevs();
                for (SJmoLdevIndex sJmoLdevIndex : checkLdevList) {
                    int index = Collections.binarySearch(sysRsgLdevList, sJmoLdevIndex);
                    if (index >= 0) continue;
                    retList.add(sJmoLdevIndex);
                }
            } else {
                retList.addAll(checkLdevList);
            }
        }
        return retList;
    }

    public boolean isSelRscPortInSysRsg(SJmoPortIndex checkPortIndex) {
        ArrayList sysRsgPortList;
        int index;
        boolean ret = false;
        if (null == checkPortIndex) {
            SJctrLogUty.error("SJctrResourceGroupUtility", "isSelRscPortInSysRsg", "checkPortIndex is null.");
            throw SJctrRsgUtility.makeException(107001);
        }
        if (null != this.systemRsgInfo && (index = Collections.binarySearch(sysRsgPortList = this.systemRsgInfo.getPorts(), checkPortIndex)) >= 0) {
            ret = true;
        }
        return ret;
    }

    public List<SJmoPortIndex> extractPortInSysRsg(List<? extends SJmoPortIndex> checkPortList) {
        ArrayList<SJmoPortIndex> retList = new ArrayList<SJmoPortIndex>();
        if (null != checkPortList && null != this.systemRsgInfo) {
            ArrayList sysRsgPortList = this.systemRsgInfo.getPorts();
            for (SJmoPortIndex sJmoPortIndex : checkPortList) {
                int index = Collections.binarySearch(sysRsgPortList, sJmoPortIndex);
                if (index < 0) continue;
                retList.add(sJmoPortIndex);
            }
        }
        return retList;
    }

    public List<SJmoPortIndex> extractPortExceptSysRsg(List<? extends SJmoPortIndex> checkPortList) {
        ArrayList<SJmoPortIndex> retList = new ArrayList<SJmoPortIndex>();
        if (null != checkPortList) {
            if (null != this.systemRsgInfo) {
                ArrayList sysRsgPortList = this.systemRsgInfo.getPorts();
                for (SJmoPortIndex sJmoPortIndex : checkPortList) {
                    int index = Collections.binarySearch(sysRsgPortList, sJmoPortIndex);
                    if (index >= 0) continue;
                    retList.add(sJmoPortIndex);
                }
            } else {
                retList.addAll(checkPortList);
            }
        }
        return retList;
    }

    public boolean isSelRscHgInSysRsg(SJmoHostGroupIndex checkHgIndex) {
        ArrayList sysRsgHgList;
        int index;
        boolean ret = false;
        if (null == checkHgIndex) {
            SJctrLogUty.error("SJctrResourceGroupUtility", "isSelRscHgInSysRsg", "checkHgIndex is null.");
            throw SJctrRsgUtility.makeException(107001);
        }
        if (null != this.systemRsgInfo && (index = Collections.binarySearch(sysRsgHgList = this.systemRsgInfo.getHostGrps(), checkHgIndex)) >= 0) {
            ret = true;
        }
        return ret;
    }

    public List<SJmoHostGroupIndex> extractHgInSysRsg(List<? extends SJmoHostGroupIndex> checkHgList) {
        ArrayList<SJmoHostGroupIndex> retList = new ArrayList<SJmoHostGroupIndex>();
        if (null != checkHgList && null != this.systemRsgInfo) {
            ArrayList sysRsgHgList = this.systemRsgInfo.getHostGrps();
            for (SJmoHostGroupIndex sJmoHostGroupIndex : checkHgList) {
                int index = Collections.binarySearch(sysRsgHgList, sJmoHostGroupIndex);
                if (index < 0) continue;
                retList.add(sJmoHostGroupIndex);
            }
        }
        return retList;
    }

    public List<SJmoHostGroupIndex> extractHgExceptSysRsg(List<? extends SJmoHostGroupIndex> checkHgList) {
        ArrayList<SJmoHostGroupIndex> retList = new ArrayList<SJmoHostGroupIndex>();
        if (null != checkHgList) {
            if (null != this.systemRsgInfo) {
                ArrayList sysRsgHgList = this.systemRsgInfo.getHostGrps();
                for (SJmoHostGroupIndex sJmoHostGroupIndex : checkHgList) {
                    int index = Collections.binarySearch(sysRsgHgList, sJmoHostGroupIndex);
                    if (index >= 0) continue;
                    retList.add(sJmoHostGroupIndex);
                }
            } else {
                retList.addAll(checkHgList);
            }
        }
        return retList;
    }
}

