/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.BitSet;

public class SJctrUniqueIdManager {
    private final int circuitSize;
    private final BitSet uniqueIdSet;
    private int uniqueIdIndex;

    public SJctrUniqueIdManager(int size) {
        this.circuitSize = size;
        this.uniqueIdSet = new BitSet(this.circuitSize);
        this.uniqueIdIndex = -1;
    }

    public synchronized void releaseId(int id) {
        this.uniqueIdSet.clear(id);
    }

    public synchronized int acquireId() {
        if (this.getUseSize() >= this.circuitSize) {
            return -1;
        }
        ++this.uniqueIdIndex;
        this.uniqueIdIndex = this.uniqueIdSet.nextClearBit(this.uniqueIdIndex);
        if (this.uniqueIdIndex >= this.circuitSize) {
            this.uniqueIdIndex %= this.circuitSize;
            this.uniqueIdIndex = this.uniqueIdSet.nextClearBit(this.uniqueIdIndex);
        }
        this.uniqueIdSet.set(this.uniqueIdIndex);
        return this.uniqueIdIndex;
    }

    public int getUseSize() {
        return this.uniqueIdSet.cardinality();
    }
}

