/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;

public class SJctrHostGroupIdColumnFromPortHostGroupTableKey
extends SJctrColumn {
    public SJctrHostGroupIdColumnFromPortHostGroupTableKey(String key) {
        super(key);
        this.setPartsId("HG_ID");
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> list = new ArrayList<Object>();
        SJctrPortHostGroupTableKey ptHginfo = (SJctrPortHostGroupTableKey)index;
        if (ptHginfo.isFibre()) {
            list.add(ptHginfo.getHostGroupInfo());
        } else {
            list.add(ptHginfo.getIscsiTargetInfo());
        }
        return list;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortHostGroupInfo.class);
        list.add(SJmoGetPortIscsiTargetInfo.class);
        return list;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        return "^([0-9A-Fa-f]{1,2})$";
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int sHg = -1;
        SJctrPortHostGroupTableKey ptHGTableKey = (SJctrPortHostGroupTableKey)this.getPrimaryKeyObject(dat);
        if (ptHGTableKey.isFibre()) {
            SJmoHostGroupInfo hgInfo = ptHGTableKey.getHostGroupInfo();
            if (hgInfo != null) {
                sHg = hgInfo.getSHostGroup();
            }
        } else {
            SJmoIscsiTargetInfo itInfo = ptHGTableKey.getIscsiTargetInfo();
            if (itInfo != null) {
                sHg = itInfo.getSIscsiTarget();
            }
        }
        return sHg;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strHGName = "?";
        if (dataList.get(0) instanceof SJmoHostGroupInfo) {
            SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)dataList.get(0);
            strHGName = String.format("%02X", hgInfo.getSHostGroup());
        } else if (dataList.get(0) instanceof SJmoIscsiTargetInfo) {
            SJmoIscsiTargetInfo itInfo = (SJmoIscsiTargetInfo)dataList.get(0);
            strHGName = String.format("%02X", itInfo.getSIscsiTarget());
        }
        return strHGName;
    }
}

