/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrLdevIdColumnFromPortLunTableKey
extends SJctrColumn {
    protected HashMap<SJctrPortLunTableKey, SJmoLdevIndex> ldevIndexMap = null;

    public SJctrLdevIdColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("LDEV_ID"));
    }

    @Override
    public int getFilterType() {
        return 16;
    }

    @Override
    public int getSortType() {
        return 3;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPortLunDetail> list = new ArrayList<SJmoPortLunDetail>();
        SJctrPortLunTableKey ptLunInfo = (SJctrPortLunTableKey)index;
        SJmoPortLunDetail ptLunDtl = ptLunInfo.getPortLunDetail();
        if (this.ldevIndexMap == null) {
            this.ldevIndexMap = new HashMap(this.getTable().getRowCount());
        }
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        ldevIndex.setLdevIndex(ptLunDtl.getSLDKC(), ptLunDtl.getSCU(), ptLunDtl.getSLDEV());
        this.ldevIndexMap.put(ptLunInfo, ldevIndex);
        list.add(ptLunDtl);
        return list;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoPortLunDetail ptLunDetail = (SJmoPortLunDetail)dataList.get(0);
        SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
        return util.toLdevDisplay(ptLunDetail);
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return new SJctrLdevIndexComparator(){

            @Override
            public int compare(Object o1, Object o2) {
                boolean result = false;
                SJmoLdevIndex ldev1 = this.getCompareValue(o1);
                SJmoLdevIndex ldev2 = this.getCompareValue(o2);
                return super.compare(ldev1, ldev2);
            }

            private SJmoLdevIndex getCompareValue(Object obj) {
                SJmoLdevIndex ldev = obj instanceof SJctrPortLunTableKey ? SJctrLdevIdColumnFromPortLunTableKey.this.ldevIndexMap.get(obj) : (SJmoLdevIndex)obj;
                return ldev;
            }
        };
    }
}

