/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrVVolTier1UsedCapacityColumnFromPortLunTableKey;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoTierInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrVVolTier3UsedCapacityColumnFromPortLunTableKey
extends SJctrVVolTier1UsedCapacityColumnFromPortLunTableKey {
    public SJctrVVolTier3UsedCapacityColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("TIER3"));
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && dataList.size() != 0) {
            Object toDispData = dataList.get(0);
            if (toDispData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelation = (SJmoHDPRelation)toDispData;
                String strCapaUnit = this.getUnitSelect();
                SJctrComUtility comUtil = this.getTable().getComUtility();
                strRtn = comUtil.getPoolUtility().toLUNTierUsedCapacityDisplay(hdpRelation, 3, strCapaUnit, comUtil);
            } else if (toDispData instanceof SJmoLdevDetail) {
                strRtn = SJctrPoolUtility.HAIFUN_STR;
            }
        }
        return strRtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lRtn = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelationData = (SJmoHDPRelation)modelData;
                long lPageSize = hdpRelationData.getLPageCapa();
                ArrayList tierInfoList = hdpRelationData.getAlDpVolTierInfo();
                for (SJmoTierInfo tierInfo : tierInfoList) {
                    if (tierInfo.getSTierNum() != 3) continue;
                    long lTierUse = tierInfo.getLUseTier();
                    long lTierUseCapa = lPageSize * lTierUse;
                    lRtn = this.getTable().getComUtility().getCapacityUtility().valueOf(lTierUseCapa, SJctrCapacityUtility.UNIT.KB);
                    break;
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                lRtn = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return lRtn;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        long lRtn = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)modelData;
                ArrayList tierInfoList = hdpRelData.getAlDpVolTierInfo();
                for (SJmoTierInfo tierInfo : tierInfoList) {
                    if (tierInfo.getSTierNum() != 3) continue;
                    lRtn = tierInfo.getLUseTier();
                    break;
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                lRtn = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return lRtn;
    }
}

