/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.rsg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrRsgColumnFromPortDetail
extends SJctrColumn {
    public static final String DEFAULT_STR = "";
    public static final int NOT_RSG_ID = -1;
    static final String NAME_ID_RSG = "RES_GRP_NAME_ID";

    public SJctrRsgColumnFromPortDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance(NAME_ID_RSG));
    }

    @Override
    public int getFilterType() {
        return 1;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<SJmoRSGgetRsg> ret = new ArrayList<SJmoRSGgetRsg>();
        SJmoPortDetail portDetail = (SJmoPortDetail)index;
        List<?> allRsgsList = basicData.get(SJmoGetRSGgetAllRsgs.class);
        SJmoRSGgetRsg rtnRsg = null;
        if (allRsgsList != null && allRsgsList.size() > 0) {
            ArrayList rsglist = ((SJmoRSGgetAllRsgs)allRsgsList.get(0)).getRsgs();
            for (SJmoRSGgetRsg rsg : rsglist) {
                ArrayList portlist = rsg.getPorts();
                int rsgIndex = Collections.binarySearch(portlist, portDetail);
                if (rsgIndex < 0) continue;
                rtnRsg = rsg;
            }
        }
        ret.add(rtnRsg);
        return ret;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortDetail.class);
        list.add(SJmoGetRSGgetAllRsgs.class);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String dispString = DEFAULT_STR;
        SJmoRSGgetRsg rtnRsg = (SJmoRSGgetRsg)dataList.get(0);
        SJctrDataController dc = this.getTable().getDataController();
        SJctrUserController uc = dc.getOwner();
        SJctrComUtility comUtil = this.getTable().getComUtility();
        if (rtnRsg != null) {
            SJmoRSGInfo rsgInfo = rtnRsg.getRsgInfo();
            dispString = SJctrRsgUtility.toRsgIdDisplay(comUtil, rsgInfo);
        } else {
            dispString = "?";
        }
        return dispString;
    }
}

