/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDExternalVolumeEx;
import sanproject.sn2.controller.com.column.SJctrLdevIdColummnFromLdevIndex;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrDataDirectMappLdevColumnFromExdVolumeInfo
extends SJctrLdevIdColummnFromLdevIndex {
    protected static final String GUID_DDIM_LDEV = "DATA_DIRECT_MAP_LDEV";
    protected static final SJmoLdevIndex defaultLdevIndex = new SJmoLdevIndex();
    protected Map<SJmoExdVolumeInfo, SJmoLdevIndex> exdVolDMLdevMap = Collections.emptyMap();

    public SJctrDataDirectMappLdevColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId(GUID_DDIM_LDEV);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        List<Class<? extends SJmoGetKind_IF>> list = super.getNeedModelKind();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetExDVirtualPgInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoLdevIndex> list = new ArrayList<SJmoLdevIndex>();
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)index;
        EXDExternalVolumeEx exdVolEx = (EXDExternalVolumeEx)volumeInfo.getRmiExdVolumeInfo();
        if (!exdVolEx.isDDMAttribute()) {
            return list;
        }
        SJmoLdevIndex startLdev = this.getStartLdev(volumeInfo, modelData);
        if (startLdev == null) {
            list.add(defaultLdevIndex);
            return list;
        }
        SJmoLdevDetail ldevDtl = this.getLdevDetail(startLdev, modelData);
        if (ldevDtl == null) {
            list.add(null);
        } else if (ldevDtl.getBDM()) {
            SJmoLdevIndex dmLdev = ldevDtl.getCnctLDEVIndex();
            if (dmLdev != null) {
                if (this.exdVolDMLdevMap.isEmpty()) {
                    this.exdVolDMLdevMap = new HashMap<SJmoExdVolumeInfo, SJmoLdevIndex>(this.getTable().getRowCount());
                }
                this.exdVolDMLdevMap.put(volumeInfo, dmLdev);
                list.add(dmLdev);
            } else {
                list.add(defaultLdevIndex);
            }
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "-";
        if (!dataList.isEmpty()) {
            SJmoLdevIndex ldev = (SJmoLdevIndex)dataList.get(0);
            ret = ldev != null && ldev == defaultLdevIndex ? "" : super.toDispString(dataList);
        }
        return ret;
    }

    @Override
    protected Object getObject(Map<String, Object> dat) {
        SJmoExdVolumeInfo primaryKeyObj = (SJmoExdVolumeInfo)this.getPrimaryKeyObject(dat);
        SJmoLdevIndex ddmLdev = this.getDMLdev(primaryKeyObj);
        if (ddmLdev == null) {
            ddmLdev = defaultLdevIndex;
        }
        return ddmLdev;
    }

    protected SJmoLdevIndex getStartLdev(SJmoExdVolumeInfo volumeInfo, Map<Class<?>, List<?>> modelData) {
        SJmoExDPgInfo exdPGInfo;
        SJmoLdevIndex startLdev = null;
        SJmoExDVirtualPgInfo vpginfo = (SJmoExDVirtualPgInfo)modelData.get(SJmoGetExDVirtualPgInfo.class).get(0);
        ArrayList exdVpgList = vpginfo.getAlVpgForExd();
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        EXDExternalVolume exdVol = volumeInfo.getRmiExdVolumeInfo();
        pgIndex.setFB4(exdVol.getIFB4());
        pgIndex.setPG(exdVol.getIPG());
        int searchId = Collections.binarySearch((List)exdVpgList, (Object)pgIndex);
        if (searchId >= 0 && 1 <= (exdPGInfo = (SJmoExDPgInfo)exdVpgList.get(searchId)).getSNumOfLdev()) {
            startLdev = exdPGInfo.getStartLdevId();
        }
        return startLdev;
    }

    protected SJmoLdevDetail getLdevDetail(SJmoLdevIndex ldev, Map<Class<?>, List<?>> modelData) {
        SJmoLdevDetail ldevDtl = null;
        List<?> ldevDtlList = modelData.get(SJmoGetLdevDetail.class);
        int searchId = Collections.binarySearch(ldevDtlList, (Object)ldev);
        if (searchId >= 0) {
            ldevDtl = (SJmoLdevDetail)ldevDtlList.get(searchId);
        }
        return ldevDtl;
    }

    public SJmoLdevIndex getDMLdev(SJmoExdVolumeInfo volumeInfo) {
        return this.exdVolDMLdevMap.get(volumeInfo);
    }

    @Override
    protected Comparator<HashMap<String, Object>> createComparator() {
        Comparator<HashMap<String, Object>> retComparator = new Comparator<HashMap<String, Object>>(){

            @Override
            public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                int result = 0;
                Object obj1 = SJctrDataDirectMappLdevColumnFromExdVolumeInfo.this.getObject(o1);
                Object obj2 = SJctrDataDirectMappLdevColumnFromExdVolumeInfo.this.getObject(o2);
                Comparator comparator = SJctrDataDirectMappLdevColumnFromExdVolumeInfo.this.createObjectComparator();
                result = comparator.compare(obj1, obj2);
                if (result == 0) {
                    result = SJctrDataDirectMappLdevColumnFromExdVolumeInfo.this.getString(o1).compareTo(SJctrDataDirectMappLdevColumnFromExdVolumeInfo.this.getString(o2));
                }
                return result;
            }
        };
        return retComparator;
    }
}

