/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.mof.compiler;

import com.ws.cim.mof.compiler.CIMMutableElement;
import com.ws.cim.mof.compiler.CIMMutableParameter;
import com.ws.cim.mof.compiler.CIMMutableQualifier;
import java.util.ArrayList;
import javax.cim.CIMDataType;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;
import javax.cim.CIMQualifier;

public class CIMMutableMethod
extends CIMMutableElement {
    private String mName;
    private CIMMutableParameter[] mParameters = null;
    private CIMMutableQualifier[] mQualifiers = null;
    private CIMDataType mType;

    public CIMMutableMethod() {
    }

    public CIMMutableMethod(CIMMethod<?> method) {
        this();
        CIMParameter<?>[] mParameters;
        CIMQualifier<?>[] propQuals;
        this.setName(method.getName());
        this.setType(method.getDataType());
        ArrayList<CIMMutableQualifier> qList = new ArrayList<CIMMutableQualifier>();
        for (CIMQualifier<?> prop : propQuals = method.getQualifiers()) {
            qList.add(new CIMMutableQualifier(prop));
        }
        this.setQualifiers(qList.toArray(new CIMMutableQualifier[qList.size()]));
        ArrayList<CIMMutableParameter> pList = new ArrayList<CIMMutableParameter>();
        for (CIMParameter<?> param : mParameters = method.getParameters()) {
            pList.add(new CIMMutableParameter(param));
        }
        this.setParameters(pList.toArray(new CIMMutableParameter[pList.size()]));
    }

    public CIMParameter<?>[] getCIMParameters() {
        ArrayList l = new ArrayList();
        if (this.mParameters == null) {
            return new CIMParameter[0];
        }
        for (CIMMutableParameter p : this.mParameters) {
            l.add(p.getParameter());
        }
        return l.toArray(new CIMParameter[l.size()]);
    }

    public CIMQualifier<?>[] getCIMQualifiers() {
        ArrayList l = new ArrayList();
        if (null != this.mQualifiers) {
            for (CIMMutableQualifier q : this.mQualifiers) {
                l.add(q.getCIMQualifier());
            }
        }
        return l.toArray(new CIMQualifier[l.size()]);
    }

    public CIMDataType getDataType() {
        return this.mType;
    }

    public CIMMethod<?> getMethod() {
        return new CIMMethod(this.mName, this.mType, this.getCIMQualifiers(), this.getCIMParameters(), false);
    }

    public String getName() {
        return this.mName;
    }

    public CIMMutableParameter[] getParameters() {
        return this.mParameters;
    }

    public CIMMutableQualifier[] getQualifiers() {
        return this.mQualifiers;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setParameters(CIMMutableParameter[] pParameters) {
        this.mParameters = pParameters;
    }

    public void setQualifiers(CIMMutableQualifier[] pQualifiers) {
        this.mQualifiers = pQualifiers;
    }

    public void setType(CIMDataType type) {
        this.mType = type;
    }

    public void replaceQualifier(CIMMutableQualifier p) {
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            CIMMutableQualifier prop = this.mQualifiers[i];
            if (null == prop || null == prop.getName() || null == p || null == p.getName()) {
                return;
            }
            if (!prop.getName().equals(p.getName())) continue;
            this.mQualifiers[i] = p;
            return;
        }
    }
}

