/*
 * Decompiled with CFR 0.152.
 */
package javax.cim3;

import com.ws.cim3.mof.MOFStyle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.cim3.CIMClassProperty;
import javax.cim3.CIMEnumeration;
import javax.cim3.CIMInstance;
import javax.cim3.CIMMethod;
import javax.cim3.CIMNamedElementInterface;
import javax.cim3.CIMObjectPath;
import javax.cim3.CIMProperty;
import javax.cim3.CIMQualifiedElementInterface;
import javax.cim3.CIMQualifier;
import javax.cim3.CIMStructure;
import javax.cim3.CIMValuedElement;
import javax.cim3.SharedMethods;

public class CIMClass
extends CIMStructure
implements CIMQualifiedElementInterface,
CIMNamedElementInterface,
Serializable {
    private static final String KEY = "Key";
    private static final String ASSOCIATION = "Association";
    private static final long serialVersionUID = -5634561913210025100L;
    private final boolean mIsAssociation;
    private final boolean mIsKeyed;
    private final CIMMethod<?>[] mMethods;

    public CIMClass(CIMObjectPath path, String superclass, CIMQualifier<?>[] qualifiers, CIMClassProperty<?>[] properties, CIMMethod<?>[] methods, CIMStructure[] structures, CIMEnumeration<?>[] enumerations, boolean isAssociation, boolean isKeyed) {
        super(path, superclass, qualifiers, properties, structures, enumerations);
        this.mIsKeyed = isKeyed;
        this.mIsAssociation = isAssociation;
        this.mMethods = methods != null ? methods : new CIMMethod[]{};
    }

    public CIMClass(CIMObjectPath name, String superclass, CIMQualifier<?>[] qualifiers, CIMClassProperty<?>[] properties, CIMMethod<?>[] methods) {
        super(name, superclass, qualifiers, properties, null, null);
        this.mMethods = methods != null ? methods : new CIMMethod[]{};
        boolean b = false;
        for (CIMQualifier<?> cIMQualifier : qualifiers) {
            if (!ASSOCIATION.equalsIgnoreCase(cIMQualifier.getName())) continue;
            b = true;
        }
        this.mIsAssociation = b;
        b = false;
        for (CIMValuedElement cIMValuedElement : properties) {
            try {
                Object val = ((CIMClassProperty)cIMValuedElement).getQualifierValue(KEY);
                if (null == val || !val.equals(Boolean.TRUE)) continue;
                b = true;
                break;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.mIsKeyed = b;
    }

    @Override
    public boolean equals(Object obj) {
        CIMClass clazz;
        String mSuperClass = this.getSuperClassName();
        CIMObjectPath mObjectPath = this.getObjectPath();
        if (obj instanceof CIMClass && super.equals(obj) && mObjectPath.equals((clazz = (CIMClass)obj).getObjectPath()) && (mSuperClass == null ? clazz.getSuperClassName() == null : mSuperClass.equalsIgnoreCase(clazz.getSuperClassName())) && this.mIsAssociation == clazz.mIsAssociation) {
            Object[] methods = (CIMMethod[])this.getMethods().clone();
            Object[] clazzmethods = (CIMMethod[])clazz.getMethods().clone();
            Arrays.sort(methods);
            Arrays.sort(clazzmethods);
            if (Arrays.equals(methods, clazzmethods)) {
                Object[] props = (CIMProperty[])this.getProperties().clone();
                Object[] clazzprops = (CIMProperty[])clazz.getProperties().clone();
                Arrays.sort(props);
                Arrays.sort(clazzprops);
                if (Arrays.equals(props, clazzprops)) {
                    Object[] quals = (CIMQualifier[])this.getQualifiers().clone();
                    Object[] clazzquals = (CIMQualifier[])clazz.getQualifiers().clone();
                    Arrays.sort(quals);
                    Arrays.sort(clazzquals);
                    if (Arrays.equals(quals, clazzquals)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public CIMClass filterProperties(boolean localOnly, boolean includeQualifiers, String[] propertyList) {
        if (!localOnly && includeQualifiers && propertyList == null) {
            return this;
        }
        CIMQualifier<?>[] qualList = includeQualifiers ? SharedMethods.getFilteredQualifiers(localOnly, this.getQualifiers()) : null;
        CIMClassProperty<?>[] propList = this.getFilteredProperties(localOnly, includeQualifiers, propertyList);
        CIMMethod<?>[] methodList = this.getFilteredMethods(localOnly, includeQualifiers, propertyList);
        CIMClass cc = new CIMClass(this.getObjectPath(), this.getSuperClassName(), qualList, propList, methodList, this.getStructures(), this.getEnumerations(), this.mIsAssociation, this.mIsKeyed);
        return cc;
    }

    protected CIMMethod<?>[] getFilteredMethods(boolean localOnly, boolean includeQualifier, String[] propertyList) {
        ArrayList methodList = new ArrayList();
        if (propertyList == null && this.mMethods != null && this.mMethods.length > 0) {
            for (CIMMethod<?> m : this.mMethods) {
                if ((!localOnly || m.isPropagated()) && localOnly) continue;
                methodList.add(m.filter(includeQualifier));
            }
        }
        if (!methodList.isEmpty()) {
            return methodList.toArray(new CIMMethod[methodList.size()]);
        }
        return null;
    }

    public CIMClassProperty<?>[] getKeys() {
        ArrayList l = new ArrayList();
        for (CIMClassProperty<?> mPropertie : this.getProperties()) {
            if (!mPropertie.isKey()) continue;
            l.add(mPropertie);
        }
        return l.toArray(new CIMClassProperty[l.size()]);
    }

    public CIMMethod<?> getMethod(int index) throws ArrayIndexOutOfBoundsException {
        return this.mMethods[index];
    }

    public CIMMethod<?> getMethod(String name) {
        if (this.mMethods == null || name == null) {
            return null;
        }
        for (CIMMethod<?> mMethod : this.mMethods) {
            if (!mMethod.getName().equalsIgnoreCase(name)) continue;
            return mMethod;
        }
        return null;
    }

    public int getMethodCount() {
        return this.mMethods.length;
    }

    public CIMMethod<?>[] getMethods() {
        return this.mMethods;
    }

    public boolean isAssociation() {
        return this.mIsAssociation;
    }

    public boolean isKeyed() {
        return this.mIsKeyed;
    }

    public CIMInstance newInstance() {
        CIMClassProperty<?>[] clazzProps = this.getProperties();
        CIMProperty[] cpArray = new CIMProperty[clazzProps.length];
        for (int i = 0; i < clazzProps.length; ++i) {
            CIMClassProperty<?> ccp = clazzProps[i];
            cpArray[i] = new CIMProperty(ccp.getName(), ccp.getDataType(), ccp.getValue(), ccp.isKey());
        }
        return new CIMInstance(this.getObjectPath(), cpArray);
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

