/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.messages.RPCMessage;
import flex.messaging.util.StringUtils;
import flex.messaging.util.URLDecoder;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class HTTPMessage
extends RPCMessage {
    private static final long serialVersionUID = 5954910346466323369L;
    protected String contentType;
    protected String method;
    protected String url;
    protected Map httpHeaders;
    protected boolean recordHeaders;

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String m) {
        this.method = m != null ? m.trim().toUpperCase() : m;
    }

    public Map getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map h) {
        this.httpHeaders = h;
    }

    public void setUrl(String s) {
        try {
            this.url = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.url = s;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getRecordHeaders() {
        return this.recordHeaders;
    }

    public void setRecordHeaders(boolean recordHeaders) {
        this.recordHeaders = recordHeaders;
    }

    @Override
    protected String toStringFields(int indentLevel) {
        String sep = this.getFieldSeparator(indentLevel);
        StringBuilder sb = new StringBuilder();
        sb.append(sep).append("method = ").append(this.getMethod()).append(sep).append("url = ").append(this.getUrl()).append(sep).append("headers = ").append(this.getHeaders());
        sb.append(super.toStringFields(indentLevel));
        return sb.toString();
    }

    @Override
    protected String internalBodyToString(Object body, int indentLevel) {
        return body instanceof String ? StringUtils.prettifyString((String)((String)body)) : super.internalBodyToString(body, indentLevel);
    }
}

