/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.io.IOException;
import java.io.Serializable;
import org.wbemservices.wbem.repository.PersistentStore;

class CIMRlogEntry
implements Serializable {
    private static final long serialVersionUID = 4012529228189L;
    protected String name;
    protected static PersistentStore store;
    private long objectID = -1L;

    protected static String toNameKey(String s) {
        return s.toLowerCase();
    }

    public static void setPersistentStore(PersistentStore store) {
        CIMRlogEntry.store = store;
    }

    public CIMRlogEntry() {
    }

    public CIMRlogEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getNameKey() {
        return CIMRlogEntry.toNameKey(this.name);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof CIMRlogEntry) {
            CIMRlogEntry e = (CIMRlogEntry)anObject;
            return e.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public byte[] getValue() {
        if (this.objectID == -1L) {
            return null;
        }
        try {
            byte[] bytes = null;
            bytes = store.readObjectBytes(this.objectID);
            return bytes;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void createPersistObject(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            this.delete();
            return;
        }
        long id = store.writeObjectBytes(bytes);
        this.setID(id);
    }

    public void setID(long id) {
        this.delete();
        this.objectID = id;
    }

    public long getID() {
        return this.objectID;
    }

    public void delete() {
        if (this.objectID != -1L) {
            store.deleteObject(this.objectID);
        }
        this.objectID = -1L;
    }

    public PersistentStore.PersistObject getPersistObject() {
        if (this.objectID == -1L) {
            throw new RuntimeException("CIMRlogEntry contains no object");
        }
        return store.getPersistObject(this.objectID);
    }
}

