/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.cmpi;

import com.ws.cim.codegen.cmpi.CDataMember;
import com.ws.cim.codegen.cmpi.CFunction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;

public class CCodeWriter {
    private ArrayList<String> mImportList;
    private String mClassName;
    private final ArrayList<CDataMember> mDataMembers;
    private final ArrayList<CFunction> mFunctions;
    private final String mOutdir;

    public CCodeWriter(String pOutdir) {
        this.mOutdir = pOutdir;
        this.mImportList = new ArrayList();
        this.mDataMembers = new ArrayList();
        this.mFunctions = new ArrayList();
    }

    public void setClassName(String pName) {
        this.mClassName = pName;
    }

    public void addImport(String pImportName) {
        this.mImportList.add(pImportName);
    }

    public void addMethod(CFunction func) {
        this.mFunctions.add(func);
    }

    public void setImports(ArrayList<String> pImportList) {
        this.mImportList = pImportList;
    }

    public void addDataMember(CDataMember pDataMember) {
        this.mDataMembers.add(pDataMember);
    }

    public void write(String pFileName) throws Exception {
        if (pFileName == null) {
            throw new IllegalArgumentException("Invalid Argument: File name cannot be null!");
        }
        File dir = new File(this.mOutdir);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
            throw new IllegalArgumentException("could not create directory: " + this.mOutdir);
        }
        String fileName = this.mOutdir + File.separator + pFileName;
        File cFile = new File(fileName);
        if (cFile.exists()) {
            cFile.delete();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(fileName, false));
        out.write("#include <stdio.h>" + System.getProperty("line.separator"));
        out.write("#include <stdlib.h>" + System.getProperty("line.separator"));
        out.write("#include <string.h>" + System.getProperty("line.separator"));
        out.newLine();
        out.write("/* CMPI Imports */" + System.getProperty("line.separator"));
        out.write("#include \"cmpift.h\"" + System.getProperty("line.separator"));
        out.newLine();
        out.write("/* Common Includes */" + System.getProperty("line.separator"));
        out.write("#include \"" + this.mClassName + ".h\"" + System.getProperty("line.separator"));
        out.newLine();
        for (CDataMember dataMember : this.mDataMembers) {
            out.write(dataMember.toString());
            out.newLine();
        }
        out.newLine();
        for (CFunction func : this.mFunctions) {
            out.write(func.toString());
            out.newLine();
            out.newLine();
        }
        out.newLine();
        out.close();
    }
}

