/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.java;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaDataMember;
import com.ws.cim.codegen.java.JavaMethod;
import java.util.ArrayList;
import java.util.Iterator;

public class JavaEnums {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final String mComment;
    private final ArrayList<String> mEnumConstants;
    private final ArrayList<JavaDataMember> mDataMembers;
    private final ArrayList<JavaMethod> mMethods;
    private final String mName;
    private final JavaCodeWriterConstants.TYPE mType;

    public JavaEnums(String pComment, String pName, JavaCodeWriterConstants.TYPE pType, ArrayList<String> pEnumConstants, ArrayList<JavaDataMember> pDataMembers, ArrayList<JavaMethod> pMethods) {
        this.mComment = pComment;
        this.mEnumConstants = pEnumConstants;
        this.mDataMembers = pDataMembers;
        this.mMethods = pMethods;
        this.mName = pName;
        this.mType = pType;
    }

    public String getComment() {
        return this.mComment;
    }

    public ArrayList<JavaDataMember> getDataMembers() {
        return this.mDataMembers;
    }

    public ArrayList<String> getEnumConstants() {
        return this.mEnumConstants;
    }

    public ArrayList<JavaMethod> getMethods() {
        return this.mMethods;
    }

    public String getName() {
        return this.mName;
    }

    public JavaCodeWriterConstants.TYPE getType() {
        return this.mType;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        Iterator<String> i = JavaCodeWriterConstants.getLineIterator(this.mComment, 73, 1, true);
        while (i.hasNext()) {
            strBuf.append((Object)i.next());
        }
        strBuf.append("\t");
        switch (this.mType) {
            case PUBLIC: {
                strBuf.append("public");
                break;
            }
            case PRIVATE: {
                strBuf.append("private");
                break;
            }
            case PROTECTED: {
                strBuf.append("protected");
            }
        }
        strBuf.append(" ");
        strBuf.append("enum");
        strBuf.append(" ");
        strBuf.append(this.mName);
        strBuf.append(" ");
        strBuf.append("{");
        for (String c : this.mEnumConstants) {
            strBuf.append(NEWLINE + "\t" + "\t");
            strBuf.append(c);
            strBuf.append(",");
        }
        strBuf.replace(strBuf.length() - 1, strBuf.length(), ";");
        strBuf.append(NEWLINE);
        for (JavaDataMember dm : this.mDataMembers) {
            strBuf.append(NEWLINE);
            strBuf.append(dm.toString());
            strBuf.append(NEWLINE);
        }
        for (JavaMethod m : this.mMethods) {
            strBuf.append(NEWLINE);
            strBuf.append(m.toString());
            strBuf.append(NEWLINE);
        }
        strBuf.append(NEWLINE + "\t");
        strBuf.append("}");
        strBuf.append(NEWLINE);
        return strBuf.toString();
    }
}

