/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.java;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.jsr48.JavaArgument;
import java.util.ArrayList;
import java.util.Iterator;

public class JavaMethod {
    private final String mComment;
    private final JavaCodeWriterConstants.TYPE mType;
    private final String mReturnType;
    private final String mName;
    private final ArrayList<JavaArgument> mArguments;
    private final ArrayList<String> mThrows;
    private final String mBody;
    private final boolean mIsStatic;
    private boolean mIsEnum;

    public JavaMethod(String pComment, JavaCodeWriterConstants.TYPE pType, boolean pIsStatic, String pReturnType, String pName, ArrayList<JavaArgument> pArguments, ArrayList<String> pThrows, String pBody) {
        this.mComment = pComment;
        this.mType = pType;
        this.mReturnType = pReturnType;
        this.mName = pName;
        this.mArguments = pArguments;
        this.mThrows = pThrows;
        this.mBody = pBody;
        this.mIsStatic = pIsStatic;
    }

    public void setInEnum(boolean pIsEnum) {
        this.mIsEnum = pIsEnum;
    }

    public String getName() {
        return this.mName;
    }

    public Object getReturnType() {
        return this.mReturnType;
    }

    public String getComment() {
        return this.mComment;
    }

    public ArrayList<String> getThrows() {
        return this.mThrows;
    }

    public ArrayList<JavaArgument> getArguments() {
        return this.mArguments;
    }

    public JavaCodeWriterConstants.TYPE getType() {
        return this.mType;
    }

    public String getBody() {
        return this.mBody;
    }

    public String toString() {
        StringBuilder methodStructure = new StringBuilder();
        StringBuilder tempMethodStructure = new StringBuilder();
        int maxLen = 78;
        String tabs = "";
        int ntabs = 1;
        if (this.mIsEnum) {
            maxLen = 68;
            tabs = "\t";
            ++ntabs;
        }
        Iterator<String> commentIterator = JavaCodeWriterConstants.getLineIterator(this.mComment, maxLen, ntabs, true);
        while (commentIterator.hasNext()) {
            methodStructure.append(commentIterator.next());
        }
        switch (this.mType) {
            case PUBLIC: {
                tempMethodStructure.append("public");
                break;
            }
            case PRIVATE: {
                tempMethodStructure.append("private");
                break;
            }
            case PROTECTED: {
                tempMethodStructure.append("protected");
                break;
            }
            default: {
                tempMethodStructure.append("");
            }
        }
        tempMethodStructure.append(" ");
        if (this.mIsStatic) {
            tempMethodStructure.append("static");
            tempMethodStructure.append(" ");
        }
        if (this.mReturnType != null) {
            tempMethodStructure.append(this.mReturnType);
            tempMethodStructure.append(" ");
        }
        tempMethodStructure.append(this.mName);
        tempMethodStructure.append("(");
        if (this.mArguments != null) {
            tempMethodStructure.append(JavaCodeWriterConstants.getCommaSeparatedLine(this.mArguments));
        }
        tempMethodStructure.append(") ");
        if (this.mThrows != null) {
            tempMethodStructure.append("throws ");
            tempMethodStructure.append(JavaCodeWriterConstants.getCommaSeparatedLine(this.mThrows));
            tempMethodStructure.append(" ");
        }
        tempMethodStructure.append("{");
        Iterator<String> methodIterator = JavaCodeWriterConstants.getLineIterator(tempMethodStructure.toString(), maxLen, ntabs, false);
        while (methodIterator.hasNext()) {
            methodStructure.append(methodIterator.next());
        }
        if (this.mBody != null) {
            methodStructure.append("\t\t" + this.mBody);
        }
        methodStructure.append(tabs);
        if (this.mIsEnum) {
            methodStructure.append(System.getProperty("line.separator") + "\t" + "\t" + "}");
        } else {
            methodStructure.append(System.getProperty("line.separator") + "\t" + "}");
        }
        return methodStructure.toString();
    }

    public String getPrototype() {
        StringBuilder methodStructure = new StringBuilder();
        StringBuilder tempMethodStructure = new StringBuilder();
        int maxLen = 78;
        int nTab = 1;
        Iterator<String> commentIterator = JavaCodeWriterConstants.getLineIterator(this.mComment, maxLen, nTab, true);
        while (commentIterator.hasNext()) {
            methodStructure.append(commentIterator.next());
        }
        switch (this.mType) {
            case PUBLIC: {
                tempMethodStructure.append("public");
                break;
            }
            case PRIVATE: {
                tempMethodStructure.append("private");
                break;
            }
            case PROTECTED: {
                tempMethodStructure.append("protected");
                break;
            }
            default: {
                tempMethodStructure.append("");
            }
        }
        tempMethodStructure.append(" ");
        if (this.mReturnType != null) {
            tempMethodStructure.append(this.mReturnType);
        }
        tempMethodStructure.append(" ");
        tempMethodStructure.append(this.mName);
        tempMethodStructure.append("(");
        if (this.mArguments != null) {
            tempMethodStructure.append(JavaCodeWriterConstants.getCommaSeparatedLine(this.mArguments));
        }
        tempMethodStructure.append(")");
        if (this.mThrows != null) {
            tempMethodStructure.append("throws ");
            tempMethodStructure.append(JavaCodeWriterConstants.getCommaSeparatedLine(this.mThrows));
        }
        tempMethodStructure.append(";");
        Iterator<String> methodIterator = JavaCodeWriterConstants.getLineIterator(tempMethodStructure.toString(), maxLen, nTab, false);
        while (methodIterator.hasNext()) {
            methodStructure.append(methodIterator.next());
        }
        if (this.mReturnType == null || this.mReturnType == "") {
            methodStructure = methodStructure.delete(0, methodStructure.length());
        }
        return methodStructure.toString();
    }
}

