/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ImportManager {
    private final Set<String> mImportList = new HashSet<String>(50);

    public void addImport(int pDataType) {
        StringBuilder b = new StringBuilder();
        switch (pDataType) {
            case 17: {
                b.append("javax.cim.CIMClass");
                break;
            }
            case 12: {
                b.append("javax.cim.CIMDateTime");
                break;
            }
            case 15: {
                b.append("javax.cim.CIMInstance");
                break;
            }
            case 14: {
                b.append("javax.cim.CIMObjectPath");
                break;
            }
            case 0: {
                b.append("javax.cim.UnsignedInteger8");
                break;
            }
            case 2: {
                b.append("javax.cim.UnsignedInteger16");
                break;
            }
            case 4: {
                b.append("javax.cim.UnsignedInteger32");
                break;
            }
            case 6: {
                b.append("javax.cim.UnsignedInteger64");
            }
        }
        this.mImportList.add(b.toString());
    }

    public void addImport(String pImport) {
        if (pImport != null && !this.mImportList.contains(pImport)) {
            this.mImportList.add(pImport);
        }
    }

    public ArrayList<String> getImportList() {
        return new ArrayList<String>(this.mImportList);
    }

    public String toString() {
        StringBuilder importStr = new StringBuilder();
        if (null != this.mImportList) {
            ArrayList<String> tList = new ArrayList<String>(this.mImportList);
            Collections.sort(tList);
            for (String mprt : tList) {
                if (mprt.equals("")) continue;
                importStr.append("import ");
                importStr.append(mprt);
                importStr.append(";");
                importStr.append(System.lineSeparator());
            }
        }
        if (importStr.length() > 0) {
            return importStr.toString();
        }
        return "";
    }

    public String toString(String pTemplate) {
        StringBuilder importStr = new StringBuilder();
        if (null != this.mImportList) {
            ArrayList<String> importList = new ArrayList<String>(this.mImportList);
            Collections.sort(importList);
            for (String mprt : importList) {
                if (mprt.isEmpty() || !pTemplate.contains(mprt.substring(mprt.lastIndexOf(46) + 1))) continue;
                StringBuilder tImportStr = new StringBuilder("import ");
                tImportStr.append(mprt);
                tImportStr.append(";");
                if (pTemplate.contains(tImportStr)) continue;
                tImportStr.append(System.lineSeparator());
                importStr.append(tImportStr.toString());
            }
        }
        return importStr.toString();
    }
}

