/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.codegen.jsr48;

import com.ws.cim.codegen.java.JavaCodeWriterConstants;
import com.ws.cim.codegen.java.JavaDataConstant;
import com.ws.cim.codegen.java.JavaDataMember;
import com.ws.cim.codegen.java.JavaEnums;
import com.ws.cim.codegen.java.JavaMethod;
import com.ws.cim.codegen.java.JavaMethodBody;
import com.ws.cim.codegen.java.JavaMethodVariable;
import com.ws.cim.codegen.jsr48.AbstractCodeGenerator;
import com.ws.cim.codegen.jsr48.CodeGeneratorConstants;
import com.ws.cim.codegen.jsr48.JavaArgument;
import com.ws.utilities.Resources;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMMethod;

public class PropertyCodeGenerator
extends AbstractCodeGenerator {
    private final String RESOURCE_BUNDLE = "com.ws.cim.codegen.jsr48.CodeGenerator";
    private final Resources mResourceBundleHandle;
    private final CIMClass mClass;
    private final ArrayList<JavaDataMember> mClassMember;
    private final ArrayList<JavaMethod> mMethodList;
    private final ArrayList<String> mImportList;
    private final ArrayList<JavaDataConstant> mDataConstant;
    private final ArrayList<JavaEnums> mEnums;

    public PropertyCodeGenerator(CIMClass pClass) {
        this.mClass = pClass;
        this.mClassMember = new ArrayList();
        this.mDataConstant = new ArrayList();
        this.mMethodList = new ArrayList();
        this.mImportList = new ArrayList();
        this.mEnums = new ArrayList();
        this.mResourceBundleHandle = new Resources("com.ws.cim.codegen.jsr48.CodeGenerator");
        this.addConstants();
        this.setImports();
        this.addClassConstructor();
        this.setDataMembers();
        this.setConstants();
        this.setMethods();
    }

    @Override
    public void setImports() {
        if (this.mImportList != null) {
            this.mImports.addAll(this.mImportList);
        }
    }

    @Override
    public void setMethods() {
        if (this.mMethodList != null) {
            this.mMethods.addAll(this.mMethodList);
        }
    }

    @Override
    public void setDataMembers() {
        if (this.mClassMember != null) {
            this.mDataMembers.addAll(this.mClassMember);
        }
    }

    @Override
    public void setConstants() {
        this.mDataConstants.addAll(this.mDataConstant);
    }

    public ArrayList<JavaMethod> getMethodList() {
        return this.mMethodList;
    }

    public ArrayList<String> getImportList() {
        return this.mImportList;
    }

    public ArrayList<JavaEnums> getEnums() {
        return this.mEnums;
    }

    private void addClassConstructor() {
        if (mClassType.equals("Client")) {
            this.setImports("javax.wbem.client.WBEMClient");
            ArrayList<JavaArgument> argList = new ArrayList<JavaArgument>();
            argList.add(new JavaArgument(false, "pWBEMClient", "WBEMClient"));
            argList.add(new JavaArgument(false, "pCIMInstance", "CIMInstance"));
            ArrayList<String> lData = new ArrayList<String>();
            lData.add("super(pWBEMClient, pCIMInstance);");
            lData.add("\n\t\tif ((pWBEMClient.toString()).contains(\"WSManClient\")){");
            lData.add("\n\t\t\ttypeConversion(pCIMInstance);");
            lData.add("\n\t\t} else {");
            lData.add("\n\t\t\tsetCIMInstance(pCIMInstance);");
            lData.add("\n\t\t}");
            String comment = "Class constructor initialize data members. \n \n@param pWBEMClient \tHandle to the WBEMClient. \n@param pCIMInstance \tHandle to the CIMInstance being managed.";
            JavaMethodBody body = new JavaMethodBody(null, lData);
            String className = this.mClass.getName();
            JavaMethod m = new JavaMethod(comment, JavaCodeWriterConstants.TYPE.PUBLIC, false, null, className, argList, null, body.toString());
            this.mMethodList.add(0, m);
        }
    }

    public String getArrayValues(Object[] array, int type) {
        Object[] arr = array;
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < arr.length; ++i) {
            if (type >= 0 && type < 8 || type > 8 && type < 13 || type == 14 || type == 17) {
                if (type == 12) {
                    sb.append("new " + this.identifyDateTime(arr[i].toString()) + "(" + arr[i] + ")");
                } else {
                    sb.append("new " + CodeGeneratorConstants.DATATYPE[type] + "(" + arr[i] + ")");
                }
            } else if (type == 8 || type == 15) {
                sb.append("\"");
                sb.append(arr[i]);
                sb.append("\"");
            } else if (type == 13) {
                sb.append("'");
                sb.append(arr[i]);
                sb.append("'");
            } else if (type == -1 || type == 16) break;
            if (i >= arr.length - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString().trim();
    }

    public String identifyDateTime(String pDateTime) {
        String dateTime = "";
        if (pDateTime.contains(":")) {
            dateTime = "CIMDateTimeInterval";
            this.setImports("javax.cim.CIMDateTimeInterval");
        } else if (pDateTime.contains("-") || pDateTime.contains("+")) {
            dateTime = "CIMDateTimeAbsolute";
            this.setImports("javax.cim.CIMDateTimeAbsolute");
        }
        return dateTime;
    }

    public String identifyDataType(CIMClassProperty<?> pProperty) {
        String dataType = "";
        int index = pProperty.getDataType().getType();
        dataType = index == 12 && pProperty.getValue() != null ? this.identifyDateTime(pProperty.getValue().toString()) : CodeGeneratorConstants.DATATYPE[index];
        return dataType;
    }

    public void addSetter(String pName, CIMDataType pType, boolean pIsDeprecated, boolean pHasValueValueMap, boolean pIsStatic) {
        ArrayList<String> throwsList = new ArrayList<String>();
        ArrayList<String> body = new ArrayList<String>();
        throwsList.add("IllegalArgumentException");
        ArrayList<JavaArgument> argumentList = new ArrayList<JavaArgument>();
        String dType = CodeGeneratorConstants.DATATYPE[pType.getType()];
        if (pType.isArray()) {
            dType = dType + "[]";
        }
        String paramName = "p" + pName;
        argumentList.add(new JavaArgument(false, paramName, dType));
        String quote = pType.getType() == 13 ? "''" : "\"\"";
        String otherCondition = "";
        if (pType.getType() == 8) {
            otherCondition = pType.isArray() ? " || " + paramName + ".length == 0" : " || " + paramName + " == " + quote + "";
        } else if (pType.getType() == 13) {
            otherCondition = " || " + paramName + " == " + quote + "";
        }
        body.add("if (" + paramName + " == null" + otherCondition + "){");
        body.add("\n\t\t\tthrow new IllegalArgumentException();");
        body.add("\n\t\t}");
        String dataType = "";
        dataType = pType.getType() == 14 ? MessageFormat.format(this.mResourceBundleHandle.loadString(dType), pType.getRefClassName()) : this.mResourceBundleHandle.loadString(dType);
        body.add("\n\t\tsetPropertyValue(CPN_" + pName.toUpperCase() + ", " + dataType + ", " + paramName + ");");
        String comment = "Sets the " + pName + " property." + " \n \n@param p" + pName + " \n\t\t\tSets the value of the " + pName + " property." + " \n \n@throws IllegalArgumentException - If the argument passed is illegal or inappropriate.";
        if (pIsDeprecated) {
            comment = comment + " \n \n@deprecated";
        }
        this.setImports("javax.cim.CIMDataType");
        this.mMethodList.add(new JavaMethod(comment, JavaCodeWriterConstants.TYPE.PUBLIC, false, "void", "set" + pName, argumentList, throwsList, new JavaMethodBody(null, body).toString()));
    }

    public void addGetter(String pPropName, CIMDataType pDataType, boolean pIsDeprecated, boolean pIsStatic) {
        ArrayList<String> body = new ArrayList<String>();
        String dtype = CodeGeneratorConstants.DATATYPE[pDataType.getType()];
        if (pDataType.isArray()) {
            dtype = dtype + "[]";
        }
        body.add("return (" + dtype + ")mCimInstance.getPropertyValue(CPN_" + pPropName.toUpperCase() + ");");
        String comment = "Gets the " + pPropName + " property." + " \n \n@return" + " \tThe value of the " + pPropName + " property.";
        if (pIsDeprecated) {
            comment = comment + " \n \n@deprecated";
        }
        this.mMethodList.add(new JavaMethod(comment, JavaCodeWriterConstants.TYPE.PUBLIC, false, dtype, "get" + pPropName, null, null, new JavaMethodBody(null, body).toString()));
    }

    private String replaceIdentifiers(String pString) {
        StringBuffer oRet = new StringBuffer(pString);
        if (oRet != null) {
            for (int i = 0; i < pString.length(); ++i) {
                if (oRet.charAt(i) >= 'A' && oRet.charAt(i) <= 'Z' || oRet.charAt(i) >= 'a' && oRet.charAt(i) <= 'z' || oRet.charAt(i) >= '0' && oRet.charAt(i) <= '9') continue;
                oRet.setCharAt(i, '_');
            }
        }
        return oRet.toString();
    }

    private ArrayList<String> addEnumConstants(CIMClassProperty<?> pProperty, boolean pIsValues) {
        ArrayList<String> enumConstants = new ArrayList<String>();
        String name = pProperty.getName();
        String str = pIsValues ? "VALUE_" : "VALUEMAP_";
        String dataType = pIsValues ? "String" : CodeGeneratorConstants.DATATYPE[pProperty.getDataType().getType()];
        String[] valueMap = null;
        String[] values = null;
        if (pProperty.hasQualifier("ValueMap")) {
            valueMap = (String[])pProperty.getQualifier("ValueMap").getValue();
            if (!pProperty.hasQualifier("Values")) {
                values = (String[])pProperty.getQualifier("ValueMap").getValue();
            }
        }
        if (pProperty.hasQualifier("Values")) {
            values = (String[])pProperty.getQualifier("Values").getValue();
            if (!pProperty.hasQualifier("ValueMap")) {
                valueMap = (String[])pProperty.getQualifier("Values").getValue();
            }
        }
        ArrayList<String> varNameMonitor = new ArrayList<String>();
        if (null != valueMap && null != values) {
            for (int i = 0; i < valueMap.length; ++i) {
                String propertyStr = this.replaceIdentifiers(values[i]);
                propertyStr = propertyStr.toUpperCase();
                String init = pIsValues ? values[i] : valueMap[i];
                if (varNameMonitor.contains(propertyStr)) {
                    String strvMap = valueMap[i];
                    strvMap = strvMap.replaceAll("\\.", "_");
                    propertyStr = propertyStr + "_" + strvMap;
                }
                varNameMonitor.add(propertyStr);
                if (dataType.equals("String")) {
                    enumConstants.add(name.toUpperCase() + str + propertyStr + "(\"" + init + "\")");
                    continue;
                }
                enumConstants.add(name.toUpperCase() + str + propertyStr + "(new " + dataType + "(\"" + init + "\"))");
            }
        }
        varNameMonitor = null;
        return enumConstants;
    }

    private JavaMethod addEnumConstructor(String pName, boolean pIsValues, String pDataType) {
        JavaMethod method = null;
        ArrayList<String> body = new ArrayList<String>();
        ArrayList<JavaArgument> argumentList = new ArrayList<JavaArgument>();
        String str = pIsValues ? "Values" : "ValueMap";
        String argument = pIsValues ? "value" : "valueMap";
        String bodyContent = pIsValues ? "\tthis.value = value;" : "\tthis.valueMap = valueMap;";
        argumentList.add(new JavaArgument(false, argument, pDataType));
        body.add(bodyContent);
        JavaMethodBody methodBody = new JavaMethodBody(null, body);
        methodBody.setInEnum(true);
        method = new JavaMethod("Constructor for the enum.", JavaCodeWriterConstants.TYPE.PRIVATE, false, null, pName + str, argumentList, null, methodBody.toString());
        method.setInEnum(true);
        return method;
    }

    private JavaMethod addEnumMethod(String pComment, String pName, ArrayList<JavaArgument> pArguments, ArrayList<JavaMethodVariable> pMethodVariables, ArrayList<String> pBody, String pReturnType, boolean pIsStatic) {
        JavaMethod method = null;
        ArrayList<JavaArgument> argumentList = pArguments;
        ArrayList<String> body = new ArrayList<String>();
        body.addAll(pBody);
        JavaMethodBody methodBody = new JavaMethodBody(pMethodVariables, body);
        methodBody.setInEnum(true);
        method = new JavaMethod(pComment, JavaCodeWriterConstants.TYPE.PUBLIC, pIsStatic, pReturnType, pName, argumentList, null, methodBody.toString());
        method.setInEnum(true);
        return method;
    }

    private JavaDataMember addEnumDataMember(String pMemberName, String pDataType) {
        JavaDataMember member = null;
        member = new JavaDataMember("Holds the data of the enum instance.", JavaCodeWriterConstants.TYPE.PRIVATE, false, false, pDataType, pMemberName, null);
        member.setInEnum(true);
        return member;
    }

    public void addValuesEnum(CIMClassProperty<?> pProperty) {
        ArrayList<JavaDataMember> dataMembers = new ArrayList<JavaDataMember>();
        ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>();
        ArrayList<String> body = new ArrayList<String>();
        String name = pProperty.getName();
        JavaDataMember member = this.addEnumDataMember("value", "String");
        JavaMethod constructor = this.addEnumConstructor(name, true, "String");
        body.add("\treturn this.value;");
        JavaMethod toString = this.addEnumMethod("Returns the data of the enum in String", "toString", null, null, body, "String", false);
        dataMembers.add(member);
        methods.add(constructor);
        methods.add(toString);
        this.mEnums.add(new JavaEnums(pProperty.getName() + " Values enum", pProperty.getName() + "Values", JavaCodeWriterConstants.TYPE.PUBLIC, this.addEnumConstants(pProperty, true), dataMembers, methods));
    }

    public void addValueMapEnum(CIMClassProperty<?> pProperty) {
        ArrayList<JavaDataMember> dataMembers = new ArrayList<JavaDataMember>();
        ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>();
        ArrayList<JavaMethodVariable> methodVariable = new ArrayList<JavaMethodVariable>();
        ArrayList<JavaArgument> argument = new ArrayList<JavaArgument>();
        ArrayList<String> body = new ArrayList<String>();
        String dataType = CodeGeneratorConstants.DATATYPE[pProperty.getDataType().getType()];
        String name = pProperty.getName();
        JavaDataMember member = this.addEnumDataMember("valueMap", dataType);
        JavaMethod constructor = this.addEnumConstructor(name, false, dataType);
        body.add("\treturn this.valueMap;");
        JavaMethod getValueMap = this.addEnumMethod("Returns the data of the enum in String", "getValueMap", null, null, body, dataType, false);
        argument.add(new JavaArgument(false, "pValue", dataType));
        JavaMethodVariable oRet = new JavaMethodVariable(false, dataType, "oRet", "null");
        methodVariable.add(oRet);
        body.clear();
        body.add("\t\t\tfor(" + name + "ValueMap vMap : " + name + "ValueMap.values()){");
        body.add("\n\t\t\t\tif(vMap.getValueMap().equals(pValue)){");
        body.add("\n\t\t\t\t\toRet = vMap.getValueMap();");
        body.add("\n\t\t\t\t\tbreak;");
        body.add("\n\t\t\t\t}");
        body.add("\n\t\t\t}");
        body.add("\n\t\t\treturn " + oRet.getName() + ";");
        String comment = "Checks if the given value is equivalent to one of the value of the ValueMap enum. \n \n@param pValue \t\t\tThe value to be checked.";
        JavaMethod getOverridenGetValueMap = this.addEnumMethod(comment, "getValueMap", argument, methodVariable, body, dataType, true);
        dataMembers.add(member);
        methods.add(constructor);
        methods.add(getValueMap);
        methods.add(getOverridenGetValueMap);
        this.mEnums.add(new JavaEnums(pProperty.getName() + " ValueMap enum", pProperty.getName() + "ValueMap", JavaCodeWriterConstants.TYPE.PUBLIC, this.addEnumConstants(pProperty, false), dataMembers, methods));
    }

    public void addSerializableConstant() {
        String comment = "Required data constant for java";
        this.mDataConstant.add(new JavaDataConstant(comment, JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "long", "serialVersionUID", "1L"));
    }

    private void addVersionConstant() {
        if (mClassType.equals("Client") && this.mClass.hasQualifier("Version")) {
            String comment = "String representation of the version of this CIM class.";
            this.mDataConstant.add(new JavaDataConstant(comment, JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "String", "mClassVersion", "\"" + this.mClass.getQualifier("Version").getValue() + "\""));
            comment = "Gets the version for this class. \n \n@return \tThe version information for this class";
            ArrayList<String> body = new ArrayList<String>();
            body.add("return mClassVersion;");
            this.mMethodList.add(new JavaMethod(comment, JavaCodeWriterConstants.TYPE.PUBLIC, false, "String", "getClassVersion", null, null, new JavaMethodBody(null, body).toString()));
        }
    }

    public String getPropertyDescription(CIMClassProperty<?> pProp) {
        StringBuffer description = new StringBuffer();
        if (pProp.hasQualifier("Description")) {
            description.append(pProp.getQualifierValue("Description"));
            if (pProp.hasQualifier("Deprecated")) {
                description.append(" \n \n@deprecated\t");
                String[] deprecatedValues = (String[])pProp.getQualifier("Deprecated").getValue();
                for (int i = 0; i < deprecatedValues.length; ++i) {
                    description.append(deprecatedValues[i]);
                    if (i >= deprecatedValues.length - 1) continue;
                    description.append(",");
                }
            }
        }
        return description.toString();
    }

    private void addClassKeyConstant() {
        if (mClassType.equals("Client")) {
            String comment = "String array of the key properties of this CIM class.";
            if (this.mClass.getKeys().length > 0) {
                CIMClassProperty[] prop = this.mClass.getKeys();
                Object[] valueArr = new String[prop.length];
                int ctr = 0;
                for (CIMClassProperty p : prop) {
                    valueArr[ctr] = p.getName();
                    ++ctr;
                }
                this.mDataConstant.add(new JavaDataConstant(comment, JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "String[]", "mKeys", this.getArrayValues(valueArr, 8)));
                comment = "Gets the key property names for this class. \n \n@return \tThe names of the key properties for this class";
                ArrayList<String> body = new ArrayList<String>();
                body.add("return mKeys;");
                this.mMethodList.add(new JavaMethod(comment, JavaCodeWriterConstants.TYPE.PUBLIC, false, "String[]", "getKeyPropertyNames", null, null, new JavaMethodBody(null, body).toString()));
            }
        }
    }

    public void addConstants() {
        this.addSerializableConstant();
        this.addVersionConstant();
        this.addClassKeyConstant();
        this.addPropertyNameConstants();
    }

    public void addPropertyNameConstants() {
        CIMClassProperty[] properties = this.mClass.getProperties();
        if (properties != null && properties.length > 0) {
            for (CIMClassProperty property : properties) {
                CIMMethod getMethod;
                int index;
                if (property.isPropagated()) continue;
                String propName = property.getName();
                String varName = "CPN_" + propName.toUpperCase();
                String comment = "Holds the string value for the " + propName + " property name";
                boolean hasValueValueMap = false;
                boolean isDeprecated = false;
                if (property.hasQualifier("Deprecated")) {
                    isDeprecated = true;
                }
                if (this.getImport(index = property.getDataType().getType()) != "") {
                    this.mImportList.add(this.getImport(index));
                }
                this.mDataConstant.add(new JavaDataConstant(comment, JavaCodeWriterConstants.TYPE.PRIVATE, true, true, "String", varName, "\"" + propName + "\""));
                if (!mClassType.equals("Client")) continue;
                CIMMethod setMethod = this.mClass.getMethod("set" + propName);
                if (setMethod == null) {
                    this.addSetter(propName, property.getDataType(), isDeprecated, hasValueValueMap, false);
                }
                if ((getMethod = this.mClass.getMethod("get" + propName)) != null) continue;
                this.addGetter(propName, property.getDataType(), isDeprecated, false);
            }
        }
    }
}

