/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.html;

import com.ws.cim.CIMMappingBase;
import com.ws.cim.xmlcim.CIMXMLWriter;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class HTMLMapping
extends CIMMappingBase {
    private static final String TITLE = "Title";
    private static final String FORMAT_WS = "ws";
    private static final String FORMAT_ILLEGAL = "ILLEGAL";
    private static final String indexXSLName = "/com/ws/cim/html/index.xsl";
    private static final String multiXSLName = "/com/ws/cim/html/multimof.xsl";
    private static final String mofHTMLName = "mof.html";
    private CIMXMLWriter xw;
    private String mFormat = "ILLEGAL";
    private String mOutdir;
    private String mTitle;
    private boolean mQuiet;
    private Properties mProperties;

    @Override
    public void initialize(String outdir) throws Exception {
        this.mQuiet = false;
        this.mTitle = "WS";
        this.mOutdir = outdir;
        this.mProperties = new Properties();
        this.mProperties.load(this.getClass().getClassLoader().getResourceAsStream("com/ws/cim/html/HTMLMapping.properties"));
        try {
            File dir = new File(this.mOutdir);
            if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
                throw new Exception("could not create directory: " + this.mOutdir);
            }
            this.xw = new CIMXMLWriter(this.mOutdir);
            this.xw.recordAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void close() throws Exception {
        this.xw.closeAll();
        String xmlFile = this.mOutdir + File.separator + "class_index.xml";
        String htmlFile = this.mOutdir + File.separator + mofHTMLName;
        if (!this.mQuiet) {
            System.out.println("Generating HTML...");
        }
        this.transform(xmlFile, indexXSLName, htmlFile);
        xmlFile = this.mOutdir + File.separator + "all_classes.xml";
        htmlFile = this.mOutdir + File.separator + mofHTMLName;
        this.transform(xmlFile, multiXSLName, htmlFile);
        String[] remove = new String[]{"Version_Number", "store", "Logfile.", "Snapshot.", ".xml"};
        this.removeTempFiles(this.mQuiet, this.mOutdir, remove);
    }

    private void transform(String xmlFile, String xslFile, String htmlFile) throws Exception {
        URL url = this.getClass().getResource(xslFile);
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource xmlStream = new StreamSource(new File(xmlFile));
            StreamSource xsltStream = new StreamSource(url.openStream());
            StreamResult htmlResult = new StreamResult(new File(htmlFile));
            Transformer transf = tFactory.newTransformer(xsltStream);
            transf.setParameter("outputdir", this.mOutdir);
            transf.setParameter("indexfile", this.mOutdir + File.separator + "class_index.xml");
            transf.setParameter("pCompany", this.mTitle);
            transf.transform(xmlStream, htmlResult);
        }
        catch (Exception e) {
            System.out.println("Received an exception transforming " + xmlFile + " to " + htmlFile);
            throw e;
        }
    }

    @Override
    public void produceMappedElement(CIMElement element) throws Exception {
        if (this.mFormat.equals(FORMAT_ILLEGAL)) {
            throw new IllegalArgumentException(this.mProperties.getProperty("ERROR_INVALID_FORMAT"));
        }
        this.xw.writeElement((Object)element);
    }

    @Override
    public void produceMappedInstance(CIMInstance instance) throws Exception {
        if (this.mFormat.equals(FORMAT_ILLEGAL)) {
            throw new IllegalArgumentException(this.mProperties.getProperty("ERROR_INVALID_FORMAT"));
        }
        this.xw.writeElement((Object)instance);
    }

    @Override
    public void setFormat(String format) {
        if (!format.equalsIgnoreCase(FORMAT_WS)) {
            throw new IllegalArgumentException(this.mProperties.getProperty("ERROR_INVALID_FORMAT"));
        }
        this.mFormat = FORMAT_WS;
    }

    @Override
    public void setProperty(String pName, String pValue) {
        if (TITLE.equals(pName)) {
            this.mTitle = pValue;
            return;
        }
        if ("q".equals(pName)) {
            this.mQuiet = true;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String[] getCustomPropertyNames(String format) {
        return new String[]{TITLE, "q"};
    }

    @Override
    public String getCustomPropertyDescription(String cpName) {
        return this.mProperties.getProperty(cpName);
    }
}

