/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.ws;

import com.ws.cim.CIMMapping;
import com.ws.cim.ws.WSCIMWSDLMapping;
import com.ws.cim.ws.WSCIMXSDMapping;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.cim.CIMClass;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;

public class WSCIMMapping
implements CIMMapping {
    protected static final String TARGET_NAMESPACE = "targetNamespace";
    protected static final String THIS_WSDL = "thisWSDL";
    private static final String FORMAT_WSDL = "WSDL";
    private static final String FORMAT_XSD = "XSD";
    private String mFormat;
    private String mOutdir;
    private Properties mProps;

    @Override
    public void close() {
        List<File> files = this.getFileListing(new File(this.mOutdir));
        for (File fName : files) {
            fName.deleteOnExit();
        }
    }

    public CIMElement getCIMElement(Object mapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCustomPropertyDescription(String cpName) {
        if (TARGET_NAMESPACE.equals(cpName)) {
            return "Set the targetNamespace in the WSDL file.";
        }
        if ("gb".equals(cpName)) {
            return "This option will generate the wsdl:bindings and wsdl:service sections";
        }
        if ("q".equals(cpName)) {
            return "This option will supress all output (not including exceptions)";
        }
        if ("iq".equalsIgnoreCase(cpName)) {
            return "If this option is set the qualifiers will be included and an anotated XSD will be produced.";
        }
        if ("*".equalsIgnoreCase(cpName)) {
            return "This option is used to specify the XSD Namespace for extension schema, for example WS=http://schemas.ws-inc.com/";
        }
        return null;
    }

    @Override
    public String[] getCustomPropertyNames(String format) {
        if (FORMAT_WSDL.equalsIgnoreCase(format)) {
            return new String[]{"*", "gb", "q", TARGET_NAMESPACE};
        }
        if (FORMAT_XSD.equalsIgnoreCase(format)) {
            return new String[]{"*", "iq", "q"};
        }
        return null;
    }

    private List<File> getFileListing(File aStartingDir) {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isDirectory()) {
                List<File> deeperList = this.getFileListing(file);
                result.addAll(deeperList);
                continue;
            }
            if (file.getName().endsWith(".xsd") || file.getName().endsWith(".wsdl")) continue;
            result.add(file);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void initialize(String outdir) {
        this.mOutdir = outdir;
        this.mProps = new Properties();
    }

    @Override
    public void produceMappedElement(CIMElement element) throws Exception {
        if (element instanceof CIMClass) {
            if (FORMAT_XSD.equals(this.mFormat)) {
                new WSCIMXSDMapping(element, this.mOutdir, this.mProps);
            } else if (FORMAT_WSDL.equals(this.mFormat)) {
                new WSCIMWSDLMapping(element, this.mOutdir, this.mProps);
            }
        }
    }

    @Override
    public void produceMappedInstance(CIMInstance instance) throws Exception {
    }

    @Override
    public void setFormat(String format) {
        if (format.equalsIgnoreCase(FORMAT_WSDL)) {
            this.mFormat = FORMAT_WSDL;
            return;
        }
        if (format.equalsIgnoreCase(FORMAT_XSD)) {
            this.mFormat = FORMAT_XSD;
            return;
        }
        throw new IllegalArgumentException("The format \"" + format + "\" is not valid.");
    }

    @Override
    public void setProperty(String name, String value) {
        this.mProps.put(name, value);
    }
}

