/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.ws;

import com.ws.cim.ws.WSCIMDataType;
import com.ws.cim.ws.WSCIMNamespaceConstants;
import com.ws.wbem.apps.common.WSProductInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMElement;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSCIMXSDMapping {
    private static final String ANNOTATION = "annotation";
    private static final String APPINFO = "appinfo";
    private static final String CIM_ANY_SIMPLE_TYPE = "cimAnySimpleType";
    private static final String DOTDOT = "..";
    private static final String _TYPE = "_Type";
    private static final String BASE = "base";
    private static final String CIM_BASE64BINARY = "cimBase64Binary";
    private static final String CIM_HEX_BINARY = "cimHexBinary";
    private static final String CLASS = "Class";
    private static final String CLASSORIGIN = "Classorigin";
    private static final String COLON = ":";
    private static final String COMPLEXTYPE = "complexType";
    private static final String DEFAULTVALUE = "Defaultvalue";
    private static final String ELEMENT = "element";
    private static final String ENUMERATION = "enumeration";
    private static final String INPUT = "_INPUT";
    private static final String LAX = "lax";
    private static final String MAXINCLUSIVE = "maxInclusive";
    private static final String MAXLENGTH = "maxLength";
    private static final String MAXOCCURS = "maxOccurs";
    private static final String MININCLUSIVE = "minInclusive";
    private static final String MINLENGTH = "minLength";
    private static final String MINOCCURS = "minOccurs";
    private static final String NAME = "name";
    private static final String NAMESPACE = "namespace";
    private static final String NILLABLE = "nillable";
    private static final String OUTPUT = "_OUTPUT";
    private static final String PROCESSCONTENTS = "processContents";
    private static final String QUALIFIER = "Qualifier";
    private static final String QUALIFIER_EMBEDDEDINSTANCE = "EmbeddedInstance";
    private static final String QUALIFIER_EMBEDDEDOBJECT = "EmbeddedObject";
    private static final String QUALIFIER_IN = "IN";
    private static final String QUALIFIER_MAXLEN = "MaxLen";
    private static final String QUALIFIER_MAXVALUE = "MaxValue";
    private static final String QUALIFIER_MINLEN = "MinLen";
    private static final String QUALIFIER_MINVALUE = "MinValue";
    private static final String QUALIFIER_OCTETSTRING = "OctetString";
    private static final String QUALIFIER_OUT = "OUT";
    private static final String QUALIFIER_REQUIRED = "Required";
    private static final String QUALIFIER_VALUEMAP = "ValueMap";
    private static final String RESTRICTION = "restriction";
    private static final String RETURNVALUE = "ReturnValue";
    private static final String SEQUENCE = "sequence";
    private static final String SIMPLECONTENT = "simpleContent";
    private static final String SIMPLETYPE = "simpleType";
    private static final String SOURCE = "source";
    private static final String SUPERCLASS = "superclass";
    private static final String TYPE = "type";
    private static final String UNBOUNDED = "unbounded";
    private static final String UNION = "union";
    private static final String VALUE = "value";
    private static final String VALUEMAP = "valuemap";
    private final String mOutdir;
    private final Properties mProps;

    public WSCIMXSDMapping() {
        this.mOutdir = null;
        this.mProps = new Properties();
    }

    public WSCIMXSDMapping(CIMElement element, String outdir, Properties props) throws Exception {
        this.mProps = props;
        this.mOutdir = outdir;
        if (element instanceof CIMClass) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder db = docFactory.newDocumentBuilder();
            Document xsd = db.newDocument();
            this.createXSD((CIMClass)element, xsd, null);
            this.writeFile(xsd, element.getName());
        }
    }

    void addQualifier(Document xsd, Element appinfo, CIMQualifier<?> q, Object value) {
        Element qualifierE = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("cim"), "cim:Qualifier");
        qualifierE.setAttribute(NAME, q.getName());
        qualifierE.setAttribute(TYPE, WSCIMDataType.getType(q.getDataType().getType()));
        if (null == value && q.getDataType() == CIMDataType.BOOLEAN_T) {
            qualifierE.setTextContent("true");
        } else if (null != value) {
            qualifierE.setTextContent(value.toString());
        }
        appinfo.appendChild(qualifierE);
    }

    private void addQualifiers(Element e, CIMQualifier<?>[] quals, Document xsd, ETYPE eType, String clazzName, Object superclass, CIMDataType propType) {
        Element annotation = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:annotation");
        Element appinfo = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:appinfo");
        appinfo.setAttribute(SOURCE, WSCIMNamespaceConstants.getNamespace("cim"));
        if (eType == ETYPE.CLASS) {
            Element classE = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("cim"), "cim:Class");
            classE.setAttribute(NAME, clazzName);
            if (null != superclass) {
                classE.setAttribute(SUPERCLASS, superclass.toString());
            }
            appinfo.appendChild(classE);
        }
        boolean special = false;
        CIMQualifier<?> qValues = null;
        CIMQualifier<?> qValueMap = null;
        for (CIMQualifier<?> q : quals) {
            if (QUALIFIER_VALUEMAP.equalsIgnoreCase(q.getName())) {
                qValueMap = q;
                special = true;
                continue;
            }
            if ("Values".equalsIgnoreCase(q.getName())) {
                qValues = q;
                special = true;
                continue;
            }
            if (q.getDataType().isArray()) {
                if (null == q.getValue()) continue;
                for (Object o : (Object[])q.getValue()) {
                    if (null == o) continue;
                    this.addQualifier(xsd, appinfo, q, o);
                }
                continue;
            }
            this.addQualifier(xsd, appinfo, q, q.getValue());
        }
        if (special && (null != qValues || null != qValueMap)) {
            Object[] x = null;
            if (null != qValueMap) {
                x = (Object[])qValueMap.getValue();
            }
            int index = 0;
            if (null != qValues) {
                for (Object o : (Object[])qValues.getValue()) {
                    Element qualifierE = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("cim"), "cim:Qualifier");
                    qualifierE.setAttribute(NAME, "Values");
                    qualifierE.setAttribute(TYPE, WSCIMDataType.getType(8));
                    if (null != x) {
                        qualifierE.setAttribute(VALUEMAP, x[index].toString());
                    }
                    qualifierE.setTextContent(o.toString());
                    appinfo.appendChild(qualifierE);
                    ++index;
                }
            } else if (null != x) {
                for (Object o : x) {
                    Element qualifierE = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("cim"), "cim:Qualifier");
                    qualifierE.setAttribute(NAME, "Values");
                    qualifierE.setAttribute(TYPE, WSCIMDataType.getType(8));
                    if (null != o) {
                        qualifierE.setAttribute(VALUEMAP, o.toString());
                    }
                    qualifierE.setAttribute("xsi:nil", "true");
                    appinfo.appendChild(qualifierE);
                }
            }
        }
        if (ETYPE.PROPERTY == eType) {
            Element classE = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("cim"), "cim:Classorigin");
            classE.setAttribute(NAME, clazzName);
            appinfo.appendChild(classE);
            if (null != superclass) {
                Element defaultV = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("cim"), "cim:Defaultvalue");
                defaultV.setAttribute(TYPE, WSCIMDataType.getType(propType.getType()));
                defaultV.setTextContent(superclass.toString());
                appinfo.appendChild(defaultV);
            }
        }
        annotation.appendChild(appinfo);
        e.appendChild(annotation);
    }

    private void addRestricitions(CIMQualifiedElementInterface property, int elementType, Document out, Element root) {
        UnsignedInteger32 minLen = (UnsignedInteger32)property.getQualifierValue(QUALIFIER_MINLEN);
        UnsignedInteger32 maxLen = (UnsignedInteger32)property.getQualifierValue(QUALIFIER_MAXLEN);
        Long minValue = (Long)property.getQualifierValue(QUALIFIER_MINVALUE);
        Long maxValue = (Long)property.getQualifierValue(QUALIFIER_MAXVALUE);
        String[] valuemap = (String[])property.getQualifierValue(QUALIFIER_VALUEMAP);
        if (maxLen == null && minLen == null && valuemap == null && minValue == null && maxValue == null) {
            return;
        }
        root.removeAttribute(TYPE);
        Element restrictionComplexType = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:complexType");
        root.appendChild(restrictionComplexType);
        Element restrictionSimpleContent = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:simpleContent");
        restrictionComplexType.appendChild(restrictionSimpleContent);
        boolean union = false;
        boolean therest = false;
        if (valuemap != null) {
            for (String valueMap : valuemap) {
                if (!valueMap.contains(DOTDOT)) continue;
                union = true;
                if (!valueMap.equals(DOTDOT)) continue;
                therest = true;
            }
        }
        Element restriction = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:restriction");
        if (property.hasQualifierValue(QUALIFIER_OCTETSTRING, (Object)true)) {
            if (elementType == 0) {
                restriction.setAttribute(BASE, "cim:cimBase64Binary");
            } else if (elementType == 8) {
                restriction.setAttribute(BASE, "cim:cimHexBinary");
            }
        } else if (union) {
            restriction.setAttribute(BASE, "cim:cimAnySimpleType");
        } else {
            restriction.setAttribute(BASE, WSCIMDataType.getType(elementType));
        }
        restrictionSimpleContent.appendChild(restriction);
        if (maxLen != null) {
            Element maxLength = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:maxLength");
            maxLength.setAttribute(VALUE, maxLen.toString());
            restriction.appendChild(maxLength);
        }
        if (maxValue != null) {
            Element maxValueE = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:maxInclusive");
            maxValueE.setAttribute(VALUE, maxValue.toString());
            restriction.appendChild(maxValueE);
        }
        if (minLen != null) {
            Element minLength = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:minLength");
            minLength.setAttribute(VALUE, minLen.toString());
            restriction.appendChild(minLength);
        }
        if (minValue != null) {
            Element minValueE = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:minInclusive");
            minValueE.setAttribute(VALUE, minValue.toString());
            restriction.appendChild(minValueE);
        }
        if (valuemap == null) {
            Element anyAttr = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:anyAttribute");
            anyAttr.setAttribute(NAMESPACE, "##any");
            anyAttr.setAttribute(PROCESSCONTENTS, LAX);
            restriction.appendChild(anyAttr);
            return;
        }
        if (union) {
            Element SimpleType = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:simpleType");
            restriction.appendChild(SimpleType);
            Element rest = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:union");
            if (therest) {
                HashMap<BigInteger, BigInteger> rangeB = new HashMap<BigInteger, BigInteger>();
                ArrayList<BigInteger> l = new ArrayList<BigInteger>();
                for (String element2 : valuemap) {
                    BigInteger b;
                    if (element2.equals(DOTDOT)) continue;
                    if (element2.startsWith(DOTDOT)) {
                        b = this.getMinValue(elementType);
                        BigInteger e = this.getValuemapInteger(element2.substring(2));
                        rangeB.put(b, e);
                        l.add(b);
                        continue;
                    }
                    if (element2.endsWith(DOTDOT)) {
                        b = this.getValuemapInteger(element2.substring(0, element2.indexOf(DOTDOT)));
                        rangeB.put(b, BigInteger.valueOf(0L));
                        l.add(b);
                        continue;
                    }
                    if (element2.contains(DOTDOT)) {
                        BigInteger e = this.getValuemapInteger(element2.substring(element2.indexOf(DOTDOT) + 2));
                        BigInteger b2 = this.getValuemapInteger(element2.substring(0, element2.indexOf(DOTDOT)));
                        rangeB.put(b2, e);
                        l.add(b2);
                        continue;
                    }
                    BigInteger iV = this.getValuemapInteger(element2);
                    l.add(iV);
                }
                Object[] iArray = l.toArray(new BigInteger[l.size()]);
                Arrays.sort(iArray);
                for (int ctr = 0; ctr < iArray.length; ++ctr) {
                    Element maxInclusive;
                    BigInteger max;
                    Element enumeration;
                    Element minInclusive;
                    BigInteger min;
                    Element SimpleType2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:simpleType");
                    Element restriction2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:restriction");
                    restriction2.setAttribute(BASE, WSCIMDataType.getXSType(elementType));
                    if (ctr == iArray.length - 1) {
                        if (!valuemap[valuemap.length - 1].endsWith(DOTDOT) || valuemap[valuemap.length - 1].equals(DOTDOT)) {
                            Object num = iArray[iArray.length - 1];
                            if (rangeB.get(num) != null) {
                                num = (BigInteger)rangeB.get(num);
                            }
                            if (((BigInteger)num).compareTo(this.getMaxValue(elementType)) == 0) break;
                            min = ((BigInteger)iArray[ctr]).add(BigInteger.valueOf(1L));
                            minInclusive = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:minInclusive");
                            minInclusive.setAttribute(VALUE, min.toString());
                            restriction2.appendChild(minInclusive);
                            SimpleType2.appendChild(restriction2);
                            rest.appendChild(SimpleType2);
                            break;
                        }
                        if (0 != ctr || !DOTDOT.equals(valuemap[0])) break;
                        if (((BigInteger)iArray[ctr]).compareTo(this.getMinValue(elementType).add(BigInteger.valueOf(1L))) == 0) {
                            enumeration = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:enumeration");
                            enumeration.setAttribute(VALUE, this.getMinValue(elementType).toString());
                            restriction2.appendChild(enumeration);
                            SimpleType2.appendChild(restriction2);
                            rest.appendChild(SimpleType2);
                            SimpleType2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:simpleType");
                            restriction2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:restriction");
                            restriction2.setAttribute(BASE, WSCIMDataType.getXSType(elementType));
                            break;
                        }
                        max = ((BigInteger)iArray[ctr]).subtract(BigInteger.valueOf(1L));
                        maxInclusive = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:maxInclusive");
                        maxInclusive.setAttribute(VALUE, max.toString());
                        restriction2.appendChild(maxInclusive);
                        SimpleType2.appendChild(restriction2);
                        rest.appendChild(SimpleType2);
                        SimpleType2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:simpleType");
                        restriction2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:restriction");
                        restriction2.setAttribute(BASE, WSCIMDataType.getXSType(elementType));
                        break;
                    }
                    if (ctr == 0 && ((BigInteger)iArray[ctr]).compareTo(this.getMinValue(elementType)) != 0 && !valuemap[0].startsWith(DOTDOT) || ctr == 0 && ((BigInteger)iArray[ctr]).compareTo(this.getMinValue(elementType)) != 0 && valuemap[0].equals(DOTDOT)) {
                        if (((BigInteger)iArray[ctr]).compareTo(this.getMinValue(elementType).add(BigInteger.valueOf(1L))) == 0) {
                            enumeration = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:enumeration");
                            enumeration.setAttribute(VALUE, this.getMinValue(elementType).toString());
                            restriction2.appendChild(enumeration);
                            SimpleType2.appendChild(restriction2);
                            rest.appendChild(SimpleType2);
                            SimpleType2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:simpleType");
                            restriction2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:restriction");
                            restriction2.setAttribute(BASE, WSCIMDataType.getXSType(elementType));
                        } else {
                            max = ((BigInteger)iArray[ctr]).subtract(BigInteger.valueOf(1L));
                            maxInclusive = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:maxInclusive");
                            maxInclusive.setAttribute(VALUE, max.toString());
                            restriction2.appendChild(maxInclusive);
                            SimpleType2.appendChild(restriction2);
                            rest.appendChild(SimpleType2);
                            SimpleType2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:simpleType");
                            restriction2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:restriction");
                            restriction2.setAttribute(BASE, WSCIMDataType.getXSType(elementType));
                        }
                    }
                    if (rangeB.get(iArray[ctr]) != null) {
                        BigInteger i = (BigInteger)rangeB.get(iArray[ctr]);
                        if (iArray.length <= ctr + 1 || i.compareTo(((BigInteger)iArray[ctr + 1]).subtract(BigInteger.valueOf(1L))) == 0) continue;
                        min = i.add(BigInteger.valueOf(1L));
                        BigInteger max2 = ((BigInteger)iArray[ctr + 1]).subtract(BigInteger.valueOf(1L));
                        Element minInclusive2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:minInclusive");
                        minInclusive2.setAttribute(VALUE, min.toString());
                        restriction2.appendChild(minInclusive2);
                        Element maxInclusive2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:maxInclusive");
                        maxInclusive2.setAttribute(VALUE, max2.toString());
                        restriction2.appendChild(maxInclusive2);
                        SimpleType2.appendChild(restriction2);
                        rest.appendChild(SimpleType2);
                        continue;
                    }
                    if (((BigInteger)iArray[ctr]).compareTo(((BigInteger)iArray[ctr + 1]).subtract(BigInteger.valueOf(1L))) == 0) continue;
                    if (((BigInteger)iArray[ctr + 1]).subtract((BigInteger)iArray[ctr]).compareTo(BigInteger.valueOf(2L)) == 0) {
                        enumeration = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:enumeration");
                        BigInteger i = ((BigInteger)iArray[ctr]).add(BigInteger.valueOf(1L));
                        enumeration.setAttribute(VALUE, i.toString());
                        restriction2.appendChild(enumeration);
                        SimpleType2.appendChild(restriction2);
                        rest.appendChild(SimpleType2);
                        continue;
                    }
                    BigInteger min2 = ((BigInteger)iArray[ctr]).add(BigInteger.valueOf(1L));
                    BigInteger max3 = ((BigInteger)iArray[ctr + 1]).subtract(BigInteger.valueOf(1L));
                    minInclusive = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:minInclusive");
                    minInclusive.setAttribute(VALUE, min2.toString());
                    restriction2.appendChild(minInclusive);
                    Element maxInclusive3 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:maxInclusive");
                    maxInclusive3.setAttribute(VALUE, max3.toString());
                    restriction2.appendChild(maxInclusive3);
                    SimpleType2.appendChild(restriction2);
                    rest.appendChild(SimpleType2);
                }
            }
            Element unionType = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:union");
            SimpleType.appendChild(unionType);
            block3: for (int x = 0; x < valuemap.length; ++x) {
                Element SimpleType2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:simpleType");
                unionType.appendChild(SimpleType2);
                Element restriction2 = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:restriction");
                restriction2.setAttribute(BASE, WSCIMDataType.getXSType(elementType));
                if (!valuemap[x].equals(DOTDOT)) {
                    SimpleType2.appendChild(restriction2);
                }
                if (valuemap[x].contains(DOTDOT)) {
                    BigInteger i;
                    if (!valuemap[x].startsWith(DOTDOT)) {
                        Element minInclusive = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:minInclusive");
                        i = this.getValuemapInteger(valuemap[x].substring(0, valuemap[x].indexOf(DOTDOT)));
                        minInclusive.setAttribute(VALUE, i.toString());
                        restriction2.appendChild(minInclusive);
                    }
                    if (!valuemap[x].endsWith(DOTDOT)) {
                        Element maxInclusive = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:maxInclusive");
                        i = this.getValuemapInteger(valuemap[x].substring(valuemap[x].indexOf(DOTDOT) + 2));
                        maxInclusive.setAttribute(VALUE, i.toString());
                        restriction2.appendChild(maxInclusive);
                    }
                    if (!valuemap[x].equals(DOTDOT)) continue;
                    SimpleType2.appendChild(rest);
                    continue;
                }
                while (!valuemap[x].contains(DOTDOT)) {
                    Element enumeration = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:enumeration");
                    enumeration.setAttribute(VALUE, valuemap[x]);
                    restriction2.appendChild(enumeration);
                    if (valuemap.length <= x + 1 || valuemap[x + 1].contains(DOTDOT)) continue block3;
                    ++x;
                }
            }
        } else {
            for (String valueMap : valuemap) {
                Element enumeration = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:enumeration");
                enumeration.setAttribute(VALUE, valueMap);
                restriction.appendChild(enumeration);
            }
        }
        Element anyAttr = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:anyAttribute");
        anyAttr.setAttribute(NAMESPACE, "##any");
        anyAttr.setAttribute(PROCESSCONTENTS, LAX);
        restriction.appendChild(anyAttr);
    }

    private String checkType(CIMQualifiedElementInterface e, String type) {
        if (e.hasQualifierValue(QUALIFIER_EMBEDDEDOBJECT, (Object)true) || e.hasQualifier(QUALIFIER_EMBEDDEDINSTANCE)) {
            type = "xs:anyType";
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    public void createXSD(CIMClass cl, Document xsd, Element startingElement) {
        void var18_23;
        CIMMethod[] m;
        Object[] p;
        String TARGET_NAMESPACE = "targetNamespace";
        String XMLNS = "xmlns";
        String ELEMENT_FORM_DEFAULT = "elementFormDefault";
        String QUALIFIED = "qualified";
        String IMPORT = "import";
        String className = cl.getName();
        String schemaName = "CIM";
        String xsdNamespace = WSCIMNamespaceConstants.getNamespace("class");
        try {
            schemaName = className.substring(0, className.indexOf(95));
            if (!schemaName.equalsIgnoreCase("CIM") && !schemaName.equalsIgnoreCase("PRS") && this.mProps.containsKey(schemaName)) {
                xsdNamespace = this.mProps.getProperty(schemaName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null != startingElement) {
            WSProductInfo pInfo = new WSProductInfo("com.ws.wbem.apps.mofmorph");
            xsd.appendChild(xsd.createComment(pInfo.getGeneratedByText()));
        }
        Element root = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:schema");
        root.setAttribute("targetNamespace", xsdNamespace + cl.getName());
        root.setAttribute("xmlns:class", xsdNamespace + cl.getName());
        root.setAttribute("xmlns:cim", WSCIMNamespaceConstants.getNamespace("cim"));
        root.setAttribute("xmlns:xs", WSCIMNamespaceConstants.getNamespace("xs"));
        root.setAttribute("xmlns:xsi", WSCIMNamespaceConstants.getNamespace("xsi"));
        root.setAttribute("elementFormDefault", "qualified");
        if (null == startingElement) {
            xsd.appendChild(root);
        } else {
            startingElement.appendChild(root);
        }
        Element cimBaseImport = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:import");
        cimBaseImport.setAttribute(NAMESPACE, "http://schemas.dmtf.org/wbem/wscim/1/common");
        cimBaseImport.setAttribute("schemaLocation", "http://schemas.dmtf.org/wbem/wscim/1/common.xsd");
        root.appendChild(cimBaseImport);
        for (CIMClassProperty cIMClassProperty : p = cl.getProperties()) {
            this.mapProperty(cl, cIMClassProperty, root, xsd);
        }
        CIMMethod[] arr$ = m = cl.getMethods();
        int len$ = arr$.length;
        boolean bl = false;
        while (var18_23 < len$) {
            CIMMethod me = arr$[var18_23];
            this.mapMethod(me, root, xsd);
            ++var18_23;
        }
        Element classGED = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:element");
        classGED.setAttribute(NAME, cl.getName());
        classGED.setAttribute(TYPE, "class:" + cl.getName() + _TYPE);
        root.appendChild(classGED);
        if (null != this.mProps.getProperty("iq")) {
            this.addQualifiers(classGED, cl.getQualifiers(), xsd, ETYPE.CLASS, cl.getName(), cl.getSuperClassName(), null);
        }
        Element complexType = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:complexType");
        complexType.setAttribute(NAME, cl.getName() + _TYPE);
        root.appendChild(complexType);
        Element element = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:sequence");
        complexType.appendChild(element);
        Arrays.sort(p);
        for (Object pe : p) {
            Element element2 = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:element");
            element2.setAttribute("ref", "class:" + pe.getName());
            if (pe.getDataType().isArray() || !pe.isKey() && !pe.hasQualifierValue(QUALIFIER_REQUIRED, (Object)true)) {
                element2.setAttribute(MINOCCURS, "0");
            }
            if (pe.getDataType().isArray()) {
                int size = pe.getDataType().getSize();
                element2.setAttribute(MAXOCCURS, size == 0 ? UNBOUNDED : Integer.toString(size));
            }
            element.appendChild(element2);
        }
        Element any = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:any");
        any.setAttribute(NAMESPACE, "##other");
        any.setAttribute(PROCESSCONTENTS, LAX);
        any.setAttribute(MINOCCURS, "0");
        any.setAttribute(MAXOCCURS, UNBOUNDED);
        element.appendChild(any);
        Element anyAttr = xsd.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:anyAttribute");
        anyAttr.setAttribute(NAMESPACE, "##any");
        anyAttr.setAttribute(PROCESSCONTENTS, LAX);
        complexType.appendChild(anyAttr);
    }

    private BigInteger getMaxValue(int elementType) {
        switch (elementType) {
            case 3: {
                return BigInteger.valueOf(32767L);
            }
            case 5: {
                return BigInteger.valueOf(Integer.MAX_VALUE);
            }
            case 7: {
                return BigInteger.valueOf(Long.MAX_VALUE);
            }
            case 1: {
                return BigInteger.valueOf(127L);
            }
            case 2: {
                return BigInteger.valueOf(65535L);
            }
            case 4: {
                return BigInteger.valueOf(0xFFFFFFFFL);
            }
            case 6: {
                return UnsignedInteger64.MAX_VALUE;
            }
            case 0: {
                return BigInteger.valueOf(255L);
            }
        }
        return BigInteger.valueOf(0L);
    }

    private BigInteger getMinValue(int elementType) {
        switch (elementType) {
            case 3: {
                return BigInteger.valueOf(-32768L);
            }
            case 5: {
                return BigInteger.valueOf(Integer.MIN_VALUE);
            }
            case 7: {
                return BigInteger.valueOf(Long.MIN_VALUE);
            }
            case 1: {
                return BigInteger.valueOf(-128L);
            }
            case 2: {
                return BigInteger.valueOf(0L);
            }
            case 4: {
                return BigInteger.valueOf(0L);
            }
            case 6: {
                return UnsignedInteger64.MIN_VALUE;
            }
            case 0: {
                return BigInteger.valueOf(0L);
            }
        }
        return BigInteger.valueOf(0L);
    }

    private BigInteger getValuemapInteger(String entry) {
        int base = 10;
        if (entry.startsWith("0x")) {
            entry = entry.substring(2);
            base = 16;
        }
        return new BigInteger(entry, base);
    }

    public void mapMethod(CIMMethod<?> method, Element root, Document out) {
        CIMParameter[] op;
        Element methodElement = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:element");
        String name = method.getName();
        methodElement.setAttribute(NAME, name + INPUT);
        root.appendChild(methodElement);
        Element it = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:complexType");
        methodElement.appendChild(it);
        CIMParameter[] parameters = method.getParameters();
        if (parameters.length > 0) {
            Element sequence = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:sequence");
            it.appendChild(sequence);
            for (CIMParameter parameter : parameters) {
                if (!parameter.hasQualifierValue(QUALIFIER_IN, (Object)true)) continue;
                this.mapParameter(parameter, sequence, out);
            }
        }
        Element oe = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:element");
        oe.setAttribute(NAME, name + OUTPUT);
        root.appendChild(oe);
        Element ot = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:complexType");
        oe.appendChild(ot);
        Element sequence = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:sequence");
        ot.appendChild(sequence);
        for (CIMParameter param : op = method.getParameters()) {
            if (!param.hasQualifierValue(QUALIFIER_OUT, (Object)true)) continue;
            this.mapParameter(param, sequence, out);
        }
        Element re = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:element");
        re.setAttribute(NAME, RETURNVALUE);
        re.setAttribute(TYPE, WSCIMDataType.getType(method.getDataType().getType()));
        re.setAttribute(NILLABLE, "true");
        sequence.appendChild(re);
        this.addRestricitions((CIMQualifiedElementInterface)method, method.getDataType().getType(), out, re);
    }

    public void mapParameter(CIMParameter<?> parameter, Element sequence, Document out) {
        String name = parameter.getName();
        String type = WSCIMDataType.getType(parameter.getDataType().getType());
        type = this.checkType((CIMQualifiedElementInterface)parameter, type);
        Element element = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:element");
        element.setAttribute(NAME, name);
        element.setAttribute(TYPE, type);
        if (!parameter.hasQualifierValue(QUALIFIER_REQUIRED, (Object)true)) {
            element.setAttribute(NILLABLE, "true");
        }
        if (parameter.getDataType().isArray()) {
            int size;
            if (!parameter.hasQualifierValue(QUALIFIER_REQUIRED, (Object)true)) {
                element.setAttribute(MINOCCURS, "0");
            }
            element.setAttribute(MAXOCCURS, (size = parameter.getDataType().getSize()) == 0 ? UNBOUNDED : Integer.toString(size));
        }
        sequence.appendChild(element);
        this.addRestricitions((CIMQualifiedElementInterface)parameter, parameter.getDataType().getType(), out, element);
    }

    private void mapProperty(CIMClass cl, CIMClassProperty<?> prop, Element root, Document out) {
        Element element = out.createElementNS(WSCIMNamespaceConstants.getNamespace("xs"), "xs:element");
        String type = WSCIMDataType.getType(prop.getDataType().getType());
        type = this.checkType((CIMQualifiedElementInterface)prop, type);
        element.setAttribute(NAME, prop.getName());
        element.setAttribute(TYPE, type);
        root.appendChild(element);
        if (prop.getDataType().isArray() || !prop.isKey() && !prop.hasQualifierValue(QUALIFIER_REQUIRED, (Object)true)) {
            element.setAttribute(NILLABLE, "true");
        }
        if (null != this.mProps.getProperty("iq")) {
            this.addQualifiers(element, prop.getQualifiers(), out, ETYPE.PROPERTY, cl.getName(), prop.getValue(), prop.getDataType());
        }
        this.addRestricitions((CIMQualifiedElementInterface)prop, prop.getDataType().getType(), out, element);
    }

    private void writeFile(Document doc, String name) throws Exception {
        String XSD = ".xsd";
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer tr = factory.newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        String outName = this.mOutdir + File.separator + name + ".xsd";
        tr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(outName), "utf-8")));
    }

    private static enum ETYPE {
        CLASS,
        PROPERTY;

    }
}

