/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi;

import com.ws.utilities.Resources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class XMICodeWriter {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    private Resources mResourceHandle;
    private String mOutdir;

    public XMICodeWriter(String pOutdir) {
        this.mOutdir = pOutdir;
        this.mResourceHandle = new Resources(BUNDLE);
    }

    public void write(String pFileName, String pData) throws Exception {
        if (pFileName == null) {
            throw new IllegalArgumentException(this.mResourceHandle.loadString("MSG_ILLEGALARGUMENTEXCEPTION"));
        }
        File dir = new File(this.mOutdir);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
            throw new IllegalArgumentException("could not create directory: " + this.mOutdir);
        }
        String fileName = this.mOutdir + File.separator + pFileName;
        File cFile = new File(fileName);
        if (cFile.exists()) {
            cFile.delete();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(fileName, false));
        out.write(pData);
        out.close();
    }
}

