/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi.metaclass;

import com.ws.utilities.Resources;
import java.text.MessageFormat;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMMethod;
import javax.cim.CIMParameter;

public abstract class BaseMetaClass {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    protected static final String ABSTRACT_QUALIFIER = "Abstract";
    protected static final String TERMINAL_QUALIFIER = "Terminal";
    protected static final String DESCRIPTION_QUALIFIER = "Description";
    protected static final String TAB = "\t";
    protected String mName;
    protected String mVisibility = "public";
    protected Resources mResourceHandle = new Resources("com.ws.cim.xmi.XMIGenerator");

    protected final Resources getBaseResourceHandle() {
        return this.mResourceHandle;
    }

    protected String generateOwnedComment(Object pElement, String pTabs) {
        String comment = "";
        if (null != pElement) {
            if (pElement instanceof CIMClass) {
                CIMClass classObject = (CIMClass)pElement;
                comment = (String)classObject.getQualifierValue(DESCRIPTION_QUALIFIER);
            } else if (pElement instanceof CIMMethod) {
                CIMMethod methodObject = (CIMMethod)pElement;
                comment = (String)methodObject.getQualifierValue(DESCRIPTION_QUALIFIER);
            } else if (pElement instanceof CIMClassProperty) {
                CIMClassProperty propertyObject = (CIMClassProperty)pElement;
                comment = (String)propertyObject.getQualifierValue(DESCRIPTION_QUALIFIER);
            } else if (pElement instanceof CIMParameter) {
                CIMParameter parameterObject = (CIMParameter)pElement;
                comment = (String)parameterObject.getQualifierValue(DESCRIPTION_QUALIFIER);
            }
        }
        if (null != comment) {
            comment = comment.replaceAll("&apos;", "XXXapos;");
            comment = comment.replaceAll("&", "&amp;");
            comment = comment.replaceAll("XXXapos;", "&apos;");
        }
        return MessageFormat.format(this.mResourceHandle.loadString("COMMENT_METACLASS"), pTabs, this.arrangeString(pTabs, comment));
    }

    private String arrangeString(String pTab, String pStr) {
        StringBuffer strBuffer = new StringBuffer();
        if (null != pStr) {
            pStr = pStr.replaceAll("\n", "");
            pStr = pStr.replaceAll("\"", "");
            pStr = pStr.replaceAll("<", "");
            pStr = pStr.replaceAll(">", "");
            String[] splitStr = pStr.split(" ");
            StringBuffer tempBuffer = new StringBuffer();
            for (String str : splitStr) {
                if (tempBuffer.length() + str.length() >= 80) {
                    strBuffer.append(tempBuffer.toString());
                    tempBuffer = new StringBuffer();
                    tempBuffer.append(pTab + TAB);
                    tempBuffer.append(str + " ");
                    continue;
                }
                tempBuffer.append(str + " ");
            }
            strBuffer.append(tempBuffer.toString());
        }
        return strBuffer.toString();
    }
}

