/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmi.metaclass;

import com.ws.cim.xmi.metaclass.BaseMetaClass;
import com.ws.utilities.Resources;
import java.text.MessageFormat;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;

public class PropertyMetaClass
extends BaseMetaClass {
    private static final String BUNDLE = "com.ws.cim.xmi.XMIGenerator";
    private final String WRITE_QUALIFIER = "Write";
    private final String STATIC_QUALIFIER = "Static";
    private final String ARRAYTYPE_QUALIFIER = "ArrayType";
    private final String MIN_QUALIFIER = "Min";
    private final String MAX_QUALIFIER = "Max";
    private final String AGGREGATION_QUALIFIER = "Aggregation";
    private final String AGGREGATE_QUALIFIER = "Aggregate";
    private final String COMPOSITION_QUALIFIER = "Composition";
    private final String V_ARRAYTYPE = "Ordered";
    private final String LITERAL_NULL = "uml:LiteralNull";
    private final String NONE = "none";
    private CIMClassProperty<?> mClassProperty;
    private final String mClassName;
    private final boolean mIsAssociationClass;
    private Resources mLocalResourceHandle;

    public PropertyMetaClass(CIMClassProperty<?> pClassProperty, String className, boolean isAssociationClass) {
        this.mClassName = className;
        this.mIsAssociationClass = isAssociationClass;
        this.mClassProperty = pClassProperty;
        this.mName = pClassProperty.getName();
        this.mLocalResourceHandle = new Resources(BUNDLE);
        this.mVisibility = "public";
    }

    public String toString(String pTabs) {
        StringBuffer ownedAttribute = new StringBuffer("");
        boolean isDerived = false;
        boolean isUnique = true;
        String tabs = pTabs + "\t";
        String ownedComment = this.generateOwnedComment(this.mClassProperty, tabs);
        if (this.mIsAssociationClass && 14 == this.mClassProperty.getDataType().getType()) {
            ownedAttribute.append(MessageFormat.format(this.mLocalResourceHandle.loadString("MEMBER_END"), pTabs, this.mClassName + "." + this.mClassProperty.getName()));
            ownedAttribute.append(MessageFormat.format(this.mLocalResourceHandle.loadString("OWNED_END"), pTabs, this.mClassName + "." + this.mClassProperty.getName(), this.mClassName, this.mClassProperty.getDataType().getRefClassName(), ownedComment));
        } else {
            String type = this.generateType(tabs);
            String defaultValue = this.generateDefaultValue(tabs);
            String lowerValue = this.generateLowerValue(tabs);
            String upperValue = this.generateUpperValue(tabs);
            String aggregation = this.generateAggregation();
            ownedAttribute.append(MessageFormat.format(this.mLocalResourceHandle.loadString("PROPERTY_METACLASS"), pTabs, this.mName, this.mVisibility, isDerived, this.isReadOnly(), this.isStatic(), this.isOrdered(), isUnique, aggregation, type, defaultValue, lowerValue, upperValue, ownedComment));
        }
        return ownedAttribute.toString();
    }

    private String isReadOnly() {
        if (this.mClassProperty.hasQualifierValue("Write", (Object)Boolean.TRUE)) {
            return " isReadOnly=\"true\"";
        }
        return "";
    }

    private String isStatic() {
        if (this.mClassProperty.getDataType().getType() != 14 && this.mClassProperty.hasQualifierValue("Static", (Object)Boolean.TRUE)) {
            return " isStatic=\"true\"";
        }
        return "";
    }

    private boolean isOrdered() {
        if (this.mClassProperty.getDataType().getType() != 14) {
            return this.mClassProperty.hasQualifierValue("ArrayType", (Object)"Ordered");
        }
        return false;
    }

    private String generateType(String pTabs) {
        CIMDataType dataType = this.mClassProperty.getDataType();
        String literalType = pTabs + this.getLiteralType(dataType);
        return literalType;
    }

    private String getLiteralType(CIMDataType pDataType) {
        String DT_BOOLEAN = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#Boolean\"/>";
        String DT_CHAR16 = "<type xmi:idref=\"_char16\"/>";
        String DT_STRING = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
        String DT_DATETIME = "<type xmi:idref=\"_datetime\"/>";
        String DT_UINT8 = "<type xmi:idref=\"_uint8\"/>";
        String DT_UINT16 = "<type xmi:idref=\"_uint16\"/>";
        String DT_UINT32 = "<type xmi:idref=\"_uint32\"/>";
        String DT_UINT64 = "<type xmi:idref=\"_uint64\"/>";
        String DT_SINT8 = "<type xmi:idref=\"_sint8\"/>";
        String DT_SINT16 = "<type xmi:idref=\"_sint16\"/>";
        String DT_SINT32 = "<type xmi:idref=\"_sint32\"/>";
        String DT_SINT64 = "<type xmi:idref=\"_sint64\"/>";
        String DT_REAL32 = "<type xmi:idref=\"_real32\"/>";
        String DT_REAL64 = "<type xmi:idref=\"_real64\"/>";
        String DT_BOOLEAN_ARRAY = "<type xmi:idref=\"_boolean__\"/>";
        String DT_CHAR16_ARRAY = "<type xmi:idref=\"_char__\"/>";
        String DT_STRING_ARRAY = "<type xmi:idref=\"_string__\"/>";
        String DT_DATETIME_ARRAY = "<type xmi:idref=\"_datetime__\"/>";
        String DT_UINT8_ARRAY = "<type xmi:idref=\"_uint8__\"/>";
        String DT_UINT16_ARRAY = "<type xmi:idref=\"_uint16__\"/>";
        String DT_UINT32_ARRAY = "<type xmi:idref=\"_uint32__\"/>";
        String DT_UINT64_ARRAY = "<type xmi:idref=\"_uint64__\"/>";
        String DT_SINT8_ARRAY = "<type xmi:idref=\"_sint8__\"/>";
        String DT_SINT16_ARRAY = "<type xmi:idref=\"_sint16__\"/>";
        String DT_SINT32_ARRAY = "<type xmi:idref=\"_sint32__\"/>";
        String DT_SINT64_ARRAY = "<type xmi:idref=\"_sint64__\"/>";
        String DT_REAL32_ARRAY = "<type xmi:idref=\"_real32__\"/>";
        String DT_REAL64_ARRAY = "<type xmi:idref=\"_real64__\"/>";
        int type = pDataType.getType();
        String literalType = "";
        if (!pDataType.isArray()) {
            switch (type) {
                case 9: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#Boolean\"/>";
                    break;
                }
                case 13: {
                    literalType = "<type xmi:idref=\"_char16\"/>";
                    break;
                }
                case 17: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
                    break;
                }
                case 12: {
                    literalType = "<type xmi:idref=\"_datetime\"/>";
                    break;
                }
                case 15: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
                    break;
                }
                case 10: {
                    literalType = "<type xmi:idref=\"_real32\"/>";
                    break;
                }
                case 11: {
                    literalType = "<type xmi:idref=\"_real64\"/>";
                    break;
                }
                case 14: {
                    literalType = "";
                    break;
                }
                case 8: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
                    break;
                }
                case 1: {
                    literalType = "<type xmi:idref=\"_sint8\"/>";
                    break;
                }
                case 3: {
                    literalType = "<type xmi:idref=\"_sint16\"/>";
                    break;
                }
                case 5: {
                    literalType = "<type xmi:idref=\"_sint32\"/>";
                    break;
                }
                case 7: {
                    literalType = "<type xmi:idref=\"_sint64\"/>";
                    break;
                }
                case 0: {
                    literalType = "<type xmi:idref=\"_uint8\"/>";
                    break;
                }
                case 2: {
                    literalType = "<type xmi:idref=\"_uint16\"/>";
                    break;
                }
                case 4: {
                    literalType = "<type xmi:idref=\"_uint32\"/>";
                    break;
                }
                case 6: {
                    literalType = "<type xmi:idref=\"_uint64\"/>";
                    break;
                }
                default: {
                    literalType = "<type xmi:type=\"uml:PrimitiveType\" href=\"http://schema.omg.org/spec/UML/2.1/uml.xml#String\"/>";
                    break;
                }
            }
        } else {
            switch (type) {
                case 9: {
                    literalType = "<type xmi:idref=\"_boolean__\"/>";
                    break;
                }
                case 13: {
                    literalType = "<type xmi:idref=\"_char__\"/>";
                    break;
                }
                case 17: {
                    literalType = "<type xmi:idref=\"_string__\"/>";
                    break;
                }
                case 12: {
                    literalType = "<type xmi:idref=\"_datetime__\"/>";
                    break;
                }
                case 15: {
                    literalType = "<type xmi:idref=\"_string__\"/>";
                    break;
                }
                case 10: {
                    literalType = "<type xmi:idref=\"_real32__\"/>";
                    break;
                }
                case 11: {
                    literalType = "<type xmi:idref=\"_real64__\"/>";
                    break;
                }
                case 14: {
                    literalType = "";
                    break;
                }
                case 8: {
                    literalType = "<type xmi:idref=\"_string__\"/>";
                    break;
                }
                case 1: {
                    literalType = "<type xmi:idref=\"_sint8__\"/>";
                    break;
                }
                case 3: {
                    literalType = "<type xmi:idref=\"_sint16__\"/>";
                    break;
                }
                case 5: {
                    literalType = "<type xmi:idref=\"_sint32__\"/>";
                    break;
                }
                case 7: {
                    literalType = "<type xmi:idref=\"_sint64__\"/>";
                    break;
                }
                case 0: {
                    literalType = "<type xmi:idref=\"_uint8__\"/>";
                    break;
                }
                case 2: {
                    literalType = "<type xmi:idref=\"_uint16__\"/>";
                    break;
                }
                case 4: {
                    literalType = "<type xmi:idref=\"_uint32__\"/>";
                    break;
                }
                case 6: {
                    literalType = "<type xmi:idref=\"_uint64__\"/>";
                    break;
                }
                default: {
                    literalType = "<type xmi:idref=\"_string__\"/>";
                }
            }
        }
        return literalType;
    }

    private String generateDefaultValue(String pTabs) {
        String defaultValue = "";
        Object propertyValue = this.mClassProperty.getValue();
        if (null != propertyValue) {
            String dataType = "uml:LiteralNull";
            dataType = this.getLiteralType(this.mClassProperty.getDataType());
            propertyValue = propertyValue.toString().replaceAll("\"", "");
            String value = "";
            if (!dataType.equalsIgnoreCase("uml:LiteralNull")) {
                value = " value=\"" + propertyValue + "\"";
            }
            defaultValue = MessageFormat.format(this.mLocalResourceHandle.loadString("DEFAULT_VALUE"), pTabs, dataType, value);
        }
        return defaultValue;
    }

    private String generateLowerValue(String pTabs) {
        Object value = null;
        if (this.mClassProperty.getDataType().getType() == 14) {
            value = this.mClassProperty.getQualifierValue("Min");
            if (null == value) {
                value = "0";
            }
        } else {
            value = this.mClassProperty.hasQualifier("ArrayType") ? "0" : "1";
        }
        String lowerValue = MessageFormat.format(this.mLocalResourceHandle.loadString("LOWER_VALUE"), pTabs, value);
        return lowerValue;
    }

    private String generateUpperValue(String pTabs) {
        String upperValue = "";
        Object value = null;
        if (this.mClassProperty.getDataType().getType() == 14) {
            value = this.mClassProperty.getQualifierValue("Max");
            if (null == value) {
                value = "*";
            }
        } else {
            value = this.mClassProperty.getDataType().isArray() ? "*" : "1";
        }
        upperValue = this.mClassProperty.getDataType().isArray() || this.mClassProperty.getDataType().getType() == 14 ? MessageFormat.format(this.mLocalResourceHandle.loadString("UPPER_VALUE_ARRAY"), pTabs, value) : MessageFormat.format(this.mLocalResourceHandle.loadString("UPPER_VALUE"), pTabs, value);
        return upperValue;
    }

    private String generateAggregation() {
        String aggregation = "";
        if (this.mClassProperty.getDataType().getType() == 14) {
            StringBuffer aggregationBuf = new StringBuffer();
            boolean hasAggregation = false;
            if (this.mClassProperty.hasQualifierValue("Aggregation", (Object)Boolean.TRUE)) {
                aggregationBuf.append("Aggregation");
                hasAggregation = true;
            }
            if (this.mClassProperty.hasQualifierValue("Aggregate", (Object)Boolean.TRUE)) {
                aggregationBuf.append("Aggregate");
                hasAggregation = true;
            }
            if (this.mClassProperty.hasQualifierValue("Composition", (Object)Boolean.TRUE)) {
                aggregationBuf.append("Composition");
                hasAggregation = true;
            }
            if (!hasAggregation) {
                aggregationBuf.append("none");
            }
            aggregation = MessageFormat.format(this.mLocalResourceHandle.loadString("AGGREGATION"), aggregationBuf.toString());
        }
        return aggregation;
    }
}

