/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.MinMax;
import java.io.Serializable;

public class ChartDataViewSeries
implements Serializable {
    protected ChartDataView parent = null;
    private double[] xvalues;
    private double[] yvalues;
    protected int firstPoint;
    protected DerivedInt lastPoint = new DerivedInt(0, true);
    protected String name;
    protected int drawingOrder = -1;
    protected boolean visible = true;
    protected boolean visibleInLegend = true;
    protected boolean included = true;
    protected String label;
    protected static int dataViewSeriesNum = 0;

    public ChartDataViewSeries() {
        this.parent = null;
        this.xvalues = null;
        this.yvalues = null;
    }

    ChartDataViewSeries(double[] dArray, double[] dArray2, ChartDataView chartDataView) {
        this.parent = chartDataView;
        this.xvalues = dArray;
        this.yvalues = dArray2;
        if (dArray2 == null) {
            this.firstPoint = Integer.MAX_VALUE;
            this.lastPoint.value = Integer.MAX_VALUE;
            this.lastPoint.isDefault = true;
        } else {
            this.firstPoint = 0;
            this.lastPoint.value = this.maxIndex();
            this.lastPoint.isDefault = true;
        }
    }

    void calcStep(ChartDataView chartDataView) {
        double[] dArray;
        double[] dArray2 = dArray = this.xvalues == null ? this.parent.getX() : this.xvalues;
        if (dArray == null || dArray.length == 0) {
            return;
        }
        int n = 1;
        while (n < dArray.length) {
            double d = dArray[n] - dArray[n - 1];
            if (d < 0.0) {
                d = -d;
            }
            if (d < chartDataView.step && d != 0.0) {
                chartDataView.step = d;
            }
            ++n;
        }
        if (chartDataView.step == Double.MAX_VALUE) {
            chartDataView.step = 1.0;
        }
    }

    public void editPoint(int n, double d) {
        if (this.parent.editPoint(this, n, d)) {
            this.yvalues[n] = d;
            this.parent.setChanged(true, 2);
        }
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public int getFirstPoint() {
        if (this.firstPoint == Integer.MAX_VALUE && this.getX() != null && this.getY() != null) {
            this.firstPoint = 0;
        }
        return this.firstPoint;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = new String(String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key127")) + (this.drawingOrder + 1));
        }
        return this.label;
    }

    public int getLastPoint() {
        double[] dArray = this.getX();
        double[] dArray2 = this.getY();
        if (this.lastPoint.isDefault) {
            if (dArray != null && dArray2 != null) {
                return Math.min(dArray2.length, dArray.length) - 1;
            }
            return -1;
        }
        return this.lastPoint.value;
    }

    public boolean getLastPointIsDefault() {
        return this.lastPoint.isDefault;
    }

    public String getName() {
        return this.name;
    }

    public ChartDataView getParent() {
        return this.parent;
    }

    int getPoint(double d, double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = Math.abs(dArray[n2] - d);
            if (d3 < d2) {
                d2 = d3;
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public JCChartStyle getStyle() {
        if (this.parent == null) {
            return null;
        }
        int n = this.parent.getSeriesIndex(this);
        if (n < 0) {
            return null;
        }
        return this.parent.getChartStyle(n);
    }

    double[] getX() {
        return this.xvalues == null ? this.parent.getX() : this.xvalues;
    }

    public int getX(double d) {
        return this.getPoint(d, this.getX());
    }

    public double getX(int n) {
        return this.xvalues == null ? this.parent.getX()[n] : this.xvalues[n];
    }

    void getXMinMax(MinMax minMax) {
        if (minMax == null) {
            return;
        }
        JCAxis jCAxis = this.parent.getXAxis();
        minMax.setMinMax(this.xvalues == null ? this.parent.getX() : this.xvalues, this.parent.getHoleValue(), jCAxis != null ? jCAxis.isLogarithmic() : false);
    }

    double[] getY() {
        return this.yvalues;
    }

    public int getY(double d) {
        return this.getPoint(d, this.yvalues);
    }

    public double getY(int n) {
        return this.yvalues[n];
    }

    void getYMinMax(MinMax minMax) {
        if (minMax == null) {
            return;
        }
        JCAxis jCAxis = this.parent.getYAxis();
        minMax.setMinMax(this.yvalues, this.parent.getHoleValue(), jCAxis != null ? jCAxis.isLogarithmic() : false);
    }

    void init(double[] dArray, double[] dArray2, ChartDataView chartDataView) {
        this.parent = chartDataView;
        this.xvalues = dArray;
        this.yvalues = dArray2;
        if (dArray2 == null) {
            this.firstPoint = Integer.MAX_VALUE;
            this.lastPoint.value = Integer.MAX_VALUE;
            this.lastPoint.isDefault = true;
        } else {
            this.firstPoint = 0;
            this.lastPoint.value = this.maxIndex();
            this.lastPoint.isDefault = true;
        }
        this.name = String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key27")) + ++dataViewSeriesNum;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    public int maxIndex() {
        return Math.max(0, Math.min(this.maxXIndex(), this.maxYIndex()) - 1);
    }

    public int maxXIndex() {
        int n = this.parent == null ? 0 : (this.parent.getX() == null ? 0 : this.parent.getX().length);
        return this.xvalues == null ? n : this.xvalues.length;
    }

    public int maxYIndex() {
        return this.yvalues == null ? 0 : this.yvalues.length;
    }

    public void setDrawingOrder(int n) {
        if (this.drawingOrder == n) {
            return;
        }
        this.drawingOrder = n;
        if (this.parent != null) {
            this.parent.setChanged(true, 17);
        }
    }

    public void setFirstPoint(int n) {
        if (n < 0 || n > this.maxIndex()) {
            throw new IllegalArgumentException("FirstPoint value does not address a point in the data series");
        }
        if (this.firstPoint == n) {
            return;
        }
        this.firstPoint = n;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public void setIncluded(boolean bl) {
        if (bl == this.included) {
            return;
        }
        this.included = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public void setLabel(String string) {
        if (string == this.label) {
            return;
        }
        this.label = string;
        if (this.parent != null) {
            this.parent.setChanged(true, 32);
        }
    }

    public void setLastPoint(int n) {
        if (n < 0 || n > this.maxIndex()) {
            throw new IllegalArgumentException("LastPoint value does not address a point in the data series");
        }
        if (this.lastPoint.value == n) {
            return;
        }
        this.lastPoint.value = n;
        this.lastPoint.isDefault = false;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public void setLastPointIsDefault(boolean bl) {
        this.lastPoint.isDefault = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 130);
        }
    }

    public void setName(String string) {
        if (this.name == string) {
            return;
        }
        this.name = string;
    }

    public void setStyle(JCChartStyle jCChartStyle) {
        if (this.parent == null) {
            return;
        }
        int n = this.parent.getSeriesIndex(this);
        this.parent.setChartStyle(n, jCChartStyle);
    }

    public void setVisible(boolean bl) {
        if (bl == this.visible) {
            return;
        }
        this.visible = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 162);
        }
    }

    public void setVisibleInLegend(boolean bl) {
        if (bl == this.visibleInLegend) {
            return;
        }
        this.visibleInLegend = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 32);
        }
    }

    void setX(double[] dArray) {
        this.xvalues = dArray;
    }

    void setY(double[] dArray) {
        this.yvalues = dArray;
    }

    public String toString() {
        String string = this.getName();
        return string == null ? JCChartBundle.string("com.klg.jclass.chart.Key143") : string;
    }
}

