/*
 * Decompiled with CFR 0.152.
 */
package com.ws.logging;

import com.ws.logging.ConsoleLogFormatter;
import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CIMClientTrace {
    private static final String CIMCLIENTLOG = "WBEMClientTrace%g.txt";
    public static final String CIMCLIENT_LOGGER_NAME = "com.ws.wbem.client";
    private static Boolean mInitialized = Boolean.FALSE;
    private static Logger mLog;
    private static FileHandler mLogFileHandle;

    public static void close() {
        if (mLogFileHandle != null) {
            mLogFileHandle.flush();
            mLogFileHandle.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initTrace(String pLimit, String pNumFiles, String pDir, String pLogName, String consoleLogging, String fileLogging) {
        if (mInitialized.booleanValue()) {
            return;
        }
        Class<CIMClientTrace> clazz = CIMClientTrace.class;
        synchronized (CIMClientTrace.class) {
            int numFiles;
            int limit;
            if (mInitialized.booleanValue()) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            Level levelConsole = Level.parse(consoleLogging);
            Level levelFile = Level.parse(fileLogging);
            try {
                limit = Integer.parseInt(pLimit);
            }
            catch (NumberFormatException e) {
                limit = 0x500000;
            }
            try {
                numFiles = Integer.parseInt(pNumFiles);
            }
            catch (NumberFormatException e) {
                numFiles = 3;
            }
            String logName = pLogName;
            if (null == logName || logName.trim().length() == 0) {
                logName = CIMCLIENTLOG;
            }
            mLog = Logger.getLogger(CIMCLIENT_LOGGER_NAME);
            mLog.setUseParentHandlers(false);
            mLog.setLevel(Level.ALL);
            if (levelConsole == Level.OFF && levelFile == Level.OFF) {
                mLog.setLevel(levelConsole);
                CIMClientTrace.close();
            } else {
                if (Level.OFF != levelConsole) {
                    ConsoleHandler consoleHandler = new ConsoleHandler();
                    consoleHandler.setFormatter(new ConsoleLogFormatter());
                    consoleHandler.setLevel(levelConsole);
                    mLog.addHandler(consoleHandler);
                }
                if (Level.OFF != levelFile) {
                    try {
                        if (pDir != null) {
                            logName = pDir + File.separator + logName;
                        }
                        mLogFileHandle = new FileHandler(logName, limit, numFiles);
                    }
                    catch (Exception e) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return;
                    }
                    mLogFileHandle.setLevel(levelFile);
                    mLog.addHandler(mLogFileHandle);
                }
            }
            mInitialized = true;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }
}

