/*
 * Decompiled with CFR 0.152.
 */
package com.ws.logging;

import com.ws.logging.RequestAndResponse;
import java.util.ArrayList;

public class TraceDocument {
    private static XMLRecordingSession mRecordingSession;

    public static void trace(String trace, boolean request) {
        if (null != mRecordingSession) {
            if (request) {
                mRecordingSession.recordRequest(trace);
            } else {
                mRecordingSession.recordResponse(trace);
            }
        }
    }

    public void startRecording() {
        TraceDocument.setRecordingSession(new XMLRecordingSession());
    }

    public ArrayList<RequestAndResponse> stopRecording() {
        if (mRecordingSession != null) {
            ArrayList<RequestAndResponse> retVal = mRecordingSession.getRecordingSession();
            mRecordingSession = null;
            return retVal;
        }
        return new ArrayList<RequestAndResponse>();
    }

    private static void setRecordingSession(XMLRecordingSession session) {
        mRecordingSession = session;
    }

    class XMLRecordingSession {
        private final ArrayList<RequestAndResponse> recording = new ArrayList();
        private String mResponse;

        XMLRecordingSession() {
        }

        void recordRequest(String request) {
            if (null != request) {
                this.recording.add(new RequestAndResponse(request, this.mResponse));
            }
        }

        void recordResponse(String response) {
            if (null != response) {
                this.mResponse = response;
            }
        }

        public ArrayList<RequestAndResponse> getRecordingSession() {
            return this.recording;
        }
    }
}

