/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import com.ws.cim.mof.MOFStyle;
import java.io.Serializable;
import javax.cim.CIMDateTime;
import javax.cim.Messages;

public class CIMDateTimeInterval
extends CIMDateTime
implements Serializable {
    static final long serialVersionUID = -7362881414085831668L;
    private final String ASTERISKS_2 = "**";
    private final String ASTERISKS_6 = "******";
    private final String ASTERISKS_8 = "********";
    private int mDays;
    private int mHours;
    private String mIntervalString;
    private int mMicroseconds;
    private int mMinutes;
    private int mSeconds;

    public CIMDateTimeInterval(int days, int hours, int minutes, int seconds, int microseconds) throws IllegalArgumentException {
        this.validate(days, hours, minutes, seconds, microseconds);
    }

    public CIMDateTimeInterval(long milliseconds) throws IllegalArgumentException {
        long tSeconds = milliseconds / 1000L;
        int microseconds = (int)((milliseconds - tSeconds * 1000L) * 1000L);
        int seconds = (int)(tSeconds % 60L);
        int tMinutes = (int)(tSeconds / 60L);
        int minutes = tMinutes % 60;
        int tHours = tMinutes / 60;
        int hours = tHours % 24;
        int days = tHours / 24;
        this.validate(days, hours, minutes, seconds, microseconds);
    }

    public CIMDateTimeInterval(String intervalString) throws IllegalArgumentException {
        int days;
        int hours;
        int minutes;
        int seconds;
        int microseconds;
        if (null == intervalString) {
            throw new IllegalArgumentException("intervalString can not be null");
        }
        String iString = intervalString;
        if (intervalString.startsWith("\"") && intervalString.endsWith("\"")) {
            iString = intervalString.substring(1, intervalString.length() - 1);
        }
        if (iString.length() != 25 || iString.charAt(14) != '.' || iString.charAt(21) != ':') {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.15") + iString);
        }
        String msString = this.getMicrosecondsString(iString);
        if (msString.equals(this.ASTERISKS_6)) {
            microseconds = -1;
        } else {
            if (msString.indexOf(42) >= 0) {
                while (msString.endsWith("*")) {
                    msString = msString.substring(0, msString.length() - 1);
                }
                msString = this.padTrailingZeros(msString, 6);
            }
            try {
                microseconds = Integer.parseInt(msString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.10") + iString);
            }
        }
        String secString = this.getSecondsString(iString);
        if (secString.equals(this.ASTERISKS_2)) {
            seconds = -1;
        } else {
            try {
                seconds = Integer.parseInt(secString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.11") + iString);
            }
        }
        String minString = this.getMinutesString(iString);
        if (minString.equals(this.ASTERISKS_2)) {
            minutes = -1;
        } else {
            try {
                minutes = Integer.parseInt(minString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.12") + iString);
            }
        }
        String hourString = this.getHoursString(iString);
        if (hourString.equals(this.ASTERISKS_2)) {
            hours = -1;
        } else {
            try {
                hours = Integer.parseInt(hourString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.13") + iString);
            }
        }
        String dayString = this.getDaysString(iString);
        if (dayString.equals(this.ASTERISKS_8)) {
            days = -1;
        } else {
            try {
                days = Integer.parseInt(dayString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.14") + iString);
            }
        }
        this.mIntervalString = iString.substring(0, 22);
        this.mIntervalString = this.mIntervalString.concat("000");
        this.validate(days, hours, minutes, seconds, microseconds);
    }

    @Override
    public int compareTo(CIMDateTime dt) {
        int ret = 0;
        if (!(dt instanceof CIMDateTimeInterval)) {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.0"));
        }
        String thisIntervalString = this.mIntervalString;
        String whenIntervalString = ((CIMDateTimeInterval)dt).getDateTimeString();
        if (whenIntervalString.indexOf(42) >= 0 || thisIntervalString.indexOf(42) >= 0) {
            int index = whenIntervalString.indexOf(42) < thisIntervalString.indexOf(42) ? whenIntervalString.indexOf(42) : thisIntervalString.indexOf(42);
            thisIntervalString = thisIntervalString.substring(0, index);
            whenIntervalString = whenIntervalString.substring(0, index);
        }
        ret = thisIntervalString.compareTo(whenIntervalString);
        return ret;
    }

    @Override
    public boolean equals(Object dateTime) {
        if (dateTime instanceof CIMDateTimeInterval) {
            return super.equals(dateTime);
        }
        return false;
    }

    @Override
    public String getDateTimeString() {
        return this.mIntervalString;
    }

    public int getDays() {
        return this.mDays;
    }

    private String getDaysString(String intervalString) {
        return intervalString.substring(0, 8);
    }

    public int getHours() {
        return this.mHours;
    }

    private String getHoursString(String intervalString) {
        return intervalString.substring(8, 10);
    }

    private String getIntervalString(int days, int hours, int minutes, int seconds, int microseconds) {
        return this.padLeadingZeros(days, 8) + this.padLeadingZeros(hours, 2) + this.padLeadingZeros(minutes, 2) + this.padLeadingZeros(seconds, 2) + "." + this.padLeadingZeros(microseconds, 6) + ":000";
    }

    public int getMicroseconds() {
        return this.mMicroseconds;
    }

    private String getMicrosecondsString(String intervalString) {
        return intervalString.substring(15, 21);
    }

    public int getMinutes() {
        return this.mMinutes;
    }

    private String getMinutesString(String intervalString) {
        return intervalString.substring(10, 12);
    }

    public int getSeconds() {
        return this.mSeconds;
    }

    private String getSecondsString(String intervalString) {
        return intervalString.substring(12, 14);
    }

    public long getTotalMilliseconds() {
        long tHours = this.getHours() + this.getDays() * 24;
        long tMin = (long)this.getMinutes() + tHours * 60L;
        long tSec = (long)this.getSeconds() + tMin * 60L;
        long tMSec = (long)(this.getMicroseconds() / 1000) + tSec * 1000L;
        return tMSec;
    }

    @Override
    public int hashCode() {
        return this.mIntervalString.hashCode();
    }

    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }

    private void validate(int days, int hours, int minutes, int seconds, int microseconds) throws IllegalArgumentException {
        boolean insignificant = false;
        if (microseconds == -1) {
            insignificant = true;
        } else if (microseconds < 0 || microseconds > 999999) {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.5") + microseconds);
        }
        if (seconds == -1) {
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.1"));
            }
        } else {
            insignificant = false;
            if (seconds < 0 || seconds > 59) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.6") + seconds);
            }
        }
        if (minutes == -1) {
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.2"));
            }
        } else {
            insignificant = false;
            if (minutes < 0 || minutes > 59) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.7") + minutes);
            }
        }
        if (hours == -1) {
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.3"));
            }
        } else {
            insignificant = false;
            if (hours < 0 || hours > 23) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.8") + hours);
            }
        }
        if (days == -1) {
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.4"));
            }
        } else if (days < 0 || days > 99999999) {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeInterval.9") + days);
        }
        this.mDays = days;
        this.mHours = hours;
        this.mMinutes = minutes;
        this.mSeconds = seconds;
        this.mMicroseconds = microseconds;
        if (this.mIntervalString == null) {
            this.mIntervalString = this.getIntervalString(days, hours, minutes, seconds, microseconds);
        }
    }
}

