/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import com.ws.cim.mof.MOFStyle;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.cim.CIMClass;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMTypedElement;
import javax.cim.Messages;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

public abstract class CIMValuedElement<E>
extends CIMTypedElement<E>
implements Comparable<CIMElement> {
    private static final String DT_CLASS = "Class";
    private static final String DT_OBJECT = "Object";
    private static final long serialVersionUID = -5535931215586890247L;
    private final E mValue;

    public CIMValuedElement(String pName, CIMDataType pType, E pValue) throws IllegalArgumentException {
        super(pName, pType);
        this.mValue = pValue;
        if (pType != null && !this.verifyValueHasType(pValue, pType)) {
            String type = pType.toString();
            if (pType.getType() == 15) {
                type = DT_OBJECT;
            } else if (pType.getType() == 17) {
                type = DT_CLASS;
            }
            Object[] args = new Object[]{pValue, type, pName};
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CIMValuedElement.0"), args));
        }
    }

    @Override
    public boolean equals(Object obj) {
        try {
            E o;
            if (obj instanceof CIMValuedElement && super.equals(obj) && (this.getValue() != null ? this.equalsValueHasType(o = ((CIMValuedElement)obj).getValue(), this.getDataType()) : ((CIMValuedElement)obj).getValue() == null)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean equalsValueHasType(Object pValue, CIMDataType pType) {
        if (pValue == null) {
            return this.mValue == null;
        }
        if (pType == null) {
            if (pValue instanceof Object[]) {
                Object[] pVal = (Object[])((Object[])pValue).clone();
                Object[] mVal = (Object[])((Object[])this.mValue).clone();
                return Arrays.equals(pVal, mVal);
            }
            return pValue.equals(this.mValue);
        }
        if (!pType.isArray()) {
            switch (pType.getType()) {
                case 9: {
                    return ((Boolean)pValue).equals(this.mValue);
                }
                case 13: {
                    return ((Character)pValue).equals(this.mValue);
                }
                case 17: {
                    return ((CIMClass)pValue).equals(this.mValue);
                }
                case 12: {
                    return ((CIMDateTime)pValue).equals(this.mValue);
                }
                case 10: {
                    return ((Float)pValue).equals(this.mValue);
                }
                case 11: {
                    return ((Double)pValue).equals(this.mValue);
                }
                case 14: {
                    return ((CIMObjectPath)pValue).equals(this.mValue);
                }
                case 1: {
                    return ((Byte)pValue).equals(this.mValue);
                }
                case 3: {
                    return ((Short)pValue).equals(this.mValue);
                }
                case 5: {
                    return ((Integer)pValue).equals(this.mValue);
                }
                case 7: {
                    return ((Long)pValue).equals(this.mValue);
                }
                case 0: {
                    return ((UnsignedInteger8)pValue).equals(this.mValue);
                }
                case 2: {
                    return ((UnsignedInteger16)pValue).equals(this.mValue);
                }
                case 4: {
                    return ((UnsignedInteger32)pValue).equals(this.mValue);
                }
                case 6: {
                    return ((UnsignedInteger64)pValue).equals(this.mValue);
                }
                case 8: {
                    return ((String)pValue).equals(this.mValue);
                }
                case 15: {
                    return ((CIMInstance)pValue).equals(this.mValue);
                }
            }
            return false;
        }
        Object[] pVal = (Object[])((Object[])pValue).clone();
        Object[] mVal = (Object[])((Object[])this.mValue).clone();
        return Arrays.equals(pVal, mVal);
    }

    public E getValue() {
        return this.mValue;
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }

    private boolean verifyValueHasType(E pValue, CIMDataType pType) {
        if (pValue == null || pType == CIMDataType.INVALID_T) {
            return true;
        }
        if (!pType.isArray()) {
            switch (pType.getType()) {
                case 9: {
                    return pValue instanceof Boolean;
                }
                case 13: {
                    return pValue instanceof Character;
                }
                case 17: {
                    return pValue instanceof CIMClass;
                }
                case 12: {
                    return pValue instanceof CIMDateTime;
                }
                case 10: {
                    return pValue instanceof Float;
                }
                case 11: {
                    return pValue instanceof Double;
                }
                case 14: {
                    return pValue instanceof CIMObjectPath;
                }
                case 1: {
                    return pValue instanceof Byte;
                }
                case 3: {
                    return pValue instanceof Short;
                }
                case 5: {
                    return pValue instanceof Integer;
                }
                case 7: {
                    return pValue instanceof Long;
                }
                case 0: {
                    return pValue instanceof UnsignedInteger8;
                }
                case 2: {
                    return pValue instanceof UnsignedInteger16;
                }
                case 4: {
                    return pValue instanceof UnsignedInteger32;
                }
                case 6: {
                    return pValue instanceof UnsignedInteger64;
                }
                case 8: {
                    return pValue instanceof String;
                }
                case 15: {
                    return pValue instanceof CIMInstance;
                }
            }
            return false;
        }
        if (pType.getSize() > 0 && ((Object[])pValue).length > pType.getSize()) {
            return false;
        }
        switch (pType.getType()) {
            case 9: {
                return pValue instanceof Boolean[];
            }
            case 13: {
                return pValue instanceof Character[];
            }
            case 17: {
                return pValue instanceof CIMClass[];
            }
            case 12: {
                return pValue instanceof CIMDateTime[];
            }
            case 10: {
                return pValue instanceof Float[];
            }
            case 11: {
                return pValue instanceof Double[];
            }
            case 14: {
                return pValue instanceof CIMObjectPath[];
            }
            case 1: {
                return pValue instanceof Byte[];
            }
            case 3: {
                return pValue instanceof Short[];
            }
            case 5: {
                return pValue instanceof Integer[];
            }
            case 7: {
                return pValue instanceof Long[];
            }
            case 0: {
                return pValue instanceof UnsignedInteger8[];
            }
            case 2: {
                return pValue instanceof UnsignedInteger16[];
            }
            case 4: {
                return pValue instanceof UnsignedInteger32[];
            }
            case 6: {
                return pValue instanceof UnsignedInteger64[];
            }
            case 8: {
                return pValue instanceof String[];
            }
            case 15: {
                return pValue instanceof CIMInstance[];
            }
        }
        return false;
    }
}

