/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmlcim;

import java.math.BigInteger;
import java.util.ArrayList;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

class CIMXMLUtilities {
    CIMXMLUtilities() {
    }

    static Object convertArrayToType(ArrayList<Object> l, CIMDataType type) {
        Object[] o = null;
        switch (type.getType()) {
            case 9: {
                o = l.toArray(new Boolean[l.size()]);
                break;
            }
            case 13: {
                o = l.toArray(new Character[l.size()]);
                break;
            }
            case 12: {
                o = l.toArray(new CIMDateTime[l.size()]);
                break;
            }
            case 10: {
                o = l.toArray(new Float[l.size()]);
                break;
            }
            case 11: {
                o = l.toArray(new Double[l.size()]);
                break;
            }
            case 14: {
                o = l.toArray(new CIMObjectPath[l.size()]);
                break;
            }
            case 3: {
                o = l.toArray(new Short[l.size()]);
                break;
            }
            case 5: {
                o = l.toArray(new Integer[l.size()]);
                break;
            }
            case 7: {
                o = l.toArray(new Long[l.size()]);
                break;
            }
            case 1: {
                o = l.toArray(new Byte[l.size()]);
                break;
            }
            case 8: {
                o = l.toArray(new String[l.size()]);
                break;
            }
            case 2: {
                o = l.toArray(new UnsignedInteger16[l.size()]);
                break;
            }
            case 4: {
                o = l.toArray(new UnsignedInteger32[l.size()]);
                break;
            }
            case 6: {
                o = l.toArray(new UnsignedInteger64[l.size()]);
                break;
            }
            case 0: {
                o = l.toArray(new UnsignedInteger8[l.size()]);
                break;
            }
            case 15: {
                o = l.toArray(new CIMInstance[l.size()]);
            }
        }
        return o;
    }

    static Object convertStringToProperType(CIMDataType type, String value) {
        Object o = null;
        if (null == value) {
            return o;
        }
        int inType = type.getType();
        int radix = 10;
        if ((inType == 3 || inType == 5 || inType == 7 || inType == 1) && (value.startsWith("0x") || value.startsWith("+0x") || value.startsWith("-0x") || value.startsWith("0X") || value.startsWith("+0X") || value.startsWith("-0X")) || (inType == 2 || inType == 4 || inType == 6 || inType == 0) && (value.startsWith("0x") || value.startsWith("0X"))) {
            radix = 16;
            int dot = (value.indexOf("x") > 0 ? value.indexOf("x") : value.indexOf("X")) + 1;
            value = value.startsWith("-") ? "-" + value.substring(dot) : value.substring(dot);
        }
        switch (type.getType()) {
            case 9: {
                o = Boolean.valueOf(value);
                break;
            }
            case 13: {
                o = new Character(value.charAt(0));
                break;
            }
            case 12: {
                try {
                    o = new CIMDateTimeAbsolute(value);
                }
                catch (IllegalArgumentException exp) {
                    o = new CIMDateTimeInterval(value);
                }
                break;
            }
            case 10: {
                o = new Float(value);
                break;
            }
            case 11: {
                o = new Double(value);
                break;
            }
            case 14: {
                o = new CIMObjectPath(value);
                break;
            }
            case 3: {
                o = Short.valueOf(value, radix);
                break;
            }
            case 5: {
                o = Integer.valueOf(value, radix);
                break;
            }
            case 7: {
                o = Long.valueOf(value, radix);
                break;
            }
            case 1: {
                o = Byte.valueOf(value, radix);
                break;
            }
            case 8: {
                o = value;
                break;
            }
            case 2: {
                o = new UnsignedInteger16(Integer.valueOf(value, radix).intValue());
                break;
            }
            case 4: {
                o = new UnsignedInteger32(Long.valueOf(value, radix).longValue());
                break;
            }
            case 6: {
                o = new UnsignedInteger64(new BigInteger(value, radix));
                break;
            }
            case 0: {
                o = new UnsignedInteger8(Short.valueOf(value, radix).shortValue());
            }
        }
        return o;
    }

    static String getCIMXMLDataTypefromCIMDataType(CIMDataType cdt) {
        String type = null;
        if (cdt == null) {
            return type;
        }
        if (-1 == cdt.getType() || 15 == cdt.getType()) {
            type = CIMDataType.STRING_T.toString();
        } else if (cdt.getType() != 14) {
            type = cdt.toString().toLowerCase();
            if (type.indexOf("_") > 0) {
                type = type.substring(0, type.indexOf("_"));
            } else if (type.indexOf("[") > 0) {
                type = type.substring(0, type.indexOf("["));
            }
        } else {
            type = "reference";
        }
        return type;
    }

    static CIMDataType getDataType(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.equals("boolean")) {
            return CIMDataType.BOOLEAN_T;
        }
        if (type.equals("char16")) {
            return CIMDataType.CHAR16_T;
        }
        if (type.equals("datetime")) {
            return CIMDataType.DATETIME_T;
        }
        if (type.equals("real32")) {
            return CIMDataType.REAL32_T;
        }
        if (type.equals("real64")) {
            return CIMDataType.REAL64_T;
        }
        if (type.equals("sint16")) {
            return CIMDataType.SINT16_T;
        }
        if (type.equals("sint32")) {
            return CIMDataType.SINT32_T;
        }
        if (type.equals("sint64")) {
            return CIMDataType.SINT64_T;
        }
        if (type.equals("sint8")) {
            return CIMDataType.SINT8_T;
        }
        if (type.equals("string")) {
            return CIMDataType.STRING_T;
        }
        if (type.equals("uint16")) {
            return CIMDataType.UINT16_T;
        }
        if (type.equals("uint32")) {
            return CIMDataType.UINT32_T;
        }
        if (type.equals("uint64")) {
            return CIMDataType.UINT64_T;
        }
        if (type.equals("uint8")) {
            return CIMDataType.UINT8_T;
        }
        return CIMDataType.STRING_T;
    }

    static CIMDataType getDataType(String type, boolean isArray) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (isArray) {
            if (type.equals("boolean")) {
                return CIMDataType.BOOLEAN_ARRAY_T;
            }
            if (type.equals("char16")) {
                return CIMDataType.CHAR16_ARRAY_T;
            }
            if (type.equals("datetime")) {
                return CIMDataType.DATETIME_ARRAY_T;
            }
            if (type.equals("real32")) {
                return CIMDataType.REAL32_ARRAY_T;
            }
            if (type.equals("real64")) {
                return CIMDataType.REAL64_ARRAY_T;
            }
            if (type.equals("sint16")) {
                return CIMDataType.SINT16_ARRAY_T;
            }
            if (type.equals("sint32")) {
                return CIMDataType.SINT32_ARRAY_T;
            }
            if (type.equals("sint64")) {
                return CIMDataType.SINT64_ARRAY_T;
            }
            if (type.equals("sint8")) {
                return CIMDataType.SINT8_ARRAY_T;
            }
            if (type.equals("string")) {
                return CIMDataType.STRING_ARRAY_T;
            }
            if (type.equals("uint16")) {
                return CIMDataType.UINT16_ARRAY_T;
            }
            if (type.equals("uint32")) {
                return CIMDataType.UINT32_ARRAY_T;
            }
            if (type.equals("uint64")) {
                return CIMDataType.UINT64_ARRAY_T;
            }
            if (type.equals("uint8")) {
                return CIMDataType.UINT8_ARRAY_T;
            }
            return CIMDataType.STRING_ARRAY_T;
        }
        return CIMXMLUtilities.getDataType(type);
    }
}

