/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities.wbem.client;

import com.ws.wbem.jserver.JServerProperties;
import java.util.ArrayList;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;

public class WBEMServerNamespace {
    public static CIMObjectPath createNamespace(WBEMClient clientHandle, CIMObjectPath interopOP, String namespaceName) throws WBEMException {
        CIMArgument[] outArgs;
        CIMInstance nsTemplate;
        CIMArgument[] inArgs;
        CIMObjectPath wsPath;
        UnsignedInteger32 ret;
        CIMObjectPath wsOP = new CIMObjectPath(interopOP.getScheme(), interopOP.getHost(), interopOP.getPort(), interopOP.getNamespace(), "CIM_WBEMServer", null);
        CloseableIterator i = clientHandle.enumerateInstances(wsOP, null);
        CIMInstance wsInstance = null;
        while (null != i && i.hasNext()) {
            wsInstance = (CIMInstance)i.next();
        }
        if (null != wsInstance && 0 == (ret = (UnsignedInteger32)clientHandle.invokeMethod(wsPath = wsInstance.getObjectPath(), "CreateWBEMServerNamespace", inArgs = new CIMArgument[]{new CIMArgument("NamespaceTemplate", CIMDataType.OBJECT_T, (Object)(nsTemplate = WBEMServerNamespace.generateDefaultNamespaceTemplate(namespaceName)))}, outArgs = new CIMArgument[]{new CIMArgument("Namespace", new CIMDataType("CIM_WBEMServerNamespace"), null), new CIMArgument("Errors", CIMDataType.OBJECT_ARRAY_T, null)})).intValue()) {
            for (CIMArgument a : outArgs) {
                if (!"Namespace".equalsIgnoreCase(a.getName())) continue;
                return (CIMObjectPath)a.getValue();
            }
        }
        return null;
    }

    private static CIMInstance generateDefaultNamespaceTemplate(String nsName) {
        CIMProperty[] props = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)nsName), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)(nsName + " caption")), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)(nsName + " element name"))};
        return new CIMInstance(new CIMObjectPath("CIM_WBEMServerNamespace"), props);
    }

    public void deleteNamespace(WBEMClient pHandle, String pInteropNamespace, String pName) throws WBEMException {
        if (null != pName) {
            CloseableIterator i = pHandle.enumerateInstances(new CIMObjectPath("CIM_WBEMServerNamespace"), null);
            while (i.hasNext()) {
                CIMInstance ci = (CIMInstance)i.next();
                if (!pName.equals(ci.getPropertyValue("Name"))) continue;
                pHandle.deleteInstance(ci.getObjectPath());
            }
        }
    }

    public CIMInstance[] enumerateNamespaces(WBEMClient clientHandle, CIMObjectPath nsPath) throws WBEMException {
        ArrayList<Object> l = new ArrayList<Object>();
        CIMObjectPath opNamespace = new CIMObjectPath(nsPath.getScheme(), nsPath.getHost(), nsPath.getPort(), JServerProperties.getInteropNamespace(), "CIM_WBEMServerNamespace", null);
        try {
            CloseableIterator iterWSNS = clientHandle.enumerateInstances(opNamespace, null);
            while (iterWSNS.hasNext()) {
                l.add(iterWSNS.next());
            }
        }
        catch (Exception e) {
            opNamespace = new CIMObjectPath(nsPath.getScheme(), nsPath.getHost(), nsPath.getPort(), JServerProperties.getInteropNamespace(), "CIM_Namespace", null);
            CloseableIterator iterNS = clientHandle.enumerateInstances(opNamespace, null);
            while (iterNS.hasNext()) {
                l.add(iterNS.next());
            }
        }
        return l.toArray(new CIMInstance[l.size()]);
    }

    public static boolean namespaceExist(WBEMClient clientHandle, CIMObjectPath nsPath) {
        CIMObjectPath opNamespace = new CIMObjectPath(nsPath.getScheme(), nsPath.getHost(), nsPath.getPort(), JServerProperties.getInteropNamespace(), "CIM_WBEMServerNamespace", null);
        try {
            CloseableIterator iterWSNS = clientHandle.enumerateInstances(opNamespace, null);
            while (iterWSNS.hasNext()) {
                CIMInstance ci = (CIMInstance)iterWSNS.next();
                if (!nsPath.getNamespace().equals(ci.getPropertyValue("Name"))) continue;
                return true;
            }
        }
        catch (WBEMException wBEMException) {
            // empty catch block
        }
        return false;
    }
}

