/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem;

import com.ws.wbem.IndicationFilterParser;
import com.ws.wbem.IndicationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class IndicationManager {
    private final HashMap<String, IndicationFilterParser> mSupportedFilterQueriesMap;
    private final ProviderHandle mProviderHandle;
    private final String mClassname;
    private final Map<IndicationType, Map<String, ArrayList<CIMInstance>>> mActiveSubscriptions;
    protected final Logger mLogger;
    private long mSequenceNumber;
    private final Set<IndicationType> mEnabledIndicationTypes;

    public IndicationManager(ProviderHandle providerHandle, String classname) {
        this(providerHandle, classname, null);
    }

    public IndicationManager(ProviderHandle providerHandle, String classname, Logger logger) {
        this.mLogger = null == logger ? Logger.getLogger("com.ws.wbem.jserver") : logger;
        this.mProviderHandle = providerHandle;
        this.mClassname = classname;
        this.mActiveSubscriptions = Collections.synchronizedMap(new HashMap());
        this.mEnabledIndicationTypes = new HashSet<IndicationType>();
        for (IndicationType indicationType : IndicationType.values()) {
            if (indicationType == IndicationType.ClassCreation || indicationType == IndicationType.ClassDeletion || indicationType == IndicationType.ClassModification) continue;
            this.mActiveSubscriptions.put(indicationType, Collections.synchronizedMap(new HashMap()));
        }
        this.mSupportedFilterQueriesMap = new HashMap();
        this.mSequenceNumber = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateFilter(CIMInstance instFilter, CIMInstance instSubscription) throws WBEMException {
        boolean firstActivation = false;
        String query = ((String)instFilter.getPropertyValue("Query")).toLowerCase();
        IndicationType indicationType = null;
        IndicationFilterParser filterQuery = this.mSupportedFilterQueriesMap.get(query);
        if (null != filterQuery) {
            indicationType = filterQuery.getIndicationType();
        } else {
            indicationType = this.getDefaultEnabledIndicationType(query);
            if (null != indicationType) {
                this.registerSupportedFilterQuery(query);
            }
        }
        if (null != indicationType) {
            Map<String, ArrayList<CIMInstance>> subscriptionMap;
            Map<String, ArrayList<CIMInstance>> map = subscriptionMap = this.mActiveSubscriptions.get((Object)indicationType);
            synchronized (map) {
                ArrayList<Object> listSubscriptions = subscriptionMap.get(query);
                if (null == listSubscriptions) {
                    listSubscriptions = new ArrayList();
                    subscriptionMap.put(query, listSubscriptions);
                    firstActivation = true;
                }
                listSubscriptions.add(instSubscription);
            }
        } else {
            String info = "Could not activate filter \"" + query + "\" for class " + this.mClassname + "because this filter is not supported";
            throw new WBEMException(1, info);
        }
        return firstActivation;
    }

    public void addEnabledIndicationType(IndicationType indicationType) {
        this.mEnabledIndicationTypes.add(indicationType);
    }

    public void authorizeFilter(CIMInstance instFilter) throws WBEMException {
        String query = ((String)instFilter.getPropertyValue("Query")).toLowerCase();
        if (!this.mSupportedFilterQueriesMap.containsKey(query)) {
            if (null != this.getDefaultEnabledIndicationType(query)) {
                this.registerSupportedFilterQuery(query);
            } else {
                String info = "Could not authorize filter \"" + query + "\" for class " + this.mClassname;
                throw new WBEMException(1, info);
            }
        }
    }

    private String createIndicationIdentifier() {
        return "WS:" + UUID.randomUUID().toString();
    }

    public CIMInstance createIndicationInstance(String namespace, String classname, String indicationIdentifier, Integer perceivedSeverity, CIMInstance sourceInstance, CIMInstance prevInstance) {
        ArrayList<CIMProperty> propList = new ArrayList<CIMProperty>();
        propList.add(new CIMProperty("IndicationTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false));
        propList.add(new CIMProperty("SequenceNumber", CIMDataType.SINT64_T, (Object)this.mSequenceNumber++, false));
        if (null != indicationIdentifier) {
            propList.add(new CIMProperty("IndicationIdentifier", CIMDataType.STRING_T, (Object)indicationIdentifier, false));
        }
        if (null != perceivedSeverity) {
            propList.add(new CIMProperty("PerceivedSeverity", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(perceivedSeverity.intValue()), false));
        }
        if (null != sourceInstance) {
            propList.add(new CIMProperty("SourceInstance", CIMDataType.OBJECT_T, (Object)sourceInstance, false));
            if (null != sourceInstance.getObjectPath()) {
                propList.add(new CIMProperty("SourceInstanceModelPath", CIMDataType.STRING_T, (Object)sourceInstance.getObjectPath().toString(), false));
            }
        }
        if (null != prevInstance) {
            propList.add(new CIMProperty("PreviousInstance", CIMDataType.OBJECT_T, (Object)prevInstance, false));
        }
        CIMObjectPath op = new CIMObjectPath(null, null, null, namespace, classname, null);
        CIMProperty[] props = propList.toArray(new CIMProperty[propList.size()]);
        return new CIMInstance(op, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivateFilter(CIMInstance instFilter, CIMInstance instSubscription) throws WBEMException {
        boolean lastActivation = false;
        String query = ((String)instFilter.getPropertyValue("Query")).toLowerCase();
        IndicationType indicationType = null;
        IndicationFilterParser filterQuery = this.mSupportedFilterQueriesMap.get(query);
        indicationType = null != filterQuery ? filterQuery.getIndicationType() : this.getDefaultEnabledIndicationType(query);
        if (null != indicationType) {
            Map<String, ArrayList<CIMInstance>> subscriptionMap;
            Map<String, ArrayList<CIMInstance>> map = subscriptionMap = this.mActiveSubscriptions.get((Object)indicationType);
            synchronized (map) {
                ArrayList<CIMInstance> listSubscriptions = subscriptionMap.get(query);
                if (null != listSubscriptions) {
                    ArrayList<CIMInstance> arrayList = listSubscriptions;
                    synchronized (arrayList) {
                        for (int i = 0; i < listSubscriptions.size(); ++i) {
                            CIMInstance currentSubscription = listSubscriptions.get(i);
                            if (!currentSubscription.getObjectPath().equalsModelPath(instSubscription.getObjectPath())) continue;
                            listSubscriptions.remove(i);
                            if (!listSubscriptions.isEmpty()) break;
                            subscriptionMap.remove(query);
                            lastActivation = true;
                            break;
                        }
                    }
                } else {
                    String info = "Could not deactivate filter \"" + query + "\" for class " + this.mClassname + " because there are no active filters for this " + "subscription";
                    throw new WBEMException(1, info);
                }
            }
        } else {
            String info = "Could not deactivate filter \"" + query + "\" for class " + this.mClassname + " because this filter is not supported";
            throw new WBEMException(1, info);
        }
        return lastActivation;
    }

    public void deliverIndication(IndicationType indicationType, CIMInstance instIndication) {
        if (this.hasActiveSubscriptions(indicationType)) {
            Map<String, ArrayList<CIMInstance>> mapSubscriptions = this.mActiveSubscriptions.get((Object)indicationType);
            Set<Map.Entry<String, ArrayList<CIMInstance>>> entrySet = mapSubscriptions.entrySet();
            for (Map.Entry<String, ArrayList<CIMInstance>> entry : entrySet) {
                String query = entry.getKey();
                IndicationFilterParser filterQuery = this.mSupportedFilterQueriesMap.get(query);
                if (null == filterQuery || !filterQuery.matchIndication(instIndication)) continue;
                ArrayList listSubscriptions = new ArrayList(entry.getValue());
                this.mProviderHandle.deliverEvent(instIndication, listSubscriptions.toArray(new CIMInstance[listSubscriptions.size()]));
            }
        }
    }

    public void deliverInstanceIndication(IndicationType indicationType, CIMInstance sourceInstance, CIMInstance previousInstance) {
        this.deliverInstanceIndication(indicationType, this.createIndicationIdentifier(), null, sourceInstance, previousInstance);
    }

    public void deliverInstanceIndication(IndicationType indicationType, String indicationIdentifier, Integer perceivedSeverity, CIMInstance sourceInstance, CIMInstance previousInstance) {
        if (this.hasActiveSubscriptions(indicationType)) {
            if (null == sourceInstance) {
                this.mLogger.log(Level.WARNING, "Cannot deliver instance indication because specified sourceInstance is null");
            } else {
                CIMInstance instIndication = this.createIndicationInstance(sourceInstance.getObjectPath().getNamespace(), this.getIndicationClassName(indicationType, sourceInstance.getClassName()), indicationIdentifier, perceivedSeverity, sourceInstance, previousInstance);
                this.deliverIndication(indicationType, instIndication);
            }
        }
    }

    public void deliverProcessIndication(String namespace, String classname) {
        this.deliverProcessIndication(namespace, classname, this.createIndicationIdentifier(), null);
    }

    public void deliverProcessIndication(String namespace, String classname, String indicationIdentifier, Integer perceivedSeverity) {
        if (this.hasActiveSubscriptions(IndicationType.Process)) {
            CIMInstance instIndication = this.createIndicationInstance(namespace, classname, indicationIdentifier, perceivedSeverity, null, null);
            this.deliverIndication(IndicationType.Process, instIndication);
        }
    }

    private IndicationType getDefaultEnabledIndicationType(String query) {
        IndicationType indicationType;
        IndicationFilterParser filterQuery;
        IndicationType ret = null;
        if (!this.mEnabledIndicationTypes.isEmpty() && null != query && null != (filterQuery = new IndicationFilterParser(this.mProviderHandle, query)) && this.mEnabledIndicationTypes.contains((Object)(indicationType = filterQuery.getIndicationType()))) {
            ret = indicationType;
        }
        return ret;
    }

    private String getIndicationClassName(IndicationType indicationType, String classname) {
        String ret = "";
        if (null != indicationType) {
            switch (indicationType) {
                case InstanceCreation: {
                    ret = "CIM_InstCreation";
                    break;
                }
                case InstanceDeletion: {
                    ret = "CIM_InstDeletion";
                    break;
                }
                case InstanceModification: {
                    ret = "CIM_InstModification";
                    break;
                }
                case InstanceRead: {
                    ret = "CIM_InstRead";
                    break;
                }
                case ClassCreation: {
                    ret = "CIM_ClassCreation";
                    break;
                }
                case ClassDeletion: {
                    ret = "CIM_ClassDeletion";
                    break;
                }
                case ClassModification: {
                    ret = "CIM_ClassModification";
                    break;
                }
                case InstanceMethodCall: {
                    ret = classname;
                    break;
                }
                default: {
                    ret = "";
                }
            }
        }
        return ret;
    }

    public Set<String> getSupportedFilterQueries() {
        return this.mSupportedFilterQueriesMap.keySet();
    }

    public boolean hasActiveInstanceIndicationSubscriptions() {
        IndicationType[] instanceIndicationTypes;
        boolean ret = false;
        for (IndicationType indicationType : instanceIndicationTypes = new IndicationType[]{IndicationType.InstanceCreation, IndicationType.InstanceDeletion, IndicationType.InstanceModification, IndicationType.InstanceRead}) {
            if (this.mActiveSubscriptions.get((Object)indicationType).isEmpty()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean hasActiveSubscriptions() {
        boolean ret = false;
        for (IndicationType indicationType : IndicationType.values()) {
            if (this.mActiveSubscriptions.get((Object)indicationType).isEmpty()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean hasActiveSubscriptions(IndicationType indicationType) {
        boolean ret = false;
        if (null != indicationType) {
            ret = !this.mActiveSubscriptions.get((Object)indicationType).isEmpty();
        }
        return ret;
    }

    public void registerSupportedFilterQueries(String[] queries) {
        if (null != queries) {
            for (String query : queries) {
                this.registerSupportedFilterQuery(query);
            }
        }
    }

    public void registerSupportedFilterQuery(String query) {
        if (null != query) {
            String newQuery = query.toLowerCase();
            this.mSupportedFilterQueriesMap.put(newQuery, new IndicationFilterParser(this.mProviderHandle, newQuery));
        } else {
            this.mLogger.log(Level.WARNING, "Tried to register null filter query for class {0}", this.mClassname);
        }
    }

    public void removeEnabledIndicationType(IndicationType indicationType) {
        this.mEnabledIndicationTypes.remove((Object)indicationType);
    }
}

