/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.common;

import com.ws.wbem.client.adapter.common.LoggingInputStream;
import com.ws.wbem.client.adapter.common.LoggingOutputStream;
import com.ws.wbem.client.adapter.common.WBEMClientLogger;
import com.ws.wbem.client.adapter.common.WSSSLSocketFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMObjectPath;
import javax.net.ssl.HttpsURLConnection;
import javax.security.auth.Subject;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.client.WBEMClient;
import sun.net.www.protocol.http.AuthCache;
import sun.net.www.protocol.http.AuthCacheImpl;
import sun.net.www.protocol.http.AuthCacheValue;

public abstract class HTTPClient {
    private final WBEMClientLogger mClientLogger;
    private final ThreadLocal<HttpURLConnection> mHTTPConnection;
    private final ThreadLocal<LoggingOutputStream> mOut;
    private final ThreadLocal<LoggingInputStream> mIn;
    private URL mURL;
    private boolean mCloseCalled = false;
    protected Locale[] mLocales;
    private PasswordAuthentication mPA = null;
    private final Logger mLogger = Logger.getLogger("com.ws.wbem.client");
    private WSSSLSocketFactory sslFactory = null;

    public HTTPClient() {
        this.mHTTPConnection = new ThreadLocal();
        this.mOut = new ThreadLocal();
        this.mIn = new ThreadLocal();
        this.mClientLogger = new WBEMClientLogger();
        HttpURLConnection.setFollowRedirects(false);
        if (null == System.getProperty("http.maxRedirects")) {
            System.setProperty("http.maxRedirects", "5");
        }
    }

    public void addHeader(String key, String value) throws IllegalStateException, NullPointerException {
        this.getConnection().addRequestProperty(key, value);
    }

    private void checkHTTPReturnCode(HttpURLConnection conn) throws IOException, WBEMException {
        int retCode = conn.getResponseCode();
        if (retCode > 210) {
            if (401 == retCode) {
                throw WBEMOperationErrors.getAccessDeniedException();
            }
            throw new WBEMException(1, "Server responded with: " + retCode + " " + conn.getResponseMessage());
        }
    }

    public final void connect(String contentType, URL url) throws IOException, WBEMException {
        if (this.isClosed()) {
            throw new WBEMException("Close() has been called on WBEMClient, you must recall initialize after you call close()!");
        }
        try {
            if (null == url) {
                this.mHTTPConnection.set((HttpURLConnection)this.mURL.openConnection());
            } else {
                this.mHTTPConnection.set((HttpURLConnection)url.openConnection());
            }
            HttpURLConnection conn = this.getConnection();
            if (null != this.sslFactory) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslFactory);
                ((HttpsURLConnection)conn).setHostnameVerifier(this.sslFactory.getLocalHostnameVerifier());
            }
            this.setRequestMethod(conn);
            conn.setUseCaches(false);
            conn.addRequestProperty("Content-Type", contentType);
            conn.addRequestProperty("User-Agent", this.getUserAgentValue());
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
    }

    public void connectionDone() {
        Closeable stream;
        try {
            stream = this.mOut.get();
            if (null != stream) {
                this.mOut.set(null);
                stream.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            stream = this.mIn.get();
            if (null != stream) {
                this.mIn.set(null);
                stream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void disconnect() {
        this.mCloseCalled = true;
        this.mPA = null;
        HttpURLConnection conn = this.getConnection();
        if (null != conn) {
            conn.disconnect();
        }
        this.mHTTPConnection.set(null);
    }

    public WBEMClientLogger getClientLogger() {
        return this.mClientLogger;
    }

    private HttpURLConnection getConnection() {
        return this.mHTTPConnection.get();
    }

    protected abstract String getDefaultHTTPPort();

    protected abstract String getDefaultHTTPSPort();

    public InputStream getErrorStream() {
        HttpURLConnection conn = this.getConnection();
        InputStream ret = conn.getErrorStream();
        LoggingInputStream retVal = new LoggingInputStream(ret);
        this.mIn.set(retVal);
        return retVal;
    }

    public String getHeader(String name) {
        return this.getConnection().getHeaderField(name);
    }

    public int getHTTPReturnCode() throws IOException {
        HttpURLConnection conn = this.getConnection();
        return conn.getResponseCode();
    }

    public InputStream getInputStream() throws IOException, WBEMException {
        HttpURLConnection conn = this.getConnection();
        if (this.mLogger.isLoggable(Level.FINEST)) {
            StringBuffer b = new StringBuffer();
            Map<String, List<String>> m = conn.getHeaderFields();
            Iterator<Map.Entry<String, List<String>>> i = m.entrySet().iterator();
            while (i.hasNext()) {
                b.append(i.next().toString());
                b.append("\n");
            }
            this.mLogger.finest(b.toString());
        }
        InputStream ret = null;
        this.checkHTTPReturnCode(conn);
        ret = this.mIn.get();
        if (null == ret) {
            ret = conn.getInputStream();
        }
        LoggingInputStream retVal = new LoggingInputStream(ret);
        this.mIn.set(retVal);
        return retVal;
    }

    protected String getLocaleString() {
        String localeStr = null;
        try {
            if (null == this.mLocales) {
                return "*";
            }
            if (this.mLocales.length > 0) {
                localeStr = "";
            }
            for (int x = 0; x < this.mLocales.length; ++x) {
                String lang;
                if (null == localeStr) {
                    localeStr = "";
                }
                if ((lang = this.mLocales[x].getLanguage()).isEmpty()) continue;
                localeStr = localeStr.concat(lang);
                if (!this.mLocales[x].getCountry().isEmpty()) {
                    localeStr = localeStr.concat("-");
                    localeStr = localeStr.concat(this.mLocales[x].getCountry());
                }
                if (x >= this.mLocales.length - 1) continue;
                localeStr = localeStr.concat(", ");
            }
            if (null != localeStr && localeStr.indexOf(42) == -1) {
                localeStr = localeStr.concat(", *");
            }
        }
        catch (Exception e) {
            localeStr = "*";
        }
        return localeStr;
    }

    public LoggingOutputStream getOutputStream() throws IOException {
        LoggingOutputStream retVal = this.mOut.get();
        if (null == retVal) {
            HttpURLConnection conn = this.getConnection();
            OutputStream ret = conn.getOutputStream();
            retVal = new LoggingOutputStream(ret);
            this.mOut.set(retVal);
        }
        return retVal;
    }

    protected abstract String getProtocolPath();

    public HTTPRequestMethods getRequestMethod() {
        return HTTPRequestMethods.POST;
    }

    private String getUserAgentValue() {
        return WBEMClient.class.getPackage().getImplementationTitle() + WBEMClient.class.getPackage().getImplementationVersion();
    }

    protected void initializeClient(CIMObjectPath name, Subject subject, Properties clientSettings) throws WBEMException {
        this.mCloseCalled = false;
        String scheme = name.getScheme();
        if (scheme == null || scheme.length() == 0) {
            scheme = "https";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(name.getHost());
        buffer.append(':');
        String port = name.getPort();
        if (port == null || port.length() == 0) {
            port = scheme.toLowerCase().equals("https") ? this.getDefaultHTTPSPort() : this.getDefaultHTTPPort();
        }
        buffer.append(port);
        buffer.append(this.getProtocolPath());
        try {
            this.initializeClient(new URL(buffer.toString()), subject, clientSettings);
        }
        catch (MalformedURLException ex) {
            throw new WBEMException(1, ex.toString(), null, (Throwable)ex);
        }
    }

    protected void initializeClient(URL theURL, Subject subject) throws WBEMException {
        this.initializeClient(theURL, subject, null);
    }

    protected void initializeClient(URL theURL, Subject subject, Properties clientSettings) throws WBEMException {
        String protocols = null;
        String keystore = null;
        String keystorePwd = null;
        String truststore = null;
        String ciphers = null;
        if (null != clientSettings) {
            keystore = clientSettings.getProperty("javax.wbem.client.keyStore");
            keystorePwd = clientSettings.getProperty("javax.wbem.client.keyStorePassword");
            truststore = clientSettings.getProperty("javax.wbem.client.trustStore");
            ciphers = clientSettings.getProperty("javax.wbem.client.ciphers");
            protocols = clientSettings.getProperty("https.protocols");
            if (null != protocols) {
                System.setProperty("https.protocols", protocols);
            }
            if (null != clientSettings.getProperty("javax.wbem.client.timeout")) {
                System.setProperty("sun.net.client.defaultReadTimeout", clientSettings.getProperty("javax.wbem.client.timeout"));
            }
        }
        this.initializeClient(theURL, subject, keystore, keystorePwd, truststore, null != ciphers ? ciphers.split("\\s*,\\s*") : null);
    }

    protected void initializeClient(URL theURL, Subject subject, String keystore, String keystorePwd, String truststore, String[] ciphers) throws WBEMException {
        this.mCloseCalled = false;
        this.mURL = theURL;
        this.setCredentials(subject);
        if ("https".equalsIgnoreCase(this.mURL.getProtocol())) {
            try {
                this.sslFactory = new WSSSLSocketFactory(keystore, keystorePwd, truststore, ciphers, null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new WBEMException(1, e.toString(), null, (Throwable)e);
            }
        }
    }

    private synchronized boolean isClosed() {
        return this.mCloseCalled;
    }

    private void setCredentials(Subject subject) {
        AuthCacheValue.setAuthCache((AuthCache)new AuthCacheImpl());
        if (null != subject) {
            Set<UserPrincipal> sUP = subject.getPrincipals(UserPrincipal.class);
            Iterator<UserPrincipal> iUP = sUP.iterator();
            UserPrincipal userPrinciple = null;
            while (iUP.hasNext()) {
                userPrinciple = iUP.next();
            }
            Set<PasswordCredential> sPC = subject.getPrivateCredentials(PasswordCredential.class);
            Iterator<PasswordCredential> iSP = sPC.iterator();
            PasswordCredential pc = null;
            while (iSP.hasNext()) {
                pc = iSP.next();
            }
            this.mPA = new PasswordAuthentication(null == userPrinciple ? null : userPrinciple.getUserName(), null == pc ? new char[]{} : pc.getUserPassword());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return HTTPClient.this.mPA;
                }
            });
        } else {
            this.mPA = null;
        }
    }

    private void setRequestMethod(HttpURLConnection conn) throws WBEMException {
        HTTPRequestMethods mthd = this.getRequestMethod();
        try {
            conn.setRequestMethod(mthd.toString());
            if (HTTPRequestMethods.POST == mthd) {
                conn.setDoOutput(true);
            }
        }
        catch (ProtocolException e) {
            throw new WBEMException(1, "Unable to set HTTP request method.", null, (Throwable)e);
        }
    }

    public static enum HTTPRequestMethods {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        DELETE,
        TRACE;

    }
}

