/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.Encryption.data;

import java.util.ArrayList;
import java.util.Date;
import sanproject.client.Encryption.RJEncPanel;
import sanproject.client.Encryption.com.RJEncMacro;
import sanproject.client.Encryption.data.RJEncApply;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcAbsDataSupplier;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataMsg;
import sanproject.serverux.dataimpl.DISKgetSubsystemInfo;
import sanproject.serverux.dataimpl.DKCgetEncryptionKeyInfo;
import sanproject.serverux.dataimpl.DKCgetEncryptionKeyInfo_IN;
import sanproject.serverux.dataimpl.DKCgetEncryptionKeyInfo_OUT;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class RJEncDataSupplier
extends RJcAbsDataSupplier
implements RJEncMacro {
    private RJEncPanel m_EncPanel;
    private DISKgetSubsystemInfo m_SubsystemInfo;
    private DKCgetEncryptionKeyInfo[] m_KeyInfo;
    private RJEncApply m_ApplyData;
    private ArrayList m_ErrList;

    public RJEncDataSupplier(RJDataControl rJDataControl, RJEncPanel rJEncPanel) {
        super(rJDataControl);
        this.m_EncPanel = rJEncPanel;
        this.m_ApplyData = new RJEncApply(this);
    }

    public void getSubsystemInfo() throws RJDataException {
        try {
            this.putLog("[Encryption]", "", "getSubsystemInfo Start");
            this.waitControl();
            this.controller.getSubsystemInfo();
            this.controller.waitDC();
            this.m_ErrList = this.controller.getEndStatus();
            if ((Integer)this.m_ErrList.get(0) != 0) {
                int n = (Integer)this.m_ErrList.get(0);
                int n2 = (Integer)this.m_ErrList.get(1);
                RJDataException rJDataException = new RJDataException(n, n2);
                throw rJDataException;
            }
            this.m_SubsystemInfo = this.controller.getSubsystemClass();
            this.putLog("[Encryption]", "", "getSubsystemInfo End");
        }
        catch (RJDataException rJDataException) {
            int[] nArray = rJDataException.getErrInfo();
            this.showErrMsg(nArray[0], nArray[1]);
            throw rJDataException;
        }
    }

    public void getEncryptionKeyInfo() throws RJDataException {
        try {
            this.putLog("[Encryption]", "", "getEncryptionKeyInfo(): Start");
            DKCgetEncryptionKeyInfo_IN dKCgetEncryptionKeyInfo_IN = new DKCgetEncryptionKeyInfo_IN();
            this.waitControl();
            this.controller.getDataInfEx((SanRmiInputInterface)dKCgetEncryptionKeyInfo_IN);
            this.controller.waitDC();
            ArrayList arrayList = this.controller.getEndStatus();
            if ((Integer)arrayList.get(0) != 0) {
                int n = (Integer)arrayList.get(0);
                int n2 = (Integer)arrayList.get(1);
                RJDataException rJDataException = new RJDataException(n, n2);
                throw rJDataException;
            }
            DKCgetEncryptionKeyInfo_OUT dKCgetEncryptionKeyInfo_OUT = (DKCgetEncryptionKeyInfo_OUT)this.controller.getDataInfExData();
            this.m_KeyInfo = dKCgetEncryptionKeyInfo_OUT.getDataObject();
            this.putLog("[Encryption]", "", "getEncryptionKeyInfo(): End");
        }
        catch (RJDataException rJDataException) {
            int[] nArray = rJDataException.getErrInfo();
            this.showErrMsg(nArray[0], nArray[1]);
            throw rJDataException;
        }
    }

    public void showErrMsg(int n, int n2) {
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, n, n2);
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
        int n3 = super.showMessage(super.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        RJComFuncPanel rJComFuncPanel = (RJComFuncPanel)this.getParentPanel();
        rJComFuncPanel.endRequest(rJDataMsg.getErrorLevel());
    }

    public String getDeviceName() {
        return this.m_SubsystemInfo.strDKCsysName;
    }

    public String getSerialNum() {
        Integer n = new Integer(this.m_SubsystemInfo.nDKCSerialNumber);
        return n.toString();
    }

    public void setBackupData(String string) {
        this.m_ApplyData.setBackupData(string);
    }

    public boolean setRestoreData(String string, String string2) {
        return this.m_ApplyData.setRestoreData(string, string2);
    }

    public void setApplyData() {
        this.m_ApplyData.setApplyData();
    }

    public void clearApplyData() {
        this.m_ApplyData.clearApplyData();
    }

    public boolean isEDKA() {
        boolean bl = false;
        if (this.m_KeyInfo.length > 0) {
            bl = true;
        }
        return bl;
    }

    public Date getKeyCreateDate() {
        Date date = null;
        if (this.m_KeyInfo.length > 0 && this.m_KeyInfo[0].getIKeyCreateCount() > 0) {
            date = this.m_KeyInfo[0].getDaKeyCreateDate();
        }
        return date;
    }

    public int getKeyCreateCount() {
        int n = 0;
        if (this.m_KeyInfo.length > 0) {
            n = this.m_KeyInfo[0].getIKeyCreateCount();
        }
        return n;
    }

    public int getKeyBackupCount() {
        int n = 0;
        if (this.m_KeyInfo.length > 0) {
            n = this.m_KeyInfo[0].iKeyBackupCount;
        }
        return n;
    }
}

