/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.abs;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.abs.RJaDataModel;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.com.abs.RJaTable;
import sanproject.client.com.abs.RJaTableColumn;
import sanproject.client.com.abs.RJaTableColumnGroup;
import sanproject.client.com.abs.RJaTableManager;

public abstract class RJaTableDataModel
extends RJaDataModel {
    protected RJaTableManager manager;
    protected TableColumnModel rhColumnModel = null;
    private int rhColumnIndex = 0;
    protected TableColumnModel vpColumnModel = new InnerTableColumnModel();
    private int vpColumnIndex = 0;
    protected ArrayList vpColumnGroups = null;
    private int headerMode = 1;
    private int autoResizeMode = 2;
    public static final int DEFAULT_WIDTH = 0;
    public static final int COL_MARGIN = 20;
    private boolean servile = true;
    private boolean sorting = false;
    private RJaTableColumnGroup currentGroup = null;
    private int remain = 0;
    private boolean headerPush = true;
    private int pageTopRow = 0;
    private int pageRowCount = -1;

    public RJaTableDataModel() {
        this.defineTable();
    }

    public void setTable(RJaTableManager rJaTableManager) {
        this.manager = rJaTableManager;
    }

    protected abstract void defineTable();

    protected void addRHColumnInfo(String string, Object object, int n, Object object2, boolean bl, int n2) {
        this.addRHColumnInfo(string, object, n, object2, bl, n2, null);
    }

    protected void addRHColumnInfo(String string, Object object, int n, Object object2, boolean bl, int n2, DefaultTableCellRenderer defaultTableCellRenderer) {
        if (this.rhColumnModel == null) {
            this.rhColumnModel = new DefaultTableColumnModel();
        }
        TableColumn tableColumn = this.createTableColumn(this.rhColumnIndex, string, object, n, object2, bl, n2, defaultTableCellRenderer);
        this.rhColumnModel.addColumn(tableColumn);
        if (this.remain > 0) {
            this.currentGroup.add(tableColumn);
            --this.remain;
        }
        ++this.rhColumnIndex;
    }

    protected void addColumnInfo(String string, Object object, int n, Object object2, boolean bl, int n2) {
        this.addColumnInfo(string, object, n, object2, bl, n2, null);
    }

    protected void addColumnInfo(String string, Object object, int n, Object object2, boolean bl, int n2, DefaultTableCellRenderer defaultTableCellRenderer) {
        TableColumn tableColumn = this.createTableColumn(this.vpColumnIndex, string, object, n, object2, bl, n2, defaultTableCellRenderer);
        this.vpColumnModel.addColumn(tableColumn);
        if (this.remain > 0) {
            this.currentGroup.add(tableColumn);
            --this.remain;
        }
        ++this.vpColumnIndex;
    }

    private TableColumn createTableColumn(int n, String string, Object object, int n2, Object object2, boolean bl, int n3, DefaultTableCellRenderer defaultTableCellRenderer) {
        RJaTableColumn rJaTableColumn = new RJaTableColumn(n, string, object, n2, object2, bl, n3, defaultTableCellRenderer);
        rJaTableColumn.setHeaderPush(this.headerPush);
        this.columnNames.addKey(string);
        return rJaTableColumn;
    }

    protected void setSpecialHeader(String string, String string2, int n) {
        RJaTableColumn rJaTableColumn = this.getVPTableColumn(string, 0);
        if (rJaTableColumn != null) {
            this.currentGroup = new RJaTableColumnGroup(string, string2);
            this.currentGroup.add(rJaTableColumn);
            this.remain = n - 1;
            for (int i = 1; i < n; ++i) {
                rJaTableColumn = this.getVPTableColumn(string, i);
                if (rJaTableColumn == null) continue;
                this.currentGroup.add(rJaTableColumn);
                --this.remain;
            }
            if (this.vpColumnGroups == null) {
                this.vpColumnGroups = new ArrayList();
            }
            this.vpColumnGroups.add(this.currentGroup);
        }
    }

    public ArrayList getVPColumnGroup() {
        return this.vpColumnGroups;
    }

    private RJaTableColumn getVPTableColumn(String string, int n) {
        RJaTableColumn rJaTableColumn = null;
        try {
            int n2 = this.vpColumnModel.getColumnIndex(string);
            if (n2 + n < this.vpColumnModel.getColumnCount()) {
                rJaTableColumn = (RJaTableColumn)this.vpColumnModel.getColumn(n2 + n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return rJaTableColumn;
    }

    public RJaTableColumnGroup getTableColumnGroup(String string) {
        RJaTableColumnGroup rJaTableColumnGroup;
        int n;
        RJaTableColumnGroup rJaTableColumnGroup2 = null;
        if (this.vpColumnGroups != null && (n = this.vpColumnGroups.indexOf(rJaTableColumnGroup = new RJaTableColumnGroup(string, null))) != -1) {
            rJaTableColumnGroup2 = (RJaTableColumnGroup)this.vpColumnGroups.get(n);
        }
        return rJaTableColumnGroup2;
    }

    public RJaTableColumn getTableColumn(String string) {
        int n;
        RJaTableColumn rJaTableColumn = null;
        if (this.rhColumnModel != null) {
            try {
                n = this.rhColumnModel.getColumnIndex(string);
                rJaTableColumn = (RJaTableColumn)this.rhColumnModel.getColumn(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (rJaTableColumn == null) {
            try {
                n = this.vpColumnModel.getColumnIndex(string);
                rJaTableColumn = (RJaTableColumn)this.vpColumnModel.getColumn(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return rJaTableColumn;
    }

    public int getMaxWidth(String string) {
        RJaTable rJaTable = this.manager.getTable();
        RJaTableColumn rJaTableColumn = this.getTableColumn(string);
        int n = rJaTableColumn.getPreferredWidth();
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            String string2 = new String("");
            Object object = this.getValueAt(i, string);
            if (object != null) {
                string2 = object.toString();
            }
            if ((n3 = this.manager.getFontMetrics(rJaTable.getFont()).stringWidth(string2) + 1) <= n) continue;
            n = n3;
        }
        return n;
    }

    public void setColumnWidth(String string, int n) {
        RJaTableColumn rJaTableColumn = this.getTableColumn(string);
        rJaTableColumn.setPreferredWidth(n);
    }

    protected int getHeaderMode() {
        return this.headerMode;
    }

    protected void setHeaderMode(int n) {
        this.headerMode = n;
    }

    public TableColumnModel getRHColumnModel() {
        return this.rhColumnModel;
    }

    public TableColumnModel getVPColumnModel() {
        return this.vpColumnModel;
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setHeaderPush(boolean bl) {
        RJaTableColumn rJaTableColumn;
        int n;
        this.headerPush = bl;
        if (this.rhColumnModel != null) {
            for (n = 0; n < this.rhColumnModel.getColumnCount(); ++n) {
                rJaTableColumn = (RJaTableColumn)this.rhColumnModel.getColumn(n);
                rJaTableColumn.setHeaderPush(bl);
            }
        }
        if (this.vpColumnModel != null) {
            for (n = 0; n < this.vpColumnModel.getColumnCount(); ++n) {
                rJaTableColumn = (RJaTableColumn)this.vpColumnModel.getColumn(n);
                rJaTableColumn.setHeaderPush(bl);
            }
        }
    }

    public boolean isHeaderPush() {
        return this.headerPush;
    }

    protected void setAutoResizeMode(int n) {
        this.autoResizeMode = n;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public boolean isCellEditable(int n, Object object, boolean bl) {
        return bl;
    }

    protected void tbMouseClicked(MouseEvent mouseEvent, Object object) {
    }

    protected void tbMousePressed(MouseEvent mouseEvent, Object object) {
    }

    protected void tbMouseReleased(MouseEvent mouseEvent, Object object) {
    }

    protected void thMouseClicked(MouseEvent mouseEvent, Object object) {
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = null;
        return point;
    }

    public RJaDataModelEntry setRow(int n, RJaDataModelEntry rJaDataModelEntry) {
        RJaDataModelEntry rJaDataModelEntry2 = super.setRow(n, rJaDataModelEntry);
        if (this.isAvailRow(n)) {
            this.refresh();
        }
        return rJaDataModelEntry2;
    }

    public void addRow(RJaDataModelEntry rJaDataModelEntry) {
        super.addRow(rJaDataModelEntry);
        this.refresh();
    }

    public void remove() {
        int[] nArray = this.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.remove(nArray[i]);
        }
        this.clearSelection();
    }

    public RJaDataModelEntry remove(int n) {
        RJaDataModelEntry rJaDataModelEntry = null;
        if (this.isAvailRow(n)) {
            rJaDataModelEntry = super.remove(n);
            if (this.manager != null) {
                ListSelectionModel listSelectionModel = this.manager.getVPTable().getSelectionModel();
                listSelectionModel.removeSelectionInterval(n, n);
            }
            this.refresh();
        }
        return rJaDataModelEntry;
    }

    public void removeAll() {
        super.removeAll();
        this.clearSelection();
        this.refresh();
    }

    public int getSelectedRow() {
        return this.manager.getTable().getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.manager.getTable().getSelectedRows();
    }

    public void clearSelection() {
        this.manager.getTable().clearSelection();
    }

    public void sort(Vector vector, int n) {
        if (this.servile) {
            this.servileSort(vector, n);
        } else {
            super.sort(vector, n);
        }
    }

    private void servileSort(Vector vector, int n) {
        this.sorting = true;
        ListSelectionModel listSelectionModel = this.manager.getTable().getSelectionModel();
        if (listSelectionModel != null) {
            int n2;
            int n3 = listSelectionModel.getAnchorSelectionIndex();
            RJaDataModelEntry rJaDataModelEntry = null;
            if (n3 >= 0) {
                rJaDataModelEntry = this.getRow(n3);
            }
            int n4 = listSelectionModel.getMinSelectionIndex();
            int n5 = listSelectionModel.getMaxSelectionIndex();
            if (n4 != -1 && n5 != -1) {
                int n6;
                n2 = 0;
                RJaDataModelEntry[] rJaDataModelEntryArray = new RJaDataModelEntry[1 + (n5 - n4)];
                for (n6 = n4; n6 <= n5; ++n6) {
                    if (!listSelectionModel.isSelectedIndex(n6)) continue;
                    rJaDataModelEntryArray[n2++] = this.getRow(n6);
                }
                super.sort(vector, n);
                listSelectionModel.clearSelection();
                for (n6 = 0; n6 < n2; ++n6) {
                    int n7 = this.rows.indexOf(rJaDataModelEntryArray[n6]);
                    if (n7 < 0) continue;
                    listSelectionModel.addSelectionInterval(n7, n7);
                }
            } else {
                super.sort(vector, n);
            }
            if (rJaDataModelEntry != null && (n2 = this.rows.indexOf(rJaDataModelEntry)) >= 0) {
                listSelectionModel.setAnchorSelectionIndex(n2);
            }
        } else {
            super.sort(vector, n);
        }
        this.sorting = false;
    }

    public boolean isSorting() {
        return this.sorting;
    }

    public boolean isServileSort() {
        return this.servile;
    }

    public void setServileSort(boolean bl) {
        this.servile = bl;
    }

    public int getVisibleRowCount() {
        int n = this.getRowCount();
        if (this.pageRowCount >= 0) {
            n -= this.pageTopRow;
            n = Math.min(n, this.pageRowCount);
        }
        return n;
    }

    public int getPageTopRow() {
        int n = this.pageTopRow;
        return n;
    }

    public int getPageRowCount() {
        int n = this.getRowCount();
        if (this.pageRowCount >= 0) {
            n = this.pageRowCount;
        }
        return n;
    }

    public void setPageRowCount(int n) {
        this.pageRowCount = n;
    }

    public int convertRowIndexToView(int n) {
        int n2 = n - this.pageTopRow;
        return n2;
    }

    public int convertRowIndexToModel(int n) {
        int n2 = n + this.pageTopRow;
        return n2;
    }

    public boolean hasPreviousPage() {
        boolean bl = false;
        if (this.pageTopRow - this.getPageRowCount() >= 0) {
            bl = true;
        }
        return bl;
    }

    public boolean hasNextPage() {
        boolean bl = false;
        if (this.pageTopRow + this.getPageRowCount() < this.getRowCount()) {
            bl = true;
        }
        return bl;
    }

    public void previousPage() {
        if (this.hasPreviousPage()) {
            this.pageTopRow -= this.getPageRowCount();
            this.refresh();
        }
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            this.pageTopRow += this.getPageRowCount();
            this.refresh();
        }
    }

    public void absolutePage(int n) {
        int n2 = this.getRowCount();
        int n3 = this.getPageRowCount();
        if (n2 != 0 && n3 != 0) {
            int n4 = n < 0 ? 0 : (n < n2 ? n : n2 - 1);
            this.pageTopRow = n4 / n3 * n3;
        } else {
            this.pageTopRow = 0;
        }
        this.refresh();
    }

    protected void refresh() {
        if (this.manager != null) {
            this.manager.refresh();
        }
    }

    public void print() {
        super.print();
    }

    class InnerTableColumnModel
    extends DefaultTableColumnModel {
        InnerTableColumnModel() {
        }

        public TableColumn getColumn(int n) {
            TableColumn tableColumn = new TableColumn();
            if (n < this.getColumnCount()) {
                tableColumn = super.getColumn(n);
            }
            return tableColumn;
        }
    }
}

