/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.email;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RJEmailTextField
extends JTextField
implements DocumentListener,
FocusListener {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final short ALPHABETIC = 1;
    public static final short NUMERIC = 2;
    public static final short HEXADECIMAL = 4;
    public static final short ALL_MARK = 8;
    public static final short MAIL_MARK = 16;
    public static final short MAILADDRESS = 19;
    public static final short HOSTNAME = 11;
    public static final short IPv4ADDRESS = 2;
    public static final short IPv6ADDRESS = 4;
    public static final short ACCOUNT = 11;
    private char[] ACCOUNT_NG_CHARACTERS = new char[]{'\"', '\\', ';', ':', ',', '*', '?', '<', '>', '|', '/', '#', '&', '+', '=', '[', ']', '\'', '{', '}', '^', ' '};
    private char[] ADDRESS_OK_CHARACTERS = new char[]{'@', '!', '#', '$', '%', '&', '`', '+', '-', '*', '/', '\'', '^', '{', '}', '_', '.'};
    private RJEmailTextField textField = this;
    private boolean editChk = false;
    private boolean updFlg = false;
    static final int MAX_LEN = 65536;
    private int min = 0;
    private int max = 65536;
    private short chkStr = 0;
    private KeyListener keyListener = null;
    private boolean bUseBlueFont = true;
    private String initText = null;
    private boolean validText = true;

    public RJEmailTextField(short s) {
        this.setHorizontalAlignment(2);
        this.setForeground(Color.black);
        this.setFont(this.getFont().deriveFont(11.0f));
        this.setEditChk(true);
        this.setUpdFlg(true);
        this.setChkStr(s);
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
    }

    protected Document createDefaultModel() {
        return new EmailDocument();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    public void update() {
        String string = this.getText();
        this.validText = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN) continue;
            this.validText = false;
            break;
        }
        if (this.textField.initText != null && this.textField.initText.equals(this.textField.getText())) {
            this.textField.setForeground(Color.black);
            this.textField.setUpdFlg(false);
        } else {
            this.textField.setForeground(Color.blue);
            this.textField.setUpdFlg(true);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.isValidText()) {
            if (this.chkStr == 4) {
                this.setText(this.getText().toUpperCase());
            }
            if (this.chkStr == 2 && this.getText() != null && !this.getText().equals("")) {
                Integer n = new Integer(this.getText());
                this.setText(n.toString());
            }
        }
    }

    public RJEmailTextField(short s, int n) {
        this(s);
        this.setMaxLen(n);
    }

    public void setField(int n) {
        this.setMaxLen(n);
    }

    public void setText(String string, boolean bl) {
        super.setText(string);
        if (bl) {
            this.setForeground(Color.black);
            this.setUpdFlg(false);
            this.initText = string;
        }
    }

    public void setText(String string) {
        this.setText(string, false);
    }

    public long getValue() {
        long l = 0L;
        return l;
    }

    public void setValue(long l) {
    }

    public boolean isValidText() {
        return this.validText;
    }

    public void setEditChk(boolean bl) {
        this.editChk = bl;
    }

    public void setMaxLen(int n) {
        this.max = n > 65536 ? 65536 : (n < this.min ? this.min : n);
    }

    public void setMinLen(int n) {
        this.min = n < 0 ? 0 : (n > this.max ? this.max : n);
    }

    public void setUpdFlg(boolean bl) {
        if (bl) {
            this.setFont(new Font(this.getFont().getName(), 3, this.getFont().getSize()));
        } else {
            this.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
        }
        this.updFlg = bl;
    }

    public boolean getUpdFlg() {
        return this.updFlg;
    }

    public void setChkStr(short s) {
        this.chkStr = s;
    }

    public void setUseBlueFont(boolean bl) {
        this.bUseBlueFont = bl;
    }

    public boolean isUseBlueFont() {
        return this.bUseBlueFont;
    }

    private KeyListener makeLister() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                RJEmailTextField.this.textField_keyPressed(keyEvent);
            }
        };
    }

    private void textField_keyPressed(KeyEvent keyEvent) {
        if (!this.isEditable()) {
            keyEvent.consume();
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 8) {
            if (this.getCaretPosition() - 1 >= 0) {
                this.setForeground(Color.blue);
                this.setUpdFlg(true);
            }
            return;
        }
        if (n == 127) {
            if (this.getCaretPosition() == this.getText().length()) {
                keyEvent.consume();
                return;
            }
        } else {
            if (n == 10) {
                keyEvent.consume();
                return;
            }
            return;
        }
        this.setForeground(Color.blue);
        this.setUpdFlg(true);
    }

    protected class EmailDocument
    extends PlainDocument {
        protected EmailDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && !string.equals("")) {
                int n2 = 0;
                if (attributeSet == null) {
                    for (n2 = 0; n2 < string.length(); ++n2) {
                        char c = string.charAt(n2);
                        if (Character.UnicodeBlock.of(c) != Character.UnicodeBlock.BASIC_LATIN) {
                            string = string.substring(0, n2);
                            break;
                        }
                        if (this.checkCharacter(c) == 0 && this.checkLengthOver(n2)) continue;
                        string = string.substring(0, n2);
                        break;
                    }
                    RJEmailTextField.this.validText = true;
                } else {
                    for (n2 = 0; n2 < string.length(); ++n2) {
                        char c = string.charAt(n2);
                        if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN) continue;
                        RJEmailTextField.this.validText = false;
                        break;
                    }
                }
                super.insertString(n, string, attributeSet);
            }
        }

        public int checkCharacter(char c) {
            int n = -1;
            n = RJEmailTextField.this.chkStr != 0 ? this.customCharCheck(c) : 0;
            return n;
        }

        public int customCharCheck(char c) {
            int n = -1;
            if ((RJEmailTextField.this.chkStr & 1) == 1 && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                n = 0;
            }
            if ((RJEmailTextField.this.chkStr & 2) == 2 && c >= '0' && c <= '9') {
                n = 0;
            }
            if ((RJEmailTextField.this.chkStr & 4) == 4 && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9')) {
                n = 0;
            }
            if ((RJEmailTextField.this.chkStr & 8) == 8 && n != 0 && this.accountCharCheck(c) == 0) {
                n = 0;
            }
            if ((RJEmailTextField.this.chkStr & 0x10) == 16 && n != 0 && this.addressCharCheck(c) == 0) {
                n = 0;
            }
            return n;
        }

        public int accountCharCheck(char c) {
            int n = -1;
            boolean bl = false;
            for (int i = 0; RJEmailTextField.this.ACCOUNT_NG_CHARACTERS.length > i; ++i) {
                if (RJEmailTextField.this.ACCOUNT_NG_CHARACTERS[i] != c) continue;
                bl = true;
                break;
            }
            if (!bl) {
                n = 0;
            }
            return n;
        }

        public int addressCharCheck(char c) {
            int n = -1;
            boolean bl = false;
            for (int i = 0; RJEmailTextField.this.ADDRESS_OK_CHARACTERS.length > i; ++i) {
                if (RJEmailTextField.this.ADDRESS_OK_CHARACTERS[i] != c) continue;
                bl = true;
                break;
            }
            if (bl) {
                n = 0;
            }
            return n;
        }

        public boolean checkLengthOver(int n) {
            boolean bl = true;
            if (RJEmailTextField.this.textField.getText().length() + n >= RJEmailTextField.this.max) {
                bl = false;
            }
            return bl;
        }
    }
}

