/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import sanproject.client.exdevice.data.Utility;

public class EmulationTypeInfo
implements Comparable {
    protected static final BigInteger CYL_OF_SLOT = BigInteger.valueOf(15L);
    protected static final BigInteger MAX_SLOT = BigInteger.valueOf(0x1000000L);
    protected static final BigInteger MIN_CAPACITY = BigInteger.valueOf(50L);
    protected static final int MAX_DIVIDE = 2048;
    protected String type = new String();
    protected BigInteger capacity;
    protected BigInteger SLOT_OF_LBA;
    protected BigInteger CYL_OF_LBA;
    protected BigInteger mCtlCylLba;
    protected BigInteger mHdevDivideSize;
    protected BigInteger mHdevDivideSizeMin;
    protected BigInteger mVdevSizeMax;
    private int mEmuKind = 0;
    private int mEmuId = 0;
    private int mEmuGroup = -1;

    protected EmulationTypeInfo() {
    }

    public EmulationTypeInfo(String string, long l, int n, int n2, int n3) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("emuName=" + string);
        }
        this.type = string;
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException(this.type + ":emuKind=" + n);
        }
        this.mEmuKind = n;
        if (n3 <= 0) {
            throw new IllegalArgumentException(this.type + ":slotSize=" + n3);
        }
        this.SLOT_OF_LBA = Utility.kibToLba(n3);
        this.CYL_OF_LBA = this.SLOT_OF_LBA.multiply(CYL_OF_SLOT);
        if (l <= 0L) {
            throw new IllegalArgumentException(this.type + ":emuMaxSize=" + l);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(this.type + ":ctlCyl=" + n2);
        }
        if (this.mEmuKind == 3) {
            this.capacity = Utility.kibToLba(l);
            this.mCtlCylLba = Utility.kibToLba(n2);
        } else {
            this.capacity = BigInteger.valueOf(l);
            this.capacity = this.capacity.multiply(this.CYL_OF_LBA);
            this.mCtlCylLba = BigInteger.valueOf(n2);
            this.mCtlCylLba = this.mCtlCylLba.multiply(this.CYL_OF_LBA);
        }
        this.mHdevDivideSize = this.capacity.add(this.mCtlCylLba);
        this.mHdevDivideSizeMin = this.cylToLba(MIN_CAPACITY);
        this.mHdevDivideSizeMin = this.mHdevDivideSizeMin.add(this.mCtlCylLba);
        this.mVdevSizeMax = MAX_SLOT.multiply(this.SLOT_OF_LBA);
    }

    public String toString() {
        return this.getType();
    }

    public String getType() {
        return this.type;
    }

    public int getEmulationKind() {
        return this.mEmuKind;
    }

    public boolean isInheritEmulation(String string) {
        return string != null && string.startsWith(this.type);
    }

    public boolean isOpenType() {
        return this.mEmuKind == 3;
    }

    public BigInteger getCapacity() {
        return this.capacity;
    }

    public Collection getHdevCapacityList(BigInteger bigInteger) {
        int n;
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        if (bigInteger != null && (n = this.getDivideHdev(bigInteger)) >= 1) {
            if (bigInteger.compareTo(this.mHdevDivideSize) < 0) {
                BigInteger bigInteger2 = bigInteger.subtract(this.mCtlCylLba);
                bigInteger2 = this.correctCapacity(bigInteger2);
                arrayList.add(bigInteger2);
            } else {
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.capacity);
                }
            }
        }
        return arrayList;
    }

    public BigInteger correctCapacity(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ZERO;
        if (bigInteger != null) {
            BigInteger bigInteger3 = this.lbaToCyl(bigInteger);
            bigInteger2 = bigInteger3.multiply(this.CYL_OF_LBA);
        }
        return bigInteger2;
    }

    public BigInteger lbaToCyl(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ZERO;
        if (bigInteger != null) {
            BigInteger bigInteger3 = bigInteger.divide(this.SLOT_OF_LBA);
            bigInteger2 = bigInteger3.divide(CYL_OF_SLOT);
        }
        return bigInteger2;
    }

    public BigInteger cylToLba(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ZERO;
        if (bigInteger != null) {
            bigInteger2 = bigInteger.multiply(this.CYL_OF_LBA);
        }
        return bigInteger2;
    }

    public int getDivideHdev(BigInteger bigInteger) {
        int n = 0;
        if (bigInteger != null) {
            if (bigInteger.compareTo(this.mVdevSizeMax) > 0) {
                bigInteger = this.mVdevSizeMax;
            }
            if ((n = bigInteger.divide(this.mHdevDivideSize).intValue()) == 0) {
                if (bigInteger.compareTo(this.mHdevDivideSizeMin) >= 0) {
                    n = 1;
                }
            } else if (n > 2048) {
                n = 2048;
            }
        }
        return n;
    }

    void setEmulationId(int n) {
        this.mEmuId = n;
    }

    public int getEmulationId() {
        return this.mEmuId;
    }

    void setGroup(int n) {
        this.mEmuGroup = n;
    }

    public int getGroup() {
        return this.mEmuGroup;
    }

    public int compareTo(Object object) {
        EmulationTypeInfo emulationTypeInfo = (EmulationTypeInfo)object;
        return this.type.compareTo(emulationTypeInfo.type);
    }
}

