/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.pathoperation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcMenuAction;
import sanproject.client.com.RJcPopupMenu;
import sanproject.client.exdevice.com.AbstractTableDataModel;
import sanproject.client.exdevice.com.Operation;
import sanproject.client.exdevice.com.TableColumnInfo;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.pathoperation.DeviceStatusColumnInfo;
import sanproject.client.exdevice.pathoperation.FLITOVColumnInfo;
import sanproject.client.exdevice.pathoperation.LocalGuidance;
import sanproject.client.exdevice.pathoperation.LocalOperation;
import sanproject.client.exdevice.pathoperation.MarginColumnInfo;
import sanproject.client.exdevice.pathoperation.PLITOVColumnInfo;
import sanproject.client.exdevice.pathoperation.PortElement;
import sanproject.client.exdevice.pathoperation.PortNameColumnInfo;
import sanproject.client.exdevice.pathoperation.RootElement;

public class PortTableDataModel
extends AbstractTableDataModel {
    private TableColumnInfo[] headers;
    private RJcMenuAction disconnectPathsAction;
    private RJcMenuAction checkPathsAction;
    private RootElement rootElement;

    public PortTableDataModel(RootElement rootElement) {
        this.rootElement = rootElement;
        String string = LocalGuidance.MENU_DISCONNECTPATHS.getItemID();
        this.disconnectPathsAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                PortTableDataModel.this.onSelectDisconnectPaths(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        string = LocalGuidance.MENU_CHECKPATHS.getItemID();
        this.checkPathsAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                PortTableDataModel.this.onSelectCheckPaths(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        this.setAutoResizeMode(0);
    }

    public TableColumnInfo[] getColumnInfos() {
        if (this.headers == null) {
            this.headers = new TableColumnInfo[]{new PortNameColumnInfo(), new PLITOVColumnInfo(), new FLITOVColumnInfo(), new MarginColumnInfo(), new DeviceStatusColumnInfo()};
        }
        TableColumnInfo[] tableColumnInfoArray = this.headers;
        return tableColumnInfoArray;
    }

    public PortElement[] getSelectedPortElements() {
        int[] nArray = this.getSelectedRows();
        PortElement[] portElementArray = this.getPortElements(nArray);
        return portElementArray;
    }

    public PortElement[] getPortElements(int[] nArray) {
        RJcElement[] rJcElementArray = this.getElements(nArray);
        int n = rJcElementArray.length;
        ArrayList<RJcElement> arrayList = new ArrayList<RJcElement>();
        arrayList.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            RJcElement rJcElement = rJcElementArray[i];
            if (!(rJcElement instanceof PortElement)) continue;
            arrayList.add(rJcElement);
        }
        PortElement[] portElementArray = new PortElement[]{};
        portElementArray = arrayList.toArray(portElementArray);
        return portElementArray;
    }

    protected JPopupMenu createPopupMenu() {
        RJcPopupMenu rJcPopupMenu = null;
        this.updateActionsStatus();
        RJcMenuAction[] rJcMenuActionArray = new RJcMenuAction[]{this.disconnectPathsAction, this.checkPathsAction};
        rJcPopupMenu = new RJcPopupMenu(rJcMenuActionArray);
        return rJcPopupMenu;
    }

    private void updateActionsStatus() {
        PresetManager presetManager;
        boolean bl;
        boolean bl2 = bl = PortTableDataModel.isEditable(13, 1);
        boolean bl3 = bl;
        PortElement[] portElementArray = this.getSelectedPortElements();
        if (bl) {
            presetManager = PresetManager.getInstance();
            bl2 = Operation.isPossibleTo(presetManager, LocalOperation.DISCONNECT_PATHS) ? this.rootElement.canDisconnectPaths(portElementArray) : false;
        }
        if (bl) {
            presetManager = PresetManager.getInstance();
            bl3 = Operation.isPossibleTo(presetManager, LocalOperation.CHECK_PATHS) ? this.rootElement.canCheckPaths(portElementArray) : false;
        }
        this.disconnectPathsAction.setEnabled(bl2);
        this.checkPathsAction.setEnabled(bl3);
    }

    private void onSelectDisconnectPaths(ActionEvent actionEvent) {
        PortElement[] portElementArray = this.getSelectedPortElements();
        this.rootElement.requestDisconnectPaths(portElementArray);
    }

    private void onSelectCheckPaths(ActionEvent actionEvent) {
        PortElement[] portElementArray = this.getSelectedPortElements();
        this.rootElement.requestCheckPaths(portElementArray);
    }
}

