/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur.dialog.jnl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import sanproject.client.com.RJComDialog;
import sanproject.client.data.RJDataMsg;
import sanproject.client.hur.RJHurGuide;
import sanproject.client.hur.RJHurMacro;
import sanproject.client.hur.RJHurPresetChangeSystemOptionData;
import sanproject.client.hur.dialog.RJHurSystemOptionDialog;
import sanproject.client.hur.dialog.com.RJHurBaseButton;
import sanproject.client.hur.dialog.com.RJHurBaseDialogPanel;
import sanproject.client.hur.dialog.com.RJHurBasePanel;
import sanproject.client.hur.dialog.com.RJHurBaseStaticPanel;
import sanproject.client.hur.dialog.com.RJHurBaseTitlePanel;
import sanproject.client.hur.dialog.com.RJHurBorderLayoutPanel;
import sanproject.client.hur.dialog.com.RJHurGridLabelPanel;
import sanproject.client.hur.dialog.com.RJHurGridLayoutPanel;
import sanproject.client.hur.dialog.jnl.RJHurNumericField;

public class RJHurSystemOptionPanel
extends RJHurBaseDialogPanel
implements RJHurMacro {
    private static final String CLASSNAME = "RJHurSystemOptionPanel";
    private static final int LBL_TITLE_WIDTH = 288;
    private static final int LBL_PARAM_WIDTH = 120;
    private RJHurSystemOptionDialog m_dlgParent = null;
    private RJHurBaseButton m_btnSet = null;
    private RJHurBaseButton m_btnCancel = null;
    private RJHurNumericField m_fldInitCopy = null;

    public RJHurSystemOptionPanel(RJHurSystemOptionDialog rJHurSystemOptionDialog) {
        try {
            this.m_dlgParent = rJHurSystemOptionDialog;
            this.initInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void initInstance() throws Exception {
        this.m_fldInitCopy = new RJHurNumericField("");
        this.m_fldInitCopy.setRange(1, 128, 10, false, false);
        this.m_fldInitCopy.setRestrict(3);
        this.m_fldInitCopy.setPreferredSize(new Dimension(120, 24));
        this.m_btnSet = this.newButton("Set");
        this.m_btnSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHurSystemOptionPanel.this.onSet(actionEvent);
            }
        });
        this.m_btnCancel = this.newButton("Cancel");
        this.m_btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHurSystemOptionPanel.this.onCancel(actionEvent);
            }
        });
        super.addButton(this.m_btnSet, 0);
        super.addButton(this.m_btnCancel, 0);
        this.buildLayout();
    }

    protected void buildLayout() {
        RJHurBorderLayoutPanel rJHurBorderLayoutPanel = new RJHurBorderLayoutPanel();
        RJHurBaseTitlePanel rJHurBaseTitlePanel = new RJHurBaseTitlePanel(RJHurGuide.text("SYSOP_Title"));
        RJHurGridLabelPanel rJHurGridLabelPanel = new RJHurGridLabelPanel(1, 1, 288, 28, 20);
        rJHurBorderLayoutPanel.add((Component)rJHurGridLabelPanel, "West");
        RJHurBasePanel rJHurBasePanel = this.buildLayoutInputPanel();
        rJHurBorderLayoutPanel.add((Component)rJHurBasePanel, "Center");
        this.add((Component)rJHurBaseTitlePanel, "North");
        this.add((Component)rJHurBorderLayoutPanel, "Center");
        super.putButtons();
    }

    private RJHurBasePanel buildLayoutInputPanel() {
        RJHurGridLayoutPanel rJHurGridLayoutPanel = new RJHurGridLayoutPanel(1, 1, 120, 28);
        RJHurBaseStaticPanel rJHurBaseStaticPanel = new RJHurBaseStaticPanel();
        rJHurBaseStaticPanel.add((Component)this.m_fldInitCopy, "Center");
        Component[] componentArray = new RJHurBaseStaticPanel[]{rJHurBaseStaticPanel};
        rJHurGridLayoutPanel.adjustSize((JComponent[])componentArray);
        rJHurGridLayoutPanel.addComponent(componentArray);
        return rJHurGridLayoutPanel;
    }

    public void displayData() {
        int n = this.m_dlgParent.getInitCopy();
        this.m_fldInitCopy.setText(Integer.toString(n, 10));
    }

    public boolean updateData() {
        RJHurPresetChangeSystemOptionData rJHurPresetChangeSystemOptionData = new RJHurPresetChangeSystemOptionData();
        boolean bl = this.checkRange(this.m_fldInitCopy, true);
        if (!bl) {
            return false;
        }
        rJHurPresetChangeSystemOptionData.maxInitCopy = Integer.parseInt(this.m_fldInitCopy.getText());
        boolean bl2 = true;
        try {
            this.m_dlgParent.updateData(rJHurPresetChangeSystemOptionData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
        }
        this.m_dlgParent.setClosedBtn(bl2);
        return true;
    }

    private boolean checkRange(RJHurNumericField rJHurNumericField, boolean bl) {
        boolean bl2 = false;
        String string = rJHurNumericField.getText();
        if (string.length() != 0) {
            bl2 = rJHurNumericField.chkRangeForce();
        }
        if (!bl2) {
            if (bl) {
                RJDataMsg rJDataMsg = this.m_dlgParent.getMessageInf(5144);
                Object[] objectArray = this.m_dlgParent.getMessageOptOK();
                RJComDialog.show(this.m_dlgParent, rJDataMsg, 0, objectArray, objectArray[0]);
            }
            rJHurNumericField.setText("");
        }
        return bl2;
    }

    public void onSet(ActionEvent actionEvent) {
        if (this.updateData()) {
            this.m_dlgParent.windowClose();
        }
    }

    public void onCancel(ActionEvent actionEvent) {
        this.m_dlgParent.setClosedBtn(false);
        this.m_dlgParent.windowClose();
    }
}

