/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.io.IOException;
import javax.swing.JScrollBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.com.abs.RJaTreeNodeObject;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDragSource;
import sanproject.client.monitor.com.RJHihDragSourceObject;
import sanproject.client.monitor.com.RJHihDropTarget;
import sanproject.client.monitor.com.RJHihObjectTransference;
import sanproject.client.monitor.com.RJHihTreePanel;

public abstract class RJHihDnDTreePanel
extends RJHihTreePanel
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
Autoscroll {
    protected DragSource source;
    protected DropTarget target;
    protected TreePath dragPath = null;
    protected RJaTreeNode dragNode = null;
    protected boolean draging = false;
    protected int selectionMode;
    protected int actionKind = 1;
    protected TreePath prePath = null;
    private int top;
    private int left;
    private int bottom;
    private int right;

    public RJHihDnDTreePanel() {
        this(null, null);
    }

    public RJHihDnDTreePanel(RJHihDataSupplier rJHihDataSupplier) {
        this(rJHihDataSupplier, null);
    }

    public RJHihDnDTreePanel(RJHihDataSupplier rJHihDataSupplier, RJcTablePanel rJcTablePanel) {
        super(rJHihDataSupplier, rJcTablePanel);
        this.setTablePanel(rJcTablePanel);
        this.selectionMode = this.tree.getSelectionModel().getSelectionMode();
    }

    public void setAction(int n) {
        this.actionKind = n;
    }

    protected void setActiveDragSource() {
        this.source = new RJHihDragSource();
        this.source.createDefaultDragGestureRecognizer(this.tree, this.actionKind, this);
    }

    protected void setActiveDropTarget() {
        this.target = new RJHihDropTarget(this.tree, this.actionKind, this);
    }

    protected void setSelectionMode(int n) {
        this.selectionMode = n;
        this.tree.getSelectionModel().setSelectionMode(n);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (!inputEvent.isControlDown()) {
            this.putLog("[HIHSM com]", "[Drag&Drop]", "dragGestureRecognized");
            TreePath treePath = this.tree.getPathForLocation(dragGestureEvent.getDragOrigin().x, dragGestureEvent.getDragOrigin().y);
            if (treePath != null) {
                this.dragPath = treePath;
                this.dragNode = (RJaTreeNode)treePath.getLastPathComponent();
                RJaTreeNodeObject rJaTreeNodeObject = (RJaTreeNodeObject)this.dragNode.getUserObject();
                if (rJaTreeNodeObject instanceof RJHihDragSourceObject && ((RJHihDragSourceObject)((Object)rJaTreeNodeObject)).isAllowDrag()) {
                    RJHihObjectTransference rJHihObjectTransference = this.newObjectTransference((RJHihDragSourceObject)((Object)rJaTreeNodeObject));
                    try {
                        this.source.startDrag(dragGestureEvent, DragSource.DefaultMoveNoDrop, rJHihObjectTransference, this);
                    }
                    catch (InvalidDnDOperationException invalidDnDOperationException) {
                        this.putLog("[HIHSM com]", "[Drag&Drop]", "dragGestureRecognized InvalidDnDOperationException " + invalidDnDOperationException.getMessage());
                    }
                }
            }
        }
    }

    protected RJHihObjectTransference newObjectTransference(RJHihDragSourceObject rJHihDragSourceObject) {
        return null;
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.putLog("[HIHSM com]", "[Drag&Drop]", "Source dragDropEnd " + dragSourceDropEvent.getDropSuccess() + " " + this.getAction(dragSourceDropEvent.getDropAction()));
        if (dragSourceDropEvent.getDropSuccess() && dragSourceDropEvent.getDropAction() == 2) {
            this.removeNode(this.dragNode);
        }
        this.dragPath = null;
        this.dragNode = null;
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.dragEnd();
        try {
            if (dropTargetDropEvent.getDropAction() != 0 && this.dropAction(dropTargetDropEvent)) {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    protected boolean dropAction(DropTargetDropEvent dropTargetDropEvent) throws IOException, UnsupportedFlavorException {
        return false;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.tree.getSelectionModel().setSelectionMode(4);
        this.draging = true;
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.prePath != null) {
            this.tree.removeSelectionPath(this.prePath);
            this.prePath = null;
        }
        TreePath treePath = this.tree.getClosestPathForLocation(dropTargetDragEvent.getLocation().x, dropTargetDragEvent.getLocation().y);
        if (dropTargetDragEvent.getDropAction() != 0 && treePath != null && this.isAccept(treePath, dropTargetDragEvent) && !this.tree.isPathSelected(treePath)) {
            this.tree.addSelectionPath(treePath);
            this.prePath = treePath;
        }
    }

    protected boolean isAccept(TreePath treePath, DropTargetDragEvent dropTargetDragEvent) {
        return false;
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.dragEnd();
    }

    protected void dragEnd() {
        if (this.prePath != null) {
            this.tree.removeSelectionPath(this.prePath);
            this.prePath = null;
        }
        this.draging = false;
        this.tree.getSelectionModel().setSelectionMode(this.selectionMode);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.draging) {
            super.valueChanged(treeSelectionEvent);
        }
    }

    protected String getAction(int n) {
        String[] stringArray = new String[]{"REJECT", "ACTION_COPY", "ACTION_MOVE", "ACTION_COPY_OR_MOVE"};
        return stringArray[n];
    }

    public Insets getAutoscrollInsets() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollPane.getHorizontalScrollBar();
        Rectangle rectangle = this.tree.getVisibleRect();
        this.top = rectangle.y + 16;
        this.left = rectangle.x + 8;
        this.bottom = rectangle.y + rectangle.height - 16;
        this.right = rectangle.x + rectangle.width - 8;
        Insets insets = new Insets(this.top, this.left, jScrollBar.getMaximum() - this.bottom, jScrollBar2.getMaximum() - this.right);
        return insets;
    }

    public void autoscroll(Point point) {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollPane.getHorizontalScrollBar();
        if (point.y < this.top) {
            int n = point.y < this.top - 8 ? 32 : 8;
            jScrollBar.setValue(jScrollBar.getValue() - n);
        } else if (point.y > this.bottom) {
            int n = point.y > this.bottom + 8 ? 32 : 8;
            jScrollBar.setValue(jScrollBar.getValue() + n);
        }
        if (point.x < this.left) {
            jScrollBar2.setValue(jScrollBar2.getValue() - 8);
        } else if (point.x > this.right) {
            jScrollBar2.setValue(jScrollBar2.getValue() + 8);
        }
    }
}

