/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.com;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import sanproject.client.openldevguard.com.KeyEventReceiver;
import sanproject.client.openldevguard.com.KeyEventTransferable;

public class StandardButton
extends JButton
implements KeyEventTransferable {
    private static final int MINIMUM_WIDTH = 90;
    private static final int DEFAULT_HEIGHT = 24;
    private transient Set msetEventRecievers = new HashSet();

    public StandardButton() {
        this("", null);
    }

    public StandardButton(String string) {
        this(string, null);
    }

    public StandardButton(String string, Icon icon) {
        super(string, icon);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                StandardButton.this.notifyReceivers(keyEvent);
            }
        };
        this.addKeyListener(keyAdapter);
    }

    public final synchronized void addKeyEventReceiver(KeyEventReceiver keyEventReceiver) {
        this.msetEventRecievers.add(keyEventReceiver);
    }

    public final synchronized void removeKeyEventReceiver(KeyEventReceiver keyEventReceiver) {
        this.msetEventRecievers.remove(keyEventReceiver);
    }

    public final synchronized void removeKeyEventReceivers() {
        this.msetEventRecievers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyReceivers(KeyEvent keyEvent) {
        Set set;
        Object object = this;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetEventRecievers);
        }
        object = set.iterator();
        while (object.hasNext() && !keyEvent.isConsumed()) {
            KeyEventReceiver keyEventReceiver = (KeyEventReceiver)object.next();
            keyEventReceiver.keyEventReceived(this, keyEvent);
        }
    }

    public final Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!this.isPreferredSizeSet()) {
            if (dimension.width < 90) {
                dimension.width = 90;
            }
            dimension.height = 24;
        }
        Dimension dimension2 = dimension;
        return dimension2;
    }
}

