/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.prm;

import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.common.Robj_interface_DKCgetAllPGNumber;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_RJiPGInfoDetail;
import sanproject.serverux.dataimpl.PRMDiskAddress;

class RJPRMDiskAddress
extends PRMDiskAddress
implements Comparable {
    boolean bChange = false;
    private boolean bDetail = false;
    private int nPGCnctType = 0;
    private int nRepDG = -1;
    private int nRepPG = -1;
    private int nType = -1;
    private String sRaidLevel = "";
    private String sBaseEmu = "";

    RJPRMDiskAddress(PRMDiskAddress pRMDiskAddress) {
        int n = pRMDiskAddress.getIFB4();
        int n2 = pRMDiskAddress.getIPG();
        this.nDiskCapacity = pRMDiskAddress.nDiskCapacity;
        this.nOptionFlag = pRMDiskAddress.nOptionFlag;
        this.setPGIndex(n, n2);
        if (pRMDiskAddress instanceof RJPRMDiskAddress) {
            RJPRMDiskAddress rJPRMDiskAddress = (RJPRMDiskAddress)pRMDiskAddress;
            this.bDetail = rJPRMDiskAddress.bDetail;
            this.nPGCnctType = rJPRMDiskAddress.nPGCnctType;
            this.nRepDG = rJPRMDiskAddress.nRepDG;
            this.nRepPG = rJPRMDiskAddress.nRepPG;
            this.nType = rJPRMDiskAddress.nType;
            this.sBaseEmu = rJPRMDiskAddress.sBaseEmu;
            this.sRaidLevel = rJPRMDiskAddress.sRaidLevel;
        }
    }

    RJPRMDiskAddress(PRMDiskAddress pRMDiskAddress, boolean bl) {
        this(pRMDiskAddress);
        this.bChange = bl;
    }

    PRMDiskAddress getDisk() {
        PRMDiskAddress pRMDiskAddress = new PRMDiskAddress();
        int n = this.getIFB4();
        int n2 = this.getIPG();
        pRMDiskAddress.setPGIndex(n, n2);
        pRMDiskAddress.nDiskCapacity = this.nDiskCapacity;
        pRMDiskAddress.nOptionFlag = this.nOptionFlag;
        return pRMDiskAddress;
    }

    boolean isModified() {
        return this.bChange;
    }

    boolean hasDetail() {
        return this.bDetail;
    }

    void setDetail(Robj_interface_RJiPGInfoDetail robj_interface_RJiPGInfoDetail, Robj_interface_DKCgetAllPGNumber[] robj_interface_DKCgetAllPGNumberArray) {
        if (this.bDetail) {
            return;
        }
        this.bDetail = true;
        this.nPGCnctType = 0;
        if (robj_interface_DKCgetAllPGNumberArray != null && robj_interface_RJiPGInfoDetail.isNormalVolume()) {
            for (int i = 0; i < robj_interface_DKCgetAllPGNumberArray.length && robj_interface_DKCgetAllPGNumberArray[i].isNormalVolume(); ++i) {
                Robj_interface_RJiPGIndex[] robj_interface_RJiPGIndexArray = robj_interface_DKCgetAllPGNumberArray[i].getObjPGIndex();
                if (robj_interface_DKCgetAllPGNumberArray[i].getIFB4() == robj_interface_RJiPGInfoDetail.getIFB4() && robj_interface_DKCgetAllPGNumberArray[i].getIPG() == robj_interface_RJiPGInfoDetail.getIPG()) {
                    if (robj_interface_RJiPGIndexArray.length == 0) break;
                    this.nPGCnctType = 1;
                    this.nRepDG = robj_interface_RJiPGInfoDetail.getIFB4();
                    this.nRepPG = robj_interface_RJiPGInfoDetail.getIPG();
                    break;
                }
                boolean bl = false;
                for (int j = 0; j < robj_interface_RJiPGIndexArray.length; ++j) {
                    if (robj_interface_RJiPGIndexArray[j].getIFB4() != this.getIFB4() || robj_interface_RJiPGIndexArray[j].getIPG() != this.getIPG()) continue;
                    this.nPGCnctType = 2;
                    this.nRepDG = robj_interface_DKCgetAllPGNumberArray[i].getIFB4();
                    this.nRepPG = robj_interface_DKCgetAllPGNumberArray[i].getIPG();
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        RJDataChange rJDataChange = RJDataControl.getDataControl().getChangeTbl();
        this.sRaidLevel = robj_interface_RJiPGInfoDetail.isNormalVolume() ? "RAID" + rJDataChange.getRAIDLevelName(robj_interface_RJiPGInfoDetail) : "-";
        int n = robj_interface_RJiPGInfoDetail.getIBaseEmulationType();
        this.sBaseEmu = rJDataChange.getEmulationTypeName(n);
        switch (n & 0xF00) {
            case 0: {
                this.nType = 1;
                break;
            }
            case 512: {
                this.nType = 3;
                break;
            }
            default: {
                this.nType = 2;
            }
        }
    }

    boolean isConnected() {
        boolean bl = this.isPrimary() || this.isSecondary();
        return bl;
    }

    boolean isPrimary() {
        return this.nPGCnctType == 1;
    }

    boolean isSecondary() {
        return this.nPGCnctType == 2;
    }

    boolean equalsPrimary(int n, int n2) {
        return this.nRepDG == n && this.nRepPG == n2;
    }

    int getRepDG() {
        return this.nRepDG;
    }

    int getRepPG() {
        return this.nRepPG;
    }

    int getType() {
        return this.nType;
    }

    String getRaidLevel() {
        return this.sRaidLevel;
    }

    String getBaseEmu() {
        return this.sBaseEmu;
    }
}

