/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.xrc;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComModalDialog;
import sanproject.client.com.RJComPanel;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.data.RJDataStartParam;
import sanproject.client.data.RJDataWndInf;
import sanproject.client.xrc.RJXrcMacro;
import sanproject.common.RCobj_interface_CheckRet;
import sanproject.serverux.dataimpl.PRMName;
import sanproject.serverux.dataimpl.XRCdataClpr;
import sanproject.serverux.dataimpl.XRCdataOption;
import sanproject.serverux.dataimpl.XRCdataSlpr;

public class RJXrcDataCtrl
implements RJXrcMacro {
    RJDataControl data;
    private XRCdataOption rmiData = null;
    private ArrayList presetData = new ArrayList();
    private ArrayList errData = new ArrayList();
    public String[] oOk = new String[1];
    public String[] oOkCancel = new String[2];
    public String[] oYesNo = new String[2];
    RJComModalDialog dlg = null;
    final String szTrcKey = "DataCtrl";
    RJDataWndInf MSG_OK = null;
    RJDataWndInf MSG_CANCEL = null;
    RJDataWndInf MSG_YES = null;
    RJDataWndInf MSG_NO = null;
    RJDataWndInf STS_ENABLE = null;
    RJDataWndInf STS_DISABLE = null;
    RJDataWndInf STS_VOLLVL = null;
    RJDataWndInf STS_CHCLVL = null;
    RJDataWndInf CMN_BDR_CLR = null;
    RJDataWndInf CMN_TITLE_MARKCLR = null;
    RJDataWndInf CMN_PNL_BGCLR = null;
    RJDataWndInf CMN_BTN_BGCLR = null;
    RJDataWndInf CMN_MIDTTL_FG = null;
    RJDataWndInf CMN_MIDTTL_BG = null;
    RJDataWndInf CMN_STR_FG = null;
    RJDataWndInf CMN_LBL_BG = null;
    RJDataWndInf CMN_INFLBL_BG = null;

    public RJXrcDataCtrl(RJDataControl rJDataControl) {
        this.data = rJDataControl;
        this.initString();
    }

    void initString() {
        this.MSG_OK = this.getGuidClass("MSG_OK", "OK");
        this.MSG_CANCEL = this.getGuidClass("MSG_CANCEL", "Cancel");
        this.MSG_YES = this.getGuidClass("MSG_YES", "Yes");
        this.MSG_NO = this.getGuidClass("MSG_NO", "No");
        this.STS_ENABLE = this.getGuidClass("STS_ENABLE", "Enable");
        this.STS_DISABLE = this.getGuidClass("STS_DISABLE", "Disable");
        this.STS_VOLLVL = this.getGuidClass("STS_VOLLVL", "Volume");
        this.STS_CHCLVL = this.getGuidClass("STS_CHCLVL", "Cache");
        this.CMN_BDR_CLR = this.getGuidClassForColor("CMN_BDR_CLR", Color.lightGray);
        this.CMN_TITLE_MARKCLR = this.getGuidClassForColor("CMN_TITLE_MARKCLR", new Color(0, 0, 153));
        this.CMN_PNL_BGCLR = this.getGuidClassForColor("CMN_PNL_BGCLR", Color.lightGray);
        this.CMN_BTN_BGCLR = this.getGuidClassForColor("CMN_BTN_BGCLR", Color.lightGray);
        this.CMN_MIDTTL_FG = this.getGuidClassForColor("CMN_MIDTTL_FG", Color.WHITE);
        this.CMN_MIDTTL_BG = this.getGuidClassForColor("CMN_MIDTTL_BG", new Color(0, 0, 153));
        this.CMN_STR_FG = this.getGuidClassForColor("CMN_STR_FG", Color.BLACK);
        this.CMN_LBL_BG = this.getGuidClassForColor("CMN_LBL_BG", new Color(153, 153, 255));
        this.CMN_INFLBL_BG = this.getGuidClassForColor("CMN_INFLBL_BG", Color.WHITE);
        this.oOk = new String[]{this.MSG_OK.getGuidance()};
        this.oOkCancel = new String[]{this.MSG_OK.getGuidance(), this.MSG_CANCEL.getGuidance()};
        this.oYesNo = new String[]{this.MSG_YES.getGuidance(), this.MSG_NO.getGuidance()};
    }

    boolean isPresetData(int n) {
        boolean bl = false;
        if (this.getPresetData(n) != null) {
            bl = true;
        }
        return bl;
    }

    ArrayList getPresetData() {
        return this.presetData;
    }

    XRCdataClpr getPresetData(int n) {
        XRCdataClpr xRCdataClpr = null;
        for (int i = 0; i < this.presetData.size(); ++i) {
            XRCdataClpr xRCdataClpr2 = (XRCdataClpr)this.presetData.get(i);
            if (n != xRCdataClpr2.iClprNum) continue;
            xRCdataClpr = xRCdataClpr2;
            break;
        }
        return xRCdataClpr;
    }

    void setPresetData(XRCdataClpr xRCdataClpr) {
        boolean bl = false;
        if (xRCdataClpr != null) {
            XRCdataClpr xRCdataClpr2;
            XRCdataClpr xRCdataClpr3;
            for (int i = 0; i < this.presetData.size(); ++i) {
                XRCdataClpr xRCdataClpr4 = (XRCdataClpr)this.presetData.get(i);
                if (xRCdataClpr4.iClprNum != xRCdataClpr.iClprNum) continue;
                bl = true;
                this.presetData.remove(i);
                xRCdataClpr3 = this.getXrcClprInf(xRCdataClpr4.iClprNum);
                if (this.compareClprData(xRCdataClpr, xRCdataClpr3)) continue;
                if (i >= this.presetData.size()) {
                    this.presetData.add(xRCdataClpr);
                    continue;
                }
                this.presetData.add(i, xRCdataClpr);
            }
            if (!bl && !this.compareClprData(xRCdataClpr, xRCdataClpr2 = this.getXrcClprInf(xRCdataClpr.iClprNum))) {
                if (this.presetData.size() != 0) {
                    for (int i = 0; i < this.presetData.size(); ++i) {
                        xRCdataClpr3 = (XRCdataClpr)this.presetData.get(i);
                        if (xRCdataClpr3.iClprNum > xRCdataClpr.iClprNum) {
                            this.presetData.add(i, xRCdataClpr);
                        } else {
                            if (i != this.presetData.size() - 1) continue;
                            this.presetData.add(xRCdataClpr);
                        }
                        break;
                    }
                } else {
                    this.presetData.add(xRCdataClpr);
                }
            }
        }
    }

    void deletePresetData(int n) {
        for (int i = 0; i < this.presetData.size(); ++i) {
            XRCdataClpr xRCdataClpr = (XRCdataClpr)this.presetData.get(i);
            if (xRCdataClpr.iClprNum != n) continue;
            this.presetData.remove(i);
            break;
        }
    }

    void initPresetData() {
        this.presetData.clear();
    }

    boolean isPresetDataStored() {
        boolean bl = false;
        if (this.presetData != null) {
            if (this.presetData.size() != 0) {
                bl = true;
            }
        } else {
            this.presetData = new ArrayList();
        }
        return bl;
    }

    void putLog(String string, String string2) {
        RJCom.putLog(this.data, "XRC", string, string2, 0);
    }

    RJDataWndInf getGuidClass(String string, String string2) {
        return RJCom.getWinInf(this.data, "XRC", string, string2, Color.BLACK);
    }

    RJDataWndInf getGuidClassForColor(String string, Color color) {
        return RJCom.getWinInf(this.data, "XRC", string, "", color);
    }

    XRCdataClpr copyClprInf(XRCdataClpr xRCdataClpr) {
        XRCdataClpr xRCdataClpr2 = new XRCdataClpr();
        xRCdataClpr2.iClprNum = xRCdataClpr.iClprNum;
        xRCdataClpr2.iDevBlock = xRCdataClpr.iDevBlock;
        xRCdataClpr2.iDontBlock = xRCdataClpr.iDontBlock;
        xRCdataClpr2.iLimit2 = xRCdataClpr.iLimit2;
        xRCdataClpr2.iSimReport = xRCdataClpr.iSimReport;
        xRCdataClpr2.iSleepFlg = xRCdataClpr.iSleepFlg;
        xRCdataClpr2.iSleepTimer = xRCdataClpr.iSleepTimer;
        xRCdataClpr2.iSuspend = xRCdataClpr.iSuspend;
        return xRCdataClpr2;
    }

    String getClprName(int n) {
        String string = null;
        PRMName pRMName = this.data.getPRMNameData();
        if (null != pRMName) {
            String string2 = pRMName.getCLPRName(n);
            string = RJComUty.itoa(n, 2) + ":" + string2;
        } else {
            string = RJComUty.itoa(n, 2);
        }
        return string;
    }

    int getScpIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < RJXrcMacro.THRESHOLD_SCP.length; ++i) {
            if (RJXrcMacro.THRESHOLD_SCP[i] != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    int showMessage(int n, int n2, Component component, int n3) {
        int n4 = -1;
        Object[] objectArray = null;
        RJDataMsg rJDataMsg = this.getMsg(n, n2);
        switch (n3) {
            case 0: {
                objectArray = this.oOk;
                break;
            }
            case 1: {
                objectArray = this.oOkCancel;
                break;
            }
            case 2: {
                objectArray = this.oYesNo;
                break;
            }
            default: {
                objectArray = this.oOk;
            }
        }
        n4 = RJComDialog.show(component, rJDataMsg, 0, objectArray, objectArray[0]);
        return n4;
    }

    int showMessage(int n, Component component, int n2) {
        return this.showMessage(6810, n, component, n2);
    }

    boolean compareClprData(XRCdataClpr xRCdataClpr, XRCdataClpr xRCdataClpr2) {
        boolean bl = true;
        if (xRCdataClpr == null || xRCdataClpr2 == null) {
            bl = false;
        } else {
            if (xRCdataClpr.iClprNum != xRCdataClpr2.iClprNum) {
                bl = false;
            }
            if (xRCdataClpr.iDevBlock != xRCdataClpr2.iDevBlock) {
                bl = false;
            }
            if (xRCdataClpr.iDontBlock != xRCdataClpr2.iDontBlock) {
                bl = false;
            }
            if (xRCdataClpr.iLimit2 != xRCdataClpr2.iLimit2) {
                bl = false;
            }
            if (xRCdataClpr.iSimReport != xRCdataClpr2.iSimReport) {
                bl = false;
            }
            if (xRCdataClpr.iSleepFlg != xRCdataClpr2.iSleepFlg) {
                bl = false;
            }
            if (xRCdataClpr.iSleepTimer != xRCdataClpr2.iSleepTimer) {
                bl = false;
            }
            if (xRCdataClpr.iSuspend != xRCdataClpr2.iSuspend) {
                bl = false;
            }
        }
        return bl;
    }

    boolean getPpStat() {
        boolean bl = false;
        bl = true;
        return bl;
    }

    ArrayList getXrcDataInstruction(Component component) {
        ArrayList arrayList = null;
        this.waitCtl();
        this.data.getXrcOptionInf();
        this.data.waitDC(component);
        ArrayList arrayList2 = this.data.getEndStatus();
        if ((Integer)arrayList2.get(0) != 0) {
            arrayList = arrayList2;
            this.putLog("DataCtrl", "getXrcDataInstruction:Err-" + (Integer)arrayList2.get(0) + ":" + (Integer)arrayList2.get(1));
        } else {
            this.waitCtl();
            this.data.getPRMName();
            this.data.waitDC();
            ArrayList arrayList3 = this.data.getEndStatus();
            if ((Integer)arrayList3.get(0) != 0) {
                arrayList = arrayList3;
                this.putLog("DataCtrl", "getXrcDataInstruction:PrmErr-" + (Integer)arrayList2.get(0) + ":" + (Integer)arrayList2.get(1));
            } else {
                this.rmiData = null;
                this.rmiData = this.data.getXrcOptionInfData();
                arrayList = new ArrayList();
                this.putLog("DataCtrl", "getXrcDataInstruction: get data normal end.");
            }
        }
        return arrayList;
    }

    ArrayList getXrcAllClprInf() {
        ArrayList<XRCdataClpr> arrayList = new ArrayList<XRCdataClpr>();
        if (this.rmiData != null && this.rmiData.slprData != null) {
            for (int i = 0; i < this.rmiData.slprData.length; ++i) {
                if (this.rmiData.slprData[i] == null || this.rmiData.slprData[i].clprData == null) continue;
                for (int j = 0; j < this.rmiData.slprData[i].clprData.length; ++j) {
                    if (this.rmiData.slprData[i].clprData[j] == null || !this.isValidClpr(this.rmiData.slprData[i].clprData[j].iClprNum)) continue;
                    arrayList.add(this.rmiData.slprData[i].clprData[j]);
                }
            }
        }
        return arrayList;
    }

    XRCdataClpr getXrcClprInf(int n) {
        XRCdataClpr xRCdataClpr = null;
        ArrayList arrayList = this.getXrcAllClprInf();
        for (int i = 0; i < arrayList.size(); ++i) {
            XRCdataClpr xRCdataClpr2 = (XRCdataClpr)arrayList.get(i);
            if (n != xRCdataClpr2.iClprNum) continue;
            xRCdataClpr = xRCdataClpr2;
            break;
        }
        return xRCdataClpr;
    }

    public void waitCtl() {
        while (this.data.getControlDoing().getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                break;
            }
        }
    }

    String getRateString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append("%");
        return stringBuffer.toString();
    }

    String getSwitchString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.STS_DISABLE.getGuidance();
                break;
            }
            case 1: {
                string = this.STS_ENABLE.getGuidance();
                break;
            }
            default: {
                string = "---";
            }
        }
        return string;
    }

    String getTimeString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append("ms");
        return stringBuffer.toString();
    }

    String getBlockOptionString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.STS_CHCLVL.getGuidance();
                break;
            }
            case 1: {
                string = this.STS_VOLLVL.getGuidance();
                break;
            }
            default: {
                string = "---";
            }
        }
        return string;
    }

    public boolean getPermission() {
        RJDataStartParam rJDataStartParam = this.data.getStartParamClass();
        boolean bl = rJDataStartParam.getPermissionTABOption(9, 8);
        return bl;
    }

    boolean getNowMode() {
        boolean bl;
        int n = this.data.getViewModifyStatus();
        boolean bl2 = this.getPermission();
        if (n != 0) {
            if (!bl2) {
                this.putLog("DataCtrl", "getNowMode():No permission.");
                bl = false;
            } else {
                this.putLog("DataCtrl", "getNowMode():Modify mode.");
                bl = true;
            }
        } else {
            this.putLog("DataCtrl", "getNowMode():View mode.");
            bl = false;
        }
        return bl;
    }

    int setApplyData() {
        int n = 0;
        if (this.presetData == null || this.presetData.size() == 0) {
            n = 5122;
        } else {
            XRCdataOption xRCdataOption = new XRCdataOption();
            xRCdataOption.slprData = new XRCdataSlpr[1];
            xRCdataOption.slprData[0] = new XRCdataSlpr();
            xRCdataOption.slprData[0].iSlpr = 0;
            xRCdataOption.slprData[0].clprData = new XRCdataClpr[this.presetData.size()];
            for (int i = 0; i < this.presetData.size(); ++i) {
                xRCdataOption.slprData[0].clprData[i] = (XRCdataClpr)this.presetData.get(i);
                this.putLog("DataCtrl", "setApplyData:Modify data(CLPR ID):" + xRCdataOption.slprData[0].clprData[i].iClprNum);
            }
            if (!this.data.setXrcOption(xRCdataOption)) {
                n = 7440;
            }
        }
        return n;
    }

    ArrayList apply(RJComPanel rJComPanel) {
        ArrayList arrayList = new ArrayList();
        this.waitCtl();
        if (!this.data.Apply2Start()) {
            this.putLog("DataCtrl", "apply():Apply2Start Failed");
            arrayList.add(new Integer(6810));
            arrayList.add(new Integer(7440));
            return arrayList;
        }
        this.data.waitDC(rJComPanel);
        this.putLog("DataCtrl", "apply():getEndStatus start");
        ArrayList arrayList2 = this.data.getEndStatus();
        if ((Integer)arrayList2.get(0) != 0) {
            this.putLog("DataCtrl", "apply():FuncCode=" + (Integer)arrayList2.get(0));
            this.putLog("DataCtrl", "apply():ErrCode=" + (Integer)arrayList2.get(1));
            arrayList = arrayList2;
            return arrayList;
        }
        arrayList = arrayList2;
        this.initPresetData();
        this.putLog("DataCtrl", "apply():Normal end.");
        return arrayList;
    }

    void internalErrProcess(RJComPanel rJComPanel) {
        this.showMessage(7440, rJComPanel, 0);
        rJComPanel.setEnabledTopFrame(true);
        rJComPanel.endRequest(this.getMsg(6810, 7440).getErrorLevel());
    }

    RJDataMsg getMsg(int n, int n2) {
        return RJCom.getMsg(this.data, n, n2);
    }

    String getSetErrString(int n) {
        String string = null;
        string = 0 == n ? "---" : RJComUty.itoa(n, 1);
        return "---";
    }

    int getApplyErrId(int n) {
        int n2 = 0;
        if (this.errData != null || this.errData.size() == 0) {
            for (int i = 0; i < this.errData.size(); ++i) {
            }
        }
        return n2;
    }

    int chkOption(XRCdataClpr xRCdataClpr) {
        int n = 0;
        if (xRCdataClpr.iDevBlock == 1) {
            if (xRCdataClpr.iSleepFlg == 1) {
                n |= 2;
                this.putLog("DataCtrl", "chkXrcData CLPR:" + xRCdataClpr.iClprNum);
                this.putLog("DataCtrl", "Invalid [Sleep] data");
            }
            if (xRCdataClpr.iSuspend == 1) {
                n |= 4;
                this.putLog("DataCtrl", "chkXrcData CLPR:" + xRCdataClpr.iClprNum);
                this.putLog("DataCtrl", "Invalid [Suspend] data");
            }
            if (xRCdataClpr.iDontBlock == 0) {
                n |= 8;
                this.putLog("DataCtrl", "chkXrcData CLPR:" + xRCdataClpr.iClprNum);
                this.putLog("DataCtrl", "Invalid [Donot Block] data");
            }
        }
        return n;
    }

    boolean isValidClpr(int n) {
        boolean bl = true;
        RCobj_interface_CheckRet rCobj_interface_CheckRet = this.data.getCheckRetObjSx();
        if (null == rCobj_interface_CheckRet) {
            bl = false;
        } else {
            int n2 = rCobj_interface_CheckRet.getNSLPR();
            int n3 = this.getCLPRtoSLPR(n);
            if (n2 == 65535) {
                if (n3 != 0) {
                    bl = false;
                }
            } else if (n3 != n2) {
                bl = false;
            }
        }
        return bl;
    }

    int getCLPRtoSLPR(int n) {
        int n2 = -1;
        PRMName pRMName = this.data.getPRMNameData();
        if (null != pRMName && null != pRMName.prmSLPRName) {
            block0: for (int i = 0; i < pRMName.prmSLPRName.length; ++i) {
                if (null == pRMName.prmSLPRName[i].prmCLPRName) continue;
                for (int j = 0; j < pRMName.prmSLPRName[i].prmCLPRName.length; ++j) {
                    if (n != pRMName.prmSLPRName[i].prmCLPRName[j].nID) continue;
                    n2 = pRMName.prmSLPRName[i].nID;
                    continue block0;
                }
            }
        }
        return n2;
    }
}

